/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.composer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.Hash;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.RemoteArtifact;
import org.ossreviewtoolkit.model.RemoteArtifactKt;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.VcsInfoKt;
import org.ossreviewtoolkit.model.VcsType;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\r\u001a\u00020\nH\u0002\u001a2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"COMPOSER_LOCK_FILE", "", "COMPOSER_PHAR_BINARY", "COMPOSER_PLATFORM_TYPES", "", "PHP_PLATFORM_TYPES", "getRuntimeDependencies", "Lkotlin/sequences/Sequence;", "packageName", "lockFile", "Lcom/fasterxml/jackson/databind/JsonNode;", "parseArtifact", "Lorg/ossreviewtoolkit/model/RemoteArtifact;", "packageInfo", "parseAuthors", "parseDeclaredLicenses", "parseVcsInfo", "Lorg/ossreviewtoolkit/model/VcsInfo;", "parseVirtualNames", "parseVirtualPackageNames", "packages", "", "Lorg/ossreviewtoolkit/model/Package;", "manifest", "isPlatformDependency", "", "composer-package-manager"})
@SourceDebugExtension(value={"SMAP\nComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Composer.kt\norg/ossreviewtoolkit/plugins/packagemanagers/composer/ComposerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n1855#2:380\n1855#2,2:381\n1856#2:383\n1611#2:384\n1855#2:385\n1856#2:387\n1612#2:388\n1611#2:389\n1855#2:390\n1856#2:392\n1612#2:393\n1855#2:394\n1360#2:395\n1446#2,5:396\n1856#2:401\n1461#2,5:402\n1#3:386\n1#3:391\n*S KotlinDebug\n*F\n+ 1 Composer.kt\norg/ossreviewtoolkit/plugins/packagemanagers/composer/ComposerKt\n*L\n310#1:380\n311#1:381,2\n310#1:383\n331#1:384\n331#1:385\n331#1:387\n331#1:388\n334#1:389\n334#1:390\n334#1:392\n334#1:393\n365#1:394\n366#1:395\n366#1:396,5\n365#1:401\n376#1:402,5\n331#1:386\n334#1:391\n*E\n"})
public final class ComposerKt {
    @NotNull
    public static final String COMPOSER_PHAR_BINARY = "composer.phar";
    @NotNull
    public static final String COMPOSER_LOCK_FILE = "composer.lock";
    @NotNull
    private static final Set<String> COMPOSER_PLATFORM_TYPES;
    @NotNull
    private static final Set<String> PHP_PLATFORM_TYPES;

    private static final boolean isPlatformDependency(String $this$isPlatformDependency) {
        return SetsKt.plus(COMPOSER_PLATFORM_TYPES, (Iterable)PHP_PLATFORM_TYPES).contains($this$isPlatformDependency) || StringsKt.startsWith$default((String)$this$isPlatformDependency, (String)"ext-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isPlatformDependency, (String)"lib-", (boolean)false, (int)2, null);
    }

    private static final Sequence<String> getRuntimeDependencies(String packageName, JsonNode lockFile) {
        Object[] objectArray = new String[]{"packages", "packages-dev"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonNode jsonNode;
            String it = (String)element$iv;
            boolean bl = false;
            JsonNode jsonNode2 = jsonNode = lockFile.get(it);
            if (jsonNode2 == null) continue;
            Intrinsics.checkNotNull((Object)jsonNode2);
            Iterable $this$forEach$iv2 = (Iterable)jsonNode;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JsonNode requiredPackages;
                JsonNode packageInfo = (JsonNode)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)ExtensionsKt.textValueOrEmpty((JsonNode)packageInfo.get("name")), (Object)packageName) || (requiredPackages = packageInfo.get("require")) == null || !requiredPackages.isObject()) continue;
                Iterator iterator = ((ObjectNode)requiredPackages).fieldNames();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fieldNames(...)");
                return SequencesKt.asSequence((Iterator)iterator);
            }
        }
        return SequencesKt.emptySequence();
    }

    private static final RemoteArtifact parseArtifact(JsonNode packageInfo) {
        RemoteArtifact remoteArtifact;
        JsonNode jsonNode = packageInfo.get("dist");
        if (jsonNode != null) {
            JsonNode it = jsonNode;
            boolean bl = false;
            String shasum = ExtensionsKt.textValueOrEmpty((JsonNode)it.get("shasum"));
            remoteArtifact = new RemoteArtifact(ExtensionsKt.textValueOrEmpty((JsonNode)it.get("url")), Hash.Companion.create(shasum));
        } else {
            remoteArtifact = null;
        }
        return RemoteArtifactKt.orEmpty(remoteArtifact);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> parseAuthors(JsonNode packageInfo) {
        Set set;
        Set set2;
        JsonNode jsonNode = packageInfo.get("authors");
        if (jsonNode != null) {
            void var2_2;
            void $this$mapNotNullTo$iv;
            Iterable iterable = (Iterable)jsonNode;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                JsonNode it = (JsonNode)element$iv;
                boolean bl2 = false;
                JsonNode jsonNode2 = it.get("name");
                if ((jsonNode2 != null ? jsonNode2.textValue() : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            set2 = (Set)var2_2;
        } else {
            set2 = set = null;
        }
        if (set2 == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> parseDeclaredLicenses(JsonNode packageInfo) {
        Set set;
        Set set2;
        JsonNode jsonNode = packageInfo.get("license");
        if (jsonNode != null) {
            void var2_2;
            void $this$mapNotNullTo$iv;
            Iterable iterable = (Iterable)jsonNode;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                JsonNode it = (JsonNode)element$iv;
                boolean bl2 = false;
                if (it.textValue() == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            set2 = (Set)var2_2;
        } else {
            set2 = set = null;
        }
        if (set2 == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private static final VcsInfo parseVcsInfo(JsonNode packageInfo) {
        VcsInfo vcsInfo;
        JsonNode jsonNode = packageInfo.get("source");
        if (jsonNode != null) {
            JsonNode it = jsonNode;
            boolean bl = false;
            vcsInfo = new VcsInfo(VcsType.Companion.forName(ExtensionsKt.textValueOrEmpty((JsonNode)it.get("type"))), ExtensionsKt.textValueOrEmpty((JsonNode)it.get("url")), ExtensionsKt.textValueOrEmpty((JsonNode)it.get("reference")), null, 8, null);
        } else {
            vcsInfo = null;
        }
        return VcsInfoKt.orEmpty(vcsInfo);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> parseVirtualPackageNames(Map<String, Package> packages, JsonNode manifest, JsonNode lockFile) {
        Set replacedNames = new LinkedHashSet();
        CollectionsKt.addAll((Collection)replacedNames, (Iterable)ComposerKt.parseVirtualNames(manifest));
        Object[] objectArray = new String[]{"packages", "packages-dev"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$flatMapTo$iv$iv;
            String type = (String)element$iv;
            boolean bl = false;
            JsonNode jsonNode = lockFile.get(type);
            if (jsonNode == null) continue;
            Iterable $this$flatMap$iv = (Iterable)jsonNode;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                JsonNode pkgInfo = (JsonNode)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)pkgInfo);
                Iterable list$iv$iv = ComposerKt.parseVirtualNames(pkgInfo);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List it = (List)destination$iv$iv;
            boolean bl3 = false;
            CollectionsKt.addAll((Collection)replacedNames, (Iterable)it);
        }
        return SetsKt.minus((Set)replacedNames, (Iterable)packages.keySet());
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> parseVirtualNames(JsonNode packageInfo) {
        void var2_2;
        void $this$flatMapTo$iv;
        Object object = new String[]{"replace", "provide"};
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Sequence sequence;
            Sequence sequence2;
            Iterator iterator;
            String it = (String)element$iv;
            boolean bl = false;
            Object object2 = packageInfo.get(it);
            if (object2 != null && (object2 = (iterator = object2.fieldNames())) != null) {
                Intrinsics.checkNotNull((Object)object2);
                sequence2 = SequencesKt.asSequence((Iterator)iterator);
            } else {
                sequence2 = sequence = null;
            }
            if (sequence2 == null) {
                sequence = SequencesKt.emptySequence();
            }
            Sequence list$iv = sequence;
            CollectionsKt.addAll((Collection)destination$iv, (Sequence)list$iv);
        }
        return (Set)var2_2;
    }

    public static final /* synthetic */ Set access$parseVirtualPackageNames(Map packages, JsonNode manifest, JsonNode lockFile) {
        return ComposerKt.parseVirtualPackageNames(packages, manifest, lockFile);
    }

    public static final /* synthetic */ boolean access$isPlatformDependency(String $receiver) {
        return ComposerKt.isPlatformDependency($receiver);
    }

    public static final /* synthetic */ VcsInfo access$parseVcsInfo(JsonNode packageInfo) {
        return ComposerKt.parseVcsInfo(packageInfo);
    }

    public static final /* synthetic */ Set access$parseAuthors(JsonNode packageInfo) {
        return ComposerKt.parseAuthors(packageInfo);
    }

    public static final /* synthetic */ Set access$parseDeclaredLicenses(JsonNode packageInfo) {
        return ComposerKt.parseDeclaredLicenses(packageInfo);
    }

    public static final /* synthetic */ Sequence access$getRuntimeDependencies(String packageName, JsonNode lockFile) {
        return ComposerKt.getRuntimeDependencies(packageName, lockFile);
    }

    public static final /* synthetic */ RemoteArtifact access$parseArtifact(JsonNode packageInfo) {
        return ComposerKt.parseArtifact(packageInfo);
    }

    static {
        Object[] objectArray = new String[]{"composer", "composer-plugin-api", "composer-runtime-api"};
        COMPOSER_PLATFORM_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"php", "php-64bit", "php-ipv6", "php-zts", "php-debug"};
        PHP_PLATFORM_TYPES = SetsKt.setOf((Object[])objectArray);
    }
}

