/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.composer;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.model.Hash;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.RemoteArtifact;
import org.ossreviewtoolkit.model.RemoteArtifactKt;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.VcsInfoKt;
import org.ossreviewtoolkit.model.VcsType;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.Lockfile;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.PackageInfo;
import org.ossreviewtoolkit.utils.ort.ProcessedDeclaredLicense;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0001H\u0002\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a2\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\f\u0010\u0019\u001a\u00020\u0017*\u00020\u0010H\u0002\u001a\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005*\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"COMPOSER_PHAR_BINARY", "", "SCOPE_NAME_REQUIRE", "SCOPE_NAME_REQUIRE_DEV", "ALL_SCOPE_NAMES", "", "isPlatformDependency", "", "COMPOSER_PLATFORM_TYPES", "PHP_PLATFORM_TYPES", "getRuntimeDependencies", "packageName", "lockfile", "Lorg/ossreviewtoolkit/plugins/packagemanagers/composer/Lockfile;", "parseAuthors", "packageInfo", "Lorg/ossreviewtoolkit/plugins/packagemanagers/composer/PackageInfo;", "parseDeclaredLicenses", "parseVcsInfo", "Lorg/ossreviewtoolkit/model/VcsInfo;", "parseVirtualPackageNames", "packages", "", "Lorg/ossreviewtoolkit/model/Package;", "projectPackageInfo", "toPackage", "getScopeDependencies", "scopeName", "composer-package-manager"})
@SourceDebugExtension(value={"SMAP\nComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Composer.kt\norg/ossreviewtoolkit/plugins/packagemanagers/composer/ComposerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1863#2,2:344\n1619#2:346\n1863#2:347\n1864#2:349\n1620#2:350\n1454#2,5:351\n1#3:348\n*S KotlinDebug\n*F\n+ 1 Composer.kt\norg/ossreviewtoolkit/plugins/packagemanagers/composer/ComposerKt\n*L\n261#1:344,2\n271#1:346\n271#1:347\n271#1:349\n271#1:350\n301#1:351,5\n271#1:348\n*E\n"})
public final class ComposerKt {
    @NotNull
    private static final String COMPOSER_PHAR_BINARY = "composer.phar";
    @NotNull
    private static final String SCOPE_NAME_REQUIRE = "require";
    @NotNull
    private static final String SCOPE_NAME_REQUIRE_DEV = "require-dev";
    @NotNull
    private static final Set<String> ALL_SCOPE_NAMES;
    @NotNull
    private static final Set<String> COMPOSER_PLATFORM_TYPES;
    @NotNull
    private static final Set<String> PHP_PLATFORM_TYPES;

    private static final boolean isPlatformDependency(String $this$isPlatformDependency) {
        return SetsKt.plus(COMPOSER_PLATFORM_TYPES, (Iterable)PHP_PLATFORM_TYPES).contains($this$isPlatformDependency) || StringsKt.startsWith$default((String)$this$isPlatformDependency, (String)"ext-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isPlatformDependency, (String)"lib-", (boolean)false, (int)2, null);
    }

    private static final Set<String> getRuntimeDependencies(String packageName, Lockfile lockfile) {
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)lockfile.getPackages(), (Iterable)lockfile.getPackagesDev());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PackageInfo packageInfo = (PackageInfo)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)packageInfo.getName(), (Object)packageName)) continue;
            return packageInfo.getRequire().keySet();
        }
        return SetsKt.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> parseAuthors(PackageInfo packageInfo) {
        void var2_2;
        void $this$mapNotNullTo$iv;
        Iterable iterable = packageInfo.getAuthors();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            PackageInfo.Author it = (PackageInfo.Author)element$iv;
            boolean bl2 = false;
            if (it.getName() == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var2_2;
    }

    private static final Set<String> parseDeclaredLicenses(PackageInfo packageInfo) {
        return CollectionsKt.toSet((Iterable)packageInfo.getLicense());
    }

    private static final VcsInfo parseVcsInfo(PackageInfo packageInfo) {
        VcsInfo vcsInfo;
        PackageInfo.Source source = packageInfo.getSource();
        if (source != null) {
            String string;
            PackageInfo.Source it = source;
            boolean bl = false;
            String string2 = it.getType();
            if (string2 == null) {
                string2 = "";
            }
            VcsType vcsType = VcsType.Companion.forName(string2);
            String string3 = it.getUrl();
            if (string3 == null) {
                string3 = "";
            }
            if ((string = it.getReference()) == null) {
                string = "";
            }
            vcsInfo = new VcsInfo(vcsType, string3, string, null, 8, null);
        } else {
            vcsInfo = null;
        }
        return VcsInfoKt.orEmpty(vcsInfo);
    }

    private static final Set<String> parseVirtualPackageNames(Map<String, Package> packages, PackageInfo projectPackageInfo, Lockfile lockfile) {
        Set set;
        Set $this$parseVirtualPackageNames_u24lambda_u244 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$flatMapTo$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)lockfile.getPackages(), (Iterable)lockfile.getPackagesDev()), (Object)projectPackageInfo);
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PackageInfo it = (PackageInfo)element$iv;
            boolean bl2 = false;
            Iterable list$iv = SetsKt.plus(it.getReplace().keySet(), (Iterable)it.getProvide().keySet());
            CollectionsKt.addAll((Collection)$this$parseVirtualPackageNames_u24lambda_u244, (Iterable)list$iv);
        }
        $this$parseVirtualPackageNames_u24lambda_u244.removeAll((Collection)packages.keySet());
        return SetsKt.build((Set)set);
    }

    /*
     * WARNING - void declaration
     */
    private static final Package toPackage(PackageInfo $this$toPackage) {
        RemoteArtifact remoteArtifact;
        String string;
        String version;
        String string2 = $this$toPackage.getName();
        if (string2 == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        String rawName = string2;
        String string4 = $this$toPackage.getVersion();
        if (string4 == null) {
            string4 = version = "";
        }
        if ((string = $this$toPackage.getHomepage()) == null) {
            string = "";
        }
        String homepageUrl = string;
        VcsInfo vcsFromPackage = ComposerKt.parseVcsInfo($this$toPackage);
        Identifier identifier = new Identifier("Composer", StringsKt.substringBefore$default((String)rawName, (char)'/', null, (int)2, null), StringsKt.substringAfter$default((String)rawName, (char)'/', null, (int)2, null), version);
        String string5 = null;
        String string6 = null;
        Set<String> set = ComposerKt.parseAuthors($this$toPackage);
        Set<String> set2 = ComposerKt.parseDeclaredLicenses($this$toPackage);
        ProcessedDeclaredLicense processedDeclaredLicense = null;
        SpdxExpression spdxExpression = null;
        String string7 = $this$toPackage.getDescription();
        if (string7 == null) {
            string7 = "";
        }
        String string8 = homepageUrl;
        RemoteArtifact remoteArtifact2 = RemoteArtifact.EMPTY;
        PackageInfo.Dist dist = $this$toPackage.getDist();
        if (dist != null) {
            String string9;
            void it;
            PackageInfo.Dist dist2 = dist;
            RemoteArtifact remoteArtifact3 = remoteArtifact2;
            String string10 = string8;
            String string11 = string7;
            SpdxExpression spdxExpression2 = spdxExpression;
            ProcessedDeclaredLicense processedDeclaredLicense2 = processedDeclaredLicense;
            Set<String> set3 = set2;
            Set<String> set4 = set;
            String string12 = string6;
            String string13 = string5;
            Identifier identifier2 = identifier;
            boolean bl = false;
            String string14 = it.getUrl();
            if (string14 == null) {
                string14 = "";
            }
            if ((string9 = it.getShasum()) == null) {
                string9 = "";
            }
            RemoteArtifact remoteArtifact4 = new RemoteArtifact(string14, Hash.Companion.create(string9));
            identifier = identifier2;
            string5 = string13;
            string6 = string12;
            set = set4;
            set2 = set3;
            processedDeclaredLicense = processedDeclaredLicense2;
            spdxExpression = spdxExpression2;
            string7 = string11;
            string8 = string10;
            remoteArtifact2 = remoteArtifact3;
            remoteArtifact = remoteArtifact4;
        } else {
            remoteArtifact = null;
        }
        String[] stringArray = new String[]{homepageUrl};
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 122982;
        Map map = null;
        List list = null;
        boolean bl = false;
        boolean bl2 = false;
        VcsInfo vcsInfo = PackageManager.Companion.processPackageVcs(vcsFromPackage, stringArray);
        VcsInfo vcsInfo2 = vcsFromPackage;
        RemoteArtifact remoteArtifact5 = RemoteArtifactKt.orEmpty(remoteArtifact);
        RemoteArtifact remoteArtifact6 = remoteArtifact2;
        String string15 = string8;
        String string16 = string7;
        SpdxExpression spdxExpression3 = spdxExpression;
        ProcessedDeclaredLicense processedDeclaredLicense3 = processedDeclaredLicense;
        Set<String> set5 = set2;
        Set<String> set6 = set;
        String string17 = string6;
        String string18 = string5;
        Identifier identifier3 = identifier;
        return new Package(identifier3, string18, string17, set6, set5, processedDeclaredLicense3, spdxExpression3, string16, string15, remoteArtifact6, remoteArtifact5, vcsInfo2, vcsInfo, bl2, bl, list, map, n, defaultConstructorMarker);
    }

    private static final Set<String> getScopeDependencies(PackageInfo $this$getScopeDependencies, String scopeName) {
        Set<String> set;
        String string = scopeName;
        if (Intrinsics.areEqual((Object)string, (Object)SCOPE_NAME_REQUIRE)) {
            set = $this$getScopeDependencies.getRequire().keySet();
        } else if (Intrinsics.areEqual((Object)string, (Object)SCOPE_NAME_REQUIRE_DEV)) {
            set = $this$getScopeDependencies.getRequireDev().keySet();
        } else {
            throw new IllegalStateException(("Invalid scope name: '" + scopeName + "'.").toString());
        }
        return set;
    }

    public static final /* synthetic */ Set access$parseVirtualPackageNames(Map packages, PackageInfo projectPackageInfo, Lockfile lockfile) {
        return ComposerKt.parseVirtualPackageNames(packages, projectPackageInfo, lockfile);
    }

    public static final /* synthetic */ Set access$getALL_SCOPE_NAMES$p() {
        return ALL_SCOPE_NAMES;
    }

    public static final /* synthetic */ VcsInfo access$parseVcsInfo(PackageInfo packageInfo) {
        return ComposerKt.parseVcsInfo(packageInfo);
    }

    public static final /* synthetic */ Set access$parseAuthors(PackageInfo packageInfo) {
        return ComposerKt.parseAuthors(packageInfo);
    }

    public static final /* synthetic */ Set access$parseDeclaredLicenses(PackageInfo packageInfo) {
        return ComposerKt.parseDeclaredLicenses(packageInfo);
    }

    public static final /* synthetic */ Package access$toPackage(PackageInfo $receiver) {
        return ComposerKt.toPackage($receiver);
    }

    public static final /* synthetic */ Set access$getScopeDependencies(PackageInfo $receiver, String scopeName) {
        return ComposerKt.getScopeDependencies($receiver, scopeName);
    }

    public static final /* synthetic */ boolean access$isPlatformDependency(String $receiver) {
        return ComposerKt.isPlatformDependency($receiver);
    }

    public static final /* synthetic */ Set access$getRuntimeDependencies(String packageName, Lockfile lockfile) {
        return ComposerKt.getRuntimeDependencies(packageName, lockfile);
    }

    static {
        Object[] objectArray = new String[]{SCOPE_NAME_REQUIRE, SCOPE_NAME_REQUIRE_DEV};
        ALL_SCOPE_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"composer", "composer-plugin-api", "composer-runtime-api"};
        COMPOSER_PLATFORM_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"php", "php-64bit", "php-ipv6", "php-zts", "php-debug"};
        PHP_PLATFORM_TYPES = SetsKt.setOf((Object[])objectArray);
    }
}

