/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.composer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.analyzer.PackageManagerFactory;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageReference;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.Excludes;
import org.ossreviewtoolkit.plugins.api.OrtPlugin;
import org.ossreviewtoolkit.plugins.api.Plugin;
import org.ossreviewtoolkit.plugins.api.PluginDescriptor;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.ComposerCommand;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.ComposerFactory;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.ComposerKt;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.Lockfile;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.LockfileProvider;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.ModelKt;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.PackageInfo;
import org.ossreviewtoolkit.utils.common.CommandLineTool;
import org.ossreviewtoolkit.utils.common.DirectoryStashKt;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;

@OrtPlugin(displayName="Composer", description="The Composer package manager for PHP.", factory=PackageManagerFactory.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\tH\u0016JB\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001bH\u0016JV\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u001d2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020#0\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u001d2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J&\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001dH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006*"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/composer/Composer;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "descriptor", "Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "<init>", "(Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;)V", "getDescriptor", "()Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "beforeResolution", "", "analysisRoot", "Ljava/io/File;", "definitionFiles", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "mapDefinitionFiles", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "excludes", "Lorg/ossreviewtoolkit/model/config/Excludes;", "labels", "", "buildDependencyTree", "", "Lorg/ossreviewtoolkit/model/PackageReference;", "dependencies", "lockfile", "Lorg/ossreviewtoolkit/plugins/packagemanagers/composer/Lockfile;", "packages", "Lorg/ossreviewtoolkit/model/Package;", "virtualPackages", "dependencyBranch", "parseProject", "Lorg/ossreviewtoolkit/model/Project;", "scopes", "Lorg/ossreviewtoolkit/model/Scope;", "composer-package-manager"})
@SourceDebugExtension(value={"SMAP\nComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Composer.kt\norg/ossreviewtoolkit/plugins/packagemanagers/composer/Composer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 4 Issue.kt\norg/ossreviewtoolkit/model/IssueKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1740#2,3:347\n1193#2,2:350\n1267#2,4:352\n1634#2,3:356\n827#2:359\n855#2,2:360\n1869#2:362\n1870#2:375\n38#3:363\n38#3:373\n38#3:376\n38#3:377\n98#4,5:364\n88#4:369\n89#4,2:371\n91#4:374\n1#5:370\n*S KotlinDebug\n*F\n+ 1 Composer.kt\norg/ossreviewtoolkit/plugins/packagemanagers/composer/Composer\n*L\n103#1:347,3\n157#1:350,2\n157#1:352,4\n169#1:356,3\n190#1:359\n190#1:360,2\n192#1:362\n192#1:375\n197#1:363\n216#1:373\n226#1:376\n152#1:377\n216#1:364,5\n216#1:369\n216#1:371,2\n216#1:374\n216#1:370\n*E\n"})
public final class Composer
extends PackageManager {
    @NotNull
    private final PluginDescriptor descriptor;
    @NotNull
    private final List<String> globsForDefinitionFiles;

    public Composer(@NotNull PluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super("Composer");
        this.descriptor = descriptor;
        this.globsForDefinitionFiles = CollectionsKt.listOf((Object)"composer.json");
    }

    public /* synthetic */ Composer(PluginDescriptor pluginDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pluginDescriptor = ComposerFactory.Companion.getDescriptor();
        }
        this(pluginDescriptor);
    }

    @NotNull
    public PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public List<String> getGlobsForDefinitionFiles() {
        return this.globsForDefinitionFiles;
    }

    public void beforeResolution(@NotNull File analysisRoot, @NotNull List<? extends File> definitionFiles, @NotNull AnalyzerConfiguration analyzerConfig) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Iterable $this$all$iv = definitionFiles;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (new File(it.getParentFile(), "composer.phar").isFile()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        CommandLineTool.DefaultImpls.checkVersion$default((CommandLineTool)ComposerCommand.INSTANCE, null, (int)1, null);
    }

    @NotNull
    public List<File> mapDefinitionFiles(@NotNull File analysisRoot, @NotNull List<? extends File> definitionFiles) {
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        List projectFiles = CollectionsKt.toMutableList((Collection)definitionFiles);
        int index = 0;
        while (index < projectFiles.size() - 1) {
            File projectFile = (File)projectFiles.get(index++);
            File vendorDir = FilesKt.resolveSibling((File)projectFile, (String)"vendor");
            CollectionsKt.removeAll(projectFiles.subList(index, projectFiles.size()), arg_0 -> Composer.mapDefinitionFiles$lambda$1(vendorDir, arg_0));
        }
        return projectFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File analysisRoot, @NotNull File definitionFile, @NotNull Excludes excludes, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull Map<String, String> labels) {
        void destination$iv;
        void $this$mapTo$iv;
        Collection $this$associateTo$iv$iv;
        Lockfile lockfile;
        Object lockfileProvider;
        boolean hasDependencies;
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter((Object)excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        File workingDir = definitionFile.getParentFile();
        PackageInfo projectPackageInfo = ModelKt.parsePackageInfo(FilesKt.readText$default((File)definitionFile, null, (int)1, null));
        boolean bl = hasDependencies = !projectPackageInfo.getRequire().isEmpty();
        if (!hasDependencies) {
            Project project = this.parseProject(analysisRoot, definitionFile, SetsKt.emptySet());
            ProjectAnalyzerResult result = new ProjectAnalyzerResult(project, SetsKt.emptySet(), null, 4, null);
            return CollectionsKt.listOf((Object)result);
        }
        Object result = new File[1];
        Intrinsics.checkNotNull((Object)workingDir);
        result[0] = FilesKt.resolve((File)workingDir, (String)"vendor");
        result = DirectoryStashKt.stashDirectories((File[])result);
        Throwable throwable = null;
        try {
            boolean bl2 = false;
            lockfileProvider = new LockfileProvider(definitionFile);
            this.requireLockfile(analysisRoot, workingDir, analyzerConfig.getAllowDynamicVersions(), () -> Composer.resolveDependencies$lambda$5$lambda$2((LockfileProvider)lockfileProvider));
            lockfile = (Lockfile)((LockfileProvider)lockfileProvider).ensureLockfile(arg_0 -> Composer.resolveDependencies$lambda$5$lambda$4(this, arg_0));
        }
        catch (Throwable bl2) {
            throwable = bl2;
            throw bl2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)result, (Throwable)throwable);
        }
        Lockfile lockfile2 = lockfile;
        Iterable $this$associate$iv = CollectionsKt.plus((Collection)lockfile2.getPackages(), (Iterable)lockfile2.getPackagesDev());
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        lockfileProvider = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            PackageInfo it = (PackageInfo)element$iv$iv;
            boolean bl3 = false;
            String string = it.getName();
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            it = TuplesKt.to((Object)string, (Object)ComposerKt.access$toPackage(it));
            map.put(it.getFirst(), it.getSecond());
        }
        Map packages = destination$iv$iv;
        Set virtualPackages = ComposerKt.access$parseVirtualPackageNames(packages, projectPackageInfo, lockfile2);
        Iterable capacity$iv22 = ComposerKt.access$getALL_SCOPE_NAMES$p();
        $this$associateTo$iv$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void scopeName;
            Object element$iv$iv;
            element$iv$iv = (String)item$iv;
            void var23_34 = destination$iv;
            boolean bl4 = false;
            Set requiredPackages = ComposerKt.access$getScopeDependencies(projectPackageInfo, (String)scopeName);
            Set dependencies = Composer.buildDependencyTree$default(this, requiredPackages, lockfile2, packages, virtualPackages, null, 16, null);
            var23_34.add(new Scope((String)scopeName, dependencies));
        }
        Set scopes = (Set)destination$iv;
        Project project = this.parseProject(analysisRoot, definitionFile, scopes);
        ProjectAnalyzerResult result2 = new ProjectAnalyzerResult(project, CollectionsKt.toSet((Iterable)packages.values()), null, 4, null);
        return CollectionsKt.listOf((Object)result2);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PackageReference> buildDependencyTree(Set<String> dependencies, Lockfile lockfile, Map<String, Package> packages, Set<String> virtualPackages, List<String> dependencyBranch) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Set packageReferences = new LinkedHashSet();
        Iterable $this$filterNot$iv = dependencies;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String packageName = (String)element$iv$iv;
            boolean bl = false;
            if (ComposerKt.access$isPlatformDependency(packageName) || virtualPackages.contains(packageName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Package packageInfo;
            String packageName = (String)element$iv;
            boolean bl = false;
            if (packages.get(packageName) == null) {
                throw new IOException("Could not find package info for " + packageName);
            }
            if (dependencyBranch.contains(packageName)) {
                Composer $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(Composer.class).debug(() -> Composer.buildDependencyTree$lambda$10$lambda$9(packageName, dependencyBranch));
                continue;
            }
            try {
                Set runtimeDependencies = ComposerKt.access$getRuntimeDependencies(packageName, lockfile);
                Set<PackageReference> transitiveDependencies = this.buildDependencyTree(runtimeDependencies, lockfile, packages, virtualPackages, CollectionsKt.plus((Collection)dependencyBranch, (Object)packageName));
                ((Collection)packageReferences).add(Package.toReference$default((Package)packageInfo, null, transitiveDependencies, null, (int)5, null));
            }
            catch (IOException e) {
                void $this$createAndLogIssue$iv$iv;
                void $this$createAndLogIssue_u24default$iv;
                ExtensionsKt.showStackTrace((Throwable)e);
                Plugin plugin = (Plugin)this;
                String message$iv = "Could not resolve dependencies of '" + packageName + "': " + org.ossreviewtoolkit.utils.common.ExtensionsKt.collectMessages((Throwable)e);
                Object severity$iv = null;
                String affectedPath$iv = null;
                boolean $i$f$createAndLogIssue = false;
                void var21_26 = $this$createAndLogIssue_u24default$iv;
                String source$iv$iv = $this$createAndLogIssue_u24default$iv.getDescriptor().getDisplayName();
                boolean $i$f$createAndLogIssue2 = false;
                Issue issue$iv$iv = new Issue(null, source$iv$iv, message$iv, null, affectedPath$iv, 9, null);
                void $this$logger$iv$iv$iv = $this$createAndLogIssue$iv$iv;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(Composer.class).log(issue$iv$iv.getSeverity().toLog4jLevel(), (Function0)new Function0<Object>(message$iv){
                    final /* synthetic */ String $message;
                    {
                        this.$message = $message;
                    }

                    public final Object invoke() {
                        return this.$message;
                    }
                });
                Package.toReference$default((Package)packageInfo, null, null, (List)CollectionsKt.listOf((Object)issue$iv$iv), (int)3, null);
            }
        }
        return packageReferences;
    }

    static /* synthetic */ Set buildDependencyTree$default(Composer composer, Set set, Lockfile lockfile, Map map, Set set2, List list, int n, Object object) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return composer.buildDependencyTree(set, lockfile, map, set2, list);
    }

    private final Project parseProject(File analysisRoot, File definitionFile, Set<Scope> scopes) {
        String string;
        String namespace;
        String rawName;
        Composer $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(Composer.class).info(() -> Composer.parseProject$lambda$11(definitionFile));
        PackageInfo pkgInfo = ModelKt.parsePackageInfo(FilesKt.readText$default((File)definitionFile, null, (int)1, null));
        String string2 = pkgInfo.getHomepage();
        if (string2 == null) {
            string2 = "";
        }
        String homepageUrl = string2;
        VcsInfo vcs = ComposerKt.access$parseVcsInfo(pkgInfo);
        String string3 = rawName = pkgInfo.getName();
        String string4 = string3 != null ? StringsKt.substringBefore((String)string3, (String)"/", (String)"") : null;
        if (string4 == null) {
            string4 = namespace = "";
        }
        if ((string = rawName) == null || (string = StringsKt.substringAfter$default((String)string, (String)"/", null, (int)2, null)) == null) {
            string = PackageManager.Companion.getFallbackProjectName(analysisRoot, definitionFile);
        }
        String name = string;
        String string5 = this.getProjectType();
        String string6 = pkgInfo.getVersion();
        if (string6 == null) {
            string6 = "";
        }
        Identifier identifier = new Identifier(string5, namespace, name, string6);
        String string7 = VersionControlSystem.Companion.getPathInfo(definitionFile).getPath();
        Set set = ComposerKt.access$parseAuthors(pkgInfo);
        Set set2 = ComposerKt.access$parseDeclaredLicenses(pkgInfo);
        File file = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        String[] stringArray = new String[]{homepageUrl};
        return new Project(identifier, null, string7, set, set2, null, vcs, PackageManager.Companion.processProjectVcs(file, vcs, stringArray), null, homepageUrl, scopes, null, 2338, null);
    }

    private static final boolean mapDefinitionFiles$lambda$1(File $vendorDir, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FilesKt.startsWith((File)it, (File)$vendorDir);
    }

    private static final boolean resolveDependencies$lambda$5$lambda$2(LockfileProvider $lockfileProvider) {
        return $lockfileProvider.getLockfile().isFile();
    }

    private static final Object resolveDependencies$lambda$5$lambda$4$lambda$3(File $it) {
        return "Parsing lockfile at '" + $it + "'...";
    }

    private static final Lockfile resolveDependencies$lambda$5$lambda$4(Composer this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Composer $this$logger$iv = this$0;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(Composer.class).info(() -> Composer.resolveDependencies$lambda$5$lambda$4$lambda$3(it));
        return ModelKt.parseLockfile(FilesKt.readText$default((File)it, null, (int)1, null));
    }

    private static final Object buildDependencyTree$lambda$10$lambda$9(String $packageName, List $dependencyBranch) {
        return "Not adding circular dependency '" + $packageName + "' to the tree, it is already on this branch of the dependency tree: " + CollectionsKt.joinToString$default((Iterable)$dependencyBranch, (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null) + ".";
    }

    private static final Object parseProject$lambda$11(File $definitionFile) {
        return "Parsing project metadata from '" + $definitionFile + "'...";
    }

    public Composer() {
        this(null, 1, null);
    }
}

