/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.composer;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.ComposerCommand;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.semver4j.Semver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/composer/LockfileProvider;", "", "definitionFile", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "workingDir", "kotlin.jvm.PlatformType", "lockfile", "getLockfile", "()Ljava/io/File;", "ensureLockfile", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "enableLockfileCreation", "createLockFile", "", "composer-package-manager"})
@SourceDebugExtension(value={"SMAP\nLockfileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LockfileProvider.kt\norg/ossreviewtoolkit/plugins/packagemanagers/composer/LockfileProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,87:1\n1#2:88\n37#3:89\n36#3,3:90\n*S KotlinDebug\n*F\n+ 1 LockfileProvider.kt\norg/ossreviewtoolkit/plugins/packagemanagers/composer/LockfileProvider\n*L\n83#1:89\n83#1:90,3\n*E\n"})
public final class LockfileProvider {
    @NotNull
    private final File definitionFile;
    private final File workingDir;
    @NotNull
    private final File lockfile;

    public LockfileProvider(@NotNull File definitionFile) {
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        this.definitionFile = definitionFile;
        File file = this.workingDir = this.definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"workingDir");
        this.lockfile = FilesKt.resolve((File)file, (String)"composer.lock");
    }

    @NotNull
    public final File getLockfile() {
        return this.lockfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T ensureLockfile(@NotNull Function1<? super File, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.lockfile.isFile()) {
            return (T)block.invoke((Object)this.lockfile);
        }
        File definitionFileBackup = this.enableLockfileCreation();
        try {
            if (!this.createLockFile()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            object = block.invoke((Object)this.lockfile);
            this.lockfile.delete();
        }
        catch (Throwable throwable) {
            this.lockfile.delete();
            File file = definitionFileBackup;
            if (file != null) {
                File file2;
                File it = file2 = file;
                boolean bl = false;
                Path path = it.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                Path path2 = path;
                Path path3 = this.definitionFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toPath(...)");
                Path path4 = path3;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                CopyOption[] copyOptionArray2 = copyOptionArray;
                Intrinsics.checkNotNullExpressionValue((Object)Files.move(path2, path4, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"move(...)");
            }
            throw throwable;
        }
        File file = definitionFileBackup;
        if (file != null) {
            File file3;
            File it = file3 = file;
            boolean bl = false;
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Path path5 = path;
            Path path6 = this.definitionFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"toPath(...)");
            Path path7 = path6;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray3 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path5, path7, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"move(...)");
        }
        return (T)object;
    }

    private final File enableLockfileCreation() {
        File definitionFileBackup = null;
        Object object = new CharSequence[]{"--no-interaction", "config", "lock"};
        ProcessCapture lockConfig = ComposerCommand.INSTANCE.run(this.workingDir, (CharSequence)object);
        if (lockConfig.isSuccess() && Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)lockConfig.getStdout())).toString(), (Object)"false")) {
            Object it = object = File.createTempFile("composer", "json", this.workingDir);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            definitionFileBackup = FilesKt.copyTo$default((File)this.definitionFile, (File)it, (boolean)true, (int)0, (int)4, null);
            CharSequence[] charSequenceArray = new CharSequence[]{"--no-interaction", "config", "--unset", "lock"};
            ProcessCapture unsetLock = ComposerCommand.INSTANCE.run(this.workingDir, charSequenceArray);
            if (unsetLock.isError()) {
                File file = definitionFileBackup;
                if (file != null) {
                    file.delete();
                }
                return null;
            }
        }
        return definitionFileBackup;
    }

    private final boolean createLockFile() {
        List list;
        List $this$createLockFile_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$createLockFile_u24lambda_u242.add("--no-interaction");
        $this$createLockFile_u24lambda_u242.add("update");
        $this$createLockFile_u24lambda_u242.add("--ignore-platform-reqs");
        Semver composerVersion = new Semver(ComposerCommand.INSTANCE.getVersion(this.workingDir));
        if (composerVersion.getMajor() >= 2) {
            $this$createLockFile_u24lambda_u242.add("--no-install");
            $this$createLockFile_u24lambda_u242.add("--no-audit");
        }
        List args = CollectionsKt.build((List)list);
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        ProcessCapture update = ComposerCommand.INSTANCE.run(this.workingDir, Arrays.copyOf(stringArray, stringArray.length));
        return update.isSuccess();
    }
}

