/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.go;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import net.peanuuutz.tomlkt.Toml;
import net.peanuuutz.tomlkt.TomlStreamsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.IssueKt;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageLinkage;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.RemoteArtifact;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.go.GoDepKt;
import org.ossreviewtoolkit.plugins.packagemanagers.go.GoDepLockFile;
import org.ossreviewtoolkit.plugins.packagemanagers.go.utils.GoSupportKt;
import org.ossreviewtoolkit.utils.common.CommandLineTool;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;
import org.semver4j.RangesList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001 B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J*\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00150\u00142\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\u0006\u0010\u0018\u001a\u00020\u00062\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0015H\u0016J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0016\u00a8\u0006!"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/go/GoDep;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "Lorg/ossreviewtoolkit/utils/common/CommandLineTool;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "command", "workingDir", "getVersionArguments", "importLegacyManifest", "", "lockfileName", "gopath", "parseProjects", "", "", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "labels", "setUpWorkspace", "projectDir", "vcs", "Lorg/ossreviewtoolkit/model/VcsInfo;", "transformVersion", "output", "Factory", "go-package-manager"})
@SourceDebugExtension(value={"SMAP\nGoDep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDep.kt\norg/ossreviewtoolkit/plugins/packagemanagers/go/GoDep\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 TomlStreams.kt\nnet/peanuuutz/tomlkt/TomlStreamsKt\n*L\n1#1,299:1\n123#2,2:300\n38#3:302\n38#3:306\n38#3:308\n38#3:310\n819#4:303\n847#4,2:304\n1855#4,2:311\n1#5:307\n148#6:309\n*S KotlinDebug\n*F\n+ 1 GoDep.kt\norg/ossreviewtoolkit/plugins/packagemanagers/go/GoDep\n*L\n105#1:300,2\n114#1:302\n205#1:306\n228#1:308\n235#1:310\n166#1:303\n166#1:304,2\n241#1:311,2\n233#1:309\n*E\n"})
public final class GoDep
extends PackageManager
implements CommandLineTool {
    public GoDep(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, analysisRoot, analyzerConfig, repoConfig);
    }

    @NotNull
    public String command(@Nullable File workingDir) {
        return "dep";
    }

    @NotNull
    public String getVersionArguments() {
        return "version";
    }

    @NotNull
    public String transformVersion(@NotNull String output) {
        Object element$iv2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Sequence $this$first$iv = StringsKt.lineSequence((CharSequence)output);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                String it = (String)element$iv2;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"version", (boolean)false, (int)2, null)) continue;
                break block1;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)((String)element$iv2), (char)':', null, (int)2, null))).toString(), (CharSequence)"v");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        Object object;
        Object pkg;
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        File projectDir = GoDepKt.access$resolveProjectRoot(definitionFile);
        Intrinsics.checkNotNull((Object)projectDir);
        VcsInfo projectVcs = PackageManager.Companion.processProjectVcs$default((PackageManager.Companion)PackageManager.Companion, (File)projectDir, null, (String[])new String[0], (int)2, null);
        String[] stringArray = new String[]{projectDir.getName() + "-gopath"};
        File gopath = ExtensionsKt.createOrtTempDir((Object)((Object)this), (String[])stringArray);
        File workingDir = this.setUpWorkspace(projectDir, projectVcs, gopath);
        String string = (String)GoDepKt.access$getGO_LEGACY_MANIFESTS$p().get(definitionFile.getName());
        if (string != null) {
            String lockfileName = string;
            boolean bl = false;
            GoDep $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(GoDep.class).debug((Function0)new Function0<Object>(definitionFile){
                final /* synthetic */ File $definitionFile;
                {
                    this.$definitionFile = $definitionFile;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Importing legacy manifest file at '" + this.$definitionFile + "'.";
                }
            });
            this.importLegacyManifest(lockfileName, workingDir, gopath);
        }
        List<Map<String, String>> projects = this.parseProjects(workingDir, gopath);
        Set packages = new LinkedHashSet();
        Set packageRefs = new LinkedHashSet();
        for (Map<String, String> project : projects) {
            VcsInfo vcsInfo;
            String name = (String)MapsKt.getValue(project, (Object)"name");
            String revision = (String)MapsKt.getValue(project, (Object)"revision");
            String version = (String)MapsKt.getValue(project, (Object)"version");
            List issues = new ArrayList();
            try {
                vcsInfo = GoDepKt.access$resolveVcsInfo(name, revision, gopath);
            }
            catch (IOException e) {
                ExtensionsKt.showStackTrace((Throwable)e);
                ((Collection)issues).add(IssueKt.createAndLogIssue$default((Object)((Object)this), (String)this.getManagerName(), (String)("Could not resolve VCS information for project '" + name + "': " + org.ossreviewtoolkit.utils.common.ExtensionsKt.collectMessages((Throwable)e)), null, (int)4, null));
                vcsInfo = VcsInfo.EMPTY;
            }
            VcsInfo vcsProcessed = vcsInfo;
            pkg = new Package(new Identifier("Go", "", name, GoSupportKt.normalizeModuleVersion(version)), null, null, SetsKt.emptySet(), SetsKt.emptySet(), null, null, "", "", RemoteArtifact.EMPTY, RemoteArtifact.EMPTY, VcsInfo.EMPTY, vcsProcessed, false, false, 24678, null);
            ((Collection)packages).add(pkg);
            ((Collection)packageRefs).add(Package.toReference$default((Package)pkg, (PackageLinkage)PackageLinkage.STATIC, null, (List)issues, (int)2, null));
        }
        Scope scope = new Scope("default", packageRefs);
        Object object2 = this;
        try {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            GoDep $this$resolveDependencies_u24lambda_u243 = object2;
            boolean bl = false;
            URI uri = new URI(projectVcs.getUrl());
            File file = definitionFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
            String vcsPath = VersionControlSystem.Companion.getPathInfo(file).getPath();
            pkg = new String[3];
            pkg[0] = uri.getHost();
            String string2 = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            pkg[1] = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string2, (CharSequence)"/"), (CharSequence)".git");
            pkg[2] = vcsPath;
            pkg = CollectionsKt.listOf((Object[])pkg);
            boolean $i$f$filterNot = false;
            void var19_25 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (((CharSequence)it).length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String string3 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            object = Result.constructor-impl((Object)string3);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = PackageManager.Companion.getFallbackProjectName(this.getAnalysisRoot(), definitionFile);
        String projectName = (String)(Result.isFailure-impl((Object)object2) ? object : object2);
        org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)gopath, (boolean)true, null, (int)2, null);
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(new Project(new Identifier(this.getManagerName(), "", projectName, projectVcs.getRevision()), null, VersionControlSystem.Companion.getPathInfo(definitionFile).getPath(), SetsKt.emptySet(), SetsKt.emptySet(), null, VcsInfo.EMPTY, projectVcs, "", SetsKt.setOf((Object)scope), null, 1058, null), packages, null, 4, null));
    }

    private final void importLegacyManifest(String lockfileName, File workingDir, File gopath) {
        this.requireLockfile(workingDir, (Function0)new Function0<Boolean>(lockfileName, workingDir){
            final /* synthetic */ String $lockfileName;
            final /* synthetic */ File $workingDir;
            {
                this.$lockfileName = $lockfileName;
                this.$workingDir = $workingDir;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return ((CharSequence)this.$lockfileName).length() == 0 || FilesKt.resolve((File)this.$workingDir, (String)this.$lockfileName).isFile();
            }
        });
        CharSequence[] charSequenceArray = new CharSequence[]{"init"};
        this.run(charSequenceArray, workingDir, MapsKt.mapOf((Pair)TuplesKt.to((Object)"GOPATH", (Object)org.ossreviewtoolkit.utils.common.ExtensionsKt.realFile((File)gopath).getPath())));
    }

    /*
     * WARNING - void declaration
     */
    private final File setUpWorkspace(File projectDir, VcsInfo vcs, File gopath) {
        void $this$setUpWorkspace_u24lambda_u244;
        Path path;
        Path path2;
        File destination = GoDepKt.deduceImportPath(projectDir, vcs, gopath);
        GoDep $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(GoDep.class).debug((Function0)new Function0<Object>(projectDir, destination){
            final /* synthetic */ File $projectDir;
            final /* synthetic */ File $destination;
            {
                this.$projectDir = $projectDir;
                this.$destination = $destination;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Copying " + this.$projectDir + " to temporary directory " + this.$destination;
            }
        });
        Path path3 = projectDir.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toPath(...)");
        Path path4 = path2 = destination.toPath();
        Path path5 = path3;
        boolean bl = false;
        Path path6 = path = $this$setUpWorkspace_u24lambda_u244.getParent();
        if (path6 != null) {
            Intrinsics.checkNotNull((Object)path6);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path7 = Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            v4 = path7;
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"createDirectories(...)");
        } else {
            v4 = null;
        }
        Path path8 = path2;
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"apply(...)");
        PathsKt.copyToRecursively$default((Path)path5, (Path)path8, null, (boolean)false, null, (int)10, null);
        File dotGit = new File(destination, ".git");
        if (dotGit.isFile()) {
            dotGit.delete();
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Map<String, String>> parseProjects(File workingDir, File gopath) {
        File lockfile = FilesKt.resolve((File)workingDir, (String)"Gopkg.lock");
        this.requireLockfile(workingDir, (Function0)new Function0<Boolean>(lockfile){
            final /* synthetic */ File $lockfile;
            {
                this.$lockfile = $lockfile;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$lockfile.isFile();
            }
        });
        if (!lockfile.isFile()) {
            CharSequence[] $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(GoDep.class).debug((Function0)new Function0<Object>(workingDir){
                final /* synthetic */ File $workingDir;
                {
                    this.$workingDir = $workingDir;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Running 'dep ensure' to generate missing lockfile in " + this.$workingDir;
                }
            });
            $this$logger$iv = new CharSequence[]{"ensure"};
            this.run($this$logger$iv, workingDir, MapsKt.mapOf((Pair)TuplesKt.to((Object)"GOPATH", (Object)gopath.getPath())));
        }
        Object $i$f$getLogger = lockfile;
        Object object = Charsets.UTF_8;
        $i$f$getLogger = new InputStreamReader((InputStream)new FileInputStream((File)$i$f$getLogger), (Charset)object);
        object = null;
        try {
            Object it = (InputStreamReader)$i$f$getLogger;
            boolean bl = false;
            Toml $this$decodeFromNativeReader$iv = GoDepKt.access$getToml$p();
            boolean $i$f$decodeFromNativeReader = false;
            $this$decodeFromNativeReader$iv.getSerializersModule();
            it = (GoDepLockFile)TomlStreamsKt.decodeFromNativeReader((Toml)$this$decodeFromNativeReader$iv, (DeserializationStrategy)((DeserializationStrategy)GoDepLockFile.Companion.serializer()), (Reader)((Reader)it));
        }
        catch (Throwable it) {
            object = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$i$f$getLogger, (Throwable)object);
        }
        Object contents = it;
        if (((GoDepLockFile)contents).getProjects().isEmpty()) {
            CharSequence[] $this$logger$iv = this;
            boolean $i$f$getLogger2 = false;
            LoggingFactoryKt.cachedLoggerOf(GoDep.class).warn((Function0)new Function0<Object>(lockfile){
                final /* synthetic */ File $lockfile;
                {
                    this.$lockfile = $lockfile;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "The lockfile '" + this.$lockfile + "' does not contain any projects.";
                }
            });
            return CollectionsKt.emptyList();
        }
        List projects = new ArrayList();
        Iterable $this$forEach$iv = ((GoDepLockFile)contents).getProjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GoDepLockFile.Project project = (GoDepLockFile.Project)element$iv;
            boolean bl = false;
            String string = project.getVersion();
            if (string == null) {
                string = project.getRevision();
            }
            String version = string;
            Collection collection = projects;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)project.getName()), TuplesKt.to((Object)"revision", (Object)project.getRevision()), TuplesKt.to((Object)"version", (Object)version)};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        return projects;
    }

    public void checkVersion(@Nullable File workingDir) {
        CommandLineTool.DefaultImpls.checkVersion((CommandLineTool)this, (File)workingDir);
    }

    @NotNull
    public String getVersion(@Nullable File workingDir) {
        return CommandLineTool.DefaultImpls.getVersion((CommandLineTool)this, (File)workingDir);
    }

    @NotNull
    public RangesList getVersionRequirement() {
        return CommandLineTool.DefaultImpls.getVersionRequirement((CommandLineTool)this);
    }

    public boolean isInPath() {
        return CommandLineTool.DefaultImpls.isInPath((CommandLineTool)this);
    }

    @NotNull
    public ProcessCapture run(@Nullable File workingDir, CharSequence ... args) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (File)workingDir, (CharSequence[])args);
    }

    @NotNull
    public ProcessCapture run(@NotNull CharSequence[] args, @Nullable File workingDir, @NotNull Map<String, String> environment2) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (CharSequence[])args, (File)workingDir, environment2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/go/GoDep$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/go/GoDep;", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "go-package-manager"})
    @SourceDebugExtension(value={"SMAP\nGoDep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDep.kt\norg/ossreviewtoolkit/plugins/packagemanagers/go/GoDep$Factory\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,299:1\n37#2,2:300\n*S KotlinDebug\n*F\n+ 1 GoDep.kt\norg/ossreviewtoolkit/plugins/packagemanagers/go/GoDep$Factory\n*L\n91#1:300,2\n*E\n"})
    public static final class Factory
    extends AbstractPackageManagerFactory<GoDep> {
        @NotNull
        private final List<String> globsForDefinitionFiles;

        public Factory() {
            super("GoDep", false, 2, null);
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)"Gopkg.toml");
            Collection $this$toTypedArray$iv = GoDepKt.access$getGO_LEGACY_MANIFESTS$p().keySet();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
            this.globsForDefinitionFiles = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public GoDep create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new GoDep(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

