/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.node;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.node.Npm;
import org.ossreviewtoolkit.plugins.packagemanagers.node.utils.NpmSupportKt;
import org.ossreviewtoolkit.utils.common.CommandLineTool;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.Os;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0014J\u0012\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0014J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u001b\u001a\u00020\u0005H\u0014J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0005H\u0014J\f\u0010\u001f\u001a\u00020\u0018*\u00020\u0005H\u0014R\u0014\u0010\u000b\u001a\u00020\fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/node/Pnpm;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/node/Npm;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "modulesSearchDepth", "", "getModulesSearchDepth", "()I", "beforeResolution", "", "definitionFiles", "", "command", "workingDir", "getVersionRequirement", "Lorg/semver4j/RangesList;", "hasLockFile", "", "projectDir", "loadWorkspaceSubmodules", "moduleDir", "mapDefinitionFiles", "runInstall", "Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "isWorkspaceDir", "Factory", "node-package-manager"})
@SourceDebugExtension(value={"SMAP\nPnpm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pnpm.kt\norg/ossreviewtoolkit/plugins/packagemanagers/node/Pnpm\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n766#2:93\n857#2,2:94\n1549#2:96\n1620#2,3:97\n*S KotlinDebug\n*F\n+ 1 Pnpm.kt\norg/ossreviewtoolkit/plugins/packagemanagers/node/Pnpm\n*L\n68#1:93\n68#1:94,2\n68#1:96\n68#1:97,3\n*E\n"})
public final class Pnpm
extends Npm {
    private final int modulesSearchDepth;

    public Pnpm(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, analysisRoot, analyzerConfig, repoConfig);
        this.modulesSearchDepth = 2;
    }

    @Override
    protected int getModulesSearchDepth() {
        return this.modulesSearchDepth;
    }

    @Override
    protected boolean hasLockFile(@NotNull File projectDir) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        return NpmSupportKt.hasPnpmLockFile(projectDir);
    }

    @Override
    protected boolean isWorkspaceDir(@NotNull File $this$isWorkspaceDir) {
        Intrinsics.checkNotNullParameter((Object)$this$isWorkspaceDir, (String)"<this>");
        return this.findWorkspaceSubmodules(this.getAnalysisRoot()).contains(ExtensionsKt.realFile((File)$this$isWorkspaceDir));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<File> loadWorkspaceSubmodules(@NotNull File moduleDir) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)moduleDir, (String)"moduleDir");
        CharSequence[] charSequenceArray = new CharSequence[]{"list", "--recursive", "--depth=-1", "--parseable"};
        ProcessCapture process = this.run(moduleDir, charSequenceArray);
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)process.getStdout());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File(it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String command(@Nullable File workingDir) {
        return Os.INSTANCE.isWindows() ? "pnpm.cmd" : "pnpm";
    }

    @Override
    @NotNull
    public RangesList getVersionRequirement() {
        RangesList rangesList = RangesListFactory.create((String)"5.* - 7.*");
        Intrinsics.checkNotNullExpressionValue((Object)rangesList, (String)"create(...)");
        return rangesList;
    }

    @Override
    @NotNull
    public List<File> mapDefinitionFiles(@NotNull List<? extends File> definitionFiles) {
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        return CollectionsKt.toList((Iterable)NpmSupportKt.mapDefinitionFilesForPnpm((Collection<? extends File>)definitionFiles));
    }

    @Override
    @NotNull
    protected ProcessCapture runInstall(@NotNull File workingDir) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        CharSequence[] charSequenceArray = new CharSequence[]{"install", "--ignore-pnpmfile", "--ignore-scripts", "--frozen-lockfile", "--shamefully-hoist"};
        return CommandLineTool.DefaultImpls.run$default((CommandLineTool)this, (CharSequence[])charSequenceArray, (File)workingDir, null, (int)4, null);
    }

    @Override
    protected void beforeResolution(@NotNull List<? extends File> definitionFiles) {
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        CommandLineTool.DefaultImpls.checkVersion$default((CommandLineTool)this, null, (int)1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/node/Pnpm$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/node/Pnpm;", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "node-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Pnpm> {
        @NotNull
        private final List<String> globsForDefinitionFiles;

        public Factory() {
            super("PNPM", false, 2, null);
            Object[] objectArray = new String[]{"package.json", "pnpm-lock.yaml"};
            this.globsForDefinitionFiles = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Pnpm create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Pnpm(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

