/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.node;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.model.MappersKt;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.node.Npm;
import org.ossreviewtoolkit.plugins.packagemanagers.node.YarnKt;
import org.ossreviewtoolkit.plugins.packagemanagers.node.utils.NpmSupportKt;
import org.ossreviewtoolkit.utils.common.CommandLineTool;
import org.ossreviewtoolkit.utils.common.DiskCache;
import org.ossreviewtoolkit.utils.common.Os;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0014J\u0012\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0014J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0005H\u0014\u00a8\u0006\u001e"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/node/Yarn;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/node/Npm;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "beforeResolution", "", "definitionFiles", "", "command", "workingDir", "getRemotePackageDetails", "Lcom/fasterxml/jackson/databind/JsonNode;", "packageName", "getVersionRequirement", "Lorg/semver4j/RangesList;", "hasLockFile", "", "projectDir", "mapDefinitionFiles", "runInstall", "Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "Companion", "Factory", "node-package-manager"})
@SourceDebugExtension(value={"SMAP\nYarn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Yarn.kt\norg/ossreviewtoolkit/plugins/packagemanagers/node/Yarn\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class Yarn
extends Npm {
    @NotNull
    private static final Companion Companion = new Companion(null);

    public Yarn(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, analysisRoot, analyzerConfig, repoConfig);
    }

    @Override
    protected boolean hasLockFile(@NotNull File projectDir) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        return NpmSupportKt.hasYarnLockFile(projectDir);
    }

    @Override
    @NotNull
    public String command(@Nullable File workingDir) {
        return Os.INSTANCE.isWindows() ? "yarn.cmd" : "yarn";
    }

    @Override
    @NotNull
    public RangesList getVersionRequirement() {
        RangesList rangesList = RangesListFactory.create((String)"1.3.* - 1.22.*");
        Intrinsics.checkNotNullExpressionValue((Object)rangesList, (String)"create(...)");
        return rangesList;
    }

    @Override
    @NotNull
    public List<File> mapDefinitionFiles(@NotNull List<? extends File> definitionFiles) {
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        return CollectionsKt.toList((Iterable)NpmSupportKt.mapDefinitionFilesForYarn((Collection<? extends File>)definitionFiles));
    }

    @Override
    protected void beforeResolution(@NotNull List<? extends File> definitionFiles) {
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        CommandLineTool.DefaultImpls.checkVersion$default((CommandLineTool)this, null, (int)1, null);
    }

    @Override
    @NotNull
    protected ProcessCapture runInstall(@NotNull File workingDir) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        CharSequence[] charSequenceArray = new CharSequence[]{"install", "--ignore-scripts", "--ignore-engines"};
        return this.run(workingDir, charSequenceArray);
    }

    @Override
    @NotNull
    protected JsonNode getRemotePackageDetails(@NotNull File workingDir, @NotNull String packageName) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String string = YarnKt.access$getYarnInfoCache$p().read(packageName);
        if (string != null) {
            String it = string;
            boolean bl = false;
            JsonNode jsonNode2 = MappersKt.getJsonMapper().readTree(it);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"readTree(...)");
            return jsonNode2;
        }
        CharSequence[] charSequenceArray = new CharSequence[]{"info", "--json", packageName};
        ProcessCapture process = this.run(workingDir, charSequenceArray);
        JsonNode jsonNode3 = MappersKt.getJsonMapper().readTree(process.getStdout()).get("data");
        if (jsonNode3 != null) {
            JsonNode jsonNode4;
            JsonNode it = jsonNode4 = jsonNode3;
            boolean bl = false;
            DiskCache diskCache = YarnKt.access$getYarnInfoCache$p();
            String string2 = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            diskCache.write(packageName, string2);
            jsonNode = jsonNode4;
        } else {
            JsonNode jsonNode5;
            Yarn $this$getRemotePackageDetails_u24lambda_u243 = this;
            boolean bl = false;
            JsonNode it = jsonNode5 = MappersKt.getJsonMapper().readTree(process.getStderr()).get("data");
            boolean bl2 = false;
            Companion.getLogger().warn((Function0)new Function0<Object>(process, workingDir, it){
                final /* synthetic */ ProcessCapture $process;
                final /* synthetic */ File $workingDir;
                final /* synthetic */ JsonNode $it;
                {
                    this.$process = $process;
                    this.$workingDir = $workingDir;
                    this.$it = $it;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Error running '" + this.$process.getCommandLine() + "' in directory " + this.$workingDir + ": " + this.$it;
                }
            });
            JsonNode jsonNode6 = jsonNode5;
            jsonNode = jsonNode6;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode6, (String)"run(...)");
        }
        return jsonNode;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/node/Yarn$Companion;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "node-package-manager"})
    private static final class Companion
    implements Logging {
        private Companion() {
        }

        @NotNull
        public KotlinLogger getLogger() {
            return Logging.DefaultImpls.getLogger((Logging)this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/node/Yarn$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/node/Yarn;", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "node-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Yarn> {
        @NotNull
        private final List<String> globsForDefinitionFiles = CollectionsKt.listOf((Object)"package.json");

        public Factory() {
            super("Yarn", false, 2, null);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Yarn create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Yarn(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

