/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.node.utils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.PackageManagerKt;
import org.ossreviewtoolkit.model.FileFormatKt;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.VcsType;
import org.ossreviewtoolkit.plugins.packagemanagers.node.utils.NpmSupport;
import org.ossreviewtoolkit.plugins.packagemanagers.node.utils.NpmSupportKt;
import org.ossreviewtoolkit.plugins.packagemanagers.node.utils.PackageJsonInfo;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u0013\u001a\u00020\u0010H\u0002\u001a\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0000\u001a\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0000\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0000\u001a\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0000\u001a\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0000\u001a\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010!\u001a\u00020\"H\u0000\u001a\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010!\u001a\u00020\"H\u0000\u001a\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"H\u0000\u001a\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040(2\u0006\u0010)\u001a\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"ARTIFACTORY_API_PATH_PATTERN", "Lkotlin/text/Regex;", "NPM_LOCK_FILES", "", "", "PNPM_LOCK_FILES", "YARN_LOCK_FILES", "expandNpmShortcutUrl", "url", "fixNpmDownloadUrl", "downloadUrl", "getPackageJsonInfo", "", "Lorg/ossreviewtoolkit/plugins/packagemanagers/node/utils/PackageJsonInfo;", "definitionFiles", "", "Ljava/io/File;", "getPnpmWorkspaceMatchers", "Ljava/nio/file/PathMatcher;", "definitionFile", "getPnpmWorkspaceSubmodules", "getYarnWorkspaceSubmodules", "hasNpmLockFile", "", "directory", "hasPnpmLockFile", "hasYarn2ResourceFile", "hasYarnLockFile", "mapDefinitionFilesForNpm", "mapDefinitionFilesForPnpm", "mapDefinitionFilesForYarn", "mapDefinitionFilesForYarn2", "parseNpmAuthors", "json", "Lcom/fasterxml/jackson/databind/JsonNode;", "parseNpmLicenses", "parseNpmVcsInfo", "Lorg/ossreviewtoolkit/model/VcsInfo;", "node", "splitNpmNamespaceAndName", "Lkotlin/Pair;", "rawName", "node-package-manager"})
@SourceDebugExtension(value={"SMAP\nNpmSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmSupport.kt\norg/ossreviewtoolkit/plugins/packagemanagers/node/utils/NpmSupportKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FileFormat.kt\norg/ossreviewtoolkit/model/FileFormatKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,410:1\n1726#2,3:411\n1747#2,3:415\n1747#2,3:418\n1747#2,3:421\n766#2:424\n857#2,2:425\n1620#2,3:427\n766#2:430\n857#2,2:431\n1620#2,3:433\n766#2:436\n857#2,2:437\n1620#2,3:439\n766#2:442\n857#2,2:443\n1620#2,3:445\n1549#2:448\n1620#2,3:449\n1747#2,3:452\n1549#2:458\n1620#2,3:459\n1855#2:462\n1855#2:463\n1855#2,2:464\n1856#2:466\n1856#2:467\n1855#2:468\n1855#2:469\n1855#2,2:470\n1856#2:472\n1856#2:473\n1611#2:474\n1855#2:475\n1856#2:477\n1612#2:478\n1611#2:479\n1855#2:480\n1856#2:482\n1612#2:483\n1611#2:484\n1855#2:485\n1856#2:487\n1612#2:488\n1549#2:489\n1620#2,3:490\n1#3:414\n1#3:476\n1#3:481\n1#3:486\n99#4:455\n48#5:456\n43#5:457\n*S KotlinDebug\n*F\n+ 1 NpmSupport.kt\norg/ossreviewtoolkit/plugins/packagemanagers/node/utils/NpmSupportKt\n*L\n73#1:411,3\n111#1:415,3\n121#1:418,3\n131#1:421,3\n148#1:424\n148#1:425,2\n149#1:427,3\n156#1:430\n156#1:431,2\n157#1:433,3\n164#1:436\n164#1:437,2\n165#1:439,3\n172#1:442\n172#1:443,2\n173#1:445,3\n209#1:448\n209#1:449,3\n234#1:452,3\n237#1:458\n237#1:459,3\n251#1:462\n257#1:463\n258#1:464,2\n257#1:466\n251#1:467\n300#1:468\n302#1:469\n303#1:470,2\n302#1:472\n300#1:473\n350#1:474\n350#1:475\n350#1:477\n350#1:478\n358#1:479\n358#1:480\n358#1:482\n358#1:483\n362#1:484\n362#1:485\n362#1:487\n362#1:488\n292#1:489\n292#1:490,3\n350#1:476\n358#1:481\n362#1:486\n235#1:455\n235#1:456\n235#1:457\n*E\n"})
public final class NpmSupportKt {
    @NotNull
    private static final Regex ARTIFACTORY_API_PATH_PATTERN = new Regex("(.*artifactory.*)(?:/api/npm/)(.*)");
    @NotNull
    private static final List<String> NPM_LOCK_FILES;
    @NotNull
    private static final List<String> PNPM_LOCK_FILES;
    @NotNull
    private static final List<String> YARN_LOCK_FILES;

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String expandNpmShortcutUrl(@NotNull String url) {
        block27: {
            block25: {
                block24: {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    var2_1 = org.ossreviewtoolkit.utils.common.ExtensionsKt.toUri((String)url);
                    v0 = Result.exceptionOrNull-impl((Object)var2_1);
                    if (v0 != null) {
                        it = v0;
                        $i$a$-getOrElse-NpmSupportKt$expandNpmShortcutUrl$uri$1 = false;
                        return url;
                    }
                    uri = (URI)var2_1;
                    path = uri.getSchemeSpecificPart();
                    Intrinsics.checkNotNull((Object)path);
                    if (StringsKt.startsWith$default((String)path, (String)"git@", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"github.com", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"gitlab.com", (boolean)false, (int)2, null)) {
                        return url;
                    }
                    if (((CharSequence)path).length() == 0) break block25;
                    it = new String[]{uri.getAuthority(), uri.getQuery()};
                    $this$all$iv = CollectionsKt.listOf((Object[])it);
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v1 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            it = (String)element$iv;
                            $i$a$-all-NpmSupportKt$expandNpmShortcutUrl$1 = false;
                            if (it == null) continue;
                            v1 = false;
                            break block24;
                        }
                        v1 = true;
                    }
                }
                if (!v1) break block25;
                v2 = uri.getFragment();
                if (v2 != null) {
                    it = v2;
                    $i$a$-let-NpmSupportKt$expandNpmShortcutUrl$revision$1 = false;
                    v3 = "#" + it;
                } else {
                    v3 = v4 = null;
                }
                if (v3 == null) {
                    v4 = revision = "";
                }
                if ((var4_6 = uri.getScheme()) == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var4_6.hashCode()) {
                    case -1245635613: {
                        if (var4_6.equals("github")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 3173059: {
                        if (var4_6.equals("gist")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case -1245632389: {
                        if (var4_6.equals("gitlab")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 62589239: {
                        if (var4_6.equals("bitbucket")) {
                            tmp = 4;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: lbl-1000:
                    // 2 sources

                    {
                        v5 = "https://github.com/" + path + ".git" + revision;
                        break;
                    }
                    case 2: {
                        v5 = "https://gist.github.com/" + path + revision;
                        break;
                    }
                    case 4: {
                        v5 = "https://bitbucket.org/" + path + ".git" + revision;
                        break;
                    }
                    case 3: {
                        v5 = "https://gitlab.com/" + path + ".git" + revision;
                        break;
                    }
                    default: {
                        v5 = url;
                        break;
                    }
                }
                break block27;
            }
            v5 = url;
        }
        return v5;
    }

    @NotNull
    public static final String fixNpmDownloadUrl(@NotNull String downloadUrl) {
        Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
        CharSequence charSequence = StringsKt.replace$default((String)downloadUrl, (String)"http://registry.npmjs.org/", (String)"https://registry.npmjs.org/", (boolean)false, (int)4, null);
        Regex regex = ARTIFACTORY_API_PATH_PATTERN;
        String string = "$1/$2";
        return regex.replace(charSequence, string);
    }

    public static final boolean hasNpmLockFile(@NotNull File directory) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Iterable $this$any$iv = NPM_LOCK_FILES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String lockfile = (String)element$iv;
                    boolean bl2 = false;
                    if (!new File(directory, lockfile).isFile()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasPnpmLockFile(@NotNull File directory) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Iterable $this$any$iv = PNPM_LOCK_FILES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String lockfile = (String)element$iv;
                    boolean bl2 = false;
                    if (!new File(directory, lockfile).isFile()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasYarnLockFile(@NotNull File directory) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Iterable $this$any$iv = YARN_LOCK_FILES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String lockfile = (String)element$iv;
                    boolean bl2 = false;
                    if (!new File(directory, lockfile).isFile()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasYarn2ResourceFile(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return FilesKt.resolve((File)directory, (String)".yarnrc.yml").isFile();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<File> mapDefinitionFilesForNpm(@NotNull Collection<? extends File> definitionFiles) {
        void var2_3;
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        Iterable $this$filter$iv = NpmSupportKt.getPackageJsonInfo(CollectionsKt.toSet((Iterable)definitionFiles));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PackageJsonInfo it = (PackageJsonInfo)element$iv$iv;
            boolean bl = false;
            if (!(!it.isHandledByYarn() && !it.isHandledByPnpm())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PackageJsonInfo packageJsonInfo = (PackageJsonInfo)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getDefinitionFile());
        }
        return (Set)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<File> mapDefinitionFilesForPnpm(@NotNull Collection<? extends File> definitionFiles) {
        void var2_3;
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        Iterable $this$filter$iv = NpmSupportKt.getPackageJsonInfo(CollectionsKt.toSet((Iterable)definitionFiles));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PackageJsonInfo it = (PackageJsonInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.isHandledByPnpm() && !it.isPnpmWorkspaceSubmodule())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PackageJsonInfo packageJsonInfo = (PackageJsonInfo)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getDefinitionFile());
        }
        return (Set)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<File> mapDefinitionFilesForYarn(@NotNull Collection<? extends File> definitionFiles) {
        void var2_3;
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        Iterable $this$filter$iv = NpmSupportKt.getPackageJsonInfo(CollectionsKt.toSet((Iterable)definitionFiles));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PackageJsonInfo it = (PackageJsonInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.isHandledByYarn() && !it.isYarnWorkspaceSubmodule() && !it.getHasYarn2ResourceFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PackageJsonInfo packageJsonInfo = (PackageJsonInfo)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getDefinitionFile());
        }
        return (Set)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<File> mapDefinitionFilesForYarn2(@NotNull Collection<? extends File> definitionFiles) {
        void var2_3;
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        Iterable $this$filter$iv = NpmSupportKt.getPackageJsonInfo(CollectionsKt.toSet((Iterable)definitionFiles));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PackageJsonInfo it = (PackageJsonInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.isHandledByYarn() && !it.isYarnWorkspaceSubmodule() && it.getHasYarn2ResourceFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PackageJsonInfo packageJsonInfo = (PackageJsonInfo)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getDefinitionFile());
        }
        return (Set)var2_3;
    }

    /*
     * Unable to fully structure code
     */
    private static final Collection<PackageJsonInfo> getPackageJsonInfo(Set<? extends File> definitionFiles) {
        pnpmWorkspaceSubmodules = NpmSupportKt.getPnpmWorkspaceSubmodules(definitionFiles);
        yarnWorkspaceSubmodules = NpmSupportKt.getYarnWorkspaceSubmodules(definitionFiles);
        $this$map$iv = definitionFiles;
        $i$f$map = false;
        var5_5 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var10_10 = (File)item$iv$iv;
            var20_20 = destination$iv$iv;
            $i$a$-map-NpmSupportKt$getPackageJsonInfo$1 = false;
            v0 = definitionFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getParentFile(...)");
            var12_12 = NpmSupportKt.getPackageJsonInfo$isPnpmWorkspaceRoot(v0);
            if (!NpmSupportKt.getPackageJsonInfo$isYarnWorkspaceRoot((File)definitionFile)) ** GOTO lbl-1000
            v1 = definitionFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getParentFile(...)");
            if (!NpmSupportKt.getPackageJsonInfo$isPnpmWorkspaceRoot(v1)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            var13_13 = v2;
            v3 = definitionFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getParentFile(...)");
            var14_14 = NpmSupportKt.hasYarnLockFile(v3);
            v4 = definitionFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getParentFile(...)");
            var15_15 = NpmSupportKt.hasNpmLockFile(v4);
            v5 = definitionFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getParentFile(...)");
            var16_16 = NpmSupportKt.hasPnpmLockFile(v5);
            v6 = definitionFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getParentFile(...)");
            var17_17 = NpmSupportKt.hasYarn2ResourceFile(v6);
            var18_18 = pnpmWorkspaceSubmodules.contains(definitionFile);
            var19_19 = yarnWorkspaceSubmodules.contains(definitionFile) != false && pnpmWorkspaceSubmodules.contains(definitionFile) == false;
            var20_20.add(new PackageJsonInfo((File)definitionFile, var14_14, var17_17, var15_15, var16_16, var12_12, var18_18, var13_13, var19_19));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final List<PathMatcher> getPnpmWorkspaceMatchers(File definitionFile) {
        List list;
        File pnpmWorkspaceFile = FilesKt.resolveSibling((File)definitionFile, (String)"pnpm-workspace.yaml");
        if (pnpmWorkspaceFile.isFile()) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = FilesKt.readLines$default((File)pnpmWorkspaceFile, null, (int)1, null);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : $this$any$iv) {
                        String it = (String)t;
                        boolean bl2 = false;
                        if (!(!NpmSupportKt.getPnpmWorkspaceMatchers$isComment(it))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                File $this$readValue$iv = pnpmWorkspaceFile;
                boolean $i$f$readValue = false;
                ObjectMapper objectMapper = FileFormatKt.mapper((File)$this$readValue$iv);
                boolean $i$f$readValue2 = false;
                boolean $i$f$jacksonTypeRef = false;
                @JsonIgnoreProperties(ignoreUnknown=true)
                @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008b\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001e\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"org/ossreviewtoolkit/plugins/packagemanagers/node/utils/NpmSupportKt$getPnpmWorkspaceMatchers$PnpmWorkspaces", "", "packages", "", "", "(Ljava/util/List;)V", "getPackages", "()Ljava/util/List;", "component1", "copy", "(Ljava/util/List;)Lorg/ossreviewtoolkit/plugins/packagemanagers/node/utils/NpmSupportKt$getPnpmWorkspaceMatchers$PnpmWorkspaces;", "equals", "", "other", "hashCode", "", "toString", "node-package-manager"})
                public final class PnpmWorkspaces {
                    @NotNull
                    private final List<String> packages;

                    public PnpmWorkspaces(@NotNull List<String> packages) {
                        Intrinsics.checkNotNullParameter(packages, (String)"packages");
                        this.packages = packages;
                    }

                    @NotNull
                    public final List<String> getPackages() {
                        return this.packages;
                    }

                    @NotNull
                    public final List<String> component1() {
                        return this.packages;
                    }

                    @NotNull
                    public final PnpmWorkspaces copy(@NotNull List<String> packages) {
                        Intrinsics.checkNotNullParameter(packages, (String)"packages");
                        return new PnpmWorkspaces(packages);
                    }

                    public static /* synthetic */ PnpmWorkspaces copy$default(PnpmWorkspaces pnpmWorkspaces, List list, int n, Object object) {
                        if ((n & 1) != 0) {
                            list = pnpmWorkspaces.packages;
                        }
                        return pnpmWorkspaces.copy(list);
                    }

                    @NotNull
                    public String toString() {
                        return "PnpmWorkspaces(packages=" + this.packages + ")";
                    }

                    public int hashCode() {
                        return ((Object)this.packages).hashCode();
                    }

                    public boolean equals(@Nullable Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof PnpmWorkspaces)) {
                            return false;
                        }
                        PnpmWorkspaces pnpmWorkspaces = (PnpmWorkspaces)other;
                        return Intrinsics.areEqual(this.packages, pnpmWorkspaces.packages);
                    }
                }
                List<String> workspaceMatchers = ((PnpmWorkspaces)objectMapper.readValue($this$readValue$iv, (TypeReference)new TypeReference<PnpmWorkspaces>(){})).getPackages();
                Iterable $this$map$iv = workspaceMatchers;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = iterable.iterator();
                while (true) {
                    void matcher;
                    if (!iterator.hasNext()) {
                        list = (List)destination$iv$iv;
                        return list;
                    }
                    Object item$iv$iv = iterator.next();
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    File file = definitionFile.getParentFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
                    String pattern = "glob:" + FilesKt.getInvariantSeparatorsPath((File)file) + "/" + StringsKt.removeSuffix((String)matcher, (CharSequence)"/");
                    collection.add(FileSystems.getDefault().getPathMatcher(pattern));
                }
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    private static final Set<File> getPnpmWorkspaceSubmodules(Set<? extends File> definitionFiles) {
        Set result = new LinkedHashSet();
        Iterable $this$forEach$iv = definitionFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File definitionFile = (File)element$iv;
            boolean bl = false;
            File pnpmWorkspacesFile = FilesKt.resolveSibling((File)definitionFile, (String)"pnpm-workspace.yaml");
            if (!pnpmWorkspacesFile.isFile()) continue;
            List<PathMatcher> pathMatchers = NpmSupportKt.getPnpmWorkspaceMatchers(definitionFile);
            Iterable $this$forEach$iv2 = pathMatchers;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PathMatcher matcher = (PathMatcher)element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv3 = definitionFiles;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    File other = (File)element$iv3;
                    boolean bl3 = false;
                    Path projectDir = other.getParentFile().toPath();
                    if (Intrinsics.areEqual((Object)other, (Object)definitionFile) || !matcher.matches(projectDir)) continue;
                    ((Collection)result).add(other);
                }
            }
        }
        return result;
    }

    private static final Set<File> getYarnWorkspaceSubmodules(Set<? extends File> definitionFiles) {
        Set result = new LinkedHashSet();
        Iterable $this$forEach$iv = definitionFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File definitionFile = (File)element$iv;
            boolean bl = false;
            List<PathMatcher> workspaceMatchers = NpmSupportKt.getYarnWorkspaceSubmodules$getWorkspaceMatchers(definitionFile);
            Iterable $this$forEach$iv2 = workspaceMatchers;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PathMatcher matcher = (PathMatcher)element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv3 = definitionFiles;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    File other = (File)element$iv3;
                    boolean bl3 = false;
                    Path projectDir = other.getParentFile().toPath();
                    if (Intrinsics.areEqual((Object)other, (Object)definitionFile) || !matcher.matches(projectDir)) continue;
                    ((Collection)result).add(other);
                }
            }
        }
        return result;
    }

    @NotNull
    public static final Set<String> parseNpmAuthors(@NotNull JsonNode json) {
        Set set;
        block5: {
            String string;
            String string2;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Set $this$parseNpmAuthors_u24lambda_u2426 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            JsonNode jsonNode = json.get("author");
            if (jsonNode == null) break block5;
            JsonNode authorNode = jsonNode;
            boolean bl2 = false;
            if (authorNode.isObject()) {
                JsonNode jsonNode2 = authorNode.get("name");
                string2 = jsonNode2 != null ? jsonNode2.textValue() : null;
            } else if (authorNode.isTextual()) {
                char[] cArray = new char[]{'<', '('};
                string2 = PackageManagerKt.parseAuthorString((String)authorNode.textValue(), (char[])cArray);
            } else {
                string2 = null;
            }
            if ((string = string2) != null) {
                String it = string;
                boolean bl3 = false;
                $this$parseNpmAuthors_u24lambda_u2426.add(it);
            }
        }
        return SetsKt.build((Set)set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> parseNpmLicenses(@NotNull JsonNode json) {
        void var3_34;
        void $this$mapNotNullTo$iv;
        Object element$iv$iv;
        String it$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        List declaredLicenses = new ArrayList();
        JsonNode jsonNode = json.get("license");
        if (jsonNode != null) {
            JsonNode licenseNode = jsonNode;
            boolean bl2 = false;
            if (licenseNode.isTextual()) {
                ((Collection)declaredLicenses).add(licenseNode.textValue());
            } else if (licenseNode.isArray()) {
                Iterable $this$mapNotNullTo$iv2 = (Iterable)licenseNode;
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv2;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv2;
                    Object element$iv = element$iv$iv2 = iterator.next();
                    boolean bl3 = false;
                    JsonNode it = (JsonNode)element$iv;
                    boolean bl4 = false;
                    if (it.textValue() == null) continue;
                    bl = false;
                    ((Collection)declaredLicenses).add(it$iv);
                }
            } else if (licenseNode.isObject()) {
                ((Collection)declaredLicenses).add(licenseNode.get("type").textValue());
            } else {
                throw new IllegalArgumentException("Unsupported node type in '" + licenseNode + "'.");
            }
        }
        JsonNode jsonNode2 = json.get("licenses");
        if (jsonNode2 != null) {
            Iterable $this$mapNotNullTo$iv3 = (Iterable)jsonNode2;
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv3;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv2;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl5 = false;
                JsonNode licenseNode = (JsonNode)element$iv;
                boolean bl6 = false;
                JsonNode jsonNode3 = licenseNode.get("type");
                if ((jsonNode3 != null ? jsonNode3.textValue() : null) == null) continue;
                it$iv2 = it$iv2;
                boolean bl7 = false;
                ((Collection)declaredLicenses).add(it$iv2);
            }
            List cfr_ignored_1 = (List)((Collection)declaredLicenses);
        }
        Iterable iterable = declaredLicenses;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl8 = false;
            String declaredLicense = (String)element$iv;
            boolean bl9 = false;
            if (Intrinsics.areEqual((Object)declaredLicense, (Object)"UNLICENSED")) {
                string = "NONE";
            } else if (StringsKt.startsWith$default((String)declaredLicense, (String)"SEE LICENSE IN ", (boolean)false, (int)2, null)) {
                string = "NOASSERTION";
            } else {
                String string2;
                String it = string2 = declaredLicense;
                boolean bl10 = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
            }
            if (string == null) continue;
            it$iv = string;
            bl = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_34;
    }

    @NotNull
    public static final VcsInfo parseNpmVcsInfo(@NotNull JsonNode node) {
        VcsInfo vcsInfo;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String head = org.ossreviewtoolkit.utils.common.ExtensionsKt.textValueOrEmpty((JsonNode)node.get("gitHead"));
        JsonNode jsonNode = node.get("repository");
        if (jsonNode != null) {
            String string;
            String string2;
            JsonNode repo = jsonNode;
            boolean bl = false;
            String type = org.ossreviewtoolkit.utils.common.ExtensionsKt.textValueOrEmpty((JsonNode)repo.get("type"));
            String string3 = string2 = repo.textValue();
            if (string3 == null) {
                string = org.ossreviewtoolkit.utils.common.ExtensionsKt.textValueOrEmpty((JsonNode)repo.get("url"));
            } else {
                Intrinsics.checkNotNull((Object)string3);
                string = string2;
            }
            String url = string;
            String path = org.ossreviewtoolkit.utils.common.ExtensionsKt.textValueOrEmpty((JsonNode)repo.get("directory"));
            vcsInfo = new VcsInfo(VcsType.Companion.forName(type), NpmSupportKt.expandNpmShortcutUrl(url), head, path);
        } else {
            vcsInfo = new VcsInfo(VcsType.Companion.getUNKNOWN(), "", head, null, 8, null);
        }
        return vcsInfo;
    }

    @NotNull
    public static final Pair<String, String> splitNpmNamespaceAndName(@NotNull String rawName) {
        Intrinsics.checkNotNullParameter((Object)rawName, (String)"rawName");
        String name = StringsKt.substringAfterLast$default((String)rawName, (String)"/", null, (int)2, null);
        String namespace = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)rawName, (CharSequence)name), (CharSequence)"/");
        return new Pair((Object)namespace, (Object)name);
    }

    private static final boolean getPackageJsonInfo$isPnpmWorkspaceRoot(File directory) {
        return FilesKt.resolve((File)directory, (String)"pnpm-workspace.yaml").isFile();
    }

    private static final boolean getPackageJsonInfo$isYarnWorkspaceRoot(File definitionFile) {
        boolean bl;
        try {
            bl = FileFormatKt.readTree((File)definitionFile).has("workspaces");
        }
        catch (JsonProcessingException e) {
            ExtensionsKt.showStackTrace((Throwable)e);
            NpmSupport.INSTANCE.getLogger().error((Function0)new Function0<Object>(definitionFile, e){
                final /* synthetic */ File $definitionFile;
                final /* synthetic */ JsonProcessingException $e;
                {
                    this.$definitionFile = $definitionFile;
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Could not parse '" + FilesKt.getInvariantSeparatorsPath((File)this.$definitionFile) + "': " + org.ossreviewtoolkit.utils.common.ExtensionsKt.collectMessages((Throwable)this.$e);
                }
            });
            bl = false;
        }
        return bl;
    }

    private static final boolean getPnpmWorkspaceMatchers$isComment(String $this$getPnpmWorkspaceMatchers_u24isComment) {
        return StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)$this$getPnpmWorkspaceMatchers_u24isComment)).toString(), (String)"#", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PathMatcher> getYarnWorkspaceSubmodules$getWorkspaceMatchers(File definitionFile) {
        List list;
        List list2;
        JsonNode jsonNode;
        try {
            jsonNode = FileFormatKt.readTree((File)definitionFile).get("workspaces");
        }
        catch (JsonProcessingException e) {
            ExtensionsKt.showStackTrace((Throwable)e);
            NpmSupport.INSTANCE.getLogger().error((Function0)new Function0<Object>(definitionFile, e){
                final /* synthetic */ File $definitionFile;
                final /* synthetic */ JsonProcessingException $e;
                {
                    this.$definitionFile = $definitionFile;
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Could not parse '" + FilesKt.getInvariantSeparatorsPath((File)this.$definitionFile) + "': " + org.ossreviewtoolkit.utils.common.ExtensionsKt.collectMessages((Throwable)this.$e);
                }
            });
            jsonNode = null;
        }
        JsonNode workspaces2 = jsonNode;
        if (workspaces2 != null && !(workspaces2 instanceof ArrayNode)) {
            workspaces2 = workspaces2.get("packages");
        }
        JsonNode jsonNode2 = workspaces2;
        if (jsonNode2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)jsonNode2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonNode jsonNode3 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file = definitionFile.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
                String pattern = "glob:" + FilesKt.getInvariantSeparatorsPath((File)file) + "/" + it.textValue();
                collection.add(FileSystems.getDefault().getPathMatcher(pattern));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static {
        Object[] objectArray = new String[]{"npm-shrinkwrap.json", "package-lock.json"};
        NPM_LOCK_FILES = CollectionsKt.listOf((Object[])objectArray);
        PNPM_LOCK_FILES = CollectionsKt.listOf((Object)"pnpm-lock.yaml");
        YARN_LOCK_FILES = CollectionsKt.listOf((Object)"yarn.lock");
    }
}

