/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.nuget;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.analyzer.PackageManagerFactory;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.Severity;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.Excludes;
import org.ossreviewtoolkit.plugins.api.OrtPlugin;
import org.ossreviewtoolkit.plugins.api.Plugin;
import org.ossreviewtoolkit.plugins.api.PluginDescriptor;
import org.ossreviewtoolkit.plugins.packagemanagers.nuget.NuGetConfig;
import org.ossreviewtoolkit.plugins.packagemanagers.nuget.NuGetFactory;
import org.ossreviewtoolkit.plugins.packagemanagers.nuget.utils.NuGetInspector;
import org.ossreviewtoolkit.plugins.packagemanagers.nuget.utils.NuGetInspectorExtensionsKt;

@OrtPlugin(displayName="NuGet", description="The NuGet package manager for .NET.", factory=PackageManagerFactory.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JB\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/nuget/NuGet;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "descriptor", "Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "config", "Lorg/ossreviewtoolkit/plugins/packagemanagers/nuget/NuGetConfig;", "<init>", "(Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;Lorg/ossreviewtoolkit/plugins/packagemanagers/nuget/NuGetConfig;)V", "getDescriptor", "()Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "nugetConfig", "Ljava/io/File;", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "analysisRoot", "definitionFile", "excludes", "Lorg/ossreviewtoolkit/model/config/Excludes;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "labels", "", "collectTopLevelIssues", "Lorg/ossreviewtoolkit/model/Issue;", "result", "Lorg/ossreviewtoolkit/plugins/packagemanagers/nuget/utils/NuGetInspector$Result;", "nuget-package-manager"})
@SourceDebugExtension(value={"SMAP\nNuGet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NuGet.kt\norg/ossreviewtoolkit/plugins/packagemanagers/nuget/NuGet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Issue.kt\norg/ossreviewtoolkit/model/IssueKt\n+ 5 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,87:1\n1#2:88\n1#2:104\n1#2:125\n1368#3:89\n1454#3,5:90\n1557#3:95\n1628#3,2:96\n1630#3:109\n1368#3:110\n1454#3,5:111\n1557#3:116\n1628#3,2:117\n1630#3:130\n98#4,5:98\n88#4:103\n89#4,2:105\n91#4:108\n98#4,5:119\n88#4:124\n89#4,2:126\n91#4:129\n38#5:107\n38#5:128\n*S KotlinDebug\n*F\n+ 1 NuGet.kt\norg/ossreviewtoolkit/plugins/packagemanagers/nuget/NuGet\n*L\n77#1:104\n81#1:125\n76#1:89\n76#1:90,5\n76#1:95\n76#1:96,2\n76#1:109\n80#1:110\n80#1:111,5\n80#1:116\n80#1:117,2\n80#1:130\n77#1:98,5\n77#1:103\n77#1:105,2\n77#1:108\n81#1:119,5\n81#1:124\n81#1:126,2\n81#1:129\n77#1:107\n81#1:128\n*E\n"})
public final class NuGet
extends PackageManager {
    @NotNull
    private final PluginDescriptor descriptor;
    @NotNull
    private final NuGetConfig config;
    @NotNull
    private final List<String> globsForDefinitionFiles;
    @Nullable
    private final File nugetConfig;

    /*
     * WARNING - void declaration
     */
    public NuGet(@NotNull PluginDescriptor descriptor, @NotNull NuGetConfig config) {
        File file;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super("NuGet");
        this.descriptor = descriptor;
        this.config = config;
        Object[] objectArray = new String[]{"*.csproj", "*.fsproj", "*.vcxproj", "packages.config"};
        this.globsForDefinitionFiles = CollectionsKt.listOf((Object[])objectArray);
        NuGet nuGet = this;
        String string = this.config.getNugetConfigFile();
        if (string != null) {
            void it;
            String string2 = string;
            NuGet nuGet2 = nuGet;
            boolean bl = false;
            file = new File((String)it);
            nuGet = nuGet2;
        } else {
            file = null;
        }
        nuGet.nugetConfig = file;
    }

    public /* synthetic */ NuGet(PluginDescriptor pluginDescriptor, NuGetConfig nuGetConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pluginDescriptor = NuGetFactory.Companion.getDescriptor();
        }
        this(pluginDescriptor, nuGetConfig);
    }

    @NotNull
    public PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public List<String> getGlobsForDefinitionFiles() {
        return this.globsForDefinitionFiles;
    }

    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File analysisRoot, @NotNull File definitionFile, @NotNull Excludes excludes, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull Map<String, String> labels) {
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter((Object)excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        NuGetInspector.Result result = NuGetInspector.INSTANCE.inspect(definitionFile, this.nugetConfig);
        Project project = NuGetInspectorExtensionsKt.toOrtProject(result, this.getProjectType(), analysisRoot, definitionFile);
        Set<Package> packages = NuGetInspectorExtensionsKt.toOrtPackages((Collection<NuGetInspector.PackageData>)result.getDependencies());
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(project, packages, this.collectTopLevelIssues(result)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Issue> collectTopLevelIssues(NuGetInspector.Result result) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$flatMapTo$iv$iv;
        String source$iv$iv;
        Severity severity$iv;
        void $this$mapTo$iv$iv2;
        Object list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv = result.getHeaders();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (NuGetInspector.Header)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((NuGetInspector.Header)it).getErrors();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = result.getPackages();
        Collection collection = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv2 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (NuGetInspector.PackageData)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((NuGetInspector.PackageData)it).getErrors();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv2 = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $this$createAndLogIssue$iv$iv;
            Issue issue;
            void message;
            void $this$createAndLogIssue_u24default$iv;
            list$iv$iv = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Plugin plugin = (Plugin)this;
            severity$iv = Severity.ERROR;
            String affectedPath$iv = null;
            boolean $i$f$createAndLogIssue = false;
            void var16_25 = $this$createAndLogIssue_u24default$iv;
            source$iv$iv = $this$createAndLogIssue_u24default$iv.getDescriptor().getDisplayName();
            boolean $i$f$createAndLogIssue2 = false;
            if (severity$iv != null) {
                Severity it$iv$iv;
                boolean bl2 = false;
                issue = new Issue(null, source$iv$iv, (String)message, it$iv$iv, affectedPath$iv, 1, null);
            } else {
                issue = new Issue(null, source$iv$iv, (String)message, null, affectedPath$iv, 9, null);
            }
            Issue issue$iv$iv = issue;
            void $this$logger$iv$iv$iv = $this$createAndLogIssue$iv$iv;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(NuGet.class).log(issue$iv$iv.getSeverity().toLog4jLevel(), (Function0)new Function0<Object>((String)message){
                final /* synthetic */ String $message;
                {
                    this.$message = $message;
                }

                public final Object invoke() {
                    return this.$message;
                }
            });
            collection.add(issue$iv$iv);
        }
        List errors = (List)destination$iv$iv;
        Iterable $this$flatMap$iv2 = result.getPackages();
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NuGetInspector.PackageData it2 = (NuGetInspector.PackageData)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv2 = it2.getWarnings();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$createAndLogIssue$iv$iv;
            Issue issue;
            void message;
            void $this$createAndLogIssue_u24default$iv;
            String list$iv$iv2 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            severity$iv = (Plugin)this;
            Severity severity$iv2 = Severity.WARNING;
            String affectedPath$iv = null;
            boolean $i$f$createAndLogIssue = false;
            source$iv$iv = $this$createAndLogIssue_u24default$iv;
            String source$iv$iv2 = $this$createAndLogIssue_u24default$iv.getDescriptor().getDisplayName();
            boolean $i$f$createAndLogIssue3 = false;
            if (severity$iv2 != null) {
                Severity it$iv$iv;
                boolean bl3 = false;
                issue = new Issue(null, source$iv$iv2, (String)message, it$iv$iv, affectedPath$iv, 1, null);
            } else {
                issue = new Issue(null, source$iv$iv2, (String)message, null, affectedPath$iv, 9, null);
            }
            Issue issue$iv$iv = issue;
            void $this$logger$iv$iv$iv = $this$createAndLogIssue$iv$iv;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(NuGet.class).log(issue$iv$iv.getSeverity().toLog4jLevel(), (Function0)new Function0<Object>((String)message){
                final /* synthetic */ String $message;
                {
                    this.$message = $message;
                }

                public final Object invoke() {
                    return this.$message;
                }
            });
            collection.add(issue$iv$iv);
        }
        List warnings = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)errors, (Iterable)warnings);
    }
}

