/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.nuget.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.model.Hash;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.MappersKt;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageReference;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.RemoteArtifact;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.Severity;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.VcsType;
import org.ossreviewtoolkit.model.utils.PurlUtilsKt;
import org.ossreviewtoolkit.plugins.packagemanagers.nuget.utils.NuGetInspector;
import org.ossreviewtoolkit.plugins.packagemanagers.nuget.utils.NuGetUtilsKt;
import org.ossreviewtoolkit.utils.ort.DeclaredLicenseProcessor;
import org.ossreviewtoolkit.utils.ort.ProcessedDeclaredLicense;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006*\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006*\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0000\u001a$\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u001a\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006*\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"TYPE", "", "getIdentifierWithNamespace", "Lorg/ossreviewtoolkit/model/Identifier;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/nuget/utils/NuGetInspector$PackageData;", "toAuthors", "", "", "Lorg/ossreviewtoolkit/plugins/packagemanagers/nuget/utils/NuGetInspector$Party;", "toOrtPackages", "Lorg/ossreviewtoolkit/model/Package;", "", "toOrtProject", "Lorg/ossreviewtoolkit/model/Project;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/nuget/utils/NuGetInspector$Result;", "managerName", "analysisRoot", "Ljava/io/File;", "definitionFile", "toPackageReferences", "Lorg/ossreviewtoolkit/model/PackageReference;", "nuget-package-manager"})
@SourceDebugExtension(value={"SMAP\nNuGetInspectorExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NuGetInspectorExtensions.kt\norg/ossreviewtoolkit/plugins/packagemanagers/nuget/utils/NuGetInspectorExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Mappers.kt\norg/ossreviewtoolkit/model/MappersKt\n+ 7 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 9 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,166:1\n766#2:167\n857#2,2:168\n1611#2:170\n1855#2:171\n1856#2:174\n1612#2:175\n1855#2:176\n1855#2,2:177\n1856#2:179\n1620#2,2:180\n1549#2:182\n1620#2,3:183\n1549#2:186\n1620#2,3:187\n1622#2:190\n1477#2:191\n1502#2,3:192\n1505#2,3:202\n1#3:172\n1#3:173\n372#4,7:195\n152#5,2:205\n154#5:214\n73#6:207\n50#7:208\n43#7:209\n179#8,2:210\n37#9,2:212\n*S KotlinDebug\n*F\n+ 1 NuGetInspectorExtensions.kt\norg/ossreviewtoolkit/plugins/packagemanagers/nuget/utils/NuGetInspectorExtensionsKt\n*L\n44#1:167\n44#1:168,2\n44#1:170\n44#1:171\n44#1:174\n44#1:175\n67#1:176\n68#1:177,2\n67#1:179\n94#1:180,2\n95#1:182\n95#1:183,3\n99#1:186\n99#1:187,3\n94#1:190\n111#1:191\n111#1:192,3\n111#1:202,3\n44#1:173\n111#1:195,7\n111#1:205,2\n111#1:214\n125#1:207\n125#1:208\n125#1:209\n149#1:210,2\n162#1:212,2\n*E\n"})
public final class NuGetInspectorExtensionsKt {
    @NotNull
    private static final String TYPE = "NuGet";

    /*
     * WARNING - void declaration
     */
    private static final Set<String> toAuthors(List<NuGetInspector.Party> $this$toAuthors) {
        void var2_3;
        void $this$mapNotNullTo$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$toAuthors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NuGetInspector.Party it = (NuGetInspector.Party)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getRole(), (Object)"author")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            CharSequence it$iv;
            String it;
            CharSequence charSequence;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            NuGetInspector.Party party = (NuGetInspector.Party)element$iv;
            boolean bl2 = false;
            StringBuilder $this$toAuthors_u24lambda_u245_u24lambda_u243 = charSequence = new StringBuilder();
            boolean bl3 = false;
            if (party.getName() != null) {
                boolean bl4 = false;
                $this$toAuthors_u24lambda_u245_u24lambda_u243.append(it);
            }
            if (party.getEmail() != null) {
                boolean bl5 = false;
                $this$toAuthors_u24lambda_u245_u24lambda_u243.append((String)(party.getName() != null && !StringsKt.isBlank((CharSequence)it) ? " <" + it + ">" : it));
            }
            String string = charSequence.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            CharSequence it2 = charSequence = string;
            boolean bl6 = false;
            if ((!StringsKt.isBlank((CharSequence)it2) ? charSequence : null) == null) continue;
            it$iv = it$iv;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var2_3;
    }

    @NotNull
    public static final Project toOrtProject(@NotNull NuGetInspector.Result $this$toOrtProject, @NotNull String managerName, @NotNull File analysisRoot, @NotNull File definitionFile) {
        Intrinsics.checkNotNullParameter((Object)$this$toOrtProject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)managerName, (String)"managerName");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Identifier id = new Identifier(managerName, "", FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)definitionFile, (File)analysisRoot)), "");
        List nestedPackages = new ArrayList();
        Iterable $this$forEach$iv = $this$toOrtProject.getPackages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NuGetInspector.PackageData pkg = (NuGetInspector.PackageData)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = pkg.getDependencies();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                NuGetInspector.PackageData dep = (NuGetInspector.PackageData)element$iv2;
                boolean bl2 = false;
                ((Collection)nestedPackages).add(dep);
            }
        }
        Set<PackageReference> packageReferences = NuGetInspectorExtensionsKt.toPackageReferences(nestedPackages);
        Set scopes = SetsKt.setOf((Object)new Scope(((NuGetInspector.Header)CollectionsKt.first($this$toOrtProject.getHeaders())).getProjectFramework(), packageReferences));
        String string = VersionControlSystem.Companion.getPathInfo(definitionFile).getPath();
        VcsInfo vcsInfo = VcsInfo.EMPTY;
        Set set = SetsKt.emptySet();
        File file = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        VcsInfo vcsInfo2 = PackageManager.Companion.processProjectVcs$default((PackageManager.Companion)PackageManager.Companion, (File)file, null, (String[])new String[0], (int)2, null);
        Set set2 = SetsKt.emptySet();
        return new Project(id, null, string, set, set2, null, vcsInfo, vcsInfo2, "", scopes, null, 1058, null);
    }

    private static final Identifier getIdentifierWithNamespace(NuGetInspector.PackageData $this$getIdentifierWithNamespace) {
        Identifier identifier;
        CharSequence charSequence = $this$getIdentifierWithNamespace.getNamespace();
        if (charSequence == null || charSequence.length() == 0) {
            String string = $this$getIdentifierWithNamespace.getName();
            String string2 = $this$getIdentifierWithNamespace.getVersion();
            if (string2 == null) {
                string2 = "";
            }
            identifier = NuGetUtilsKt.getIdentifierWithNamespace(TYPE, string, string2);
        } else {
            String string = $this$getIdentifierWithNamespace.getNamespace();
            String string3 = $this$getIdentifierWithNamespace.getName();
            String string4 = $this$getIdentifierWithNamespace.getVersion();
            if (string4 == null) {
                string4 = "";
            }
            identifier = new Identifier(TYPE, string, string3, string4);
        }
        return identifier;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<PackageReference> toPackageReferences(List<NuGetInspector.PackageData> $this$toPackageReferences) {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = $this$toPackageReferences;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void data;
            NuGetInspector.PackageData packageData = (NuGetInspector.PackageData)item$iv;
            Collection collection2 = destination$iv;
            boolean bl = false;
            Iterable $this$map$iv = data.getErrors();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new Issue(null, TYPE, (String)SequencesKt.first((Sequence)StringsKt.lineSequence((CharSequence)((CharSequence)it))), Severity.ERROR, null, 17, null));
            }
            List errors = (List)destination$iv$iv;
            Iterable $this$map$iv2 = data.getWarnings();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl2 = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(new Issue(null, TYPE, (String)SequencesKt.first((Sequence)StringsKt.lineSequence((CharSequence)((CharSequence)it))), Severity.WARNING, null, 17, null));
            }
            List warnings = (List)destination$iv$iv2;
            collection2.add(new PackageReference(NuGetInspectorExtensionsKt.getIdentifierWithNamespace((NuGetInspector.PackageData)data), null, NuGetInspectorExtensionsKt.toPackageReferences(data.getDependencies()), CollectionsKt.plus((Collection)errors, (Iterable)warnings), 2, null));
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<Package> toOrtPackages(@NotNull Collection<NuGetInspector.PackageData> $this$toOrtPackages) {
        void var2_3;
        void $this$mapTo$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toOrtPackages, (String)"<this>");
        Object $this$groupBy$iv = $this$toOrtPackages;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            NuGetInspector.PackageData it = (NuGetInspector.PackageData)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName() + ":" + it.getVersion();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv : $this$mapTo$iv.entrySet()) {
            void $this$toTypedArray$iv;
            String string;
            String string2;
            Object var31_53;
            String string3;
            String string4;
            Set<String> set;
            Set set2;
            ProcessedDeclaredLicense processedDeclaredLicense;
            SpdxExpression spdxExpression;
            Identifier identifier;
            String commit;
            String vcsUrl;
            NuGetInspector.PackageData pkg;
            Collection collection;
            block16: {
                Object v10;
                void $this$firstOrNull$iv;
                Iterator it;
                String it22;
                String string5;
                String[] $this$readValue$iv$iv;
                String pkgDeclaredLicense;
                Map.Entry entry = item$iv;
                collection = destination$iv;
                boolean bl = false;
                List packages = (List)entry.getValue();
                pkg = (NuGetInspector.PackageData)CollectionsKt.first((List)packages);
                Identifier id = NuGetInspectorExtensionsKt.getIdentifierWithNamespace(pkg);
                Set declaredLicenses = new LinkedHashSet();
                String string6 = pkg.getDeclaredLicense();
                if (string6 == null) {
                    string6 = "";
                }
                if (!StringsKt.isBlank((CharSequence)(pkgDeclaredLicense = string6))) {
                    String string7;
                    String $this$fromYaml$iv = pkgDeclaredLicense;
                    boolean $i$f$fromYaml = false;
                    $this$readValue$iv$iv = (Object[])MappersKt.getYamlMapper();
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    Map licenseData = (Map)$this$readValue$iv$iv.readValue($this$fromYaml$iv, (TypeReference)new TypeReference<Map<String, ? extends String>>(){});
                    String string8 = (String)licenseData.get("LicenseType");
                    if (string8 == null) {
                        string8 = "";
                    }
                    String type = string8;
                    $this$readValue$iv$iv = new String[2];
                    Object[] objectArray = $this$readValue$iv$iv;
                    int n = 0;
                    if ((String)licenseData.get("LicenseExpression") != null) {
                        String string9 = $i$f$jacksonTypeRef;
                        int n2 = n;
                        Object[] objectArray2 = objectArray;
                        boolean bl3 = false;
                        boolean bl4 = StringsKt.equals((String)type, (String)"expression", (boolean)true);
                        objectArray = objectArray2;
                        n = n2;
                        string7 = bl4 ? $i$f$jacksonTypeRef : null;
                    } else {
                        string7 = null;
                    }
                    objectArray[n] = string7;
                    $this$readValue$iv$iv[1] = licenseData.get("LicenseUrl");
                    String string10 = (String)CollectionsKt.firstOrNull((List)CollectionsKt.listOfNotNull((Object[])$this$readValue$iv$iv));
                    if (string10 != null) {
                        $this$readValue$iv$iv = string10;
                        Object it22 = $this$readValue$iv$iv;
                        boolean bl5 = false;
                        ((Collection)declaredLicenses).add(it22);
                    }
                }
                if ((string5 = pkg.getVcsUrl()) == null) {
                    string5 = "";
                }
                vcsUrl = string5;
                commit = "";
                $this$readValue$iv$iv = new String[]{"@"};
                List segments = StringsKt.split$default((CharSequence)vcsUrl, (String[])$this$readValue$iv$iv, (boolean)false, (int)2, (int)2, null);
                if (segments.size() == 2) {
                    vcsUrl = (String)segments.get(0);
                    commit = (String)segments.get(1);
                }
                String bl5 = it22 = pkg.getPurl();
                identifier = id;
                boolean bl6 = false;
                boolean bl7 = ((CharSequence)((Object)it)).length() == 0;
                String string11 = !bl7 ? it22 : null;
                if (string11 == null) {
                    string11 = PurlUtilsKt.toPurl$default((Identifier)id, null, null, (int)3, null);
                }
                $this$readValue$iv$iv = StringsKt.lineSequence((CharSequence)pkg.getDescription());
                spdxExpression = null;
                processedDeclaredLicense = DeclaredLicenseProcessor.process$default((DeclaredLicenseProcessor)DeclaredLicenseProcessor.INSTANCE, (Set)declaredLicenses, null, null, (int)6, null);
                set2 = declaredLicenses;
                set = NuGetInspectorExtensionsKt.toAuthors(pkg.getParties());
                string4 = null;
                string3 = string11;
                boolean $i$f$firstOrNull = false;
                it = $this$firstOrNull$iv.iterator();
                while (it.hasNext()) {
                    Object element$iv = it.next();
                    String it3 = (String)element$iv;
                    boolean bl8 = false;
                    boolean bl9 = !StringsKt.isBlank((CharSequence)it3);
                    if (!bl9) continue;
                    v10 = element$iv;
                    break block16;
                }
                v10 = var31_53 = null;
            }
            if ((string2 = (String)var31_53) == null) {
                string2 = "";
            }
            if ((string = pkg.getHomepageUrl()) == null) {
                string = "";
            }
            Object $i$f$firstOrNull = new String[]{pkg.getCodeViewUrl(), pkg.getHomepageUrl()};
            $i$f$firstOrNull = CollectionsKt.listOfNotNull((Object[])$i$f$firstOrNull);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 24644;
            boolean bl = false;
            boolean bl10 = false;
            VcsInfo vcsInfo = PackageManager.Companion.processPackageVcs(new VcsInfo(VcsType.Companion.getUNKNOWN(), vcsUrl, commit, null, 8, null), Arrays.copyOf(stringArray, stringArray.length));
            VcsInfo vcsInfo2 = VcsInfo.copy$default((VcsInfo)VcsInfo.EMPTY, null, (String)vcsUrl, (String)commit, null, (int)9, null);
            RemoteArtifact remoteArtifact = RemoteArtifact.EMPTY;
            RemoteArtifact remoteArtifact2 = new RemoteArtifact(pkg.getDownloadUrl(), NuGetInspectorExtensionsKt.toOrtPackages$lambda$16$getHash(pkg));
            String string12 = string;
            String string13 = string2;
            SpdxExpression spdxExpression2 = spdxExpression;
            ProcessedDeclaredLicense processedDeclaredLicense2 = processedDeclaredLicense;
            Set set3 = set2;
            Set<String> set4 = set;
            String string14 = string4;
            String string15 = string3;
            Identifier identifier2 = identifier;
            collection.add(new Package(identifier2, string15, string14, set4, set3, processedDeclaredLicense2, spdxExpression2, string13, string12, remoteArtifact2, remoteArtifact, vcsInfo2, vcsInfo, bl10, bl, n, defaultConstructorMarker));
        }
        return (Set)var2_3;
    }

    private static final Hash toOrtPackages$lambda$16$getHash(NuGetInspector.PackageData $this$toOrtPackages_u24lambda_u2416_u24getHash) {
        String string = $this$toOrtPackages_u24lambda_u2416_u24getHash.getSha512();
        if (string == null && (string = $this$toOrtPackages_u24lambda_u2416_u24getHash.getSha256()) == null && (string = $this$toOrtPackages_u24lambda_u2416_u24getHash.getSha1()) == null && (string = $this$toOrtPackages_u24lambda_u2416_u24getHash.getMd5()) == null) {
            string = "";
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return Hash.Companion.create(string2);
    }
}

