/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.pub.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.downloader.VcsHost;
import org.ossreviewtoolkit.plugins.packagemanagers.pub.utils.PubCacheReader;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/pub/utils/PubCacheReader;", "", "()V", "flutterPubCacheRoot", "Ljava/io/File;", "getFlutterPubCacheRoot", "()Ljava/io/File;", "flutterPubCacheRoot$delegate", "Lkotlin/Lazy;", "pubCacheRoot", "getPubCacheRoot", "pubCacheRoot$delegate", "findFile", "packageInfo", "Lcom/fasterxml/jackson/databind/JsonNode;", "workingDir", "filename", "", "findProjectRoot", "pub-package-manager"})
@SourceDebugExtension(value={"SMAP\nPubCacheReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PubCacheReader.kt\norg/ossreviewtoolkit/plugins/packagemanagers/pub/utils/PubCacheReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,111:1\n1#2:112\n38#3:113\n*S KotlinDebug\n*F\n+ 1 PubCacheReader.kt\norg/ossreviewtoolkit/plugins/packagemanagers/pub/utils/PubCacheReader\n*L\n101#1:113\n*E\n"})
public final class PubCacheReader {
    @NotNull
    private final Lazy pubCacheRoot$delegate = LazyKt.lazy((Function0)pubCacheRoot.2.INSTANCE);
    @NotNull
    private final Lazy flutterPubCacheRoot$delegate = LazyKt.lazy((Function0)flutterPubCacheRoot.2.INSTANCE);

    private final File getPubCacheRoot() {
        Lazy lazy = this.pubCacheRoot$delegate;
        return (File)lazy.getValue();
    }

    private final File getFlutterPubCacheRoot() {
        Lazy lazy = this.flutterPubCacheRoot$delegate;
        return (File)lazy.getValue();
    }

    @Nullable
    public final File findFile(@NotNull JsonNode packageInfo, @NotNull File workingDir, @NotNull String filename) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)packageInfo, (String)"packageInfo");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            File file = this.findProjectRoot(packageInfo, workingDir);
            if (file == null) {
                return null;
            }
            File artifactRootDir = file;
            File file2 = FilesKt.resolve((File)artifactRootDir, (String)filename);
            if (file2.isFile()) {
                return file2;
            }
            Sequence sequence = (Sequence)FilesKt.walk$default((File)artifactRootDir, null, (int)1, null).onEnter((Function1)findFile.1.INSTANCE);
            for (Object e : sequence) {
                File it = (File)e;
                boolean bl = false;
                if (!(!ExtensionsKt.isSymbolicLink((File)it) && it.isFile() && Intrinsics.areEqual((Object)it.getName(), (Object)filename))) continue;
                v1 = e;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final File findProjectRoot(@NotNull JsonNode packageInfo, @NotNull File workingDir) {
        File file;
        String string;
        boolean isPathRelative;
        Intrinsics.checkNotNullParameter((Object)packageInfo, (String)"packageInfo");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        String packageVersion = ExtensionsKt.textValueOrEmpty((JsonNode)packageInfo.get("version"));
        String type = ExtensionsKt.textValueOrEmpty((JsonNode)packageInfo.get("source"));
        JsonNode description = packageInfo.get("description");
        String packageName = ExtensionsKt.textValueOrEmpty((JsonNode)description.get("name"));
        String url = ExtensionsKt.textValueOrEmpty((JsonNode)description.get("url"));
        String resolvedRef = ExtensionsKt.textValueOrEmpty((JsonNode)description.get("resolved-ref"));
        String resolvedPath = ExtensionsKt.textValueOrEmpty((JsonNode)description.get("path"));
        JsonNode jsonNode = description.get("relative");
        boolean bl = isPathRelative = jsonNode != null ? jsonNode.booleanValue() : false;
        if (Intrinsics.areEqual((Object)type, (Object)"path") && ((CharSequence)resolvedPath).length() > 0) {
            File file2;
            if (isPathRelative) {
                File file3;
                File it = file3 = FilesKt.resolve((File)workingDir, (String)resolvedPath);
                boolean bl2 = false;
                file2 = it.isDirectory() ? file3 : null;
            } else {
                File file4;
                File it = file4 = new File(resolvedPath);
                boolean bl3 = false;
                file2 = it.isDirectory() ? file4 : null;
            }
            return file2;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"hosted") && ((CharSequence)url).length() > 0) {
            string = "hosted/" + StringsKt.replace$default((String)url, (String)"https://", (String)"", (boolean)false, (int)4, null) + "/" + packageName + "-" + packageVersion;
        } else if (Intrinsics.areEqual((Object)type, (Object)"git") && ((CharSequence)resolvedRef).length() > 0) {
            String string2 = VcsHost.Companion.getProject(url);
            if (string2 == null) {
                return null;
            }
            String projectName = string2;
            string = ((CharSequence)resolvedPath).length() > 0 ? "git/" + projectName + "-" + resolvedRef + "/" + resolvedPath : "git/" + projectName + "-" + resolvedRef;
        } else {
            PubCacheReader $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(PubCacheReader.class).error((Function0)new Function0<Object>(packageName){
                final /* synthetic */ String $packageName;
                {
                    this.$packageName = $packageName;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Could not find projectRoot of '" + this.$packageName + "'.";
                }
            });
            return null;
        }
        String path2 = string;
        File it = file = FilesKt.resolve((File)this.getPubCacheRoot(), (String)path2);
        boolean bl4 = false;
        File file5 = it.isDirectory() ? file : null;
        if (file5 == null) {
            File file6 = this.getFlutterPubCacheRoot();
            if (file6 != null && (file6 = FilesKt.resolve((File)file6, (String)path2)) != null) {
                File file7;
                File it2 = file7 = file6;
                boolean bl5 = false;
                file5 = it2.isDirectory() ? file7 : null;
            } else {
                file5 = null;
            }
        }
        return file5;
    }
}

