/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.python;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.python.Pip;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipKt;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspector;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspectorExtensionsKt;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "operatingSystemOption", "pythonVersionOption", "resolveDependencies", "", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "labels", "", "runPythonInspector", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/utils/PythonInspector$Result;", "Companion", "Factory", "python-package-manager"})
public final class Pip
extends PackageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String operatingSystemOption;
    @NotNull
    private final String pythonVersionOption;
    @NotNull
    public static final String OPTION_OPERATING_SYSTEM = "operatingSystem";
    @NotNull
    public static final String OPTION_PYTHON_VERSION = "pythonVersion";

    /*
     * WARNING - void declaration
     */
    public Pip(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        void pythonVersion;
        String os;
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, analysisRoot, analyzerConfig, repoConfig);
        String string2 = (String)this.getOptions().get(OPTION_OPERATING_SYSTEM);
        if (string2 == null) {
            string2 = "linux";
        }
        String string3 = string = string2;
        Pip pip = this;
        boolean bl = false;
        if (!(((CharSequence)os).length() == 0 || PipKt.access$getOPERATING_SYSTEMS$p().contains(os))) {
            boolean $i$a$-require-Pip$operatingSystemOption$1$22 = false;
            String acceptedValues2 = CollectionsKt.joinToString$default((Iterable)PipKt.access$getOPERATING_SYSTEMS$p(), null, null, null, (int)0, null, (Function1)operatingSystemOption.1.1.acceptedValues.1.INSTANCE, (int)31, null);
            String $i$a$-require-Pip$operatingSystemOption$1$22 = "The 'operatingSystem' option must be one of " + acceptedValues2 + ", but was '" + os + "'.";
            throw new IllegalArgumentException($i$a$-require-Pip$operatingSystemOption$1$22.toString());
        }
        pip.operatingSystemOption = string;
        String string4 = (String)this.getOptions().get(OPTION_PYTHON_VERSION);
        if (string4 == null) {
            string4 = "3.10";
        }
        os = string = string4;
        pip = this;
        boolean bl2 = false;
        if (!PipKt.access$getPYTHON_VERSIONS$p().contains(pythonVersion)) {
            boolean bl3 = false;
            String acceptedValues3 = CollectionsKt.joinToString$default((Iterable)PipKt.access$getPYTHON_VERSIONS$p(), null, null, null, (int)0, null, (Function1)pythonVersionOption.1.1.acceptedValues.1.INSTANCE, (int)31, null);
            String string5 = "The 'pythonVersion' option must be one of " + acceptedValues3 + ", but was '" + (String)pythonVersion + "'.";
            throw new IllegalArgumentException(string5.toString());
        }
        pip.pythonVersionOption = string;
    }

    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        PythonInspector.Result result = this.runPythonInspector(definitionFile);
        Project project = PythonInspectorExtensionsKt.toOrtProject(result, this.getManagerName(), this.getAnalysisRoot(), definitionFile);
        Set<Package> packages = PythonInspectorExtensionsKt.toOrtPackages(result.getPackages());
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(project, packages, null, 4, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PythonInspector.Result runPythonInspector(File definitionFile) {
        Object object;
        File workingDir = definitionFile.getParentFile();
        Companion.getLogger().info((Function0)new Function0<Object>(definitionFile, this){
            final /* synthetic */ File $definitionFile;
            final /* synthetic */ Pip this$0;
            {
                this.$definitionFile = $definitionFile;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Resolving dependencies for '" + this.$definitionFile.getAbsolutePath() + "' with Python version '" + Pip.access$getPythonVersionOption$p(this.this$0) + "' and operating system '" + Pip.access$getOperatingSystemOption$p(this.this$0) + "'.";
            }
        });
        Object object2 = this;
        try {
            PythonInspector.Result result;
            Pip $this$runPythonInspector_u24lambda_u244 = object2;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)workingDir);
                result = PythonInspector.INSTANCE.inspect(workingDir, definitionFile, StringsKt.replace$default((String)$this$runPythonInspector_u24lambda_u244.pythonVersionOption, (String)".", (String)"", (boolean)false, (int)4, null), $this$runPythonInspector_u24lambda_u244.operatingSystemOption);
            }
            catch (Throwable throwable) {
                Intrinsics.checkNotNull((Object)workingDir);
                org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)FilesKt.resolve((File)workingDir, (String)".cache"), (boolean)true, null, (int)2, null);
                throw throwable;
            }
            org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)FilesKt.resolve((File)workingDir, (String)".cache"), (boolean)true, null, (int)2, null);
            object = Result.constructor-impl((Object)result);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            ExtensionsKt.showStackTrace((Throwable)e);
            Companion.getLogger().error((Function0)new Function0<Object>(definitionFile, (Throwable)e){
                final /* synthetic */ File $definitionFile;
                final /* synthetic */ Throwable $e;
                {
                    this.$definitionFile = $definitionFile;
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Unable to determine dependencies for definition file '" + this.$definitionFile.getAbsolutePath() + "': " + org.ossreviewtoolkit.utils.common.ExtensionsKt.collectMessages((Throwable)this.$e);
                }
            });
        }
        ResultKt.throwOnFailure((Object)object2);
        return (PythonInspector.Result)object2;
    }

    public static final /* synthetic */ String access$getPythonVersionOption$p(Pip $this) {
        return $this.pythonVersionOption;
    }

    public static final /* synthetic */ String access$getOperatingSystemOption$p(Pip $this) {
        return $this.operatingSystemOption;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip$Companion;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "OPTION_OPERATING_SYSTEM", "", "OPTION_PYTHON_VERSION", "python-package-manager"})
    public static final class Companion
    implements Logging {
        private Companion() {
        }

        @NotNull
        public KotlinLogger getLogger() {
            return Logging.DefaultImpls.getLogger((Logging)this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip;", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "python-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Pip> {
        @NotNull
        private final List<String> globsForDefinitionFiles;

        public Factory() {
            super("PIP", false, 2, null);
            Object[] objectArray = new String[]{"*requirements*.txt", "setup.py"};
            this.globsForDefinitionFiles = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Pip create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Pip(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

