/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.python;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.python.Pip;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipenvKt;
import org.ossreviewtoolkit.utils.common.CommandLineTool;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;
import org.semver4j.Semver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0014J\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\u0016\u001a\u00020\u00062\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pipenv;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "Lorg/ossreviewtoolkit/utils/common/CommandLineTool;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "beforeResolution", "", "definitionFiles", "", "command", "workingDir", "getVersionRequirement", "Lorg/semver4j/RangesList;", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "labels", "", "transformVersion", "output", "Companion", "Factory", "python-package-manager"})
@SourceDebugExtension(value={"SMAP\nPipenv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pipenv.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Pipenv\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class Pipenv
extends PackageManager
implements CommandLineTool {
    @NotNull
    private static final Companion Companion = new Companion(null);

    public Pipenv(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, analysisRoot, analyzerConfig, repoConfig);
    }

    @NotNull
    public String command(@Nullable File workingDir) {
        return "pipenv";
    }

    @NotNull
    public String transformVersion(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return StringsKt.removePrefix((String)output, (CharSequence)"pipenv, version ");
    }

    @NotNull
    public RangesList getVersionRequirement() {
        RangesList rangesList = RangesListFactory.create((String)"[2018.10.9,)");
        Intrinsics.checkNotNullExpressionValue((Object)rangesList, (String)"create(...)");
        return rangesList;
    }

    protected void beforeResolution(@NotNull List<? extends File> definitionFiles) {
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        CommandLineTool.DefaultImpls.checkVersion$default((CommandLineTool)this, null, (int)1, null);
    }

    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        ProcessCapture processCapture;
        Object object;
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        File workingDir = definitionFile.getParentFile();
        Intrinsics.checkNotNull((Object)workingDir);
        File requirementsFile = FilesKt.resolve((File)workingDir, (String)"requirements-from-pipenv.txt");
        Companion.getLogger().info((Function0)new Function0<Object>(requirementsFile, workingDir){
            final /* synthetic */ File $requirementsFile;
            final /* synthetic */ File $workingDir;
            {
                this.$requirementsFile = $requirementsFile;
                this.$workingDir = $workingDir;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Generating '" + this.$requirementsFile.getName() + "' file in '" + this.$workingDir + "' directory...";
            }
        });
        if (new Semver(CommandLineTool.DefaultImpls.getVersion$default((CommandLineTool)this, null, (int)1, null)).compareTo(PipenvKt.access$getREQUIREMENTS_COMMAND_VERSION$p()) >= 0) {
            object = new CharSequence[]{CommandLineTool.DefaultImpls.command$default((CommandLineTool)this, null, (int)1, null), "requirements"};
            ProcessCapture processCapture2 = new ProcessCapture(workingDir, object);
            processCapture = processCapture2;
        } else {
            object = new CharSequence[]{CommandLineTool.DefaultImpls.command$default((CommandLineTool)this, null, (int)1, null), "lock", "--requirements"};
            ProcessCapture processCapture3 = new ProcessCapture(workingDir, object);
            processCapture = processCapture3;
        }
        String requirements = processCapture.requireSuccess().getStdout();
        FilesKt.writeText$default((File)requirementsFile, (String)requirements, null, (int)2, null);
        Object it = object = new Pip(this.getManagerName(), this.getAnalysisRoot(), this.getAnalyzerConfig(), this.getRepoConfig()).resolveDependencies(requirementsFile, labels);
        boolean bl = false;
        requirementsFile.delete();
        return object;
    }

    public void checkVersion(@Nullable File workingDir) {
        CommandLineTool.DefaultImpls.checkVersion((CommandLineTool)this, (File)workingDir);
    }

    @NotNull
    public String getVersion(@Nullable File workingDir) {
        return CommandLineTool.DefaultImpls.getVersion((CommandLineTool)this, (File)workingDir);
    }

    @NotNull
    public String getVersionArguments() {
        return CommandLineTool.DefaultImpls.getVersionArguments((CommandLineTool)this);
    }

    public boolean isInPath() {
        return CommandLineTool.DefaultImpls.isInPath((CommandLineTool)this);
    }

    @NotNull
    public ProcessCapture run(@Nullable File workingDir, CharSequence ... args) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (File)workingDir, (CharSequence[])args);
    }

    @NotNull
    public ProcessCapture run(@NotNull CharSequence[] args, @Nullable File workingDir, @NotNull Map<String, String> environment) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (CharSequence[])args, (File)workingDir, environment);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pipenv$Companion;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "python-package-manager"})
    private static final class Companion
    implements Logging {
        private Companion() {
        }

        @NotNull
        public KotlinLogger getLogger() {
            return Logging.DefaultImpls.getLogger((Logging)this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pipenv$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pipenv;", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "python-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Pipenv> {
        @NotNull
        private final List<String> globsForDefinitionFiles = CollectionsKt.listOf((Object)"Pipfile.lock");

        public Factory() {
            super("Pipenv", false, 2, null);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Pipenv create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Pipenv(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

