/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.python;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.python.Pip;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipKt;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspector;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspectorExtensionsKt;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J'\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00052\u0010\b\u0002\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0017H\u0000\u00a2\u0006\u0002\b\u0018R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "operatingSystemOption", "pythonVersionOption", "detectPythonVersion", "workingDir", "resolveDependencies", "", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "labels", "", "runPythonInspector", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/utils/PythonInspector$Result;", "Lkotlin/Function0;", "runPythonInspector$python_package_manager", "Companion", "Factory", "python-package-manager"})
@SourceDebugExtension(value={"SMAP\nPip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pip.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Pip\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n38#2:143\n38#2:144\n1#3:145\n*S KotlinDebug\n*F\n+ 1 Pip.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Pip\n*L\n108#1:143\n127#1:144\n*E\n"})
public final class Pip
extends PackageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String operatingSystemOption;
    @Nullable
    private final String pythonVersionOption;
    @NotNull
    public static final String OPTION_OPERATING_SYSTEM = "operatingSystem";
    @NotNull
    public static final String OPTION_PYTHON_VERSION = "pythonVersion";

    /*
     * WARNING - void declaration
     */
    public Pip(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        String string;
        String string2;
        String os;
        Pip pip;
        String string3;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, analysisRoot, analyzerConfig, repoConfig);
        Pip pip2 = this;
        String string4 = (String)this.getOptions().get(OPTION_OPERATING_SYSTEM);
        if (string4 != null) {
            String string5 = string3 = string4;
            pip = pip2;
            boolean bl = false;
            if (!(((CharSequence)os).length() == 0 || PipKt.access$getOPERATING_SYSTEMS$p().contains(os))) {
                boolean $i$a$-require-Pip$operatingSystemOption$1$22 = false;
                String acceptedValues2 = CollectionsKt.joinToString$default((Iterable)PipKt.access$getOPERATING_SYSTEMS$p(), null, null, null, (int)0, null, (Function1)operatingSystemOption.1.1.acceptedValues.1.INSTANCE, (int)31, null);
                String $i$a$-require-Pip$operatingSystemOption$1$22 = "The 'operatingSystem' option must be one of " + acceptedValues2 + ", but was '" + os + "'.";
                throw new IllegalArgumentException($i$a$-require-Pip$operatingSystemOption$1$22.toString());
            }
            pip2 = pip;
            string2 = string3;
        } else {
            string2 = null;
        }
        pip2.operatingSystemOption = string2;
        Pip pip3 = this;
        String string6 = (String)this.getOptions().get(OPTION_PYTHON_VERSION);
        if (string6 != null) {
            void pythonVersion;
            os = string3 = string6;
            pip = pip3;
            boolean bl = false;
            if (!PipKt.getPYTHON_VERSIONS().contains(pythonVersion)) {
                boolean bl2 = false;
                String acceptedValues3 = CollectionsKt.joinToString$default((Iterable)PipKt.getPYTHON_VERSIONS(), null, null, null, (int)0, null, (Function1)pythonVersionOption.1.1.acceptedValues.1.INSTANCE, (int)31, null);
                String string7 = "The 'pythonVersion' option must be one of " + acceptedValues3 + ", but was '" + (String)pythonVersion + "'.";
                throw new IllegalArgumentException(string7.toString());
            }
            pip3 = pip;
            string = string3;
        } else {
            string = null;
        }
        pip3.pythonVersionOption = string;
    }

    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        PythonInspector.Result result2 = this.runPythonInspector$python_package_manager(definitionFile, (Function0<String>)((Function0)new Function0<String>(this, definitionFile){
            final /* synthetic */ Pip this$0;
            final /* synthetic */ File $definitionFile;
            {
                this.this$0 = $receiver;
                this.$definitionFile = $definitionFile;
                super(0);
            }

            @Nullable
            public final String invoke() {
                File file = this.$definitionFile.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
                return Pip.access$detectPythonVersion(this.this$0, file);
            }
        }));
        Project project = PythonInspectorExtensionsKt.toOrtProject(result2, this.getManagerName(), this.getAnalysisRoot(), definitionFile);
        Set<Package> packages = PythonInspectorExtensionsKt.toOrtPackages(result2.getPackages());
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(project, packages, null, 4, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PythonInspector.Result runPythonInspector$python_package_manager(@NotNull File definitionFile, @NotNull Function0<String> detectPythonVersion2) {
        Object object;
        String string;
        String operatingSystem;
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(detectPythonVersion2, (String)"detectPythonVersion");
        String string2 = this.operatingSystemOption;
        if (string2 == null) {
            string2 = operatingSystem = "linux";
        }
        if ((string = this.pythonVersionOption) == null && (string = (String)detectPythonVersion2.invoke()) == null) {
            string = "3.11";
        }
        String pythonVersion = string;
        File workingDir = definitionFile.getParentFile();
        Pip $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(Pip.class).info((Function0)new Function0<Object>(definitionFile, pythonVersion, operatingSystem){
            final /* synthetic */ File $definitionFile;
            final /* synthetic */ String $pythonVersion;
            final /* synthetic */ String $operatingSystem;
            {
                this.$definitionFile = $definitionFile;
                this.$pythonVersion = $pythonVersion;
                this.$operatingSystem = $operatingSystem;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Resolving dependencies for '" + this.$definitionFile.getAbsolutePath() + "' with Python version '" + this.$pythonVersion + "' and operating system '" + this.$operatingSystem + "'.";
            }
        });
        Object object2 = this;
        try {
            Object object3;
            Pip $this$runPythonInspector_u24lambda_u244 = object2;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)workingDir);
                object3 = new char[]{'.'};
                object3 = PythonInspector.INSTANCE.inspect(workingDir, definitionFile, CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)pythonVersion, (char[])object3, (boolean)false, (int)3, (int)2, null), (int)2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), operatingSystem);
            }
            catch (Throwable throwable) {
                Intrinsics.checkNotNull((Object)workingDir);
                org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)FilesKt.resolve((File)workingDir, (String)".cache"), (boolean)true, null, (int)2, null);
                throw throwable;
            }
            org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)FilesKt.resolve((File)workingDir, (String)".cache"), (boolean)true, null, (int)2, null);
            object = Result.constructor-impl((Object)object3);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            ExtensionsKt.showStackTrace((Throwable)e);
            Pip $this$logger$iv2 = this;
            boolean $i$f$getLogger2 = false;
            LoggingFactoryKt.cachedLoggerOf(Pip.class).error((Function0)new Function0<Object>(definitionFile, (Throwable)e){
                final /* synthetic */ File $definitionFile;
                final /* synthetic */ Throwable $e;
                {
                    this.$definitionFile = $definitionFile;
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Unable to determine dependencies for definition file '" + this.$definitionFile.getAbsolutePath() + "': " + org.ossreviewtoolkit.utils.common.ExtensionsKt.collectMessages((Throwable)this.$e);
                }
            });
        }
        ResultKt.throwOnFailure((Object)object2);
        return (PythonInspector.Result)object2;
    }

    public static /* synthetic */ PythonInspector.Result runPythonInspector$python_package_manager$default(Pip pip, File file, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = runPythonInspector.1.INSTANCE;
        }
        return pip.runPythonInspector$python_package_manager(file, (Function0<String>)function0);
    }

    private final String detectPythonVersion(File workingDir) {
        String string;
        File pythonVersionFile = FilesKt.resolve((File)workingDir, (String)".python-version");
        if (!pythonVersionFile.isFile()) {
            return null;
        }
        String string2 = (String)CollectionsKt.firstOrNull((List)FilesKt.readLines$default((File)pythonVersionFile, null, (int)1, null));
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            Character c = StringsKt.firstOrNull((CharSequence)it);
            string = (c != null ? Character.isDigit(c.charValue()) : false) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ String access$detectPythonVersion(Pip $this, File workingDir) {
        return $this.detectPythonVersion(workingDir);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip$Companion;", "", "()V", "OPTION_OPERATING_SYSTEM", "", "OPTION_PYTHON_VERSION", "python-package-manager"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip;", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "python-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Pip> {
        @NotNull
        private final List<String> globsForDefinitionFiles;

        public Factory() {
            super("PIP", false, 2, null);
            Object[] objectArray = new String[]{"*requirements*.txt", "setup.py"};
            this.globsForDefinitionFiles = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Pip create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Pip(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

