/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.python;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.python.Pip;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PoetryKt;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspector;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspectorExtensionsKt;
import org.ossreviewtoolkit.utils.common.CommandLineTool;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;
import org.semver4j.RangesList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00062\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "Lorg/ossreviewtoolkit/utils/common/CommandLineTool;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "command", "workingDir", "detectPythonVersion", "inspectLockfile", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/utils/PythonInspector$Result;", "lockfile", "dependencyGroupName", "resolveDependencies", "", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "labels", "", "transformVersion", "output", "Companion", "Factory", "python-package-manager"})
@SourceDebugExtension(value={"SMAP\nPoetry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Poetry.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,191:1\n1271#2,2:192\n1285#2,4:194\n1655#2,8:204\n76#3:198\n96#3,5:199\n152#3,3:212\n38#4:215\n38#4:218\n37#5,2:216\n*S KotlinDebug\n*F\n+ 1 Poetry.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry\n*L\n80#1:192,2\n80#1:194,4\n85#1:204,8\n83#1:198\n83#1:199,5\n96#1:212,3\n113#1:215\n137#1:218\n123#1:216,2\n*E\n"})
public final class Poetry
extends PackageManager
implements CommandLineTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PYPROJECT_FILENAME = "pyproject.toml";

    public Poetry(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, analysisRoot, analyzerConfig, repoConfig);
    }

    @NotNull
    public String command(@Nullable File workingDir) {
        return "poetry";
    }

    @NotNull
    public String transformVersion(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return StringsKt.removeSuffix((String)StringsKt.substringAfter$default((String)output, (String)"version ", null, (int)2, null), (CharSequence)")");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        void destination$iv;
        void $this$mapTo$iv;
        Object key$iv;
        Object e$iv2;
        void $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Map resultsForScopeName;
        Package it;
        Map map;
        Object element$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Set<String> scopeName = PoetryKt.parseScopeNamesFromPyproject(FilesKt.resolveSibling((File)definitionFile, (String)PYPROJECT_FILENAME));
        Iterable $this$associateWith$iv = scopeName;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv2 : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv2;
            Object t = element$iv$iv2;
            map = result$iv;
            boolean bl = false;
            PythonInspector.Result result2 = this.inspectLockfile(definitionFile, (String)it);
            map.put(t, result2);
        }
        Map $i$f$associateWith22 = resultsForScopeName = (Map)result$iv;
        boolean $i$f$flatMap = false;
        $this$associateWithTo$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        element$iv$iv2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (element$iv$iv2.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry bl = element$iv$iv3 = (Map.Entry)element$iv$iv2.next();
            boolean bl2 = false;
            PythonInspector.Result results = (PythonInspector.Result)bl.getValue();
            Iterable list$iv$iv = results.getPackages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = PythonInspectorExtensionsKt.toOrtPackages((List)destination$iv$iv);
        boolean $i$f$distinctBy = false;
        HashSet<Identifier> set$iv = new HashSet<Identifier>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv2 : $this$distinctBy$iv) {
            it = (Package)e$iv2;
            boolean bl = false;
            key$iv = it.getId();
            if (!set$iv.add((Identifier)key$iv)) continue;
            list$iv.add(e$iv2);
        }
        Set packages = CollectionsKt.toSet((Iterable)list$iv);
        Project project = Project.EMPTY;
        String string = this.getManagerName();
        String string2 = FilesKt.relativeTo((File)definitionFile, (File)this.getAnalysisRoot()).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        File file = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        Identifier identifier = new Identifier(string, "", string2, VersionControlSystem.Companion.getCloneInfo(file).getRevision());
        String string3 = VersionControlSystem.Companion.getPathInfo(definitionFile).getPath();
        e$iv2 = resultsForScopeName;
        key$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv;
            Map.Entry entry = item$iv = iterator.next();
            map = destination$iv;
            boolean bl = false;
            String scopeName2 = (String)entry.getKey();
            PythonInspector.Result results = (PythonInspector.Result)entry.getValue();
            map.add(new Scope(scopeName2, PythonInspectorExtensionsKt.toPackageReferences(results.getResolvedDependenciesGraph())));
        }
        Set set = (Set)destination$iv;
        File file2 = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        VcsInfo vcsInfo = PackageManager.Companion.processProjectVcs$default((PackageManager.Companion)PackageManager.Companion, (File)file2, null, (String[])new String[0], (int)2, null);
        Project project2 = Project.copy$default((Project)project, (Identifier)identifier, null, (String)string3, null, null, null, null, (VcsInfo)vcsInfo, null, (Set)set, null, (int)1402, null);
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(project2, packages, null, 4, null));
    }

    private final PythonInspector.Result inspectLockfile(File lockfile, String dependencyGroupName) {
        File workingDir = lockfile.getParentFile();
        File requirementsFile = ExtensionsKt.createOrtTempFile$default((Object)((Object)this), (String)"requirements.txt", null, (int)2, null);
        Poetry $this$logger$iv = this;
        boolean $i$f$getLogger22 = false;
        LoggingFactoryKt.cachedLoggerOf(Poetry.class).info((Function0)new Function0<Object>(requirementsFile, workingDir){
            final /* synthetic */ File $requirementsFile;
            final /* synthetic */ File $workingDir;
            {
                this.$requirementsFile = $requirementsFile;
                this.$workingDir = $workingDir;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Generating '" + this.$requirementsFile.getName() + "' file in '" + this.$workingDir + "' directory...";
            }
        });
        Object[] $i$f$getLogger22 = new String[]{CommandLineTool.DefaultImpls.command$default((CommandLineTool)this, null, (int)1, null), "export", "--without-hashes", "--format=requirements.txt", "--only=" + dependencyGroupName};
        List command = CollectionsKt.listOf((Object[])$i$f$getLogger22);
        Collection $this$toTypedArray$iv = command;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new String[0]);
        String requirements = new ProcessCapture(workingDir, (CharSequence[])Arrays.copyOf(object, ((String[])object).length)).requireSuccess().getStdout();
        FilesKt.writeText$default((File)requirementsFile, (String)requirements, null, (int)2, null);
        Object it = object = new Pip(this.getManagerName(), this.getAnalysisRoot(), this.getAnalyzerConfig(), this.getRepoConfig()).runPythonInspector$python_package_manager(requirementsFile, (Function0<String>)((Function0)new Function0<String>(this, workingDir){
            final /* synthetic */ Poetry this$0;
            final /* synthetic */ File $workingDir;
            {
                this.this$0 = $receiver;
                this.$workingDir = $workingDir;
                super(0);
            }

            @Nullable
            public final String invoke() {
                File file = this.$workingDir;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"$workingDir");
                return Poetry.access$detectPythonVersion(this.this$0, file);
            }
        }));
        boolean bl = false;
        File file = requirementsFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)file, (boolean)true, null, (int)2, null);
        return object;
    }

    private final String detectPythonVersion(File workingDir) {
        String string;
        File pyprojectFile = FilesKt.resolve((File)workingDir, (String)PYPROJECT_FILENAME);
        String string2 = PoetryKt.getPythonVersionConstraint(pyprojectFile);
        if (string2 == null) {
            return null;
        }
        String constraint = string2;
        String string3 = PoetryKt.getPythonVersion(constraint);
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            Poetry $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(Poetry.class).info((Function0)new Function0<Object>(it, constraint){
                final /* synthetic */ String $it;
                final /* synthetic */ String $constraint;
                {
                    this.$it = $it;
                    this.$constraint = $constraint;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Detected Python version '" + this.$it + "' from '" + this.$constraint + "'.";
                }
            });
            string = string4;
        } else {
            string = null;
        }
        return string;
    }

    public void checkVersion(@Nullable File workingDir) {
        CommandLineTool.DefaultImpls.checkVersion((CommandLineTool)this, (File)workingDir);
    }

    @NotNull
    public String getVersion(@Nullable File workingDir) {
        return CommandLineTool.DefaultImpls.getVersion((CommandLineTool)this, (File)workingDir);
    }

    @NotNull
    public String getVersionArguments() {
        return CommandLineTool.DefaultImpls.getVersionArguments((CommandLineTool)this);
    }

    @NotNull
    public RangesList getVersionRequirement() {
        return CommandLineTool.DefaultImpls.getVersionRequirement((CommandLineTool)this);
    }

    public boolean isInPath() {
        return CommandLineTool.DefaultImpls.isInPath((CommandLineTool)this);
    }

    @NotNull
    public ProcessCapture run(@Nullable File workingDir, CharSequence ... args) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (File)workingDir, (CharSequence[])args);
    }

    @NotNull
    public ProcessCapture run(@NotNull CharSequence[] args, @Nullable File workingDir, @NotNull Map<String, String> environment) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (CharSequence[])args, (File)workingDir, environment);
    }

    public static final /* synthetic */ String access$detectPythonVersion(Poetry $this, File workingDir) {
        return $this.detectPythonVersion(workingDir);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry$Companion;", "", "()V", "PYPROJECT_FILENAME", "", "python-package-manager"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry;", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "python-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Poetry> {
        @NotNull
        private final List<String> globsForDefinitionFiles = CollectionsKt.listOf((Object)"poetry.lock");

        public Factory() {
            super("Poetry", false, 2, null);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Poetry create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Poetry(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

