/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.python;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.python.Pip;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipKt;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspector;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspectorExtensionsKt;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J'\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00052\u0010\b\u0002\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "<init>", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "operatingSystemOption", "pythonVersionOption", "analyzeSetupPyInsecurelyOption", "resolveDependencies", "", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "labels", "", "runPythonInspector", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/utils/PythonInspector$Result;", "detectPythonVersion", "Lkotlin/Function0;", "runPythonInspector$python_package_manager", "workingDir", "Companion", "Factory", "python-package-manager"})
@SourceDebugExtension(value={"SMAP\nPip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pip.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Pip\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n38#2:162\n38#2:163\n1#3:164\n*S KotlinDebug\n*F\n+ 1 Pip.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Pip\n*L\n126#1:162\n146#1:163\n*E\n"})
public final class Pip
extends PackageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String operatingSystemOption;
    @Nullable
    private final String pythonVersionOption;
    @Nullable
    private final String analyzeSetupPyInsecurelyOption;
    @NotNull
    public static final String OPTION_OPERATING_SYSTEM = "operatingSystem";
    @NotNull
    public static final String OPTION_PYTHON_VERSION = "pythonVersion";
    @NotNull
    public static final String OPTION_ANALYZE_SETUP_PY_INSECURELY = "analyzeSetupPyInsecurely";

    /*
     * WARNING - void declaration
     */
    public Pip(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        String string;
        String string2;
        String pythonVersion;
        String string3;
        String os;
        Pip pip;
        String string4;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        Object object = analyzerConfig.getPackageManagerConfiguration(name);
        if (object == null || (object = object.getOptions()) == null || (object = (String)object.get("overrideProjectType")) == null) {
            object = "PIP";
        }
        super(name, (String)object, analysisRoot, analyzerConfig, repoConfig);
        Pip pip2 = this;
        String string5 = (String)this.getOptions().get(OPTION_OPERATING_SYSTEM);
        if (string5 != null) {
            String string6 = string4 = string5;
            pip = pip2;
            boolean bl = false;
            if (!(((CharSequence)os).length() == 0 || PipKt.access$getOPERATING_SYSTEMS$p().contains(os))) {
                boolean $i$a$-require-Pip$operatingSystemOption$1$22 = false;
                String acceptedValues = CollectionsKt.joinToString$default((Iterable)PipKt.access$getOPERATING_SYSTEMS$p(), null, null, null, (int)0, null, Pip::operatingSystemOption$lambda$2$lambda$1$lambda$0, (int)31, null);
                String $i$a$-require-Pip$operatingSystemOption$1$22 = "The 'operatingSystem' option must be one of " + acceptedValues + ", but was '" + os + "'.";
                throw new IllegalArgumentException($i$a$-require-Pip$operatingSystemOption$1$22.toString());
            }
            pip2 = pip;
            string3 = string4;
        } else {
            string3 = null;
        }
        pip2.operatingSystemOption = string3;
        Pip pip3 = this;
        String string7 = (String)this.getOptions().get(OPTION_PYTHON_VERSION);
        if (string7 != null) {
            os = string4 = string7;
            pip = pip3;
            boolean bl = false;
            if (!PipKt.getPYTHON_VERSIONS().contains(pythonVersion)) {
                boolean $i$a$-require-Pip$pythonVersionOption$1$22 = false;
                String acceptedValues = CollectionsKt.joinToString$default((Iterable)PipKt.getPYTHON_VERSIONS(), null, null, null, (int)0, null, Pip::pythonVersionOption$lambda$5$lambda$4$lambda$3, (int)31, null);
                String $i$a$-require-Pip$pythonVersionOption$1$22 = "The 'pythonVersion' option must be one of " + acceptedValues + ", but was '" + pythonVersion + "'.";
                throw new IllegalArgumentException($i$a$-require-Pip$pythonVersionOption$1$22.toString());
            }
            pip3 = pip;
            string2 = string4;
        } else {
            string2 = null;
        }
        pip3.pythonVersionOption = string2;
        Pip pip4 = this;
        String string8 = (String)this.getOptions().get(OPTION_ANALYZE_SETUP_PY_INSECURELY);
        if (string8 != null) {
            void analyzeSetupPy;
            pythonVersion = string4 = string8;
            pip = pip4;
            boolean bl = false;
            if (StringsKt.toBooleanStrictOrNull((String)analyzeSetupPy) == null) {
                boolean bl2 = false;
                String string9 = "The 'analyzeSetupPyInsecurely' option must be 'true' or 'false', but was '" + (String)analyzeSetupPy + "'.";
                throw new IllegalArgumentException(string9.toString());
            }
            pip4 = pip;
            string = string4;
        } else {
            string = null;
        }
        pip4.analyzeSetupPyInsecurelyOption = string;
    }

    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        PythonInspector.Result result = this.runPythonInspector$python_package_manager(definitionFile, (Function0<String>)((Function0)() -> Pip.resolveDependencies$lambda$8(this, definitionFile)));
        Project project = PythonInspectorExtensionsKt.toOrtProject(result, this.getProjectType(), this.getAnalysisRoot(), definitionFile);
        Set<Package> packages = PythonInspectorExtensionsKt.toOrtPackages(result.getPackages());
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(project, packages, null, 4, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PythonInspector.Result runPythonInspector$python_package_manager(@NotNull File definitionFile, @NotNull Function0<String> detectPythonVersion) {
        Object object;
        String string;
        String operatingSystem;
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(detectPythonVersion, (String)"detectPythonVersion");
        String string2 = this.operatingSystemOption;
        if (string2 == null) {
            string2 = operatingSystem = "linux";
        }
        if ((string = this.pythonVersionOption) == null && (string = (String)detectPythonVersion.invoke()) == null) {
            string = "3.11";
        }
        String pythonVersion = string;
        String string3 = this.analyzeSetupPyInsecurelyOption;
        boolean analyzeSetupPyInsecurely = string3 != null ? StringsKt.toBooleanStrict((String)string3) : true;
        File workingDir = definitionFile.getParentFile();
        Pip $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(Pip.class).info(() -> Pip.runPythonInspector$lambda$9(definitionFile, pythonVersion, operatingSystem));
        Object object2 = this;
        try {
            Object object3;
            Pip $this$runPythonInspector_u24lambda_u2410 = object2;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)workingDir);
                object3 = new char[]{'.'};
                object3 = PythonInspector.INSTANCE.inspect(workingDir, definitionFile, CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)pythonVersion, (char[])object3, (boolean)false, (int)3, (int)2, null), (int)2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), operatingSystem, analyzeSetupPyInsecurely);
            }
            catch (Throwable throwable) {
                Intrinsics.checkNotNull((Object)workingDir);
                org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)FilesKt.resolve((File)workingDir, (String)".cache"), null, (int)1, null);
                throw throwable;
            }
            org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)FilesKt.resolve((File)workingDir, (String)".cache"), null, (int)1, null);
            object = Result.constructor-impl((Object)object3);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            ExtensionsKt.showStackTrace((Throwable)e);
            Pip $this$logger$iv2 = this;
            boolean $i$f$getLogger2 = false;
            LoggingFactoryKt.cachedLoggerOf(Pip.class).error(() -> Pip.runPythonInspector$lambda$12$lambda$11(definitionFile, (Throwable)e));
        }
        ResultKt.throwOnFailure((Object)object2);
        return (PythonInspector.Result)object2;
    }

    public static /* synthetic */ PythonInspector.Result runPythonInspector$python_package_manager$default(Pip pip, File file, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = runPythonInspector.1.INSTANCE;
        }
        return pip.runPythonInspector$python_package_manager(file, (Function0<String>)function0);
    }

    private final String detectPythonVersion(File workingDir) {
        String string;
        File pythonVersionFile = FilesKt.resolve((File)workingDir, (String)".python-version");
        if (!pythonVersionFile.isFile()) {
            return null;
        }
        String string2 = (String)CollectionsKt.firstOrNull((List)FilesKt.readLines$default((File)pythonVersionFile, null, (int)1, null));
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            Character c = StringsKt.firstOrNull((CharSequence)it);
            string = (c != null ? Character.isDigit(c.charValue()) : false) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final CharSequence operatingSystemOption$lambda$2$lambda$1$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    private static final CharSequence pythonVersionOption$lambda$5$lambda$4$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    private static final String resolveDependencies$lambda$8(Pip this$0, File $definitionFile) {
        File file = $definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        return this$0.detectPythonVersion(file);
    }

    private static final Object runPythonInspector$lambda$9(File $definitionFile, String $pythonVersion, String $operatingSystem) {
        return "Resolving dependencies for '" + $definitionFile.getAbsolutePath() + "' with Python version '" + $pythonVersion + "' and operating system '" + $operatingSystem + "'.";
    }

    private static final Object runPythonInspector$lambda$12$lambda$11(File $definitionFile, Throwable $e) {
        return "Unable to determine dependencies for definition file '" + $definitionFile.getAbsolutePath() + "': " + org.ossreviewtoolkit.utils.common.ExtensionsKt.collectMessages((Throwable)$e);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip$Companion;", "", "<init>", "()V", "OPTION_OPERATING_SYSTEM", "", "OPTION_PYTHON_VERSION", "OPTION_ANALYZE_SETUP_PY_INSECURELY", "python-package-manager"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip;", "<init>", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "python-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Pip> {
        @NotNull
        private final List<String> globsForDefinitionFiles;

        public Factory() {
            super("PIP", false, 2, null);
            Object[] objectArray = new String[]{"*requirements*.txt", "setup.py"};
            this.globsForDefinitionFiles = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Pip create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Pip(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

