/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.python;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.python.Pip;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PoetryCommand;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PoetryKt;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspector;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspectorExtensionsKt;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "<init>", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "resolveDependencies", "", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "labels", "", "inspectLockfile", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/utils/PythonInspector$Result;", "lockfile", "dependencyGroupName", "detectPythonVersion", "workingDir", "Companion", "Factory", "python-package-manager"})
@SourceDebugExtension(value={"SMAP\nPoetry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Poetry.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,194:1\n1279#2,2:195\n1293#2,4:197\n1663#2,8:207\n77#3:201\n97#3,5:202\n153#3,3:215\n38#4:218\n38#4:223\n37#5:219\n36#5,3:220\n*S KotlinDebug\n*F\n+ 1 Poetry.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry\n*L\n81#1:195,2\n81#1:197,4\n86#1:207,8\n84#1:201\n84#1:202,5\n97#1:215,3\n114#1:218\n140#1:223\n123#1:219\n123#1:220,3\n*E\n"})
public final class Poetry
extends PackageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PYPROJECT_FILENAME = "pyproject.toml";

    public Poetry(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, "Poetry", analysisRoot, analyzerConfig, repoConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        void destination$iv;
        void $this$mapTo$iv;
        Object key$iv;
        Object e$iv2;
        void $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Map resultsForScopeName;
        Package it;
        Map map;
        Object element$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Set<String> scopeName = PoetryKt.parseScopeNamesFromPyproject(FilesKt.resolveSibling((File)definitionFile, (String)PYPROJECT_FILENAME));
        Iterable $this$associateWith$iv = scopeName;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv2 : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv2;
            Object t = element$iv$iv2;
            map = result$iv;
            boolean bl = false;
            PythonInspector.Result result = this.inspectLockfile(definitionFile, (String)it);
            map.put(t, result);
        }
        Map $i$f$associateWith22 = resultsForScopeName = (Map)result$iv;
        boolean $i$f$flatMap = false;
        $this$associateWithTo$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        element$iv$iv2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (element$iv$iv2.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry bl = element$iv$iv3 = (Map.Entry)element$iv$iv2.next();
            boolean bl2 = false;
            PythonInspector.Result results = (PythonInspector.Result)bl.getValue();
            Iterable list$iv$iv = results.getPackages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = PythonInspectorExtensionsKt.toOrtPackages((List)destination$iv$iv);
        boolean $i$f$distinctBy = false;
        HashSet<Identifier> set$iv = new HashSet<Identifier>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv2 : $this$distinctBy$iv) {
            it = (Package)e$iv2;
            boolean bl = false;
            key$iv = it.getId();
            if (!set$iv.add((Identifier)key$iv)) continue;
            list$iv.add(e$iv2);
        }
        Set packages = CollectionsKt.toSet((Iterable)list$iv);
        Project project = Project.EMPTY;
        String string = this.getProjectType();
        String string2 = FilesKt.relativeTo((File)definitionFile, (File)this.getAnalysisRoot()).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        File file = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        Identifier identifier = new Identifier(string, "", string2, VersionControlSystem.Companion.getCloneInfo(file).getRevision());
        String string3 = VersionControlSystem.Companion.getPathInfo(definitionFile).getPath();
        e$iv2 = resultsForScopeName;
        key$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv;
            Map.Entry entry = item$iv = iterator.next();
            map = destination$iv;
            boolean bl = false;
            String scopeName2 = (String)entry.getKey();
            PythonInspector.Result results = (PythonInspector.Result)entry.getValue();
            map.add(new Scope(scopeName2, PythonInspectorExtensionsKt.toPackageReferences(results.getResolvedDependenciesGraph())));
        }
        Set set = (Set)destination$iv;
        File file2 = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        VcsInfo vcsInfo = PackageManager.Companion.processProjectVcs$default((PackageManager.Companion)PackageManager.Companion, (File)file2, null, (String[])new String[0], (int)2, null);
        Project project2 = Project.copy$default((Project)project, (Identifier)identifier, null, (String)string3, null, null, null, null, (VcsInfo)vcsInfo, null, null, (Set)set, null, (int)2938, null);
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(project2, packages, null, 4, null));
    }

    private final PythonInspector.Result inspectLockfile(File lockfile, String dependencyGroupName) {
        PythonInspector.Result result;
        File workingDir = lockfile.getParentFile();
        File requirementsFile = ExtensionsKt.createOrtTempFile$default((Object)((Object)this), (String)"requirements.txt", null, (int)2, null);
        Poetry $this$logger$iv = this;
        boolean $i$f$getLogger22 = false;
        LoggingFactoryKt.cachedLoggerOf(Poetry.class).info(() -> Poetry.inspectLockfile$lambda$4(requirementsFile, workingDir));
        Object[] $i$f$getLogger22 = new String[]{"export", "--without-hashes", "--format=requirements.txt", "--only=" + dependencyGroupName};
        List options = CollectionsKt.listOf((Object[])$i$f$getLogger22);
        Collection $this$toTypedArray$iv = options;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        String requirements = PoetryCommand.INSTANCE.run(workingDir, Arrays.copyOf(stringArray, stringArray.length)).requireSuccess().getStdout();
        FilesKt.writeText$default((File)requirementsFile, (String)requirements, null, (int)2, null);
        AnalyzerConfiguration poetryAnalyzerConfig = this.getAnalyzerConfig().withPackageManagerOption(this.getManagerName(), "overrideProjectType", this.getProjectType());
        PythonInspector.Result it = result = new Pip(this.getManagerName(), this.getAnalysisRoot(), poetryAnalyzerConfig, this.getRepoConfig()).runPythonInspector$python_package_manager(requirementsFile, (Function0<String>)((Function0)() -> Poetry.inspectLockfile$lambda$5(this, workingDir)));
        boolean bl = false;
        File file = requirementsFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)file, null, (int)1, null);
        return result;
    }

    private final String detectPythonVersion(File workingDir) {
        String string;
        File pyprojectFile = FilesKt.resolve((File)workingDir, (String)PYPROJECT_FILENAME);
        String string2 = PoetryKt.getPythonVersionConstraint(pyprojectFile);
        if (string2 == null) {
            return null;
        }
        String constraint = string2;
        String string3 = PoetryKt.getPythonVersion(constraint);
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            Poetry $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(Poetry.class).info(() -> Poetry.detectPythonVersion$lambda$8$lambda$7(it, constraint));
            string = string4;
        } else {
            string = null;
        }
        return string;
    }

    private static final Object inspectLockfile$lambda$4(File $requirementsFile, File $workingDir) {
        return "Generating '" + $requirementsFile.getName() + "' file in '" + $workingDir + "' directory...";
    }

    private static final String inspectLockfile$lambda$5(Poetry this$0, File $workingDir) {
        Intrinsics.checkNotNull((Object)$workingDir);
        return this$0.detectPythonVersion($workingDir);
    }

    private static final Object detectPythonVersion$lambda$8$lambda$7(String $it, String $constraint) {
        return "Detected Python version '" + $it + "' from '" + $constraint + "'.";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry$Companion;", "", "<init>", "()V", "PYPROJECT_FILENAME", "", "python-package-manager"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry;", "<init>", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "python-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Poetry> {
        @NotNull
        private final List<String> globsForDefinitionFiles = CollectionsKt.listOf((Object)"poetry.lock");

        public Factory() {
            super("Poetry", false, 2, null);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Poetry create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Poetry(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

