/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.python;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.analyzer.PackageManagerFactory;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.Excludes;
import org.ossreviewtoolkit.plugins.api.OrtPlugin;
import org.ossreviewtoolkit.plugins.api.PluginDescriptor;
import org.ossreviewtoolkit.plugins.packagemanagers.python.Pip;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipConfig;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipFactory;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipKt;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspector;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspectorExtensionsKt;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;

@OrtPlugin(id="PIP", displayName="PIP", description="The PIP package manager for Python.", factory=PackageManagerFactory.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B#\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001b\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJB\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001bH\u0016J'\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00142\u0010\b\u0002\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001fH\u0000\u00a2\u0006\u0002\b J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u0014H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pip;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "descriptor", "Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "config", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/PipConfig;", "projectType", "", "<init>", "(Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;Lorg/ossreviewtoolkit/plugins/packagemanagers/python/PipConfig;Ljava/lang/String;)V", "(Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;Lorg/ossreviewtoolkit/plugins/packagemanagers/python/PipConfig;)V", "getDescriptor", "()Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "globsForDefinitionFiles", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "analysisRoot", "Ljava/io/File;", "definitionFile", "excludes", "Lorg/ossreviewtoolkit/model/config/Excludes;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "labels", "", "runPythonInspector", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/utils/PythonInspector$Result;", "detectPythonVersion", "Lkotlin/Function0;", "runPythonInspector$python_package_manager", "workingDir", "python-package-manager"})
@SourceDebugExtension(value={"SMAP\nPip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pip.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Pip\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n38#2:158\n38#2:159\n1#3:160\n*S KotlinDebug\n*F\n+ 1 Pip.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Pip\n*L\n122#1:158\n142#1:159\n*E\n"})
public final class Pip
extends PackageManager {
    @NotNull
    private final PluginDescriptor descriptor;
    @NotNull
    private final PipConfig config;
    @NotNull
    private final List<String> globsForDefinitionFiles;

    public Pip(@NotNull PluginDescriptor descriptor, @NotNull PipConfig config, @NotNull String projectType) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)projectType, (String)"projectType");
        super(projectType);
        this.descriptor = descriptor;
        this.config = config;
        Object[] objectArray = new String[]{"*requirements*.txt", "setup.py"};
        this.globsForDefinitionFiles = CollectionsKt.listOf((Object[])objectArray);
        if (!PipKt.access$getOPERATING_SYSTEMS$p().contains(this.config.getOperatingSystem())) {
            boolean $i$a$-require-Pip$32 = false;
            String acceptedValues = CollectionsKt.joinToString$default((Iterable)PipKt.access$getOPERATING_SYSTEMS$p(), null, null, null, (int)0, null, Pip::lambda$1$lambda$0, (int)31, null);
            String $i$a$-require-Pip$32 = "The 'operatingSystem' option must be one of " + acceptedValues + ", but was '" + this.config.getOperatingSystem() + "'.";
            throw new IllegalArgumentException($i$a$-require-Pip$32.toString());
        }
        if (!(this.config.getPythonVersion() == null || PipKt.getPYTHON_VERSIONS().contains(this.config.getPythonVersion()))) {
            boolean bl = false;
            String acceptedValues = CollectionsKt.joinToString$default((Iterable)PipKt.getPYTHON_VERSIONS(), null, null, null, (int)0, null, Pip::lambda$3$lambda$2, (int)31, null);
            String string = "The 'pythonVersion' option must be one of " + acceptedValues + ", but was '" + this.config.getPythonVersion() + "'.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Pip(PluginDescriptor pluginDescriptor, PipConfig pipConfig, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pluginDescriptor = PipFactory.Companion.getDescriptor();
        }
        this(pluginDescriptor, pipConfig, string);
    }

    @NotNull
    public PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Pip(@NotNull PluginDescriptor descriptor, @NotNull PipConfig config) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(descriptor, config, "PIP");
    }

    public /* synthetic */ Pip(PluginDescriptor pluginDescriptor, PipConfig pipConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pluginDescriptor = PipFactory.Companion.getDescriptor();
        }
        this(pluginDescriptor, pipConfig);
    }

    @NotNull
    public List<String> getGlobsForDefinitionFiles() {
        return this.globsForDefinitionFiles;
    }

    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File analysisRoot, @NotNull File definitionFile, @NotNull Excludes excludes, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull Map<String, String> labels) {
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter((Object)excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        PythonInspector.Result result = this.runPythonInspector$python_package_manager(definitionFile, (Function0<String>)((Function0)() -> Pip.resolveDependencies$lambda$4(this, definitionFile)));
        Project project = PythonInspectorExtensionsKt.toOrtProject(result, this.getProjectType(), analysisRoot, definitionFile);
        Set<Package> packages = PythonInspectorExtensionsKt.toOrtPackages(result.getPackages());
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(project, packages, null, 4, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PythonInspector.Result runPythonInspector$python_package_manager(@NotNull File definitionFile, @NotNull Function0<String> detectPythonVersion) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(detectPythonVersion, (String)"detectPythonVersion");
        String string = this.config.getPythonVersion();
        if (string == null && (string = (String)detectPythonVersion.invoke()) == null) {
            string = "3.11";
        }
        String pythonVersion = string;
        File workingDir = definitionFile.getParentFile();
        Pip $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(Pip.class).info(() -> Pip.runPythonInspector$lambda$5(definitionFile, pythonVersion, this));
        Object object2 = this;
        try {
            Object object3;
            Pip $this$runPythonInspector_u24lambda_u246 = object2;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)workingDir);
                object3 = new char[]{'.'};
                object3 = PythonInspector.INSTANCE.inspect(workingDir, definitionFile, CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)pythonVersion, (char[])object3, (boolean)false, (int)3, (int)2, null), (int)2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), $this$runPythonInspector_u24lambda_u246.config.getOperatingSystem(), $this$runPythonInspector_u24lambda_u246.config.getAnalyzeSetupPyInsecurely());
            }
            catch (Throwable throwable) {
                Intrinsics.checkNotNull((Object)workingDir);
                org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)FilesKt.resolve((File)workingDir, (String)".cache"), null, (int)1, null);
                throw throwable;
            }
            org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)FilesKt.resolve((File)workingDir, (String)".cache"), null, (int)1, null);
            object = Result.constructor-impl((Object)object3);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            ExtensionsKt.showStackTrace((Throwable)e);
            Pip $this$logger$iv2 = this;
            boolean $i$f$getLogger2 = false;
            LoggingFactoryKt.cachedLoggerOf(Pip.class).error(() -> Pip.runPythonInspector$lambda$8$lambda$7(definitionFile, (Throwable)e));
        }
        ResultKt.throwOnFailure((Object)object2);
        return (PythonInspector.Result)object2;
    }

    public static /* synthetic */ PythonInspector.Result runPythonInspector$python_package_manager$default(Pip pip, File file, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = runPythonInspector.1.INSTANCE;
        }
        return pip.runPythonInspector$python_package_manager(file, (Function0<String>)function0);
    }

    private final String detectPythonVersion(File workingDir) {
        String string;
        File pythonVersionFile = FilesKt.resolve((File)workingDir, (String)".python-version");
        if (!pythonVersionFile.isFile()) {
            return null;
        }
        String string2 = (String)CollectionsKt.firstOrNull((List)FilesKt.readLines$default((File)pythonVersionFile, null, (int)1, null));
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            Character c = StringsKt.firstOrNull((CharSequence)it);
            string = (c != null ? Character.isDigit(c.charValue()) : false) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final CharSequence lambda$1$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    private static final CharSequence lambda$3$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    private static final String resolveDependencies$lambda$4(Pip this$0, File $definitionFile) {
        File file = $definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        return this$0.detectPythonVersion(file);
    }

    private static final Object runPythonInspector$lambda$5(File $definitionFile, String $pythonVersion, Pip this$0) {
        return "Resolving dependencies for '" + $definitionFile.getAbsolutePath() + "' with Python version '" + $pythonVersion + "' and operating system '" + this$0.config.getOperatingSystem() + "'.";
    }

    private static final Object runPythonInspector$lambda$8$lambda$7(File $definitionFile, Throwable $e) {
        return "Unable to determine dependencies for definition file '" + $definitionFile.getAbsolutePath() + "': " + org.ossreviewtoolkit.utils.common.ExtensionsKt.collectMessages((Throwable)$e);
    }
}

