/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.python;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.analyzer.PackageManagerFactory;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.Excludes;
import org.ossreviewtoolkit.plugins.api.OrtPlugin;
import org.ossreviewtoolkit.plugins.api.PluginDescriptor;
import org.ossreviewtoolkit.plugins.packagemanagers.python.Pip;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipConfig;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipenvCommand;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipenvFactory;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipenvKt;
import org.ossreviewtoolkit.utils.common.CommandLineTool;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.semver4j.Semver;

@OrtPlugin(displayName="Pipenv", description="The Pipenv package manager for Python.", factory=PackageManagerFactory.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JB\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Pipenv;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "descriptor", "Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "config", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/PipConfig;", "<init>", "(Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;Lorg/ossreviewtoolkit/plugins/packagemanagers/python/PipConfig;)V", "getDescriptor", "()Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "beforeResolution", "", "analysisRoot", "Ljava/io/File;", "definitionFiles", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "excludes", "Lorg/ossreviewtoolkit/model/config/Excludes;", "labels", "", "python-package-manager"})
@SourceDebugExtension(value={"SMAP\nPipenv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pipenv.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Pipenv\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n38#2:104\n1#3:105\n*S KotlinDebug\n*F\n+ 1 Pipenv.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Pipenv\n*L\n88#1:104\n*E\n"})
public final class Pipenv
extends PackageManager {
    @NotNull
    private final PluginDescriptor descriptor;
    @NotNull
    private final PipConfig config;
    @NotNull
    private final List<String> globsForDefinitionFiles;

    public Pipenv(@NotNull PluginDescriptor descriptor, @NotNull PipConfig config) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super("Pipenv");
        this.descriptor = descriptor;
        this.config = config;
        this.globsForDefinitionFiles = CollectionsKt.listOf((Object)"Pipfile.lock");
    }

    public /* synthetic */ Pipenv(PluginDescriptor pluginDescriptor, PipConfig pipConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pluginDescriptor = PipenvFactory.Companion.getDescriptor();
        }
        this(pluginDescriptor, pipConfig);
    }

    @NotNull
    public PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public List<String> getGlobsForDefinitionFiles() {
        return this.globsForDefinitionFiles;
    }

    public void beforeResolution(@NotNull File analysisRoot, @NotNull List<? extends File> definitionFiles, @NotNull AnalyzerConfiguration analyzerConfig) {
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        CommandLineTool.DefaultImpls.checkVersion$default((CommandLineTool)PipenvCommand.INSTANCE, null, (int)1, null);
    }

    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File analysisRoot, @NotNull File definitionFile, @NotNull Excludes excludes, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull Map<String, String> labels) {
        ProcessCapture processCapture;
        Object object;
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter((Object)excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        File workingDir = definitionFile.getParentFile();
        Intrinsics.checkNotNull((Object)workingDir);
        File requirementsFile = FilesKt.resolve((File)workingDir, (String)"requirements-from-pipenv.txt");
        Pipenv $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(Pipenv.class).info(() -> Pipenv.resolveDependencies$lambda$0(requirementsFile, workingDir));
        if (new Semver(CommandLineTool.DefaultImpls.getVersion$default((CommandLineTool)PipenvCommand.INSTANCE, null, (int)1, null)).compareTo(PipenvKt.access$getREQUIREMENTS_COMMAND_VERSION$p()) >= 0) {
            object = new CharSequence[]{"requirements"};
            processCapture = PipenvCommand.INSTANCE.run(workingDir, (CharSequence)object);
        } else {
            object = new CharSequence[]{"lock", "--requirements"};
            processCapture = PipenvCommand.INSTANCE.run(workingDir, (CharSequence)object);
        }
        String requirements = processCapture.requireSuccess().getStdout();
        FilesKt.writeText$default((File)requirementsFile, (String)requirements, null, (int)2, null);
        Object it = object = new Pip(null, this.config, this.getProjectType(), 1, null).resolveDependencies(analysisRoot, requirementsFile, excludes, analyzerConfig, labels);
        boolean bl = false;
        requirementsFile.delete();
        return object;
    }

    private static final Object resolveDependencies$lambda$0(File $requirementsFile, File $workingDir) {
        return "Generating '" + $requirementsFile.getName() + "' file in '" + $workingDir + "' directory...";
    }
}

