/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.python;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.analyzer.PackageManagerFactory;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.Excludes;
import org.ossreviewtoolkit.plugins.api.OrtPlugin;
import org.ossreviewtoolkit.plugins.api.PluginDescriptor;
import org.ossreviewtoolkit.plugins.packagemanagers.python.Pip;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PipConfig;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PoetryCommand;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PoetryFactory;
import org.ossreviewtoolkit.plugins.packagemanagers.python.PoetryKt;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspector;
import org.ossreviewtoolkit.plugins.packagemanagers.python.utils.PythonInspectorExtensionsKt;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;

@OrtPlugin(displayName="Poetry", description="The Poetry package manager for Python.", factory=PackageManagerFactory.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JB\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "descriptor", "Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "config", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/PipConfig;", "<init>", "(Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;Lorg/ossreviewtoolkit/plugins/packagemanagers/python/PipConfig;)V", "getDescriptor", "()Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "analysisRoot", "Ljava/io/File;", "definitionFile", "excludes", "Lorg/ossreviewtoolkit/model/config/Excludes;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "labels", "", "inspectLockfile", "Lorg/ossreviewtoolkit/plugins/packagemanagers/python/utils/PythonInspector$Result;", "lockfile", "dependencyGroupName", "detectPythonVersion", "workingDir", "Companion", "python-package-manager"})
@SourceDebugExtension(value={"SMAP\nPoetry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Poetry.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,194:1\n1279#2,2:195\n1293#2,4:197\n77#3:201\n97#3,5:202\n153#3,3:207\n38#4:210\n38#4:215\n37#5:211\n36#5,3:212\n*S KotlinDebug\n*F\n+ 1 Poetry.kt\norg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry\n*L\n86#1:195,2\n86#1:197,4\n89#1:201\n89#1:202,5\n100#1:207,3\n117#1:210\n140#1:215\n126#1:211\n126#1:212,3\n*E\n"})
public final class Poetry
extends PackageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginDescriptor descriptor;
    @NotNull
    private final PipConfig config;
    @NotNull
    private final List<String> globsForDefinitionFiles;
    @NotNull
    public static final String PYPROJECT_FILENAME = "pyproject.toml";

    public Poetry(@NotNull PluginDescriptor descriptor, @NotNull PipConfig config) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super("Poetry");
        this.descriptor = descriptor;
        this.config = config;
        this.globsForDefinitionFiles = CollectionsKt.listOf((Object)"poetry.lock");
    }

    public /* synthetic */ Poetry(PluginDescriptor pluginDescriptor, PipConfig pipConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pluginDescriptor = PoetryFactory.Companion.getDescriptor();
        }
        this(pluginDescriptor, pipConfig);
    }

    @NotNull
    public PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public List<String> getGlobsForDefinitionFiles() {
        return this.globsForDefinitionFiles;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File analysisRoot, @NotNull File definitionFile, @NotNull Excludes excludes, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull Map<String, String> labels) {
        void $this$mapTo$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Map resultsForScopeName;
        Object object;
        Object element$iv$iv222;
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter((Object)excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Set<String> scopeName = PoetryKt.parseScopeNamesFromPyproject(FilesKt.resolveSibling((File)definitionFile, (String)PYPROJECT_FILENAME));
        Iterable $this$associateWith$iv = scopeName;
        boolean $i$f$associateWith232 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv222 : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv222;
            Object t = element$iv$iv222;
            object = result$iv;
            boolean bl = false;
            PythonInspector.Result result = this.inspectLockfile(definitionFile, string);
            object.put(t, result);
        }
        Map $i$f$associateWith232 = resultsForScopeName = (Map)result$iv;
        boolean $i$f$flatMap = false;
        $this$associateWithTo$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        element$iv$iv222 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (element$iv$iv222.hasNext()) {
            Map.Entry entry;
            Map.Entry bl = entry = (Map.Entry)element$iv$iv222.next();
            boolean bl2 = false;
            PythonInspector.Result results = (PythonInspector.Result)bl.getValue();
            Iterable list$iv$iv = results.getPackages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set<Package> packages = PythonInspectorExtensionsKt.toOrtPackages((List)destination$iv$iv);
        Project project = Project.EMPTY;
        String string = this.getProjectType();
        String string2 = FilesKt.relativeTo((File)definitionFile, (File)analysisRoot).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        File file = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        Identifier identifier = new Identifier(string, "", string2, VersionControlSystem.Companion.getCloneInfo(file).getRevision());
        String string3 = VersionControlSystem.Companion.getPathInfo(definitionFile).getPath();
        element$iv$iv222 = resultsForScopeName;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv;
            Map.Entry entry = item$iv = iterator.next();
            object = collection;
            boolean bl = false;
            String scopeName2 = (String)entry.getKey();
            PythonInspector.Result results = (PythonInspector.Result)entry.getValue();
            object.add(new Scope(scopeName2, PythonInspectorExtensionsKt.toPackageReferences(results.getResolvedDependenciesGraph())));
        }
        Set set = (Set)collection;
        File file2 = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        VcsInfo vcsInfo = PackageManager.Companion.processProjectVcs$default((PackageManager.Companion)PackageManager.Companion, (File)file2, null, (String[])new String[0], (int)2, null);
        Project project2 = Project.copy$default((Project)project, (Identifier)identifier, null, (String)string3, null, null, null, null, (VcsInfo)vcsInfo, null, null, (Set)set, null, (int)2938, null);
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(project2, packages, null, 4, null));
    }

    private final PythonInspector.Result inspectLockfile(File lockfile, String dependencyGroupName) {
        File workingDir = lockfile.getParentFile();
        File requirementsFile = ExtensionsKt.createOrtTempFile$default((Object)((Object)this), (String)"requirements.txt", null, (int)2, null);
        Poetry $this$logger$iv = this;
        boolean $i$f$getLogger22 = false;
        LoggingFactoryKt.cachedLoggerOf(Poetry.class).info(() -> Poetry.inspectLockfile$lambda$3(requirementsFile, workingDir));
        Object[] $i$f$getLogger22 = new String[]{"export", "--without-hashes", "--format=requirements.txt", "--only=" + dependencyGroupName};
        List options = CollectionsKt.listOf((Object[])$i$f$getLogger22);
        Collection $this$toTypedArray$iv = options;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new String[0]);
        String requirements = PoetryCommand.INSTANCE.run(workingDir, Arrays.copyOf(object, ((String[])object).length)).requireSuccess().getStdout();
        FilesKt.writeText$default((File)requirementsFile, (String)requirements, null, (int)2, null);
        Object it = object = new Pip(null, this.config, this.getProjectType(), 1, null).runPythonInspector$python_package_manager(requirementsFile, (Function0<String>)((Function0)() -> Poetry.inspectLockfile$lambda$4(this, workingDir)));
        boolean bl = false;
        File file = requirementsFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)file, null, (int)1, null);
        return object;
    }

    private final String detectPythonVersion(File workingDir) {
        String string;
        File pyprojectFile = FilesKt.resolve((File)workingDir, (String)PYPROJECT_FILENAME);
        String string2 = PoetryKt.getPythonVersionConstraint(pyprojectFile);
        if (string2 == null) {
            return null;
        }
        String constraint = string2;
        String string3 = PoetryKt.getPythonVersion(constraint);
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            Poetry $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(Poetry.class).info(() -> Poetry.detectPythonVersion$lambda$7$lambda$6(it, constraint));
            string = string4;
        } else {
            string = null;
        }
        return string;
    }

    private static final Object inspectLockfile$lambda$3(File $requirementsFile, File $workingDir) {
        return "Generating '" + $requirementsFile.getName() + "' file in '" + $workingDir + "' directory...";
    }

    private static final String inspectLockfile$lambda$4(Poetry this$0, File $workingDir) {
        Intrinsics.checkNotNull((Object)$workingDir);
        return this$0.detectPythonVersion($workingDir);
    }

    private static final Object detectPythonVersion$lambda$7$lambda$6(String $it, String $constraint) {
        return "Detected Python version '" + $it + "' from '" + $constraint + "'.";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/python/Poetry$Companion;", "", "<init>", "()V", "PYPROJECT_FILENAME", "", "python-package-manager"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

