/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.stack;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.analyzer.PackageManagerKt;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.MappersKt;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageReference;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.RemoteArtifact;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.VcsType;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.model.utils.PurlExtensionsKt;
import org.ossreviewtoolkit.plugins.packagemanagers.stack.Stack;
import org.ossreviewtoolkit.utils.common.CommandLineTool;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.ossreviewtoolkit.utils.ort.OkHttpClientHelperKt;
import org.ossreviewtoolkit.utils.ort.ProcessedDeclaredLicense;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010*\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0003'()B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0014J\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J,\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f2\b\b\u0002\u0010 \u001a\u00020\u0004H\u0002J*\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000f2\u0006\u0010#\u001a\u00020\u00062\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001dH\u0016J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0016\u00a8\u0006*"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "Lorg/ossreviewtoolkit/utils/common/CommandLineTool;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "beforeResolution", "", "definitionFiles", "", "command", "workingDir", "downloadCabalFile", "pkgId", "Lorg/ossreviewtoolkit/model/Identifier;", "getPackageUrl", "version", "getVersionRequirement", "Lorg/semver4j/RangesList;", "parseCabalFile", "Lorg/ossreviewtoolkit/model/Package;", "cabal", "parseKeyValue", "", "i", "", "keyPrefix", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "labels", "transformVersion", "output", "Dependency", "Factory", "Location", "stack-package-manager"})
@SourceDebugExtension(value={"SMAP\nStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Stack.kt\norg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 7 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,360:1\n1#2:361\n1#2:397\n1#2:406\n1855#3,2:362\n1549#3:365\n1620#3,3:366\n748#3,10:369\n731#3,9:379\n1549#3:388\n1620#3,3:389\n766#3:392\n857#3,2:393\n1611#3:395\n1855#3:396\n1856#3:398\n1612#3:399\n1611#3:404\n1855#3:405\n1856#3:407\n1612#3:408\n618#3,12:409\n38#4:364\n37#5,2:400\n56#6:402\n49#6:403\n643#7,5:421\n*S KotlinDebug\n*F\n+ 1 Stack.kt\norg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack\n*L\n349#1:397\n192#1:406\n157#1:362,2\n256#1:365\n256#1:366,3\n306#1:369,10\n306#1:379,9\n347#1:388\n347#1:389,3\n348#1:392\n348#1:393,2\n349#1:395\n349#1:396\n349#1:398\n349#1:399\n192#1:404\n192#1:405\n192#1:407\n192#1:408\n204#1:409,12\n232#1:364\n143#1:400,2\n146#1:402\n146#1:403\n237#1:421,5\n*E\n"})
public final class Stack
extends PackageManager
implements CommandLineTool {
    public Stack(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, analysisRoot, analyzerConfig, repoConfig);
    }

    @NotNull
    public String command(@Nullable File workingDir) {
        return "stack";
    }

    @NotNull
    public String transformVersion(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)output, (CharSequence)"Version "), (char)',', null, (int)2, null), (char)' ', null, (int)2, null);
    }

    @NotNull
    public RangesList getVersionRequirement() {
        RangesList rangesList = RangesListFactory.create((String)">=2.1.1");
        Intrinsics.checkNotNullExpressionValue((Object)rangesList, (String)"create(...)");
        return rangesList;
    }

    protected void beforeResolution(@NotNull List<? extends File> definitionFiles) {
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        CommandLineTool.DefaultImpls.checkVersion$default((CommandLineTool)this, null, (int)1, null);
    }

    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        List<Dependency> list;
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        File workingDir = definitionFile.getParentFile();
        Intrinsics.checkNotNull((Object)workingDir);
        List cabalFiles2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)workingDir, null, (int)1, null)), (Function1)resolveDependencies.cabalFiles.1.INSTANCE));
        switch (cabalFiles2.size()) {
            case 0: {
                throw new IOException("No *.cabal file found in '" + workingDir + "'.");
            }
            case 1: {
                break;
            }
            default: {
                throw new IOException("Multiple *.cabal files found in '" + cabalFiles2 + "'.");
            }
        }
        File cabalFile = (File)CollectionsKt.first((List)cabalFiles2);
        Package projectPackage = this.parseCabalFile(FilesKt.readText$default((File)cabalFile, null, (int)1, null));
        Identifier projectId = Identifier.copy$default((Identifier)projectPackage.getId(), (String)this.getManagerName(), null, null, null, (int)14, null);
        Set allDependencies = new LinkedHashSet();
        List<Dependency> it = list = Stack.resolveDependencies$listDependencies(workingDir, this, "external");
        boolean bl = false;
        CollectionsKt.addAll((Collection)allDependencies, (Iterable)it);
        List<Dependency> externalDependencyList = list;
        List<Dependency> it2 = it = Stack.resolveDependencies$listDependencies(workingDir, this, "test");
        boolean bl2 = false;
        CollectionsKt.addAll((Collection)allDependencies, (Iterable)it2);
        List<Dependency> testDependencyList = it;
        List<Dependency> it3 = it2 = Stack.resolveDependencies$listDependencies(workingDir, this, "bench");
        boolean bl3 = false;
        CollectionsKt.addAll((Collection)allDependencies, (Iterable)it3);
        List<Dependency> benchDependencyList = it2;
        Map dependencyPackageMap = new LinkedHashMap();
        Iterable $this$forEach$iv = allDependencies;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            String pkg;
            String string;
            Dependency dependency;
            block9: {
                String string2;
                Package fallback;
                block7: {
                    block8: {
                        dependency = (Dependency)element$iv;
                        boolean bl4 = false;
                        Identifier id = new Identifier("Hackage", "", dependency.getName(), dependency.getVersion());
                        fallback = Package.copy$default((Package)Package.EMPTY, (Identifier)id, (String)PurlExtensionsKt.toPurl$default((Identifier)id, null, null, (int)3, null), null, null, (Set)SetsKt.setOf((Object)dependency.getLicense()), null, null, null, null, null, null, null, null, (boolean)false, (boolean)false, null, (int)65516, null);
                        Location location = dependency.getLocation();
                        String string3 = string2 = location != null ? location.getType() : null;
                        if (!(string3 == null ? true : Intrinsics.areEqual((Object)string3, (Object)"hackage"))) break block7;
                        string = this.downloadCabalFile(id);
                        if (string == null) break block8;
                        String it4 = string;
                        boolean bl5 = false;
                        Package package_ = this.parseCabalFile(it4);
                        string = package_;
                        if (package_ != null) break block9;
                    }
                    string = fallback;
                    break block9;
                }
                string = Intrinsics.areEqual((Object)string2, (Object)"project package") ? null : fallback;
            }
            if ((pkg = string) == null || Intrinsics.areEqual((Object)pkg.getId().getName(), (Object)"ghc")) continue;
            dependencyPackageMap.put(dependency, pkg);
        }
        Object[] $i$f$forEach22 = new Scope[]{new Scope("external", Stack.resolveDependencies$toPackageReferences(Stack.resolveDependencies$getProjectDependencies(externalDependencyList), dependencyPackageMap)), new Scope("test", Stack.resolveDependencies$toPackageReferences(Stack.resolveDependencies$getProjectDependencies(testDependencyList), dependencyPackageMap)), new Scope("bench", Stack.resolveDependencies$toPackageReferences(Stack.resolveDependencies$getProjectDependencies(benchDependencyList), dependencyPackageMap))};
        Set scopes = SetsKt.setOf((Object[])$i$f$forEach22);
        String[] stringArray = new String[]{projectPackage.getHomepageUrl()};
        Project project = new Project(projectId, null, VersionControlSystem.Companion.getPathInfo(definitionFile).getPath(), projectPackage.getAuthors(), projectPackage.getDeclaredLicenses(), null, projectPackage.getVcs(), PackageManager.Companion.processProjectVcs(workingDir, projectPackage.getVcs(), stringArray), projectPackage.getHomepageUrl(), scopes, null, 1058, null);
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(project, CollectionsKt.toSet((Iterable)dependencyPackageMap.values()), null, 4, null));
    }

    private final String getPackageUrl(String name, String version) {
        return "https://hackage.haskell.org/package/" + name + "-" + version;
    }

    private final String downloadCabalFile(Identifier pkgId) {
        Object object;
        block0: {
            Throwable throwable;
            String url = this.getPackageUrl(pkgId.getName(), pkgId.getVersion()) + "/src/" + pkgId.getName() + ".cabal";
            object = OkHttpClientHelperKt.downloadText((OkHttpClient)OkHttpClientHelperKt.getOkHttpClient(), (String)url);
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block0;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            Stack $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(Stack.class).warn((Function0)new Function0<Object>(pkgId){
                final /* synthetic */ Identifier $pkgId;
                {
                    this.$pkgId = $pkgId;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Unable to retrieve Hackage metadata for package '" + this.$pkgId.toCoordinates() + "'.";
                }
            });
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseKeyValue(ListIterator<String> i, String keyPrefix) {
        Integer indentation = null;
        Map map = new LinkedHashMap();
        while (i.hasNext()) {
            void $this$mapTo$iv$iv;
            String line = i.next();
            if (StringsKt.isBlank((CharSequence)line) || StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)line)).toString(), (String)"--", (boolean)false, (int)2, null)) continue;
            if (indentation == null) {
                indentation = Stack.parseKeyValue$getIndentation(line);
            } else {
                int n = Stack.parseKeyValue$getIndentation(line);
                if (indentation != n) {
                    i.previous();
                    break;
                }
            }
            char[] cArray = new char[]{':'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)2, (int)2, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List keyValue = (List)destination$iv$iv;
            switch (keyValue.size()) {
                case 1: {
                    Map<String, String> nestedMap = this.parseKeyValue(i, keyPrefix + StringsKt.replace$default((String)((String)keyValue.get(0)), (String)" ", (String)"-", (boolean)false, (int)4, null) + "-");
                    map.putAll(nestedMap);
                    break;
                }
                case 2: {
                    String key;
                    List list;
                    void $this$dropLastWhile$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)(keyPrefix + keyValue.get(0)).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    List valueLines = new ArrayList();
                    boolean isBlock = false;
                    if (((CharSequence)keyValue.get(1)).length() > 0) {
                        if (Intrinsics.areEqual(keyValue.get(1), (Object)"{")) {
                            isBlock = true;
                        } else {
                            ((Collection)valueLines).add(keyValue.get(1));
                        }
                    }
                    while (i.hasNext()) {
                        String indentedLine = i.next();
                        if (isBlock) {
                            if (Intrinsics.areEqual((Object)indentedLine, (Object)"}")) {
                                break;
                            }
                        } else if (!StringsKt.isBlank((CharSequence)indentedLine) && Stack.parseKeyValue$getIndentation(indentedLine) <= indentation) {
                            i.previous();
                            break;
                        }
                        if (Intrinsics.areEqual((Object)(indentedLine = ((Object)StringsKt.trim((CharSequence)indentedLine)).toString()), (Object)".")) {
                            if (!(!((Collection)valueLines).isEmpty())) continue;
                            ((Collection)valueLines).add("");
                            continue;
                        }
                        ((Collection)valueLines).add(indentedLine);
                    }
                    Iterable $this$dropWhile$iv = valueLines;
                    boolean $i$f$dropWhile = false;
                    boolean yielding$iv = false;
                    ArrayList list$iv = new ArrayList();
                    for (Object item$iv : $this$dropWhile$iv) {
                        if (yielding$iv) {
                            list$iv.add(item$iv);
                            continue;
                        }
                        String it = (String)item$iv;
                        boolean bl = false;
                        if (StringsKt.isBlank((CharSequence)it)) continue;
                        list$iv.add(item$iv);
                        yielding$iv = true;
                    }
                    $this$dropWhile$iv = list$iv;
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (StringsKt.isBlank((CharSequence)it)) continue;
                            list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List trimmedValueLines = list;
                    map.put(key, CollectionsKt.joinToString$default((Iterable)trimmedValueLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                }
            }
        }
        return map;
    }

    static /* synthetic */ Map parseKeyValue$default(Stack stack, ListIterator listIterator, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return stack.parseKeyValue(listIterator, string);
    }

    /*
     * WARNING - void declaration
     */
    private final Package parseCabalFile(String cabal) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String p0;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String string;
        String homepageUrl;
        String string2;
        String string3;
        String vcsType;
        String string4;
        String string5;
        String string6;
        Map map = Stack.parseKeyValue$default(this, StringsKt.lines((CharSequence)cabal).listIterator(), null, 2, null);
        String string7 = (String)map.get("category");
        if (string7 == null) {
            string7 = "";
        }
        if ((string6 = (String)map.get("name")) == null) {
            string6 = "";
        }
        if ((string5 = (String)map.get("version")) == null) {
            string5 = "";
        }
        Identifier id = new Identifier("Hackage", string7, string6, string5);
        RemoteArtifact artifact = RemoteArtifact.copy$default((RemoteArtifact)RemoteArtifact.EMPTY, (String)(this.getPackageUrl(id.getName(), id.getVersion()) + "/" + id.getName() + "-" + id.getVersion() + ".tar.gz"), null, (int)2, null);
        String string8 = (String)map.get("source-repository-this-type");
        if (string8 == null) {
            string8 = string4 = (String)map.get("source-repository-head-type");
        }
        if (string8 == null) {
            string4 = vcsType = "";
        }
        if ((string3 = (String)map.get("source-repository-this-location")) == null) {
            string3 = string2 = (String)map.get("source-repository-head-location");
        }
        if (string3 == null) {
            string2 = "";
        }
        String vcsUrl = string2;
        VcsType vcsType2 = VcsType.Companion.forName(vcsType);
        String string9 = (String)map.get("source-repository-this-tag");
        if (string9 == null) {
            string9 = "";
        }
        String[] stringArray = string9;
        VcsInfo vcs = new VcsInfo(vcsType2, vcsUrl, (String)stringArray, null, 8, null);
        String string10 = (String)map.get("homepage");
        if (string10 == null) {
            string10 = homepageUrl = "";
        }
        if ((string = (String)map.get("author")) == null) {
            string = "";
        }
        stringArray = (String[])new char[1];
        stringArray[0] = 44;
        stringArray = StringsKt.split$default((CharSequence)string, (char[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string11 = null;
        String string12 = null;
        Identifier identifier = id;
        boolean $i$f$map = false;
        void var11_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string13 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)p0)).toString());
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$filter22 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)p0).length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        Collection $i$f$filter22 = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            String p02 = (String)element$iv;
            boolean bl2 = false;
            if (PackageManagerKt.parseAuthorString$default((String)p02, null, (int)2, null) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        collection = destination$iv;
        Set set = (Set)collection;
        Set set2 = SetsKt.setOfNotNull(map.get("license"));
        String string14 = (String)map.get("description");
        if (string14 == null) {
            string14 = "";
        }
        stringArray = new String[]{homepageUrl};
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 57446;
        List list = null;
        boolean bl = false;
        boolean bl4 = false;
        VcsInfo vcsInfo = PackageManager.Companion.processPackageVcs(vcs, stringArray);
        VcsInfo vcsInfo2 = vcs;
        RemoteArtifact remoteArtifact = artifact;
        RemoteArtifact remoteArtifact2 = RemoteArtifact.EMPTY;
        String string15 = homepageUrl;
        String string16 = string14;
        SpdxExpression spdxExpression = null;
        ProcessedDeclaredLicense processedDeclaredLicense = null;
        Set set3 = set2;
        Set set4 = set;
        String string17 = string11;
        String string18 = string12;
        Identifier identifier2 = identifier;
        return new Package(identifier2, string18, string17, set4, set3, processedDeclaredLicense, spdxExpression, string16, string15, remoteArtifact2, remoteArtifact, vcsInfo2, vcsInfo, bl4, bl, list, n, defaultConstructorMarker);
    }

    public void checkVersion(@Nullable File workingDir) {
        CommandLineTool.DefaultImpls.checkVersion((CommandLineTool)this, (File)workingDir);
    }

    @NotNull
    public String getVersion(@Nullable File workingDir) {
        return CommandLineTool.DefaultImpls.getVersion((CommandLineTool)this, (File)workingDir);
    }

    @NotNull
    public String getVersionArguments() {
        return CommandLineTool.DefaultImpls.getVersionArguments((CommandLineTool)this);
    }

    public boolean isInPath() {
        return CommandLineTool.DefaultImpls.isInPath((CommandLineTool)this);
    }

    @NotNull
    public ProcessCapture run(@Nullable File workingDir, CharSequence ... args) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (File)workingDir, (CharSequence[])args);
    }

    @NotNull
    public ProcessCapture run(@NotNull CharSequence[] args, @Nullable File workingDir, @NotNull Map<String, String> environment) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (CharSequence[])args, (File)workingDir, environment);
    }

    private static final ProcessCapture resolveDependencies$runStack(File workingDir, Stack this$0, String ... command) {
        Intrinsics.checkNotNull((Object)workingDir);
        ExtensionsKt.safeDeleteRecursively$default((File)FilesKt.resolve((File)workingDir, (String)".stack-work"), (boolean)false, null, (int)3, null);
        return this$0.run(workingDir, Arrays.copyOf(command, command.length));
    }

    private static final List<Dependency> resolveDependencies$listDependencies(File workingDir, Stack this$0, String scope) {
        String string;
        Object[] objectArray = new String[2];
        objectArray[0] = "--" + scope;
        String string2 = string = "--no-external";
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = !Intrinsics.areEqual((Object)scope, (Object)"external");
        objectArray2[n] = bl2 ? string : null;
        List scopeOptions = CollectionsKt.listOfNotNull((Object[])objectArray);
        string = new SpreadBuilder(5);
        string.add((Object)"ls");
        string.add((Object)"dependencies");
        string.add((Object)"json");
        string.add((Object)"--global-hints");
        Collection $this$toTypedArray$iv = scopeOptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        string.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        String dependenciesJson = Stack.resolveDependencies$runStack(workingDir, this$0, (String[])string.toArray((Object[])new String[string.size()])).getStdout();
        ObjectMapper $this$readValue$iv = (ObjectMapper)MappersKt.getJsonMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (List)$this$readValue$iv.readValue(dependenciesJson, (TypeReference)new TypeReference<List<? extends Dependency>>(){});
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<PackageReference> resolveDependencies$toPackageReferences(List<String> $this$resolveDependencies_u24toPackageReferences, Map<Dependency, Package> dependencyPackageMap) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Iterable iterable = $this$resolveDependencies_u24toPackageReferences;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            PackageReference packageReference;
            Object v0;
            block4: {
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                String name = (String)element$iv;
                boolean bl2 = false;
                Iterable iterable2 = dependencyPackageMap.entrySet();
                for (Object t : iterable2) {
                    Map.Entry entry = (Map.Entry)t;
                    boolean bl3 = false;
                    Dependency dependency = (Dependency)entry.getKey();
                    if (!Intrinsics.areEqual((Object)dependency.getName(), (Object)name)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            if ((Map.Entry)v0 != null) {
                Map.Entry entry;
                boolean bl = false;
                Package pkg = (Package)entry.getValue();
                Set<PackageReference> dependencies = Stack.resolveDependencies$toPackageReferences(((Dependency)entry.getKey()).getDependencies(), dependencyPackageMap);
                packageReference = PackageReference.copy$default((PackageReference)Package.toReference$default((Package)pkg, null, null, null, (int)7, null), null, null, dependencies, null, (int)11, null);
            } else {
                packageReference = null;
            }
            if (packageReference == null) continue;
            PackageReference it$iv = packageReference;
            boolean bl = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> resolveDependencies$getProjectDependencies(List<Dependency> $this$resolveDependencies_u24getProjectDependencies) {
        void var3_3;
        Iterable $this$single$iv = $this$resolveDependencies_u24getProjectDependencies;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            Dependency it = (Dependency)element$iv;
            boolean bl = false;
            Location location = it.getLocation();
            if (!Intrinsics.areEqual((Object)(location != null ? location.getType() : null), (Object)"project package")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((Dependency)var3_3).getDependencies();
    }

    /*
     * WARNING - void declaration
     */
    private static final int parseKeyValue$getIndentation(String line) {
        String string;
        block1: {
            void var1_1;
            String $this$takeWhile$iv = line;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var1_1;
        }
        return string.length();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0083\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003JC\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack$Dependency;", "", "name", "", "version", "license", "location", "Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack$Location;", "dependencies", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack$Location;Ljava/util/List;)V", "getDependencies", "()Ljava/util/List;", "getLicense", "()Ljava/lang/String;", "getLocation", "()Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack$Location;", "getName", "getVersion", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "stack-package-manager"})
    private static final class Dependency {
        @NotNull
        private final String name;
        @NotNull
        private final String version;
        @NotNull
        private final String license;
        @Nullable
        private final Location location;
        @NotNull
        private final List<String> dependencies;

        public Dependency(@NotNull String name, @NotNull String version, @NotNull String license, @Nullable Location location, @NotNull List<String> dependencies) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)license, (String)"license");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            this.name = name;
            this.version = version;
            this.license = license;
            this.location = location;
            this.dependencies = dependencies;
        }

        public /* synthetic */ Dependency(String string, String string2, String string3, Location location, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                location = null;
            }
            if ((n & 0x10) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, string2, string3, location, list);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final String getLicense() {
            return this.license;
        }

        @Nullable
        public final Location getLocation() {
            return this.location;
        }

        @NotNull
        public final List<String> getDependencies() {
            return this.dependencies;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.version;
        }

        @NotNull
        public final String component3() {
            return this.license;
        }

        @Nullable
        public final Location component4() {
            return this.location;
        }

        @NotNull
        public final List<String> component5() {
            return this.dependencies;
        }

        @NotNull
        public final Dependency copy(@NotNull String name, @NotNull String version, @NotNull String license, @Nullable Location location, @NotNull List<String> dependencies) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)license, (String)"license");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            return new Dependency(name, version, license, location, dependencies);
        }

        public static /* synthetic */ Dependency copy$default(Dependency dependency, String string, String string2, String string3, Location location, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = dependency.name;
            }
            if ((n & 2) != 0) {
                string2 = dependency.version;
            }
            if ((n & 4) != 0) {
                string3 = dependency.license;
            }
            if ((n & 8) != 0) {
                location = dependency.location;
            }
            if ((n & 0x10) != 0) {
                list = dependency.dependencies;
            }
            return dependency.copy(string, string2, string3, location, list);
        }

        @NotNull
        public String toString() {
            return "Dependency(name=" + this.name + ", version=" + this.version + ", license=" + this.license + ", location=" + this.location + ", dependencies=" + this.dependencies + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.version.hashCode();
            result = result * 31 + this.license.hashCode();
            result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
            result = result * 31 + ((Object)this.dependencies).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Dependency)) {
                return false;
            }
            Dependency dependency = (Dependency)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)dependency.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)dependency.version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.license, (Object)dependency.license)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.location, (Object)dependency.location)) {
                return false;
            }
            return Intrinsics.areEqual(this.dependencies, dependency.dependencies);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack;", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "stack-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Stack> {
        @NotNull
        private final List<String> globsForDefinitionFiles = CollectionsKt.listOf((Object)"stack.yaml");

        public Factory() {
            super("Stack", false, 2, null);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Stack create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Stack(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0083\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack$Location;", "", "url", "", "type", "(Ljava/lang/String;Ljava/lang/String;)V", "getType", "()Ljava/lang/String;", "getUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "stack-package-manager"})
    private static final class Location {
        @NotNull
        private final String url;
        @NotNull
        private final String type;

        public Location(@NotNull String url, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.url = url;
            this.type = type;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final Location copy(@NotNull String url, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Location(url, type);
        }

        public static /* synthetic */ Location copy$default(Location location, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = location.url;
            }
            if ((n & 2) != 0) {
                string2 = location.type;
            }
            return location.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Location(url=" + this.url + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Location)) {
                return false;
            }
            Location location = (Location)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)location.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)location.type);
        }
    }
}

