/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.stack;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.ScopeKt;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.model.utils.PurlExtensionsKt;
import org.ossreviewtoolkit.plugins.packagemanagers.stack.Dependency;
import org.ossreviewtoolkit.plugins.packagemanagers.stack.ModelKt;
import org.ossreviewtoolkit.plugins.packagemanagers.stack.StackKt;
import org.ossreviewtoolkit.utils.common.CommandLineTool;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.ossreviewtoolkit.utils.ort.OkHttpClientHelperKt;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001*B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0014J*\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u00062\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001bH\u0016J)\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u00062\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001e\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00162\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u001e\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\f\u0010(\u001a\u00020)*\u00020!H\u0002\u00a8\u0006+"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "Lorg/ossreviewtoolkit/utils/common/CommandLineTool;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "<init>", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "command", "workingDir", "transformVersion", "output", "getVersionRequirement", "Lorg/semver4j/RangesList;", "beforeResolution", "", "definitionFiles", "", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "labels", "", "runStack", "Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "", "(Ljava/io/File;[Ljava/lang/String;)Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "listDependencies", "Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Dependency;", "scope", "getProject", "Lorg/ossreviewtoolkit/model/Project;", "scopes", "", "Lorg/ossreviewtoolkit/model/Scope;", "toPackage", "Lorg/ossreviewtoolkit/model/Package;", "Factory", "stack-package-manager"})
@SourceDebugExtension(value={"SMAP\nStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Stack.kt\norg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,339:1\n1279#2,2:340\n1293#2,4:342\n1663#2,8:346\n827#2:354\n855#2,2:355\n1187#2,2:357\n1261#2,4:359\n865#2,2:366\n153#3,3:363\n1#4:368\n37#5,2:369\n*S KotlinDebug\n*F\n+ 1 Stack.kt\norg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack\n*L\n92#1:340,2\n92#1:342,4\n95#1:346,8\n96#1:354\n96#1:355,2\n97#1:357,2\n97#1:359,4\n104#1:366,2\n99#1:363,3\n126#1:369,2\n*E\n"})
public final class Stack
extends PackageManager
implements CommandLineTool {
    public Stack(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, analysisRoot, analyzerConfig, repoConfig);
    }

    @NotNull
    public String command(@Nullable File workingDir) {
        return "stack";
    }

    @NotNull
    public String transformVersion(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)output, (CharSequence)"Version "), (char)',', null, (int)2, null), (char)' ', null, (int)2, null);
    }

    @NotNull
    public RangesList getVersionRequirement() {
        RangesList rangesList = RangesListFactory.create((String)">=2.1.1");
        Intrinsics.checkNotNullExpressionValue((Object)rangesList, (String)"create(...)");
        return rangesList;
    }

    protected void beforeResolution(@NotNull List<? extends File> definitionFiles) {
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        CommandLineTool.DefaultImpls.checkVersion$default((CommandLineTool)this, null, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        void destination$iv;
        void $this$filterTo$iv;
        void destination$iv2;
        void $this$mapTo$iv;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Iterable $this$distinctBy$iv;
        Dependency it;
        boolean bl;
        Map map;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        File workingDir = definitionFile.getParentFile();
        Iterable $this$associateWith$iv = StackKt.access$getSCOPE_NAMES$p();
        boolean $i$f$associateWith232 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object t : $this$associateWithTo$iv$iv) {
            iterator = (String)t;
            Object t2 = t;
            map = result$iv;
            bl = false;
            Intrinsics.checkNotNull((Object)workingDir);
            List<Dependency> list = this.listDependencies(workingDir, (String)((Object)it));
            map.put(t2, list);
        }
        Map dependenciesForScopeName = result$iv;
        Iterable $i$f$associateWith232 = CollectionsKt.flatten((Iterable)dependenciesForScopeName.values());
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object t : $this$distinctBy$iv) {
            it = (Dependency)t;
            bl = false;
            String key$iv = it.getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(t);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$filterNot = false;
        set$iv = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Dependency it2 = (Dependency)element$iv$iv;
            boolean bl2 = false;
            if (StackKt.access$isProject(it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$associate232 = false;
        int capacity$iv232 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv232);
        boolean bl3 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl2 = destination$iv$iv2;
            Dependency it3 = (Dependency)element$iv$iv;
            boolean bl22 = false;
            it3 = TuplesKt.to((Object)it3.getName(), (Object)this.toPackage(it3));
            bl2.put(it3.getFirst(), it3.getSecond());
        }
        Map packageForName = destination$iv$iv2;
        Map $i$f$associate232 = dependenciesForScopeName;
        Collection capacity$iv232 = new LinkedHashSet();
        boolean $i$f$mapTo232 = false;
        for (Map.Entry entry : $this$mapTo$iv.entrySet()) {
            iterator = entry;
            map = destination$iv2;
            boolean bl4 = false;
            String name = (String)iterator.getKey();
            List dependencies = (List)iterator.getValue();
            map.add(StackKt.access$toScope(dependencies, name, packageForName));
        }
        Set scopes = (Set)destination$iv2;
        Set referencedPackages = ScopeKt.collectDependencies((Collection)scopes);
        Iterable $i$f$mapTo232 = packageForName.values();
        destination$iv$iv2 = new LinkedHashSet();
        boolean bl5 = false;
        for (Object element$iv : $this$filterTo$iv) {
            Package it4 = (Package)element$iv;
            boolean bl6 = false;
            if (!referencedPackages.contains(it4.getId())) continue;
            destination$iv.add(element$iv);
        }
        Set packages = (Set)destination$iv;
        Project project = this.getProject(definitionFile, scopes);
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(project, packages, null, 4, null));
    }

    private final ProcessCapture runStack(File workingDir, String ... command) {
        ExtensionsKt.safeDeleteRecursively$default((File)FilesKt.resolve((File)workingDir, (String)".stack-work"), (boolean)false, null, (int)3, null);
        return this.run(workingDir, Arrays.copyOf(command, command.length));
    }

    private final List<Dependency> listDependencies(File workingDir, String scope) {
        String string;
        Object[] objectArray = new String[2];
        objectArray[0] = "--" + scope;
        String string2 = string = "--no-external";
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = !Intrinsics.areEqual((Object)scope, (Object)"external");
        objectArray2[n] = bl2 ? string : null;
        List scopeOptions = CollectionsKt.listOfNotNull((Object[])objectArray);
        string = new SpreadBuilder(5);
        string.add((Object)"ls");
        string.add((Object)"dependencies");
        string.add((Object)"json");
        string.add((Object)"--global-hints");
        Collection $this$toTypedArray$iv = scopeOptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        string.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        String dependenciesJson = this.runStack(workingDir, (String[])string.toArray((Object[])new String[string.size()])).getStdout();
        return ModelKt.parseDependencies(dependenciesJson);
    }

    private final Project getProject(File definitionFile, Set<Scope> scopes) {
        File workingDir = definitionFile.getParentFile();
        Intrinsics.checkNotNull((Object)workingDir);
        List cabalFiles = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)workingDir, null, (int)1, null)), Stack::getProject$lambda$7));
        switch (cabalFiles.size()) {
            case 0: {
                throw new IOException("No *.cabal file found in '" + workingDir + "'.");
            }
            case 1: {
                break;
            }
            default: {
                throw new IOException("Multiple *.cabal files found in '" + cabalFiles + "'.");
            }
        }
        File cabalFile = (File)CollectionsKt.first((List)cabalFiles);
        Package projectPackage = StackKt.access$parseCabalFile(FilesKt.readText$default((File)cabalFile, null, (int)1, null), this.getManagerName());
        String[] stringArray = new String[]{projectPackage.getHomepageUrl()};
        return new Project(projectPackage.getId(), null, VersionControlSystem.Companion.getPathInfo(definitionFile).getPath(), projectPackage.getAuthors(), projectPackage.getDeclaredLicenses(), null, projectPackage.getVcs(), PackageManager.Companion.processProjectVcs(workingDir, projectPackage.getVcs(), stringArray), projectPackage.getHomepageUrl(), scopes, null, 1058, null);
    }

    private final Package toPackage(Dependency $this$toPackage) {
        String string;
        Identifier id = new Identifier("Hackage", "", $this$toPackage.getName(), $this$toPackage.getVersion());
        if (($this$toPackage.getLocation() == null || Intrinsics.areEqual((Object)$this$toPackage.getLocation().getType(), (Object)"hackage")) && (string = StackKt.access$downloadCabalFile(OkHttpClientHelperKt.getOkHttpClient(), id)) != null) {
            String it = string;
            boolean bl = false;
            return StackKt.access$parseCabalFile(it, "Hackage");
        }
        return Package.copy$default((Package)Package.EMPTY, (Identifier)id, (String)PurlExtensionsKt.toPurl$default((Identifier)id, null, null, (int)3, null), null, null, (Set)SetsKt.setOf((Object)$this$toPackage.getLicense()), null, null, null, null, null, null, null, null, (boolean)false, (boolean)false, null, (int)65516, null);
    }

    @NotNull
    public String getVersionArguments() {
        return CommandLineTool.DefaultImpls.getVersionArguments((CommandLineTool)this);
    }

    public boolean isInPath() {
        return CommandLineTool.DefaultImpls.isInPath((CommandLineTool)this);
    }

    @NotNull
    public ProcessCapture run(@NotNull CharSequence[] args, @Nullable File workingDir, @NotNull Map<String, String> environment) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (CharSequence[])args, (File)workingDir, environment);
    }

    @NotNull
    public ProcessCapture run(@Nullable File workingDir, CharSequence ... args) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (File)workingDir, (CharSequence[])args);
    }

    @NotNull
    public String getVersion(@Nullable File workingDir) {
        return CommandLineTool.DefaultImpls.getVersion((CommandLineTool)this, (File)workingDir);
    }

    public void checkVersion(@Nullable File workingDir) {
        CommandLineTool.DefaultImpls.checkVersion((CommandLineTool)this, (File)workingDir);
    }

    @NotNull
    public String displayName() {
        return CommandLineTool.DefaultImpls.displayName((CommandLineTool)this);
    }

    private static final boolean getProject$lambda$7(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"cabal");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/stack/Stack;", "<init>", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "stack-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Stack> {
        @NotNull
        private final List<String> globsForDefinitionFiles = CollectionsKt.listOf((Object)"stack.yaml");

        public Factory() {
            super("Stack", false, 2, null);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Stack create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Stack(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

