/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.swiftpm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.downloader.WorkingTree;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageLinkage;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.VcsInfoKt;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.swiftpm.PinV2;
import org.ossreviewtoolkit.plugins.packagemanagers.swiftpm.SwiftCommand;
import org.ossreviewtoolkit.plugins.packagemanagers.swiftpm.SwiftPackage;
import org.ossreviewtoolkit.plugins.packagemanagers.swiftpm.SwiftPmKt;
import org.ossreviewtoolkit.plugins.packagemanagers.swiftpm.SwiftPmModelKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0016J*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002\u00a8\u0006 "}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/swiftpm/SwiftPm;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "<init>", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "mapDefinitionFiles", "", "definitionFiles", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "definitionFile", "labels", "", "resolveLockfileDependencies", "packageResolvedFile", "resolveDefinitionFileDependencies", "packageSwiftFile", "getSwiftPackage", "Lorg/ossreviewtoolkit/plugins/packagemanagers/swiftpm/SwiftPackage;", "projectFromDefinitionFile", "Lorg/ossreviewtoolkit/model/Project;", "scopeDependencies", "", "Lorg/ossreviewtoolkit/model/Scope;", "Factory", "swiftpm-package-manager"})
@SourceDebugExtension(value={"SMAP\nSwiftPm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwiftPm.kt\norg/ossreviewtoolkit/plugins/packagemanagers/swiftpm/SwiftPm\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n827#2:281\n855#2,2:282\n1628#2,3:284\n1628#2,3:287\n1230#2,4:290\n1628#2,3:294\n1628#2,3:297\n*S KotlinDebug\n*F\n+ 1 SwiftPm.kt\norg/ossreviewtoolkit/plugins/packagemanagers/swiftpm/SwiftPm\n*L\n80#1:281\n80#1:282,2\n104#1:284,3\n107#1:287,3\n140#1:290,4\n146#1:294,3\n149#1:297,3\n*E\n"})
public final class SwiftPm
extends PackageManager {
    public SwiftPm(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, "SwiftPM", analysisRoot, analyzerConfig, repoConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<File> mapDefinitionFiles(@NotNull List<? extends File> definitionFiles) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
        Iterable $this$filterNot$iv = definitionFiles;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            File file = (File)element$iv$iv;
            boolean bl = false;
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)".build/checkouts", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        if (!Intrinsics.areEqual((Object)definitionFile.getName(), (Object)"Package.resolved")) {
            File file = definitionFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
            this.requireLockfile(file, () -> SwiftPm.resolveDependencies$lambda$1(definitionFile));
        }
        return Intrinsics.areEqual((Object)definitionFile.getName(), (Object)"Package.swift") ? this.resolveDefinitionFileDependencies(definitionFile) : this.resolveLockfileDependencies(definitionFile);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProjectAnalyzerResult> resolveLockfileDependencies(File packageResolvedFile) {
        Set scopeDependencies;
        Set packages;
        List issues;
        block4: {
            Throwable throwable;
            issues = new ArrayList();
            packages = new LinkedHashSet();
            scopeDependencies = new LinkedHashSet();
            Object object = SwiftPmModelKt.parseLockfile(packageResolvedFile);
            if (Result.isSuccess-impl((Object)object)) {
                void destination$iv;
                void $this$mapTo$iv;
                Set pins = (Set)object;
                boolean bl = false;
                Iterable $this$mapTo$iv2 = pins;
                boolean $i$f$mapTo22 = false;
                for (Object item$iv : $this$mapTo$iv2) {
                    void it;
                    PinV2 pinV2 = (PinV2)item$iv;
                    Collection collection = packages;
                    boolean bl2 = false;
                    collection.add(SwiftPmKt.access$toPackage((PinV2)it));
                }
                $this$mapTo$iv2 = scopeDependencies;
                Iterable $i$f$mapTo22 = packages;
                Collection collection = new LinkedHashSet();
                String string = "dependencies";
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    Package package_ = (Package)item$iv;
                    void var17_22 = destination$iv;
                    boolean bl3 = false;
                    var17_22.add(Package.toReference$default((Package)it, (PackageLinkage)PackageLinkage.DYNAMIC, null, null, (int)6, null));
                }
                Set set = (Set)destination$iv;
                String string2 = string;
                $this$mapTo$iv2.add(new Scope(string2, set));
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block4;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            Collection collection = issues;
            String string = this.getManagerName();
            String string3 = it.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            collection.add(new Issue(null, string, string3, null, null, 25, null));
        }
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(this.projectFromDefinitionFile(packageResolvedFile, scopeDependencies), packages, issues));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProjectAnalyzerResult> resolveDefinitionFileDependencies(File packageSwiftFile) {
        void destination$iv;
        void $this$mapTo$iv;
        Object object;
        SwiftPackage swiftPackage = this.getSwiftPackage(packageSwiftFile);
        List issues = new ArrayList();
        Set packages = new LinkedHashSet();
        Set scopeDependencies = new LinkedHashSet();
        Map pinsByIdentity = new LinkedHashMap();
        File lockfile = FilesKt.resolveSibling((File)packageSwiftFile, (String)"Package.resolved");
        if (lockfile.isFile()) {
            Object pins;
            object = SwiftPmModelKt.parseLockfile(lockfile);
            if (Result.isSuccess-impl((Object)object)) {
                pins = (Set)object;
                boolean bl = false;
                Iterable $this$associateByTo$iv = (Iterable)pins;
                boolean $i$f$associateByTo = false;
                for (Object element$iv : $this$associateByTo$iv) {
                    void it;
                    PinV2 pinV2 = (PinV2)element$iv;
                    Map map = pinsByIdentity;
                    boolean bl2 = false;
                    map.put(it.getIdentity(), element$iv);
                }
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object it = pins = throwable;
                boolean bl = false;
                Collection collection = issues;
                String string = this.getManagerName();
                String string2 = ((Throwable)it).getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                collection.add(new Issue(null, string, string2, null, null, 25, null));
            }
        }
        Iterable $this$mapTo$iv2 = SwiftPmKt.access$getTransitiveDependencies(swiftPackage);
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv2) {
            void it;
            SwiftPackage $i$f$associateByTo = (SwiftPackage)item$iv;
            Collection collection = packages;
            boolean bl = false;
            collection.add(SwiftPmKt.access$toPackage((SwiftPackage)it, pinsByIdentity));
        }
        object = scopeDependencies;
        Iterable $i$f$mapTo22 = swiftPackage.getDependencies();
        Collection it = new LinkedHashSet();
        String string = "dependencies";
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            Object element$iv;
            element$iv = (SwiftPackage)item$iv;
            void var20_31 = destination$iv;
            boolean bl = false;
            var20_31.add(SwiftPmKt.access$toPackageReference((SwiftPackage)it2, pinsByIdentity));
        }
        Set set = (Set)destination$iv;
        String string3 = string;
        object.add(new Scope(string3, set));
        return CollectionsKt.listOf((Object)new ProjectAnalyzerResult(this.projectFromDefinitionFile(packageSwiftFile, scopeDependencies), packages, issues));
    }

    private final SwiftPackage getSwiftPackage(File packageSwiftFile) {
        CharSequence[] charSequenceArray = new CharSequence[]{"package", "show-dependencies", "--format", "json"};
        String result = SwiftCommand.INSTANCE.run(packageSwiftFile.getParentFile(), charSequenceArray).requireSuccess().getStdout();
        return SwiftPmModelKt.parseSwiftPackage(result);
    }

    private final Project projectFromDefinitionFile(File definitionFile, Set<Scope> scopeDependencies) {
        File file = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        WorkingTree workingTree = VersionControlSystem.Companion.forDirectory$default((VersionControlSystem.Companion)VersionControlSystem.Companion, (File)file, null, (int)2, null);
        VcsInfo vcsInfo = VcsInfoKt.orEmpty((VcsInfo)(workingTree != null ? workingTree.getInfo() : null));
        String string = this.getProjectType();
        Object object = vcsInfo.getRevision();
        String string2 = PackageManager.Companion.getFallbackProjectName(this.getAnalysisRoot(), definitionFile);
        Identifier projectIdentifier = new Identifier(string, "", string2, (String)object);
        string = VcsInfo.EMPTY;
        object = SetsKt.emptySet();
        File file2 = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        string2 = PackageManager.Companion.processProjectVcs$default((PackageManager.Companion)PackageManager.Companion, (File)file2, null, (String[])new String[0], (int)2, null);
        String string3 = VersionControlSystem.Companion.getPathInfo(definitionFile).getPath();
        return new Project(projectIdentifier, null, string3, null, (Set)object, null, (VcsInfo)string, (VcsInfo)string2, null, "", scopeDependencies, null, 2346, null);
    }

    private static final boolean resolveDependencies$lambda$1(File $definitionFile) {
        return FilesKt.resolveSibling((File)$definitionFile, (String)"Package.resolved").isFile();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/swiftpm/SwiftPm$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/swiftpm/SwiftPm;", "<init>", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "swiftpm-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<SwiftPm> {
        @NotNull
        private final List<String> globsForDefinitionFiles;

        public Factory() {
            super("SwiftPM", false, 2, null);
            Object[] objectArray = new String[]{"Package.swift", "Package.resolved"};
            this.globsForDefinitionFiles = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public SwiftPm create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new SwiftPm(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

