/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.Os;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;
import org.semver4j.Semver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\bf\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019J\u0014\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0014\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J+\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013JC\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u00122\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/ossreviewtoolkit/utils/common/CommandLineTool;", "", "checkVersion", "", "workingDir", "Ljava/io/File;", "command", "", "getVersion", "getVersionArguments", "getVersionRequirement", "Lorg/semver4j/RangesList;", "isInPath", "", "run", "Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "args", "", "", "(Ljava/io/File;[Ljava/lang/CharSequence;)Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "environment", "", "([Ljava/lang/CharSequence;Ljava/io/File;Ljava/util/Map;)Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "transformVersion", "output", "Companion", "common-utils"})
public interface CommandLineTool {
    @NotNull
    public static final Companion Companion = org.ossreviewtoolkit.utils.common.CommandLineTool$Companion.$$INSTANCE;

    @NotNull
    public String command(@Nullable File var1);

    @NotNull
    public String getVersionArguments();

    @NotNull
    public String transformVersion(@NotNull String var1);

    @NotNull
    public RangesList getVersionRequirement();

    public boolean isInPath();

    @NotNull
    public ProcessCapture run(@NotNull CharSequence[] var1, @Nullable File var2, @NotNull Map<String, String> var3);

    @NotNull
    public ProcessCapture run(@Nullable File var1, CharSequence ... var2);

    @NotNull
    public String getVersion(@Nullable File var1);

    public void checkVersion(@Nullable File var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/ossreviewtoolkit/utils/common/CommandLineTool$Companion;", "", "()V", "ANY_VERSION", "Lorg/semver4j/RangesList;", "getANY_VERSION", "()Lorg/semver4j/RangesList;", "common-utils"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final RangesList ANY_VERSION;

        private Companion() {
        }

        @NotNull
        public final RangesList getANY_VERSION() {
            return ANY_VERSION;
        }

        static {
            $$INSTANCE = new Companion();
            RangesList rangesList = RangesListFactory.create((String)"*");
            Intrinsics.checkNotNullExpressionValue((Object)rangesList, (String)"create(...)");
            ANY_VERSION = rangesList;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nCommandLineTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandLineTool.kt\norg/ossreviewtoolkit/utils/common/CommandLineTool$DefaultImpls\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,115:1\n37#2,2:116\n37#2,2:118\n37#2,2:120\n38#3:122\n*S KotlinDebug\n*F\n+ 1 CommandLineTool.kt\norg/ossreviewtoolkit/utils/common/CommandLineTool$DefaultImpls\n*L\n72#1:116,2\n82#1:118,2\n88#1:120,2\n108#1:122\n*E\n"})
    public static final class DefaultImpls {
        public static /* synthetic */ String command$default(CommandLineTool commandLineTool, File file, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: command");
            }
            if ((n & 1) != 0) {
                file = null;
            }
            return commandLineTool.command(file);
        }

        @NotNull
        public static String getVersionArguments(@NotNull CommandLineTool $this) {
            return "--version";
        }

        @NotNull
        public static String transformVersion(@NotNull CommandLineTool $this, @NotNull String output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return output;
        }

        @NotNull
        public static RangesList getVersionRequirement(@NotNull CommandLineTool $this) {
            return Companion.getANY_VERSION();
        }

        public static boolean isInPath(@NotNull CommandLineTool $this) {
            return Os.INSTANCE.getPathFromEnvironment(DefaultImpls.command$default($this, null, 1, null)) != null;
        }

        @NotNull
        public static ProcessCapture run(@NotNull CommandLineTool $this, @NotNull CharSequence[] args, @Nullable File workingDir, @NotNull Map<String, String> environment) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            Collection $this$toTypedArray$iv = ExtensionsKt.splitOnWhitespace($this.command(workingDir));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
            spreadBuilder.addSpread((Object)args);
            return new ProcessCapture((CharSequence[])spreadBuilder.toArray((Object[])new CharSequence[spreadBuilder.size()]), workingDir, environment).requireSuccess();
        }

        public static /* synthetic */ ProcessCapture run$default(CommandLineTool commandLineTool, CharSequence[] charSequenceArray, File file, Map map, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: run");
            }
            if ((n & 2) != 0) {
                file = null;
            }
            if ((n & 4) != 0) {
                map = MapsKt.emptyMap();
            }
            return commandLineTool.run(charSequenceArray, file, map);
        }

        @NotNull
        public static ProcessCapture run(@NotNull CommandLineTool $this, @Nullable File workingDir, CharSequence ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            Collection $this$toTypedArray$iv = ExtensionsKt.splitOnWhitespace($this.command(workingDir));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
            spreadBuilder.addSpread((Object)args);
            return new ProcessCapture(workingDir, (CharSequence[])spreadBuilder.toArray((Object[])new CharSequence[spreadBuilder.size()])).requireSuccess();
        }

        @NotNull
        public static String getVersion(@NotNull CommandLineTool $this, @Nullable File workingDir) {
            String versionString2;
            String string;
            Object v1;
            block2: {
                Collection $this$toTypedArray$iv = ExtensionsKt.splitOnWhitespace($this.getVersionArguments());
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                ProcessCapture version = $this.run(workingDir, Arrays.copyOf(stringArray, stringArray.length));
                Object[] objectArray = new String[]{version.getStdout(), version.getStderr()};
                Sequence sequence = SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)((Function1)new Function1<String, String>($this){
                    final /* synthetic */ CommandLineTool this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.this$0.transformVersion(((Object)StringsKt.trim((CharSequence)it)).toString());
                    }
                }));
                for (Object e : sequence) {
                    String it = (String)e;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    v1 = e;
                    break block2;
                }
                v1 = null;
            }
            if ((string = (versionString2 = (String)v1)) == null) {
                string = "";
            }
            return string;
        }

        public static /* synthetic */ String getVersion$default(CommandLineTool commandLineTool, File file, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getVersion");
            }
            if ((n & 1) != 0) {
                file = null;
            }
            return commandLineTool.getVersion(file);
        }

        public static void checkVersion(@NotNull CommandLineTool $this, @Nullable File workingDir) {
            Semver actualVersion = Semver.coerce((String)$this.getVersion(workingDir));
            RangesList requiredVersion = $this.getVersionRequirement();
            Semver semver = actualVersion;
            if (!(semver != null ? semver.satisfies(requiredVersion) : false)) {
                CommandLineTool $this$logger$iv = $this;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(CommandLineTool.class).warn((Function0)new Function0<Object>(requiredVersion, actualVersion){
                    final /* synthetic */ RangesList $requiredVersion;
                    final /* synthetic */ Semver $actualVersion;
                    {
                        this.$requiredVersion = $requiredVersion;
                        this.$actualVersion = $actualVersion;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "The command is required in version " + this.$requiredVersion + ", but you are using version " + this.$actualVersion + ". This could lead to problems.";
                    }
                });
            }
        }

        public static /* synthetic */ void checkVersion$default(CommandLineTool commandLineTool, File file, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkVersion");
            }
            if ((n & 1) != 0) {
                file = null;
            }
            commandLineTool.checkVersion(file);
        }
    }
}

