/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.ArchiveType;
import org.ossreviewtoolkit.utils.common.ArchiveUtilsKt;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.Os;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001aR\u0010\u000b\u001a\u00020\b*\u00020\b2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u0011\u001a2\u0010\u0013\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0011\u001a<\u0010\u0013\u001a\u00020\u0006*\u00020\u00192\u0006\u0010\u0014\u001a\u00020\b2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u00112\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0\u0011H\u0002\u001a(\u0010\u0013\u001a\u00020\u0006*\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002\u001a(\u0010\u001c\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0011\u001a(\u0010\u001d\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0011\u001a(\u0010\u001e\u001a\u00020\u0006*\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\b2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0011\u001a(\u0010 \u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0011\u001a(\u0010!\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0011\u001a\u0012\u0010!\u001a\u00020\u0006*\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\b\u001a(\u0010!\u001a\u00020\u0006*\u00020\"2\u0006\u0010\u0014\u001a\u00020\b2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0011\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006#"}, d2={"DEB_NESTED_ARCHIVES", "", "", "getDEB_NESTED_ARCHIVES", "()Ljava/util/List;", "copyExecutableModeBit", "", "target", "Ljava/io/File;", "mode", "", "packZip", "targetFile", "prefix", "overwrite", "", "directoryFilter", "Lkotlin/Function1;", "fileFilter", "unpack", "targetDirectory", "forceArchiveType", "Lorg/ossreviewtoolkit/utils/common/ArchiveType;", "filter", "Lorg/apache/commons/compress/archivers/ArchiveEntry;", "Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "shouldSkip", "Lorg/apache/commons/compress/archivers/zip/ZipFile;", "unpack7Zip", "unpackDeb", "unpackTar", "Ljava/io/InputStream;", "unpackTryAllTypes", "unpackZip", "", "common-utils"})
@SourceDebugExtension(value={"SMAP\nArchiveUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchiveUtils.kt\norg/ossreviewtoolkit/utils/common/ArchiveUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,359:1\n1#2:360\n1#2:363\n1611#3:361\n1855#3:362\n1856#3:364\n1612#3:365\n1855#3,2:367\n1855#3,2:371\n38#4:366\n38#4:369\n38#4:370\n38#4:373\n1313#5,2:374\n*S KotlinDebug\n*F\n+ 1 ArchiveUtils.kt\norg/ossreviewtoolkit/utils/common/ArchiveUtilsKt\n*L\n109#1:363\n109#1:361\n109#1:362\n109#1:364\n109#1:365\n120#1:367,2\n232#1:371,2\n115#1:366\n143#1:369\n193#1:370\n286#1:373\n348#1:374,2\n*E\n"})
public final class ArchiveUtilsKt {
    @NotNull
    private static final List<String> DEB_NESTED_ARCHIVES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unpack(@NotNull File $this$unpack, @NotNull File targetDirectory, @NotNull ArchiveType forceArchiveType, @NotNull Function1<? super ArchiveEntry, Boolean> filter2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$unpack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)forceArchiveType), (String)"forceArchiveType");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        ArchiveType it = object = forceArchiveType;
        boolean bl = false;
        ArchiveType archiveType = !(it == ArchiveType.NONE) ? object : null;
        if (archiveType == null) {
            String string = $this$unpack.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            archiveType = ArchiveType.Companion.getType(string);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[archiveType.ordinal()]) {
            case 1: {
                ArchiveUtilsKt.unpack7Zip($this$unpack, targetDirectory, filter2);
                break;
            }
            case 2: {
                ArchiveUtilsKt.unpackZip($this$unpack, targetDirectory, filter2);
                break;
            }
            case 3: {
                object = new FileInputStream($this$unpack);
                Throwable throwable = null;
                try {
                    FileInputStream it2 = (FileInputStream)object;
                    boolean bl2 = false;
                    ArchiveUtilsKt.unpackTar(it2, targetDirectory, filter2);
                    it2 = Unit.INSTANCE;
                    break;
                }
                catch (Throwable it2) {
                    throwable = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            case 4: {
                object = new FileInputStream($this$unpack);
                Throwable throwable = null;
                try {
                    FileInputStream it3 = (FileInputStream)object;
                    boolean bl3 = false;
                    ArchiveUtilsKt.unpackTar((InputStream)new BZip2CompressorInputStream((InputStream)it3), targetDirectory, filter2);
                    it3 = Unit.INSTANCE;
                    break;
                }
                catch (Throwable it3) {
                    throwable = it3;
                    throw it3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            case 5: {
                object = new FileInputStream($this$unpack);
                Throwable throwable = null;
                try {
                    FileInputStream it4 = (FileInputStream)object;
                    boolean bl4 = false;
                    ArchiveUtilsKt.unpackTar((InputStream)new GzipCompressorInputStream((InputStream)it4), targetDirectory, filter2);
                    it4 = Unit.INSTANCE;
                    break;
                }
                catch (Throwable it4) {
                    throwable = it4;
                    throw it4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            case 6: {
                object = new FileInputStream($this$unpack);
                Throwable throwable = null;
                try {
                    FileInputStream it5 = (FileInputStream)object;
                    boolean bl5 = false;
                    ArchiveUtilsKt.unpackTar((InputStream)new XZCompressorInputStream((InputStream)it5), targetDirectory, filter2);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            case 7: {
                ArchiveUtilsKt.unpackDeb($this$unpack, targetDirectory, filter2);
                break;
            }
            case 8: {
                throw new IOException("Unable to guess compression scheme from file name '" + $this$unpack.getName() + "'.");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static /* synthetic */ void unpack$default(File file, File file2, ArchiveType archiveType, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            archiveType = ArchiveType.NONE;
        }
        if ((n & 4) != 0) {
            function1 = unpack.1.INSTANCE;
        }
        ArchiveUtilsKt.unpack(file, file2, archiveType, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public static final void unpackTryAllTypes(@NotNull File $this$unpackTryAllTypes, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter2) {
        Object v1;
        boolean $i$f$forEach;
        Object object;
        List suppressedExceptions;
        block8: {
            Object element$iv$iv;
            void $this$mapNotNullTo$iv;
            Intrinsics.checkNotNullParameter((Object)$this$unpackTryAllTypes, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
            Intrinsics.checkNotNullParameter(filter2, (String)"filter");
            String string = $this$unpackTryAllTypes.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ArchiveType typeFromName = ArchiveType.Companion.getType(string);
            suppressedExceptions = new ArrayList();
            object = (Iterable)ArchiveType.getEntries();
            ArchiveType[] archiveTypeArray = new ArchiveType[]{typeFromName};
            Iterable<ArchiveType> destination$iv = CollectionsKt.mutableListOf((Object[])archiveTypeArray);
            boolean $i$f$mapNotNullTo = false;
            void var8_10 = $this$mapNotNullTo$iv;
            $i$f$forEach = false;
            Iterator iterator = var8_10.iterator();
            while (iterator.hasNext()) {
                ArchiveType it$iv;
                ArchiveType archiveType;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                ArchiveType type = (ArchiveType)((Object)element$iv);
                boolean bl2 = false;
                ArchiveType it = archiveType = type;
                boolean bl3 = false;
                if ((!(type == typeFromName || type == ArchiveType.NONE) ? archiveType : null) == null) continue;
                it$iv = it$iv;
                boolean bl4 = false;
                destination$iv.add((ArchiveType)it$iv);
            }
            destination$iv = destination$iv;
            for (Object e : destination$iv) {
                Object it;
                Object $this$unpackTryAllTypes_u24lambda_u2410_u24lambda_u247;
                ArchiveType archiveType = (ArchiveType)((Object)e);
                boolean bl = false;
                element$iv$iv = $this$unpackTryAllTypes;
                try {
                    $this$unpackTryAllTypes_u24lambda_u2410_u24lambda_u247 = element$iv$iv;
                    boolean bl5 = false;
                    ArchiveUtilsKt.unpack($this$unpackTryAllTypes_u24lambda_u2410_u24lambda_u247, targetDirectory, archiveType, filter2);
                    $this$unpackTryAllTypes_u24lambda_u2410_u24lambda_u247 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl5) {
                    $this$unpackTryAllTypes_u24lambda_u2410_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
                }
                element$iv$iv = $this$unpackTryAllTypes_u24lambda_u2410_u24lambda_u247;
                if (Result.isSuccess-impl(element$iv$iv)) {
                    it = (Unit)element$iv$iv;
                    boolean bl6 = false;
                    File $this$logger$iv = $this$unpackTryAllTypes;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(File.class).debug((Function0)new Function0<Object>(archiveType, targetDirectory){
                        final /* synthetic */ ArchiveType $archiveType;
                        final /* synthetic */ File $targetDirectory;
                        {
                            this.$archiveType = $archiveType;
                            this.$targetDirectory = $targetDirectory;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Unpacked stream as " + this.$archiveType + " to '" + this.$targetDirectory + "'.";
                        }
                    });
                }
                if (Result.exceptionOrNull-impl(element$iv$iv) != null) {
                    Object it2 = it;
                    boolean bl7 = false;
                    ((Collection)suppressedExceptions).add(new IOException("Unpacking '" + $this$unpackTryAllTypes + "' as " + archiveType + " failed.", (Throwable)it2));
                }
                if (!Result.isSuccess-impl(element$iv$iv)) continue;
                v1 = e;
                break block8;
            }
            v1 = null;
        }
        if ((ArchiveType)v1 == null) {
            Object $this$unpackTryAllTypes_u24lambda_u2411 = object = new IOException("Unable to unpack '" + $this$unpackTryAllTypes + "'. This file is not a supported archive type.");
            boolean bl = false;
            Iterable iterable = suppressedExceptions;
            $i$f$forEach = false;
            for (Object element$iv : iterable) {
                Throwable p0 = (Throwable)element$iv;
                boolean bl8 = false;
                ExceptionsKt.addSuppressed((Throwable)((Throwable)$this$unpackTryAllTypes_u24lambda_u2411), (Throwable)p0);
            }
            throw (Throwable)object;
        }
    }

    public static /* synthetic */ void unpackTryAllTypes$default(File file, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = unpackTryAllTypes.1.INSTANCE;
        }
        ArchiveUtilsKt.unpackTryAllTypes(file, file2, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unpack7Zip(@NotNull File $this$unpack7Zip, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)$this$unpack7Zip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Closeable closeable = (Closeable)new SevenZFile($this$unpack7Zip);
        Throwable throwable = null;
        try {
            block12: {
                Throwable throwable2;
                Closeable closeable2;
                SevenZFile zipFile = (SevenZFile)closeable;
                boolean bl = false;
                File canonicalTargetDirectory = targetDirectory.getCanonicalFile();
                while (true) {
                    SevenZArchiveEntry sevenZArchiveEntry;
                    SevenZArchiveEntry sevenZArchiveEntry2 = sevenZArchiveEntry = zipFile.getNextEntry();
                    if (sevenZArchiveEntry2 == null) break block12;
                    Intrinsics.checkNotNull((Object)sevenZArchiveEntry2);
                    SevenZArchiveEntry entry = sevenZArchiveEntry;
                    if (entry.isDirectory() || entry.isAntiItem() || new File(entry.getName()).isAbsolute() || !((Boolean)filter2.invoke((Object)entry)).booleanValue()) continue;
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    File target = FilesKt.resolve((File)targetDirectory, (String)string);
                    File file = target.getCanonicalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
                    Intrinsics.checkNotNull((Object)canonicalTargetDirectory);
                    if (!FilesKt.startsWith((File)file, (File)canonicalTargetDirectory)) {
                        File $this$logger$iv = $this$unpack7Zip;
                        boolean $i$f$getLogger = false;
                        LoggingFactoryKt.cachedLoggerOf(File.class).warn((Function0)new Function0<Object>(entry, targetDirectory){
                            final /* synthetic */ SevenZArchiveEntry $entry;
                            final /* synthetic */ File $targetDirectory;
                            {
                                this.$entry = $entry;
                                this.$targetDirectory = $targetDirectory;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Skipping entry '" + this.$entry.getName() + "' which points to outside of '" + this.$targetDirectory + "'.";
                            }
                        });
                        continue;
                    }
                    File file2 = target.getParentFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
                    ExtensionsKt.safeMkdirs(file2);
                    closeable2 = new FileOutputStream(target);
                    throwable2 = null;
                    try {
                        FileOutputStream output = (FileOutputStream)closeable2;
                        boolean bl2 = false;
                        InputStream inputStream = zipFile.getInputStream(entry);
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                        long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)output, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void unpack7Zip$default(File file, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = unpack7Zip.1.INSTANCE;
        }
        ArchiveUtilsKt.unpack7Zip(file, file2, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    public static final void unpackZip(@NotNull byte[] $this$unpackZip, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)$this$unpackZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        ArchiveUtilsKt.unpack(new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel($this$unpackZip)), targetDirectory, filter2);
    }

    public static /* synthetic */ void unpackZip$default(byte[] byArray, File file, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = unpackZip.1.INSTANCE;
        }
        ArchiveUtilsKt.unpackZip(byArray, file, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    public static final void unpackZip(@NotNull File $this$unpackZip, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)$this$unpackZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        ArchiveUtilsKt.unpack(new ZipFile($this$unpackZip), targetDirectory, filter2);
    }

    public static /* synthetic */ void unpackZip$default(File file, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = unpackZip.2.INSTANCE;
        }
        ArchiveUtilsKt.unpackZip(file, file2, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void unpack(ZipFile $this$unpack, File targetDirectory, Function1<? super ArchiveEntry, Boolean> filter2) {
        Closeable closeable = (Closeable)$this$unpack;
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            File canonicalTargetDirectory = targetDirectory.getCanonicalFile();
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (entry.isDirectory() || entry.isUnixSymlink() || new File(entry.getName()).isAbsolute()) continue;
                Intrinsics.checkNotNull((Object)entry);
                if (!((Boolean)filter2.invoke((Object)entry)).booleanValue()) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                File target = FilesKt.resolve((File)targetDirectory, (String)string);
                File file = target.getCanonicalFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
                Intrinsics.checkNotNull((Object)canonicalTargetDirectory);
                if (!FilesKt.startsWith((File)file, (File)canonicalTargetDirectory)) {
                    ZipFile $this$logger$iv = $this$unpack;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(ZipFile.class).warn((Function0)new Function0<Object>(entry, targetDirectory){
                        final /* synthetic */ ZipArchiveEntry $entry;
                        final /* synthetic */ File $targetDirectory;
                        {
                            this.$entry = $entry;
                            this.$targetDirectory = $targetDirectory;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Skipping entry '" + this.$entry.getName() + "' which points to outside of '" + this.$targetDirectory + "'.";
                        }
                    });
                    continue;
                }
                File file2 = target.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
                ExtensionsKt.safeMkdirs(file2);
                Closeable closeable2 = new FileOutputStream(target);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    InputStream inputStream = zipFile.getInputStream(entry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                ArchiveUtilsKt.copyExecutableModeBit(target, entry.getUnixMode());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final List<String> getDEB_NESTED_ARCHIVES() {
        return DEB_NESTED_ARCHIVES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unpackDeb(@NotNull File $this$unpackDeb, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)$this$unpackDeb, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory("unpackDeb", Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(prefix, *attributes)");
        File tempDir = path.toFile();
        try {
            ArchiveInputStream archiveInputStream = (ArchiveInputStream)new ArArchiveInputStream((InputStream)new FileInputStream($this$unpackDeb));
            Intrinsics.checkNotNull((Object)tempDir);
            ArchiveUtilsKt.unpack(archiveInputStream, tempDir, (Function1<? super ArchiveEntry, Boolean>)((Function1)unpackDeb.2.INSTANCE), (Function1<? super ArchiveEntry, Integer>)((Function1)unpackDeb.3.INSTANCE));
            Iterable $this$forEach$iv = DEB_NESTED_ARCHIVES;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name = (String)element$iv;
                boolean bl = false;
                String subDirectoryName = StringsKt.substringBefore$default((String)name, (char)'.', null, (int)2, null);
                File subDirectory = ExtensionsKt.safeMkdirs(FilesKt.resolve((File)targetDirectory, (String)subDirectoryName));
                File file = FilesKt.resolve((File)tempDir, (String)name);
                ArchiveUtilsKt.unpack$default(file, subDirectory, null, filter2, 2, null);
            }
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNull((Object)tempDir);
            ExtensionsKt.safeDeleteRecursively$default(tempDir, true, null, 2, null);
            throw throwable;
        }
        ExtensionsKt.safeDeleteRecursively$default(tempDir, true, null, 2, null);
    }

    public static /* synthetic */ void unpackDeb$default(File file, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = unpackDeb.1.INSTANCE;
        }
        ArchiveUtilsKt.unpackDeb(file, file2, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    public static final void unpackZip(@NotNull InputStream $this$unpackZip, @NotNull File targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$unpackZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        ArchiveUtilsKt.unpack((ArchiveInputStream)new ZipArchiveInputStream($this$unpackZip), targetDirectory, (Function1<? super ArchiveEntry, Boolean>)((Function1)unpackZip.3.INSTANCE), (Function1<? super ArchiveEntry, Integer>)((Function1)unpackZip.4.INSTANCE));
    }

    public static final void unpackTar(@NotNull InputStream $this$unpackTar, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)$this$unpackTar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        ArchiveUtilsKt.unpack((ArchiveInputStream)new TarArchiveInputStream($this$unpackTar), targetDirectory, (Function1<? super ArchiveEntry, Boolean>)((Function1)new Function1<ArchiveEntry, Boolean>(filter2){
            final /* synthetic */ Function1<ArchiveEntry, Boolean> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ArchiveEntry entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                return !((TarArchiveEntry)entry).isFile() || new File(((TarArchiveEntry)entry).getName()).isAbsolute() || (Boolean)this.$filter.invoke((Object)entry) == false;
            }
        }), (Function1<? super ArchiveEntry, Integer>)((Function1)unpackTar.3.INSTANCE));
    }

    public static /* synthetic */ void unpackTar$default(InputStream inputStream, File file, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = unpackTar.1.INSTANCE;
        }
        ArchiveUtilsKt.unpackTar(inputStream, file, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void unpack(ArchiveInputStream $this$unpack, File targetDirectory, Function1<? super ArchiveEntry, Boolean> shouldSkip, Function1<? super ArchiveEntry, Integer> mode) {
        Closeable closeable = (Closeable)$this$unpack;
        Throwable throwable = null;
        try {
            ArchiveInputStream input = (ArchiveInputStream)closeable;
            boolean bl = false;
            File canonicalTargetDirectory = targetDirectory.getCanonicalFile();
            boolean processed = false;
            while (true) {
                ArchiveEntry archiveEntry;
                ArchiveEntry archiveEntry2 = archiveEntry = input.getNextEntry();
                if (archiveEntry2 == null) break;
                Intrinsics.checkNotNull((Object)archiveEntry2);
                ArchiveEntry entry = archiveEntry;
                processed = true;
                if (((Boolean)shouldSkip.invoke((Object)entry)).booleanValue()) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                File target = FilesKt.resolve((File)targetDirectory, (String)string);
                File file = target.getCanonicalFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
                Intrinsics.checkNotNull((Object)canonicalTargetDirectory);
                if (!FilesKt.startsWith((File)file, (File)canonicalTargetDirectory)) {
                    ArchiveInputStream $this$logger$iv = $this$unpack;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(ArchiveInputStream.class).warn((Function0)new Function0<Object>(entry, targetDirectory){
                        final /* synthetic */ ArchiveEntry $entry;
                        final /* synthetic */ File $targetDirectory;
                        {
                            this.$entry = $entry;
                            this.$targetDirectory = $targetDirectory;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Skipping entry '" + this.$entry.getName() + "' which points to outside of '" + this.$targetDirectory + "'.";
                        }
                    });
                    continue;
                }
                File file2 = target.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
                ExtensionsKt.safeMkdirs(file2);
                Closeable closeable2 = new FileOutputStream(target);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)((InputStream)input), (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                ArchiveUtilsKt.copyExecutableModeBit(target, ((Number)mode.invoke((Object)entry)).intValue());
            }
            if ($this$unpack instanceof TarArchiveInputStream && !processed) {
                throw new IOException("Unsupported archive type or empty archive.");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void copyExecutableModeBit(File target, int mode) {
        if (Os.INSTANCE.isWindows()) {
            return;
        }
        if ((mode & 0x41) != 0) {
            target.setExecutable(true, (mode & 1) == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final File packZip(@NotNull File $this$packZip, @NotNull File targetFile, @NotNull String prefix, boolean overwrite, @NotNull Function1<? super File, Boolean> directoryFilter, @NotNull Function1<? super File, Boolean> fileFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$packZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(directoryFilter, (String)"directoryFilter");
        Intrinsics.checkNotNullParameter(fileFilter, (String)"fileFilter");
        if (!(overwrite || !targetFile.exists())) {
            boolean bl = false;
            String string = "The target ZIP file '" + targetFile.getAbsolutePath() + "' must not exist.";
            throw new IllegalArgumentException(string.toString());
        }
        Closeable closeable = (Closeable)new ZipArchiveOutputStream(targetFile);
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            ZipArchiveOutputStream output = (ZipArchiveOutputStream)closeable;
            boolean bl = false;
            output.setLevel(9);
            Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)$this$packZip).onEnter((Function1)new Function1<File, Boolean>(directoryFilter){
                final /* synthetic */ Function1<File, Boolean> $directoryFilter;
                {
                    this.$directoryFilter = $directoryFilter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                    return Files.isDirectory(it.toPath(), linkOptionArray) && (Boolean)this.$directoryFilter.invoke((Object)it) != false;
                }
            })), (Function1)((Function1)new Function1<File, Boolean>(fileFilter, targetFile){
                final /* synthetic */ Function1<File, Boolean> $fileFilter;
                final /* synthetic */ File $targetFile;
                {
                    this.$fileFilter = $fileFilter;
                    this.$targetFile = $targetFile;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                    return Files.isRegularFile(it.toPath(), linkOptionArray) && (Boolean)this.$fileFilter.invoke((Object)it) != false && !Intrinsics.areEqual((Object)it, (Object)this.$targetFile);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void it;
                Serializable serializable;
                File file = (File)element$iv;
                boolean bl2 = false;
                File file2 = serializable = $this$packZip;
                File file3 = file;
                String string = prefix;
                boolean bl3 = false;
                boolean bl4 = it.isFile();
                File file4 = !bl4 ? serializable : null;
                if (file4 == null) {
                    file4 = $this$packZip.getParentFile();
                }
                File file5 = file4;
                Intrinsics.checkNotNull((Object)file5);
                String packPath = string + FilesKt.toRelativeString((File)file3, (File)file5);
                ZipArchiveEntry entry = new ZipArchiveEntry(file, packPath);
                output.putArchiveEntry((ArchiveEntry)entry);
                Closeable closeable2 = new FileInputStream(file);
                serializable = null;
                try {
                    FileInputStream input = (FileInputStream)closeable2;
                    boolean bl5 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)((OutputStream)output), (int)0, (int)2, null);
                }
                catch (Throwable throwable2) {
                    serializable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)serializable);
                }
                output.closeArchiveEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return targetFile;
    }

    public static /* synthetic */ File packZip$default(File file, File file2, String string, boolean bl, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            function1 = packZip.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function12 = packZip.2.INSTANCE;
        }
        return ArchiveUtilsKt.packZip(file, file2, string, bl, (Function1<? super File, Boolean>)function1, (Function1<? super File, Boolean>)function12);
    }

    static {
        Object[] objectArray = new String[]{"data.tar.xz", "control.tar.xz"};
        DEB_NESTED_ARCHIVES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArchiveType.values().length];
            try {
                nArray[ArchiveType.SEVENZIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.ZIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.TAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.TAR_BZIP2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.TAR_GZIP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.TAR_XZ.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.DEB.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.NONE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

