/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/ossreviewtoolkit/utils/common/DirectoryStash;", "Ljava/io/Closeable;", "directories", "", "Ljava/io/File;", "(Ljava/util/Set;)V", "stashedDirectories", "", "close", "", "common-utils"})
@SourceDebugExtension(value={"SMAP\nDirectoryStash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryStash.kt\norg/ossreviewtoolkit/utils/common/DirectoryStash\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,88:1\n1271#2,2:89\n1285#2,2:91\n1288#2:94\n1855#2:95\n1856#2:97\n38#3:93\n38#3:96\n*S KotlinDebug\n*F\n+ 1 DirectoryStash.kt\norg/ossreviewtoolkit/utils/common/DirectoryStash\n*L\n45#1:89,2\n45#1:91,2\n45#1:94\n70#1:95\n70#1:97\n56#1:93\n74#1:96\n*E\n"})
final class DirectoryStash
implements Closeable {
    @NotNull
    private final Map<File, File> stashedDirectories;

    /*
     * WARNING - void declaration
     */
    public DirectoryStash(@NotNull Set<? extends File> directories) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter(directories, (String)"directories");
        Iterable iterable = directories;
        DirectoryStash directoryStash = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            File file;
            void originalDir;
            File file2 = (File)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            if (originalDir.isDirectory()) {
                Path path;
                Path path2;
                File tempDir = PathsKt.createTempDirectory((Path)originalDir.getParentFile().toPath(), (String)".stash", (FileAttribute[])new FileAttribute[0]).toFile();
                Intrinsics.checkNotNull((Object)tempDir);
                String string = originalDir.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                File stashDir = FilesKt.resolve((File)tempDir, (String)string);
                DirectoryStash $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(DirectoryStash.class).info((Function0)new Function0<Object>((File)originalDir, stashDir){
                    final /* synthetic */ File $originalDir;
                    final /* synthetic */ File $stashDir;
                    {
                        this.$originalDir = $originalDir;
                        this.$stashDir = $stashDir;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Temporarily moving directory from '" + this.$originalDir.getAbsolutePath() + "' to '" + this.$stashDir.getAbsolutePath() + "'.";
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)originalDir.toPath(), (String)"toPath(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stashDir.toPath(), (String)"toPath(...)");
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
                Intrinsics.checkNotNullExpressionValue((Object)Files.move(path2, path, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(this, target, *options)");
                file = stashDir;
            } else {
                file = null;
            }
            File file3 = file;
            map.put(t, file3);
        }
        directoryStash.stashedDirectories = result$iv;
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)this.stashedDirectories.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path;
            Path path2;
            File stashDir;
            File originalDir = (File)element$iv;
            boolean bl = false;
            ExtensionsKt.safeDeleteRecursively$default(originalDir, false, null, 3, null);
            if (this.stashedDirectories.get(originalDir) == null) continue;
            boolean bl2 = false;
            DirectoryStash $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(DirectoryStash.class).info((Function0)new Function0<Object>(stashDir, originalDir){
                final /* synthetic */ File $stashDir;
                final /* synthetic */ File $originalDir;
                {
                    this.$stashDir = $stashDir;
                    this.$originalDir = $originalDir;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Moving back directory from '" + this.$stashDir.getAbsolutePath() + "' to '" + this.$originalDir.getAbsolutePath() + "'.";
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)stashDir.toPath(), (String)"toPath(...)");
            Intrinsics.checkNotNullExpressionValue((Object)originalDir.toPath(), (String)"toPath(...)");
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path2, path, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(this, target, *options)");
            if (stashDir.getParentFile().delete()) continue;
            throw new IOException("Unable to delete the '" + stashDir.getParent() + "' directory.");
        }
    }
}

