/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import com.jakewharton.disklrucache.DiskLruCache;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\f\u0010\u0012\u001a\u00020\r*\u00020\rH\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/ossreviewtoolkit/utils/common/DiskCache;", "", "directory", "Ljava/io/File;", "maxCacheSizeInBytes", "", "maxCacheEntryAgeInSeconds", "(Ljava/io/File;JJ)V", "diskLruCache", "Lcom/jakewharton/disklrucache/DiskLruCache;", "kotlin.jvm.PlatformType", "currentTimeInSeconds", "read", "", "key", "write", "", "data", "asKey", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskCache.kt\norg/ossreviewtoolkit/utils/common/DiskCache\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,148:1\n38#2:149\n38#2:150\n*S KotlinDebug\n*F\n+ 1 DiskCache.kt\norg/ossreviewtoolkit/utils/common/DiskCache\n*L\n125#1:149\n141#1:150\n*E\n"})
public final class DiskCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long maxCacheEntryAgeInSeconds;
    private final DiskLruCache diskLruCache;
    public static final int INDEX_FULL_KEY = 0;
    public static final int INDEX_TIMESTAMP = 1;
    public static final int INDEX_DATA = 2;
    public static final int VALUE_COUNT = 3;
    public static final int MAX_KEY_LENGTH = 64;
    public static final int KEY_SUFFIX_LENGTH = 6;
    private static final int KEY_INDEX_LIMIT = (int)Math.pow(10.0, 5);
    @NotNull
    private static final Regex ILLEGAL_KEY_CHARS = new Regex("[^a-z0-9_-]");

    public DiskCache(@NotNull File directory, long maxCacheSizeInBytes, long maxCacheEntryAgeInSeconds) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.maxCacheEntryAgeInSeconds = maxCacheEntryAgeInSeconds;
        this.diskLruCache = DiskLruCache.open((File)directory, (int)0, (int)3, (long)maxCacheSizeInBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String asKey(String $this$asKey) {
        String string = $this$asKey.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        CharSequence charSequence = StringsKt.replace$default((String)string, (char)'.', (char)'-', (boolean)false, (int)4, null);
        Regex regex = ILLEGAL_KEY_CHARS;
        String string2 = "_";
        String mappedKey = regex.replace(charSequence, string2);
        if (mappedKey.length() <= 58) {
            return mappedKey;
        }
        String shortenedKey = (String)SequencesKt.first((Sequence)StringsKt.chunkedSequence((CharSequence)mappedKey, (int)58));
        int n = KEY_INDEX_LIMIT;
        for (int index = 0; index < n; ++index) {
            String tryKey = shortenedKey + "-" + StringsKt.padStart((String)String.valueOf(index), (int)5, (char)'0');
            Closeable closeable = (Closeable)this.diskLruCache.get(tryKey);
            Throwable throwable = null;
            try {
                DiskLruCache.Snapshot entry = (DiskLruCache.Snapshot)closeable;
                boolean bl = false;
                if (entry == null || Intrinsics.areEqual((Object)entry.getString(0), (Object)$this$asKey)) {
                    String string3 = tryKey;
                    return string3;
                }
                Unit unit = Unit.INSTANCE;
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        throw new IOException("Cannot generate key for '" + $this$asKey + "' because all possible keys starting with '" + shortenedKey + "' are taken.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String read(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String diskKey = this.asKey(key);
        try {
            DiskLruCache.Snapshot snapshot = this.diskLruCache.get(diskKey);
            if (snapshot != null) {
                Closeable closeable = (Closeable)snapshot;
                Throwable throwable = null;
                try {
                    DiskLruCache.Snapshot entry = (DiskLruCache.Snapshot)closeable;
                    boolean bl = false;
                    String string = entry.getString(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                    long time = Long.parseLong(string);
                    if (time + this.maxCacheEntryAgeInSeconds >= this.currentTimeInSeconds()) {
                        String string2 = entry.getString(2);
                        return string2;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            this.diskLruCache.remove(diskKey);
        }
        catch (IOException e) {
            DiskCache $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(DiskCache.class).error((Function0)new Function0<Object>(diskKey, e){
                final /* synthetic */ String $diskKey;
                final /* synthetic */ IOException $e;
                {
                    this.$diskKey = $diskKey;
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Could not read cache entry for key '" + this.$diskKey + "': " + ExtensionsKt.collectMessages(this.$e);
                }
            });
        }
        return null;
    }

    public final boolean write(@NotNull String key, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String diskKey = this.asKey(key);
        try {
            DiskLruCache.Editor editor;
            DiskLruCache.Editor $this$write_u24lambda_u242 = editor = this.diskLruCache.edit(diskKey);
            boolean bl = false;
            $this$write_u24lambda_u242.set(0, key);
            $this$write_u24lambda_u242.set(1, String.valueOf(this.currentTimeInSeconds()));
            $this$write_u24lambda_u242.set(2, data);
            $this$write_u24lambda_u242.commit();
            return true;
        }
        catch (IOException e) {
            DiskCache $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(DiskCache.class).error((Function0)new Function0<Object>(diskKey, e){
                final /* synthetic */ String $diskKey;
                final /* synthetic */ IOException $e;
                {
                    this.$diskKey = $diskKey;
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Could not write to disk cache for key '" + this.$diskKey + "': " + ExtensionsKt.collectMessages(this.$e);
                }
            });
            return false;
        }
    }

    private final long currentTimeInSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/ossreviewtoolkit/utils/common/DiskCache$Companion;", "", "()V", "ILLEGAL_KEY_CHARS", "Lkotlin/text/Regex;", "INDEX_DATA", "", "INDEX_FULL_KEY", "INDEX_TIMESTAMP", "KEY_INDEX_LIMIT", "getKEY_INDEX_LIMIT", "()I", "KEY_SUFFIX_LENGTH", "MAX_KEY_LENGTH", "VALUE_COUNT", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        public final int getKEY_INDEX_LIMIT() {
            return KEY_INDEX_LIMIT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

