/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import java.io.File;
import java.util.Locale;
import java.util.SortedMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.Os;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0019\u001a\u00020\u0005J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u0005J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u0015R7\u0010\u0003\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\n\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lorg/ossreviewtoolkit/utils/common/Os;", "", "()V", "env", "Ljava/util/SortedMap;", "", "kotlin.jvm.PlatformType", "getEnv", "()Ljava/util/SortedMap;", "env$delegate", "Lkotlin/Lazy;", "isLinux", "", "()Z", "isMac", "isWindows", "name", "getName", "()Ljava/lang/String;", "nameLowerCase", "userHomeDirectory", "Ljava/io/File;", "getUserHomeDirectory", "()Ljava/io/File;", "userHomeDirectory$delegate", "fixupUserHomeProperty", "getPathFromEnvironment", "executable", "resolveWindowsExecutable", "common-utils"})
@SourceDebugExtension(value={"SMAP\nOs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Os.kt\norg/ossreviewtoolkit/utils/common/Os\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class Os {
    @NotNull
    public static final Os INSTANCE = new Os();
    @NotNull
    private static final String name;
    @NotNull
    private static final String nameLowerCase;
    private static final boolean isLinux;
    private static final boolean isMac;
    private static final boolean isWindows;
    @NotNull
    private static final Lazy env$delegate;
    @NotNull
    private static final Lazy userHomeDirectory$delegate;

    private Os() {
    }

    @NotNull
    public final String getName() {
        return name;
    }

    public final boolean isLinux() {
        return isLinux;
    }

    public final boolean isMac() {
        return isMac;
    }

    public final boolean isWindows() {
        return isWindows;
    }

    @NotNull
    public final SortedMap<String, String> getEnv() {
        Lazy lazy = env$delegate;
        return (SortedMap)lazy.getValue();
    }

    @NotNull
    public final File getUserHomeDirectory() {
        Lazy lazy = userHomeDirectory$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final String fixupUserHomeProperty() {
        Object v1;
        block3: {
            String userHome = System.getProperty("user.home");
            CharSequence charSequence = userHome;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !Intrinsics.areEqual((Object)userHome, (Object)"?")) {
                Intrinsics.checkNotNull((Object)userHome);
                return userHome;
            }
            Object[] objectArray = new String[]{this.getEnv().get("HOME"), this.getEnv().get("USERPROFILE")};
            Iterable iterable = CollectionsKt.listOfNotNull((Object[])objectArray);
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        String string = v1;
        if (string == null) {
            throw new IllegalArgumentException("Unable to determine a user home directory.");
        }
        String fallbackUserHome = string;
        System.setProperty("user.home", fallbackUserHome);
        return fallbackUserHome;
    }

    @Nullable
    public final File getPathFromEnvironment(@NotNull String executable) {
        File file;
        block7: {
            Sequence paths;
            Sequence sequence;
            Sequence sequence2;
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            String string = (String)this.getEnv().get("PATH");
            if (string != null) {
                char[] cArray = new char[]{File.pathSeparatorChar};
                sequence2 = StringsKt.splitToSequence$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            } else {
                sequence2 = sequence = null;
            }
            if (sequence2 == null) {
                sequence = paths = SequencesKt.emptySequence();
            }
            if (isWindows) {
                Regex referencePattern = new Regex("%(\\w+)%");
                for (String path : paths) {
                    boolean bl = false;
                    String expandedPath = Os.getPathFromEnvironment$expandVariable(path, referencePattern);
                    File file2 = INSTANCE.resolveWindowsExecutable(new File(expandedPath, executable));
                    if (file2 == null) continue;
                    file = file2;
                    break block7;
                }
                file = null;
            } else {
                Object v4;
                block8: {
                    Regex referencePattern = new Regex("\\$\\{?(\\w+)}?");
                    Sequence sequence3 = SequencesKt.map((Sequence)paths, (Function1)((Function1)new Function1<String, File>(referencePattern, executable){
                        final /* synthetic */ Regex $referencePattern;
                        final /* synthetic */ String $executable;
                        {
                            this.$referencePattern = $referencePattern;
                            this.$executable = $executable;
                            super(1);
                        }

                        @NotNull
                        public final File invoke(@NotNull String path) {
                            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                            String expandedPath = Os.access$getPathFromEnvironment$expandVariable(path, this.$referencePattern);
                            return new File(expandedPath, this.$executable);
                        }
                    }));
                    for (Object e : sequence3) {
                        File it = (File)e;
                        boolean bl = false;
                        if (!it.isFile()) continue;
                        v4 = e;
                        break block8;
                    }
                    v4 = null;
                }
                file = v4;
            }
        }
        return file;
    }

    @Nullable
    public final File resolveWindowsExecutable(@NotNull File executable) {
        Object object;
        Object v3;
        Object object2;
        block5: {
            Sequence sequence;
            Sequence sequence2;
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            String string = (String)this.getEnv().get("PATHEXT");
            if (string != null) {
                object2 = new char[]{File.pathSeparatorChar};
                sequence2 = StringsKt.splitToSequence$default((CharSequence)string, (char[])object2, (boolean)false, (int)0, (int)6, null);
            } else {
                sequence2 = sequence = null;
            }
            if (sequence2 == null) {
                sequence = SequencesKt.emptySequence();
            }
            Sequence extensions = sequence;
            Sequence sequence3 = SequencesKt.map((Sequence)extensions, (Function1)((Function1)new Function1<String, File>(executable){
                final /* synthetic */ File $executable;
                {
                    this.$executable = $executable;
                    super(1);
                }

                @NotNull
                public final File invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = this.$executable.getPath();
                    String string2 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    return new File(string + string2);
                }
            }));
            for (Object e : sequence3) {
                File it = (File)e;
                boolean bl = false;
                if (!it.isFile()) continue;
                v3 = e;
                break block5;
            }
            v3 = null;
        }
        if ((object = (File)v3) == null) {
            char[] it = object2 = (Object)executable;
            boolean bl = false;
            object = it.isFile() ? object2 : null;
        }
        return object;
    }

    private static final String getPathFromEnvironment$expandVariable(String $this$getPathFromEnvironment_u24expandVariable, Regex referencePattern) {
        CharSequence charSequence = $this$getPathFromEnvironment_u24expandVariable;
        Function1 function1 = getPathFromEnvironment.expandVariable.1.INSTANCE;
        return referencePattern.replace(charSequence, function1);
    }

    public static final /* synthetic */ String access$getPathFromEnvironment$expandVariable(String $receiver, Regex referencePattern) {
        return Os.getPathFromEnvironment$expandVariable($receiver, referencePattern);
    }

    static {
        String string = System.getProperty("os.name");
        if (string == null) {
            string = "";
        }
        name = string;
        String string2 = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        nameLowerCase = string2;
        isLinux = StringsKt.contains$default((CharSequence)nameLowerCase, (CharSequence)"linux", (boolean)false, (int)2, null);
        isMac = StringsKt.contains$default((CharSequence)nameLowerCase, (CharSequence)"mac", (boolean)false, (int)2, null);
        isWindows = StringsKt.contains$default((CharSequence)nameLowerCase, (CharSequence)"windows", (boolean)false, (int)2, null);
        env$delegate = LazyKt.lazy((Function0)env.2.INSTANCE);
        userHomeDirectory$delegate = LazyKt.lazy((Function0)userHomeDirectory.2.INSTANCE);
    }
}

