/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.EnvironmentVariableFilter;
import org.ossreviewtoolkit.utils.common.MaskedStringKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 *2\u00020\u0001:\u0001*B%\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B;\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010)\u001a\u00020\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR\u0016\u0010\u001d\u001a\n \u000e*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0011R\u000e\u0010!\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0011R\u000e\u0010$\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n \u000e*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lorg/ossreviewtoolkit/utils/common/ProcessCapture;", "", "workingDir", "Ljava/io/File;", "command", "", "", "(Ljava/io/File;[Ljava/lang/CharSequence;)V", "environment", "", "", "([Ljava/lang/CharSequence;Ljava/io/File;Ljava/util/Map;)V", "builder", "Ljava/lang/ProcessBuilder;", "kotlin.jvm.PlatformType", "commandLine", "getCommandLine", "()Ljava/lang/String;", "commandName", "errorMessage", "getErrorMessage", "exitValue", "", "getExitValue", "()I", "isError", "", "()Z", "isSuccess", "process", "Ljava/lang/Process;", "stderr", "getStderr", "stderrFile", "stdout", "getStdout", "stdoutFile", "tempDir", "usedWorkingDir", "getUsedWorkingDir", "()Ljava/lang/Object;", "requireSuccess", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nProcessCapture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessCapture.kt\norg/ossreviewtoolkit/utils/common/ProcessCapture\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n38#3:158\n38#3:159\n38#3:161\n38#3:164\n1855#4:160\n1856#4:162\n1855#4:163\n1856#4:165\n*S KotlinDebug\n*F\n+ 1 ProcessCapture.kt\norg/ossreviewtoolkit/utils/common/ProcessCapture\n*L\n132#1:158\n138#1:159\n142#1:161\n146#1:164\n142#1:160\n142#1:162\n146#1:163\n146#1:165\n*E\n"})
public final class ProcessCapture {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final File tempDir;
    @NotNull
    private final String commandName;
    @NotNull
    private final File stdoutFile;
    @NotNull
    private final File stderrFile;
    private final ProcessBuilder builder;
    @NotNull
    private final String commandLine;
    @NotNull
    private final Object usedWorkingDir;
    private final Process process;
    private static final int MAX_OUTPUT_LINES = 20;
    @NotNull
    private static final String MAX_OUTPUT_FOOTER = "(Above output is limited to each 20 heading and tailing lines.)";

    /*
     * WARNING - void declaration
     */
    public ProcessCapture(@NotNull CharSequence[] command, @Nullable File workingDir, @NotNull Map<String, String> environment) {
        void $this$builder_u24lambda_u243;
        Object $this$stderrFile_u24lambda_u242;
        String[] $this$stdoutFile_u24lambda_u241;
        String[] $this$tempDir_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory(this.getClass().getSimpleName(), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(prefix, *attributes)");
        String[] stringArray = object = path.toFile();
        ProcessCapture processCapture = this;
        boolean bl = false;
        $this$tempDir_u24lambda_u240.deleteOnExit();
        processCapture.tempDir = object;
        this.commandName = StringsKt.substringAfterLast$default((String)ArraysKt.first((Object[])command).toString(), (char)File.separatorChar, null, (int)2, null);
        File file = this.tempDir;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tempDir");
        $this$tempDir_u24lambda_u240 = object = FilesKt.resolve((File)file, (String)(this.commandName + ".stdout"));
        processCapture = this;
        boolean bl2 = false;
        $this$stdoutFile_u24lambda_u241.deleteOnExit();
        processCapture.stdoutFile = object;
        File file2 = this.tempDir;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tempDir");
        $this$stdoutFile_u24lambda_u241 = object = FilesKt.resolve((File)file2, (String)(this.commandName + ".stderr"));
        processCapture = this;
        boolean bl3 = false;
        $this$stderrFile_u24lambda_u242.deleteOnExit();
        processCapture.stderrFile = object;
        object = MaskedStringKt.unmaskedStrings(Arrays.copyOf(command, command.length));
        $this$stderrFile_u24lambda_u242 = object = new ProcessBuilder(Arrays.copyOf(object, ((String[])object).length)).directory(workingDir).redirectOutput(this.stdoutFile).redirectError(this.stderrFile);
        processCapture = this;
        boolean bl4 = false;
        Map<String, String> map = $this$builder_u24lambda_u243.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
        EnvironmentVariableFilter.INSTANCE.filter(map).putAll(environment);
        processCapture.builder = object;
        this.commandLine = ArraysKt.joinToString$default((Object[])command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        Object object2 = this.builder.directory();
        if (object2 == null) {
            String string = System.getProperty("user.dir");
            object2 = string;
            Intrinsics.checkNotNull((Object)string);
        }
        this.usedWorkingDir = object2;
        this.process = this.builder.start();
        ProcessCapture $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(ProcessCapture.class).info((Function0)new Function0<Object>(){

            @Nullable
            public final Object invoke() {
                return "Running '" + this.getCommandLine() + "' in '" + this.getUsedWorkingDir() + "'...";
            }
        });
        this.process.waitFor();
        $this$logger$iv = this;
        $i$f$getLogger = false;
        if (LoggingFactoryKt.cachedLoggerOf(ProcessCapture.class).getDelegate().isDebugEnabled()) {
            boolean $i$f$getLogger2;
            ProcessCapture $this$logger$iv2;
            String it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            if (this.stdoutFile.length() > 0L) {
                $this$forEach$iv = StringsKt.lines((CharSequence)ProcessCapture.Companion.limitOutputLines(this.getStdout()));
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl5 = false;
                    $this$logger$iv2 = this;
                    $i$f$getLogger2 = false;
                    LoggingFactoryKt.cachedLoggerOf(ProcessCapture.class).debug((CharSequence)it);
                }
            }
            if (this.stderrFile.length() > 0L) {
                $this$forEach$iv = StringsKt.lines((CharSequence)ProcessCapture.Companion.limitOutputLines(this.getStderr()));
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl6 = false;
                    $this$logger$iv2 = this;
                    $i$f$getLogger2 = false;
                    LoggingFactoryKt.cachedLoggerOf(ProcessCapture.class).debug((CharSequence)it);
                }
            }
        }
    }

    public /* synthetic */ ProcessCapture(CharSequence[] charSequenceArray, File file, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            file = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(charSequenceArray, file, map);
    }

    public ProcessCapture(@Nullable File workingDir, CharSequence ... command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this(Arrays.copyOf(command, command.length), workingDir, null, 4, null);
    }

    @NotNull
    public final String getStdout() {
        return FilesKt.readText$default((File)this.stdoutFile, null, (int)1, null);
    }

    @NotNull
    public final String getStderr() {
        return FilesKt.readText$default((File)this.stderrFile, null, (int)1, null);
    }

    @NotNull
    public final String getCommandLine() {
        return this.commandLine;
    }

    @NotNull
    public final Object getUsedWorkingDir() {
        return this.usedWorkingDir;
    }

    public final int getExitValue() {
        return this.process.exitValue();
    }

    public final boolean isError() {
        return this.getExitValue() != 0;
    }

    public final boolean isSuccess() {
        return this.getExitValue() == 0;
    }

    @NotNull
    public final String getErrorMessage() {
        String string;
        String it = string = this.getStderr();
        boolean bl = false;
        boolean notContainsErrorButStdoutDoes = !StringsKt.contains((CharSequence)it, (CharSequence)"error", (boolean)true) && StringsKt.contains((CharSequence)this.getStdout(), (CharSequence)"error", (boolean)true);
        String string2 = !(StringsKt.isBlank((CharSequence)it) || notContainsErrorButStdoutDoes) ? string : null;
        if (string2 == null) {
            string2 = this.getStdout();
        }
        String message = string2;
        return "Running '" + this.commandLine + "' in '" + this.usedWorkingDir + "' failed with exit code " + this.getExitValue() + ":\n" + ProcessCapture.Companion.limitOutputLines(message);
    }

    @NotNull
    public final ProcessCapture requireSuccess() {
        ProcessCapture processCapture;
        ProcessCapture it = processCapture = this;
        boolean bl = false;
        if (this.isError()) {
            throw new IOException(this.getErrorMessage());
        }
        return processCapture;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/ossreviewtoolkit/utils/common/ProcessCapture$Companion;", "", "()V", "MAX_OUTPUT_FOOTER", "", "MAX_OUTPUT_LINES", "", "limitOutputLines", "message", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final String limitOutputLines(String message) {
            String string;
            List lines = StringsKt.lines((CharSequence)message);
            int lineCount = lines.size();
            if (lineCount > 40) {
                List prefix = CollectionsKt.take((Iterable)lines, (int)20);
                List suffix = CollectionsKt.takeLast((List)lines, (int)20);
                int skippedLineCount = lineCount - 40;
                string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)prefix, (Object)("[...skipping " + skippedLineCount + " lines...]")), (Iterable)suffix), (Object)ProcessCapture.MAX_OUTPUT_FOOTER), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            } else {
                string = message;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

