/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"calculateHash", "", "file", "Ljava/io/File;", "digest", "Ljava/security/MessageDigest;", "inputStream", "Ljava/io/InputStream;", "common-utils"})
@SourceDebugExtension(value={"SMAP\nHashUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashUtils.kt\norg/ossreviewtoolkit/utils/common/HashUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 NumberUtils.kt\norg/ossreviewtoolkit/utils/common/NumberUtilsKt\n*L\n1#1,48:1\n1#2:49\n30#3:50\n25#3:51\n*S KotlinDebug\n*F\n+ 1 HashUtils.kt\norg/ossreviewtoolkit/utils/common/HashUtilsKt\n*L\n39#1:50\n39#1:51\n*E\n"})
public final class HashUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] calculateHash(@NotNull File file, @NotNull MessageDigest digest) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            byArray = HashUtilsKt.calculateHash(it, digest);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    public static /* synthetic */ byte[] calculateHash$default(File file, MessageDigest messageDigest, int n, Object object) {
        if ((n & 2) != 0) {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        return HashUtilsKt.calculateHash(file, messageDigest);
    }

    @NotNull
    public static final byte[] calculateHash(@NotNull InputStream inputStream, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        int $this$mebibytes$iv = 4;
        boolean $i$f$getMebibytes = false;
        int $this$kibibytes$iv$iv = $this$mebibytes$iv;
        boolean $i$f$getKibibytes = false;
        byte[] buffer = new byte[(int)((long)$this$kibibytes$iv$iv * 1024L * 1024L)];
        int length = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(buffer);
            boolean bl = false;
            length = it;
            if (n <= 0) break;
            digest.update(buffer, 0, length);
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] calculateHash$default(InputStream inputStream, MessageDigest messageDigest, int n, Object object) {
        if ((n & 2) != 0) {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        return HashUtilsKt.calculateHash(inputStream, messageDigest);
    }
}

