/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.utils.common.ArchiveType;
import org.ossreviewtoolkit.utils.common.FileUtilsKt;
import org.ossreviewtoolkit.utils.common.Os;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u001a2\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u001a(\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u001a(\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u001a(\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u001a(\u0010\u0000\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002\u001a(\u0010\u0013\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0002\u001a(\u0010\u0015\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00022\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u001aL\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0016*\u00020\b*\b\u0012\u0004\u0012\u0002H\u00160\u00172\u0006\u0010\u0003\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u0007H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001aR\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00022\b\b\u0002\u0010\u001f\u001a\u00020\u00102\b\b\u0002\u0010 \u001a\u00020\t2\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\u00072\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\u0007\"\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"unpack", "", "Ljava/io/File;", "targetDirectory", "forceArchiveType", "Lorg/ossreviewtoolkit/utils/common/ArchiveType;", "filter", "Lkotlin/Function1;", "Lorg/apache/commons/compress/archivers/ArchiveEntry;", "", "unpackTryAllTypes", "unpack7Zip", "unpackZip", "Lorg/apache/commons/compress/archivers/zip/ZipFile;", "DEB_NESTED_ARCHIVES", "", "", "getDEB_NESTED_ARCHIVES", "()Ljava/util/List;", "unpackDeb", "Ljava/io/InputStream;", "unpackTar", "E", "Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "shouldSkip", "mode", "", "copyExecutableModeBit", "target", "packZip", "targetFile", "prefix", "overwrite", "directoryFilter", "fileFilter", "common-utils"})
@SourceDebugExtension(value={"SMAP\nArchiveUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchiveUtils.kt\norg/ossreviewtoolkit/utils/common/ArchiveUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,353:1\n1#2:354\n1#2:357\n1625#3:355\n1869#3:356\n1870#3:358\n1626#3:359\n1869#3,2:361\n1869#3,2:365\n38#4:360\n38#4:363\n38#4:364\n38#4:367\n1321#5,2:368\n*S KotlinDebug\n*F\n+ 1 ArchiveUtils.kt\norg/ossreviewtoolkit/utils/common/ArchiveUtilsKt\n*L\n108#1:357\n108#1:355\n108#1:356\n108#1:358\n108#1:359\n119#1:361,2\n225#1:365,2\n114#1:360\n142#1:363\n186#1:364\n279#1:367\n341#1:368,2\n*E\n"})
public final class ArchiveUtilsKt {
    @NotNull
    private static final List<String> DEB_NESTED_ARCHIVES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unpack(@NotNull File $this$unpack, @NotNull File targetDirectory, @NotNull ArchiveType forceArchiveType, @NotNull Function1<? super ArchiveEntry, Boolean> filter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$unpack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)forceArchiveType), (String)"forceArchiveType");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        ArchiveType it = object = forceArchiveType;
        boolean bl = false;
        ArchiveType archiveType = !(it == ArchiveType.NONE) ? object : null;
        if (archiveType == null) {
            String string = $this$unpack.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            archiveType = ArchiveType.Companion.getType(string);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[archiveType.ordinal()]) {
            case 1: {
                ArchiveUtilsKt.unpack7Zip($this$unpack, targetDirectory, filter);
                break;
            }
            case 2: {
                ArchiveUtilsKt.unpackZip($this$unpack, targetDirectory, filter);
                break;
            }
            case 3: {
                object = new FileInputStream($this$unpack);
                Throwable throwable = null;
                try {
                    FileInputStream it2 = (FileInputStream)object;
                    boolean bl2 = false;
                    ArchiveUtilsKt.unpackTar(it2, targetDirectory, filter);
                    it2 = Unit.INSTANCE;
                    break;
                }
                catch (Throwable bl2) {
                    throwable = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            case 4: {
                object = new FileInputStream($this$unpack);
                Throwable throwable = null;
                try {
                    FileInputStream it3 = (FileInputStream)object;
                    boolean bl3 = false;
                    ArchiveUtilsKt.unpackTar((InputStream)new BZip2CompressorInputStream((InputStream)it3), targetDirectory, filter);
                    it3 = Unit.INSTANCE;
                    break;
                }
                catch (Throwable bl3) {
                    throwable = bl3;
                    throw bl3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            case 5: {
                object = new FileInputStream($this$unpack);
                Throwable throwable = null;
                try {
                    FileInputStream it4 = (FileInputStream)object;
                    boolean bl4 = false;
                    ArchiveUtilsKt.unpackTar((InputStream)new GzipCompressorInputStream((InputStream)it4), targetDirectory, filter);
                    it4 = Unit.INSTANCE;
                    break;
                }
                catch (Throwable bl4) {
                    throwable = bl4;
                    throw bl4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            case 6: {
                object = new FileInputStream($this$unpack);
                Throwable throwable = null;
                try {
                    FileInputStream it5 = (FileInputStream)object;
                    boolean bl5 = false;
                    ArchiveUtilsKt.unpackTar((InputStream)new XZCompressorInputStream((InputStream)it5), targetDirectory, filter);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            case 7: {
                ArchiveUtilsKt.unpackDeb($this$unpack, targetDirectory, filter);
                break;
            }
            case 8: {
                throw new IOException("Unable to guess compression scheme from file name '" + $this$unpack.getName() + "'.");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static /* synthetic */ void unpack$default(File file, File file2, ArchiveType archiveType, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            archiveType = ArchiveType.NONE;
        }
        if ((n & 4) != 0) {
            function1 = ArchiveUtilsKt::unpack$lambda$0;
        }
        ArchiveUtilsKt.unpack(file, file2, archiveType, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public static final void unpackTryAllTypes(@NotNull File $this$unpackTryAllTypes, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter) {
        Object v1;
        boolean $i$f$forEach;
        Object object;
        List suppressedExceptions;
        block8: {
            Object element$iv$iv;
            void $this$mapNotNullTo$iv;
            Intrinsics.checkNotNullParameter((Object)$this$unpackTryAllTypes, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            String string = $this$unpackTryAllTypes.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ArchiveType typeFromName = ArchiveType.Companion.getType(string);
            suppressedExceptions = new ArrayList();
            object = (Iterable)ArchiveType.getEntries();
            ArchiveType[] archiveTypeArray = new ArchiveType[]{typeFromName};
            Iterable<ArchiveType> destination$iv = CollectionsKt.mutableListOf((Object[])archiveTypeArray);
            boolean $i$f$mapNotNullTo = false;
            void var8_10 = $this$mapNotNullTo$iv;
            $i$f$forEach = false;
            Iterator iterator = var8_10.iterator();
            while (iterator.hasNext()) {
                ArchiveType it$iv;
                ArchiveType archiveType;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                ArchiveType type = (ArchiveType)((Object)element$iv);
                boolean bl2 = false;
                ArchiveType it = archiveType = type;
                boolean bl3 = false;
                if ((!(type == typeFromName || type == ArchiveType.NONE) ? archiveType : null) == null) continue;
                it$iv = it$iv;
                boolean bl4 = false;
                destination$iv.add((ArchiveType)it$iv);
            }
            destination$iv = destination$iv;
            for (Object e : destination$iv) {
                Object it;
                Object $this$unpackTryAllTypes_u24lambda_u2413_u24lambda_u249;
                ArchiveType archiveType = (ArchiveType)((Object)e);
                boolean bl = false;
                element$iv$iv = $this$unpackTryAllTypes;
                try {
                    $this$unpackTryAllTypes_u24lambda_u2413_u24lambda_u249 = element$iv$iv;
                    boolean bl5 = false;
                    ArchiveUtilsKt.unpack($this$unpackTryAllTypes_u24lambda_u2413_u24lambda_u249, targetDirectory, archiveType, filter);
                    $this$unpackTryAllTypes_u24lambda_u2413_u24lambda_u249 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl5) {
                    $this$unpackTryAllTypes_u24lambda_u2413_u24lambda_u249 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
                }
                element$iv$iv = $this$unpackTryAllTypes_u24lambda_u2413_u24lambda_u249;
                if (Result.isSuccess-impl(element$iv$iv)) {
                    it = (Unit)element$iv$iv;
                    boolean bl6 = false;
                    File $this$logger$iv = $this$unpackTryAllTypes;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(File.class).debug(() -> ArchiveUtilsKt.unpackTryAllTypes$lambda$13$lambda$11$lambda$10(archiveType, targetDirectory));
                }
                if (Result.exceptionOrNull-impl(element$iv$iv) != null) {
                    Object it2 = it;
                    boolean bl7 = false;
                    ((Collection)suppressedExceptions).add(new IOException("Unpacking '" + $this$unpackTryAllTypes + "' as " + archiveType + " failed.", (Throwable)it2));
                }
                if (!Result.isSuccess-impl(element$iv$iv)) continue;
                v1 = e;
                break block8;
            }
            v1 = null;
        }
        if ((ArchiveType)v1 == null) {
            Object $this$unpackTryAllTypes_u24lambda_u2414 = object = new IOException("Unable to unpack '" + $this$unpackTryAllTypes + "'. This file is not a supported archive type.");
            boolean bl = false;
            Iterable iterable = suppressedExceptions;
            $i$f$forEach = false;
            for (Object element$iv : iterable) {
                Throwable p0 = (Throwable)element$iv;
                boolean bl8 = false;
                ((Throwable)$this$unpackTryAllTypes_u24lambda_u2414).addSuppressed(p0);
            }
            throw (Throwable)object;
        }
    }

    public static /* synthetic */ void unpackTryAllTypes$default(File file, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = ArchiveUtilsKt::unpackTryAllTypes$lambda$6;
        }
        ArchiveUtilsKt.unpackTryAllTypes(file, file2, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unpack7Zip(@NotNull File $this$unpack7Zip, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)$this$unpack7Zip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Closeable closeable = (Closeable)((SevenZFile.Builder)new SevenZFile.Builder().setFile($this$unpack7Zip)).get();
        Throwable throwable = null;
        try {
            SevenZFile zipFile = (SevenZFile)closeable;
            boolean bl = false;
            File canonicalTargetDirectory = targetDirectory.getCanonicalFile();
            while (zipFile.getNextEntry() != null) {
                SevenZArchiveEntry entry;
                if (entry.isDirectory() || entry.isAntiItem() || new File(entry.getName()).isAbsolute() || !((Boolean)filter.invoke((Object)entry)).booleanValue()) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                File target = FilesKt.resolve((File)targetDirectory, (String)string);
                File file = target.getCanonicalFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
                Intrinsics.checkNotNull((Object)canonicalTargetDirectory);
                if (!FilesKt.startsWith((File)file, (File)canonicalTargetDirectory)) {
                    File $this$logger$iv = $this$unpack7Zip;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(File.class).warn(() -> ArchiveUtilsKt.unpack7Zip$lambda$18$lambda$16(entry, targetDirectory));
                    continue;
                }
                File file2 = target.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
                FileUtilsKt.safeMkdirs(file2);
                Closeable closeable2 = new FileOutputStream(target);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    InputStream inputStream = zipFile.getInputStream(entry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void unpack7Zip$default(File file, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = ArchiveUtilsKt::unpack7Zip$lambda$15;
        }
        ArchiveUtilsKt.unpack7Zip(file, file2, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    public static final void unpackZip(@NotNull File $this$unpackZip, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)$this$unpackZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        ZipFile zipFile = ((ZipFile.Builder)new ZipFile.Builder().setFile($this$unpackZip)).get();
        Intrinsics.checkNotNullExpressionValue((Object)zipFile, (String)"get(...)");
        ArchiveUtilsKt.unpack(zipFile, targetDirectory, filter);
    }

    public static /* synthetic */ void unpackZip$default(File file, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = ArchiveUtilsKt::unpackZip$lambda$19;
        }
        ArchiveUtilsKt.unpackZip(file, file2, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void unpack(ZipFile $this$unpack, File targetDirectory, Function1<? super ArchiveEntry, Boolean> filter) {
        Closeable closeable = (Closeable)$this$unpack;
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            File canonicalTargetDirectory = targetDirectory.getCanonicalFile();
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (entry.isDirectory() || entry.isUnixSymlink() || new File(entry.getName()).isAbsolute()) continue;
                Intrinsics.checkNotNull((Object)entry);
                if (!((Boolean)filter.invoke((Object)entry)).booleanValue()) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                File target = FilesKt.resolve((File)targetDirectory, (String)string);
                File file = target.getCanonicalFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
                Intrinsics.checkNotNull((Object)canonicalTargetDirectory);
                if (!FilesKt.startsWith((File)file, (File)canonicalTargetDirectory)) {
                    ZipFile $this$logger$iv = $this$unpack;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(ZipFile.class).warn(() -> ArchiveUtilsKt.unpack$lambda$22$lambda$20(entry, targetDirectory));
                    continue;
                }
                File file2 = target.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
                FileUtilsKt.safeMkdirs(file2);
                Closeable closeable2 = new FileOutputStream(target);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    InputStream inputStream = zipFile.getInputStream(entry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                ArchiveUtilsKt.copyExecutableModeBit(target, entry.getUnixMode());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final List<String> getDEB_NESTED_ARCHIVES() {
        return DEB_NESTED_ARCHIVES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unpackDeb(@NotNull File $this$unpackDeb, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)$this$unpackDeb, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory("unpackDeb", Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        File tempDir = path.toFile();
        try {
            ArchiveInputStream archiveInputStream = (ArchiveInputStream)new ArArchiveInputStream((InputStream)new FileInputStream($this$unpackDeb));
            Intrinsics.checkNotNull((Object)tempDir);
            ArchiveUtilsKt.unpack(archiveInputStream, tempDir, (Function1<? super ArchiveEntry, Boolean>)((Function1)ArchiveUtilsKt::unpackDeb$lambda$24), (Function1<? super ArchiveEntry, Integer>)((Function1)ArchiveUtilsKt::unpackDeb$lambda$25));
            Iterable $this$forEach$iv = DEB_NESTED_ARCHIVES;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name = (String)element$iv;
                boolean bl = false;
                String subDirectoryName = StringsKt.substringBefore$default((String)name, (char)'.', null, (int)2, null);
                File subDirectory = FileUtilsKt.safeMkdirs(FilesKt.resolve((File)targetDirectory, (String)subDirectoryName));
                File file = FilesKt.resolve((File)tempDir, (String)name);
                ArchiveUtilsKt.unpack$default(file, subDirectory, null, filter, 2, null);
            }
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNull((Object)tempDir);
            FileUtilsKt.safeDeleteRecursively$default(tempDir, null, 1, null);
            throw throwable;
        }
        FileUtilsKt.safeDeleteRecursively$default(tempDir, null, 1, null);
    }

    public static /* synthetic */ void unpackDeb$default(File file, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = ArchiveUtilsKt::unpackDeb$lambda$23;
        }
        ArchiveUtilsKt.unpackDeb(file, file2, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    public static final void unpackZip(@NotNull InputStream $this$unpackZip, @NotNull File targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$unpackZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        ArchiveUtilsKt.unpack((ArchiveInputStream)new ZipArchiveInputStream($this$unpackZip), targetDirectory, (Function1<? super ArchiveEntry, Boolean>)((Function1)ArchiveUtilsKt::unpackZip$lambda$28), (Function1<? super ArchiveEntry, Integer>)((Function1)ArchiveUtilsKt::unpackZip$lambda$29));
    }

    public static final void unpackTar(@NotNull InputStream $this$unpackTar, @NotNull File targetDirectory, @NotNull Function1<? super ArchiveEntry, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)$this$unpackTar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        ArchiveUtilsKt.unpack((ArchiveInputStream)new TarArchiveInputStream($this$unpackTar), targetDirectory, (Function1<? super ArchiveEntry, Boolean>)((Function1)arg_0 -> ArchiveUtilsKt.unpackTar$lambda$31(filter, arg_0)), (Function1<? super ArchiveEntry, Integer>)((Function1)ArchiveUtilsKt::unpackTar$lambda$32));
    }

    public static /* synthetic */ void unpackTar$default(InputStream inputStream, File file, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = ArchiveUtilsKt::unpackTar$lambda$30;
        }
        ArchiveUtilsKt.unpackTar(inputStream, file, (Function1<? super ArchiveEntry, Boolean>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <E extends ArchiveEntry> void unpack(ArchiveInputStream<E> $this$unpack, File targetDirectory, Function1<? super ArchiveEntry, Boolean> shouldSkip, Function1<? super ArchiveEntry, Integer> mode) {
        Closeable closeable = (Closeable)$this$unpack;
        Throwable throwable = null;
        try {
            ArchiveInputStream input = (ArchiveInputStream)closeable;
            boolean bl = false;
            File canonicalTargetDirectory = targetDirectory.getCanonicalFile();
            boolean processed = false;
            while (input.getNextEntry() != null) {
                ArchiveEntry entry;
                processed = true;
                if (((Boolean)shouldSkip.invoke((Object)entry)).booleanValue()) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                File target = FilesKt.resolve((File)targetDirectory, (String)string);
                File file = target.getCanonicalFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
                Intrinsics.checkNotNull((Object)canonicalTargetDirectory);
                if (!FilesKt.startsWith((File)file, (File)canonicalTargetDirectory)) {
                    ArchiveInputStream<E> $this$logger$iv = $this$unpack;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(ArchiveInputStream.class).warn(() -> ArchiveUtilsKt.unpack$lambda$35$lambda$33(entry, targetDirectory));
                    continue;
                }
                File file2 = target.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
                FileUtilsKt.safeMkdirs(file2);
                Closeable closeable2 = new FileOutputStream(target);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)((InputStream)input), (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                ArchiveUtilsKt.copyExecutableModeBit(target, ((Number)mode.invoke((Object)entry)).intValue());
            }
            if ($this$unpack instanceof TarArchiveInputStream && !processed) {
                throw new IOException("Unsupported archive type or empty archive.");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void copyExecutableModeBit(File target, int mode) {
        if (Os.INSTANCE.isWindows()) {
            return;
        }
        if ((mode & 0x41) != 0) {
            target.setExecutable(true, (mode & 1) == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final File packZip(@NotNull File $this$packZip, @NotNull File targetFile, @NotNull String prefix, boolean overwrite, @NotNull Function1<? super File, Boolean> directoryFilter, @NotNull Function1<? super File, Boolean> fileFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$packZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(directoryFilter, (String)"directoryFilter");
        Intrinsics.checkNotNullParameter(fileFilter, (String)"fileFilter");
        if (!(overwrite || !targetFile.exists())) {
            boolean bl = false;
            String string = "The target ZIP file '" + targetFile.getAbsolutePath() + "' must not exist.";
            throw new IllegalArgumentException(string.toString());
        }
        Closeable closeable = (Closeable)new ZipArchiveOutputStream(targetFile);
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            ZipArchiveOutputStream output = (ZipArchiveOutputStream)closeable;
            boolean bl = false;
            output.setLevel(9);
            Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)$this$packZip).onEnter(arg_0 -> ArchiveUtilsKt.packZip$lambda$44$lambda$39(directoryFilter, arg_0))), arg_0 -> ArchiveUtilsKt.packZip$lambda$44$lambda$40(fileFilter, targetFile, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file;
                File file2 = (File)element$iv;
                boolean bl2 = false;
                File it = file = $this$packZip;
                boolean bl3 = false;
                File file3 = !it.isFile() ? file : null;
                if (file3 == null) {
                    file3 = $this$packZip.getParentFile();
                }
                File base = file3;
                Intrinsics.checkNotNull((Object)base);
                String packPath = prefix + FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)file2, (File)base));
                ZipArchiveEntry entry = new ZipArchiveEntry(file2, packPath);
                output.putArchiveEntry(entry);
                Closeable closeable2 = new FileInputStream(file2);
                Throwable throwable2 = null;
                try {
                    FileInputStream input = (FileInputStream)closeable2;
                    boolean bl4 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)((OutputStream)output), (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                output.closeArchiveEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return targetFile;
    }

    public static /* synthetic */ File packZip$default(File file, File file2, String string, boolean bl, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            function1 = ArchiveUtilsKt::packZip$lambda$36;
        }
        if ((n & 0x10) != 0) {
            function12 = ArchiveUtilsKt::packZip$lambda$37;
        }
        return ArchiveUtilsKt.packZip(file, file2, string, bl, (Function1<? super File, Boolean>)function1, (Function1<? super File, Boolean>)function12);
    }

    private static final boolean unpack$lambda$0(ArchiveEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean unpackTryAllTypes$lambda$6(ArchiveEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Object unpackTryAllTypes$lambda$13$lambda$11$lambda$10(ArchiveType $archiveType, File $targetDirectory) {
        return "Unpacked stream as " + $archiveType + " to '" + $targetDirectory + "'.";
    }

    private static final boolean unpack7Zip$lambda$15(ArchiveEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Object unpack7Zip$lambda$18$lambda$16(SevenZArchiveEntry $entry, File $targetDirectory) {
        return "Skipping entry '" + $entry.getName() + "' which points to outside of '" + $targetDirectory + "'.";
    }

    private static final boolean unpackZip$lambda$19(ArchiveEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Object unpack$lambda$22$lambda$20(ZipArchiveEntry $entry, File $targetDirectory) {
        return "Skipping entry '" + $entry.getName() + "' which points to outside of '" + $targetDirectory + "'.";
    }

    private static final boolean unpackDeb$lambda$23(ArchiveEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean unpackDeb$lambda$24(ArchiveEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return entry.isDirectory() || new File(entry.getName()).isAbsolute();
    }

    private static final int unpackDeb$lambda$25(ArchiveEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return ((ArArchiveEntry)entry).getMode();
    }

    private static final boolean unpackZip$lambda$28(ArchiveEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        ZipArchiveEntry it = (ZipArchiveEntry)entry;
        boolean bl = false;
        return it.isDirectory() || it.isUnixSymlink() || new File(it.getName()).isAbsolute();
    }

    private static final int unpackZip$lambda$29(ArchiveEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return ((ZipArchiveEntry)entry).getUnixMode();
    }

    private static final boolean unpackTar$lambda$30(ArchiveEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean unpackTar$lambda$31(Function1 $filter, ArchiveEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return !((TarArchiveEntry)entry).isFile() || new File(((TarArchiveEntry)entry).getName()).isAbsolute() || (Boolean)$filter.invoke((Object)entry) == false;
    }

    private static final int unpackTar$lambda$32(ArchiveEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return ((TarArchiveEntry)entry).getMode();
    }

    private static final Object unpack$lambda$35$lambda$33(ArchiveEntry $entry, File $targetDirectory) {
        return "Skipping entry '" + $entry.getName() + "' which points to outside of '" + $targetDirectory + "'.";
    }

    private static final boolean packZip$lambda$36(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !FileUtilsKt.getVCS_DIRECTORIES().contains(it.getName());
    }

    private static final boolean packZip$lambda$37(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean packZip$lambda$44$lambda$39(Function1 $directoryFilter, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        return Files.isDirectory(it.toPath(), linkOptionArray) && (Boolean)$directoryFilter.invoke((Object)it) != false;
    }

    private static final boolean packZip$lambda$44$lambda$40(Function1 $fileFilter, File $targetFile, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        return Files.isRegularFile(it.toPath(), linkOptionArray) && (Boolean)$fileFilter.invoke((Object)it) != false && !Intrinsics.areEqual((Object)it, (Object)$targetFile);
    }

    static {
        Object[] objectArray = new String[]{"data.tar.xz", "control.tar.xz"};
        DEB_NESTED_ARCHIVES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArchiveType.values().length];
            try {
                nArray[ArchiveType.SEVENZIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.ZIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.TAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.TAR_BZIP2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.TAR_GZIP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.TAR_XZ.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.DEB.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.NONE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

