/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import com.jakewharton.disklrucache.DiskLruCache;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.MiscUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\f\u001a\u00020\r*\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/ossreviewtoolkit/utils/common/DiskCache;", "Ljava/io/Closeable;", "directory", "Ljava/io/File;", "maxCacheSizeInBytes", "", "maxCacheEntryAgeInSeconds", "<init>", "(Ljava/io/File;JJ)V", "diskLruCache", "Lcom/jakewharton/disklrucache/DiskLruCache;", "kotlin.jvm.PlatformType", "asKey", "", "read", "key", "write", "", "data", "close", "", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskCache.kt\norg/ossreviewtoolkit/utils/common/DiskCache\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,155:1\n38#2:156\n38#2:157\n*S KotlinDebug\n*F\n+ 1 DiskCache.kt\norg/ossreviewtoolkit/utils/common/DiskCache\n*L\n127#1:156\n145#1:157\n*E\n"})
public final class DiskCache
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long maxCacheEntryAgeInSeconds;
    private final DiskLruCache diskLruCache;
    public static final int INDEX_FULL_KEY = 0;
    public static final int INDEX_TIMESTAMP = 1;
    public static final int INDEX_DATA = 2;
    public static final int VALUE_COUNT = 3;
    public static final int MAX_KEY_LENGTH = 64;
    public static final int KEY_SUFFIX_LENGTH = 6;
    private static final int KEY_INDEX_LIMIT = (int)Math.pow(10.0, 5);
    @NotNull
    private static final Regex ILLEGAL_KEY_CHARS = new Regex("[^a-z0-9_-]");

    public DiskCache(@NotNull File directory, long maxCacheSizeInBytes, long maxCacheEntryAgeInSeconds) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.maxCacheEntryAgeInSeconds = maxCacheEntryAgeInSeconds;
        this.diskLruCache = DiskLruCache.open((File)directory, (int)0, (int)3, (long)maxCacheSizeInBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String asKey(String $this$asKey) {
        String string = $this$asKey.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence charSequence = StringsKt.replace$default((String)string, (char)'.', (char)'-', (boolean)false, (int)4, null);
        Regex regex = ILLEGAL_KEY_CHARS;
        String string2 = "_";
        String mappedKey = regex.replace(charSequence, string2);
        if (mappedKey.length() <= 58) {
            return mappedKey;
        }
        String shortenedKey = (String)SequencesKt.first((Sequence)StringsKt.chunkedSequence((CharSequence)mappedKey, (int)58));
        int n = KEY_INDEX_LIMIT;
        for (int index = 0; index < n; ++index) {
            String tryKey = shortenedKey + "-" + StringsKt.padStart((String)String.valueOf(index), (int)5, (char)'0');
            Closeable closeable = (Closeable)this.diskLruCache.get(tryKey);
            Throwable throwable = null;
            try {
                DiskLruCache.Snapshot entry = (DiskLruCache.Snapshot)closeable;
                boolean bl = false;
                if (entry == null || Intrinsics.areEqual((Object)entry.getString(0), (Object)$this$asKey)) {
                    String string3 = tryKey;
                    return string3;
                }
                Unit unit = Unit.INSTANCE;
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        throw new IOException("Cannot generate key for '" + $this$asKey + "' because all possible keys starting with '" + shortenedKey + "' are taken.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String read(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String diskKey = this.asKey(key);
        try {
            DiskLruCache.Snapshot snapshot = this.diskLruCache.get(diskKey);
            if (snapshot != null) {
                Closeable closeable = (Closeable)snapshot;
                Throwable throwable = null;
                try {
                    DiskLruCache.Snapshot entry = (DiskLruCache.Snapshot)closeable;
                    boolean bl = false;
                    String string = entry.getString(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                    long time = Long.parseLong(string);
                    if (time + this.maxCacheEntryAgeInSeconds >= Instant.now().getEpochSecond()) {
                        String string2 = entry.getString(2);
                        return string2;
                    }
                    entry = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            this.diskLruCache.remove(diskKey);
        }
        catch (IOException e) {
            DiskCache $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(DiskCache.class).error(() -> DiskCache.read$lambda$2(diskKey, e));
        }
        return null;
    }

    public final boolean write(@NotNull String key, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String diskKey = this.asKey(key);
        try {
            DiskLruCache.Editor editor;
            DiskLruCache.Editor $this$write_u24lambda_u243 = editor = this.diskLruCache.edit(diskKey);
            boolean bl = false;
            $this$write_u24lambda_u243.set(0, key);
            $this$write_u24lambda_u243.set(1, String.valueOf(Instant.now().getEpochSecond()));
            $this$write_u24lambda_u243.set(2, data);
            $this$write_u24lambda_u243.commit();
            return true;
        }
        catch (IOException e) {
            DiskCache $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(DiskCache.class).error(() -> DiskCache.write$lambda$4(diskKey, e));
            return false;
        }
    }

    @Override
    public void close() {
        this.diskLruCache.close();
    }

    private static final Object read$lambda$2(String $diskKey, IOException $e) {
        return "Could not read cache entry for key '" + $diskKey + "': " + MiscUtilsKt.collectMessages($e);
    }

    private static final Object write$lambda$4(String $diskKey, IOException $e) {
        return "Could not write to disk cache for key '" + $diskKey + "': " + MiscUtilsKt.collectMessages($e);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/utils/common/DiskCache$Companion;", "", "<init>", "()V", "INDEX_FULL_KEY", "", "INDEX_TIMESTAMP", "INDEX_DATA", "VALUE_COUNT", "MAX_KEY_LENGTH", "KEY_SUFFIX_LENGTH", "KEY_INDEX_LIMIT", "getKEY_INDEX_LIMIT", "()I", "ILLEGAL_KEY_CHARS", "Lkotlin/text/Regex;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        public final int getKEY_INDEX_LIMIT() {
            return KEY_INDEX_LIMIT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

