/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.NumberUtilsKt;
import org.ossreviewtoolkit.utils.common.Os;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010\u001a\n\u0010\u001a\u001a\u00020\u000e*\u00020\u000e\u001a\u0016\u0010\u001b\u001a\u00020\u001c*\u00020\u000e2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u000e\u001a\n\u0010\u001e\u001a\u00020\u000e*\u00020\u000e\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u000e*\u00020\u000e2\u0006\u0010 \u001a\u00020\u0002\u001a\n\u0010!\u001a\u00020\"*\u00020\u000e\u001a\n\u0010\u001a\u001a\u00020\u0002*\u00020\u0002\"!\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0015\u0010\u0011\u001a\u00020\u0002*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\"\u0015\u0010\u0017\u001a\u00020\u000e*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"PATH_STRING_COMPARATOR", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "getPATH_STRING_COMPARATOR", "()Ljava/util/Comparator;", "VCS_DIRECTORIES", "", "getVCS_DIRECTORIES", "()Ljava/util/Set;", "getAllAncestorDirectories", "", "file", "getCommonParentFile", "Ljava/io/File;", "files", "", "formatSizeInMib", "getFormatSizeInMib", "(Ljava/io/File;)Ljava/lang/String;", "isSymbolicLink", "", "(Ljava/io/File;)Z", "realFile", "getRealFile", "(Ljava/io/File;)Ljava/io/File;", "expandTilde", "safeDeleteRecursively", "", "baseDirectory", "safeMkdirs", "searchUpwardsForSubdirectory", "searchDirName", "toSafeUri", "Ljava/net/URI;", "common-utils"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\norg/ossreviewtoolkit/utils/common/FileUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,186:1\n1563#2:187\n1634#2,3:188\n2851#2,7:191\n1321#3,2:198\n1104#4,3:200\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\norg/ossreviewtoolkit/utils/common/FileUtilsKt\n*L\n71#1:187\n71#1:188,3\n73#1:191,7\n117#1:198,2\n34#1:200,3\n*E\n"})
public final class FileUtilsKt {
    @NotNull
    private static final Comparator<String> PATH_STRING_COMPARATOR;
    @NotNull
    private static final Set<String> VCS_DIRECTORIES;

    @NotNull
    public static final Comparator<String> getPATH_STRING_COMPARATOR() {
        return PATH_STRING_COMPARATOR;
    }

    @NotNull
    public static final Set<String> getVCS_DIRECTORIES() {
        return VCS_DIRECTORIES;
    }

    @NotNull
    public static final List<String> getAllAncestorDirectories(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List result = new ArrayList();
        for (File ancestorDir = new File(file).getParentFile(); ancestorDir != null; ancestorDir = ancestorDir.getParentFile()) {
            ((Collection)result).add(FilesKt.getInvariantSeparatorsPath((File)ancestorDir));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File getCommonParentFile(@NotNull Collection<? extends File> files) {
        String string;
        Object v0;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FilesKt.normalize((File)it).getParent());
        }
        Iterable $this$reduceOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                String string2;
                String $i$f$mapTo2 = (String)iterator$iv.next();
                String prefix = (String)accumulator$iv;
                boolean bl = false;
                String string3 = prefix;
                if (string3 != null) {
                    void path;
                    CharSequence charSequence = string3;
                    String string4 = path;
                    if (string4 == null) {
                        string4 = "";
                    }
                    string2 = StringsKt.commonPrefixWith((CharSequence)charSequence, (CharSequence)string4, (boolean)Os.INSTANCE.isWindows());
                } else {
                    string2 = null;
                }
                accumulator$iv = string2;
            }
            v0 = accumulator$iv;
        }
        if ((string = (String)v0) == null) {
            string = "";
        }
        String it = string;
        boolean bl = false;
        return new File(it);
    }

    @NotNull
    public static final String getFormatSizeInMib(@NotNull File $this$formatSizeInMib) {
        Intrinsics.checkNotNullParameter((Object)$this$formatSizeInMib, (String)"<this>");
        return NumberUtilsKt.format$default(NumberUtilsKt.bytesToMib($this$formatSizeInMib.length()), 0, 1, null) + " MiB";
    }

    public static final boolean isSymbolicLink(@NotNull File $this$isSymbolicLink) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isSymbolicLink, (String)"<this>");
        Object object2 = $this$isSymbolicLink;
        try {
            File $this$_get_isSymbolicLink__u24lambda_u247 = object2;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            BasicFileAttributes it = Files.readAttributes($this$_get_isSymbolicLink__u24lambda_u247.toPath(), BasicFileAttributes.class, linkOptionArray);
            boolean bl2 = false;
            object = Result.constructor-impl((Object)(it.isSymbolicLink() || Os.INSTANCE.isWindows() && it.isOther() ? 1 : 0));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    @NotNull
    public static final File getRealFile(@NotNull File $this$realFile) {
        Intrinsics.checkNotNullParameter((Object)$this$realFile, (String)"<this>");
        File file = $this$realFile.toPath().toRealPath(new LinkOption[0]).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @NotNull
    public static final File expandTilde(@NotNull File $this$expandTilde) {
        Intrinsics.checkNotNullParameter((Object)$this$expandTilde, (String)"<this>");
        String string = $this$expandTilde.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        File file = new File(FileUtilsKt.expandTilde(string)).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAbsoluteFile(...)");
        return file;
    }

    public static final void safeDeleteRecursively(@NotNull File $this$safeDeleteRecursively, @Nullable File baseDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$safeDeleteRecursively, (String)"<this>");
        if (Os.INSTANCE.isWindows()) {
            Sequence $this$forEach$iv = (Sequence)FilesKt.walkBottomUp((File)$this$safeDeleteRecursively).onEnter(FileUtilsKt::safeDeleteRecursively$lambda$8);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                it.setWritable(true);
            }
        }
        Path path = $this$safeDeleteRecursively.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        PathsKt.deleteRecursively((Path)path);
        if (Intrinsics.areEqual((Object)baseDirectory, (Object)$this$safeDeleteRecursively)) {
            FileUtilsKt.safeMkdirs($this$safeDeleteRecursively);
            return;
        }
        if (baseDirectory != null) {
            for (File parent = $this$safeDeleteRecursively.getParentFile(); parent != null && !Intrinsics.areEqual((Object)parent, (Object)baseDirectory) && parent.delete(); parent = parent.getParentFile()) {
            }
        }
    }

    public static /* synthetic */ void safeDeleteRecursively$default(File file, File file2, int n, Object object) {
        if ((n & 1) != 0) {
            file2 = null;
        }
        FileUtilsKt.safeDeleteRecursively(file, file2);
    }

    @NotNull
    public static final File safeMkdirs(@NotNull File $this$safeMkdirs) {
        Intrinsics.checkNotNullParameter((Object)$this$safeMkdirs, (String)"<this>");
        if ($this$safeMkdirs.isDirectory() || $this$safeMkdirs.mkdirs() || $this$safeMkdirs.isDirectory()) {
            return $this$safeMkdirs;
        }
        throw new IOException("Could not create directory '" + $this$safeMkdirs.getAbsolutePath() + "'.");
    }

    @Nullable
    public static final File searchUpwardsForSubdirectory(@NotNull File $this$searchUpwardsForSubdirectory, @NotNull String searchDirName) {
        File currentDir;
        Intrinsics.checkNotNullParameter((Object)$this$searchUpwardsForSubdirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)searchDirName, (String)"searchDirName");
        if (!$this$searchUpwardsForSubdirectory.isDirectory()) {
            return null;
        }
        for (currentDir = $this$searchUpwardsForSubdirectory.getAbsoluteFile(); currentDir != null && !FilesKt.resolve((File)currentDir, (String)searchDirName).isDirectory(); currentDir = currentDir.getParentFile()) {
        }
        return currentDir;
    }

    @NotNull
    public static final URI toSafeUri(@NotNull File $this$toSafeUri) {
        Intrinsics.checkNotNullParameter((Object)$this$toSafeUri, (String)"<this>");
        URI fileUri = $this$toSafeUri.toURI();
        return new URI("file", "", fileUri.getPath(), fileUri.getQuery(), fileUri.getFragment());
    }

    @NotNull
    public static final String expandTilde(@NotNull String $this$expandTilde) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$expandTilde, (String)"<this>");
        if (Os.INSTANCE.getEnv().get("SHELL") != null) {
            CharSequence charSequence = $this$expandTilde;
            Regex regex = new Regex("^~");
            String string2 = System.getProperty("user.home");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            String string3 = Regex.Companion.escapeReplacement(string2);
            string = regex.replace(charSequence, string3);
        } else {
            string = $this$expandTilde;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final Comparable PATH_STRING_COMPARATOR$lambda$1(String path) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence $this$count$iv = path;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv;
        }
        return Integer.valueOf((int)var3_3);
    }

    private static final Comparable PATH_STRING_COMPARATOR$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it);
    }

    private static final boolean safeDeleteRecursively$lambda$8(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !FileUtilsKt.isSymbolicLink(it);
    }

    static {
        Object[] objectArray = new Function1[]{FileUtilsKt::PATH_STRING_COMPARATOR$lambda$1, FileUtilsKt::PATH_STRING_COMPARATOR$lambda$2};
        PATH_STRING_COMPARATOR = ComparisonsKt.compareBy((Function1[])objectArray);
        objectArray = new String[]{".bzr", ".git", ".hg", ".repo", ".svn", "CVS", "CVSROOT"};
        VCS_DIRECTORIES = SetsKt.setOf((Object[])objectArray);
    }
}

