/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.Os;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a/\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015*\u0002H\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00180\u0017H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\u001a\"\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001f0\u001e*\b\u0012\u0004\u0012\u00020\r0 \u001a\n\u0010!\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\"\u001a\u00020\u0007*\u00020#\u001a\n\u0010$\u001a\u00020%*\u00020\u0007\u001a\n\u0010&\u001a\u00020\u0007*\u00020%\u001a\u0012\u0010'\u001a\u00020\u0007*\u00020\u00072\u0006\u0010(\u001a\u00020\u0007\u001a\n\u0010)\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010*\u001a\u00020\b*\u00020\b\u001a\n\u0010*\u001a\u00020\u0007*\u00020\u0007\u001a\u0012\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070,*\u0004\u0018\u00010-\u001a\u001e\u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020-0/0,*\u0004\u0018\u00010-\u001a\n\u00100\u001a\u00020\u0007*\u00020\u0007\u001a\u0014\u00101\u001a\u00020\u0007*\u00020\u001b2\b\b\u0002\u00102\u001a\u00020\r\u001a\u001c\u00103\u001a\b\u0012\u0004\u0012\u0002H\u001504\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150 \u001aB\u00103\u001a\u0014\u0012\u0004\u0012\u0002H6\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u001e05\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u00106*\b\u0012\u0004\u0012\u0002H\u00150 2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H60\u0017\u001a\u001c\u00108\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001e05*\u000209\u001a\f\u0010:\u001a\u00020;*\u0004\u0018\u00010\u0007\u001a\n\u0010<\u001a\u00020;*\u00020\b\u001a\f\u0010=\u001a\u00020;*\u0004\u0018\u00010\u0007\u001a\n\u0010>\u001a\u00020;*\u00020\u0007\u001a\u001d\u0010?\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150,\u00a2\u0006\u0002\u0010@\u001a\n\u0010A\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010B\u001a\u00020\u0007*\u00020\u0007\u001a7\u0010C\u001a\b\u0012\u0004\u0012\u0002HE0D\"\u000e\b\u0000\u0010E*\b\u0012\u0004\u0012\u0002HE0F*\b\u0012\u0004\u0012\u0002HE0D2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HE0DH\u0086\u0002\u001a\u001c\u0010H\u001a\u00020\u0007*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001f0 \u001a\n\u0010I\u001a\u00020\b*\u00020\b\u001a\u0016\u0010J\u001a\u00020\u0007*\u00020\u00072\n\b\u0002\u0010K\u001a\u0004\u0018\u00010\u0007\u001a \u0010L\u001a\u00020\u0018*\u00020\b2\b\b\u0002\u0010M\u001a\u00020;2\n\b\u0002\u0010N\u001a\u0004\u0018\u00010\b\u001a\n\u0010O\u001a\u00020\b*\u00020\b\u001a\u0014\u0010P\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010Q\u001a\u00020\u0007\u001a\u0010\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e*\u00020\u0007\u001a\f\u0010S\u001a\u00020\u0007*\u0004\u0018\u00010-\u001a\n\u0010T\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010U\u001a\u000209*\u00020\b\u001a\u0015\u0010V\u001a\b\u0012\u0004\u0012\u0002090W*\u00020\u0007\u00a2\u0006\u0002\u0010X\u001a/\u0010V\u001a\b\u0012\u0004\u0012\u0002HY0W\"\u0004\b\u0000\u0010Y*\u00020\u00072\u0012\u0010Z\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HY0\u0017\u00a2\u0006\u0002\u0010[\u001a\u0014\u0010\\\u001a\u00020\u0007*\u00020\u00072\b\b\u0002\u0010]\u001a\u00020;\u001a\n\u0010^\u001a\u00020\u0007*\u00020\u0007\u001a(\u0010_\u001a\u0004\u0018\u00010\u0007*\u0004\u0018\u00010\u00072\u0006\u0010`\u001a\u00020\u00072\u0010\b\u0002\u0010a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070b\u001a(\u0010c\u001a\u0004\u0018\u00010\u0007*\u0004\u0018\u00010\u00072\u0006\u0010d\u001a\u00020\u00072\u0010\b\u0002\u0010e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070b\u001al\u0010f\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hg05\"\u0004\b\u0000\u00106\"\u0004\b\u0001\u0010h\"\u0004\b\u0002\u0010g*\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hh052\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hh052\u001c\u0010i\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u0001Hh\u0012\u0006\u0012\u0004\u0018\u0001Hh\u0012\u0004\u0012\u0002Hg0jH\u0086\b\u00f8\u0001\u0000\u001aR\u0010k\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hh05\"\u0004\b\u0000\u00106\"\u000e\b\u0001\u0010h*\b\u0012\u0004\u0012\u0002H\u00150 \"\u0004\b\u0002\u0010\u0015*\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hh052\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hh05\u001aY\u0010k\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hh05\"\u0004\b\u0000\u00106\"\u000e\b\u0001\u0010h*\b\u0012\u0004\u0012\u0002H\u001504\"\u0004\b\u0002\u0010\u0015*\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hh052\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hh05H\u0007\u00a2\u0006\u0002\bl\u001au\u0010m\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hg05\"\u0004\b\u0000\u00106\"\u0004\b\u0001\u0010h\"\u0004\b\u0002\u0010g*\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hh052\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002Hh052\u0006\u0010n\u001a\u0002Hh2\u0018\u0010i\u001a\u0014\u0012\u0004\u0012\u0002Hh\u0012\u0004\u0012\u0002Hh\u0012\u0004\u0012\u0002Hg0jH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010o\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0016\u0010\u000b\u001a\u00020\f*\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0016\u0010\u0010\u001a\u00020\f*\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\"\u0016\u0010\u0012\u001a\u00020\f*\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006p"}, d2={"CONSECUTIVE_WHITESPACE_REGEX", "Lkotlin/text/Regex;", "NON_LINUX_LINE_BREAKS", "getNON_LINUX_LINE_BREAKS", "()Lkotlin/text/Regex;", "nonSpaceRegex", "formatSizeInMib", "", "Ljava/io/File;", "getFormatSizeInMib", "(Ljava/io/File;)Ljava/lang/String;", "gibibytes", "", "", "getGibibytes", "(I)J", "kibibytes", "getKibibytes", "mebibytes", "getMebibytes", "alsoIfNull", "T", "block", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "bytesToMib", "", "", "collapseToRanges", "", "Lkotlin/Pair;", "", "collapseWhitespace", "collectMessages", "", "decodeHex", "", "encodeHex", "encodeOr", "emptyValue", "encodeOrUnknown", "expandTilde", "fieldNamesOrEmpty", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "fieldsOrEmpty", "", "fileSystemEncode", "format", "decimalPlaces", "getDuplicates", "", "", "K", "keySelector", "getQueryParameters", "Ljava/net/URI;", "isFalse", "", "isSymbolicLink", "isTrue", "isValidUri", "nextOrNull", "(Ljava/util/Iterator;)Ljava/lang/Object;", "normalizeLineBreaks", "percentEncode", "plus", "Ljava/util/EnumSet;", "E", "", "other", "prettyPrintRanges", "realFile", "replaceCredentialsInUri", "userInfo", "safeDeleteRecursively", "force", "baseDirectory", "safeMkdirs", "searchUpwardsForSubdirectory", "searchDirName", "splitOnWhitespace", "textValueOrEmpty", "titlecase", "toSafeUri", "toUri", "Lkotlin/Result;", "(Ljava/lang/String;)Ljava/lang/Object;", "R", "transform", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "unquote", "trimWhitespace", "uppercaseFirstChar", "withoutPrefix", "prefix", "missingPrefixValue", "Lkotlin/Function0;", "withoutSuffix", "suffix", "missingSuffixValue", "zip", "W", "V", "operation", "Lkotlin/Function2;", "zipWithCollections", "zipWithSets", "zipWithDefault", "default", "(Ljava/util/Map;Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/util/Map;", "common-utils"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\norg/ossreviewtoolkit/utils/common/ExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,477:1\n201#1:515\n206#1:516\n201#1:517\n241#1:530\n242#1:535\n243#1:537\n241#1:538\n242#1:543\n243#1:545\n206#1:546\n201#1:547\n1477#2:478\n1502#2,3:479\n1505#2,3:489\n3464#2,7:499\n3471#2,3:507\n1620#2,3:510\n1855#2,2:513\n1271#2,2:518\n1285#2,4:520\n1271#2,2:524\n1285#2,4:526\n1271#2,2:531\n1285#2,2:533\n1288#2:536\n1271#2,2:539\n1285#2,2:541\n1288#2:544\n1549#2:548\n1620#2,3:549\n1490#2:578\n1520#2,3:579\n1523#2,3:589\n1238#2,4:594\n372#3,7:482\n526#3:492\n511#3,6:493\n372#3,7:582\n453#3:592\n403#3:593\n1#4:506\n1155#5,3:552\n107#6:555\n79#6,22:556\n13309#7,2:598\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\norg/ossreviewtoolkit/utils/common/ExtensionsKt\n*L\n206#1:515\n211#1:516\n211#1:517\n259#1:530\n259#1:535\n259#1:537\n277#1:538\n277#1:543\n277#1:545\n292#1:546\n292#1:547\n50#1:478\n50#1:479,3\n50#1:489,3\n67#1:499,7\n67#1:507,3\n71#1:510,3\n131#1:513,2\n241#1:518,2\n241#1:520,4\n250#1:524,2\n250#1:526,4\n259#1:531,2\n259#1:533,2\n259#1:536\n277#1:539,2\n277#1:541,2\n277#1:544\n306#1:548\n306#1:549,3\n474#1:578\n474#1:579,3\n474#1:589,3\n475#1:594,4\n50#1:482,7\n50#1:492\n50#1:493,6\n474#1:582,7\n475#1:592\n475#1:593\n398#1:552,3\n423#1:555\n423#1:556,22\n454#1:598,2\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    private static final Regex CONSECUTIVE_WHITESPACE_REGEX = new Regex("\\s+");
    @NotNull
    private static final Regex NON_LINUX_LINE_BREAKS = new Regex("\\r\\n?");
    @NotNull
    private static final Regex nonSpaceRegex = new Regex("\\S+");

    public static final <T> T alsoIfNull(T $this$alsoIfNull, @NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$alsoIfNull = false;
        T t = $this$alsoIfNull;
        if (t == null) {
            T t2 = $this$alsoIfNull;
            block.invoke(t2);
            t = t2;
        }
        return t;
    }

    @NotNull
    public static final String encodeHex(@NotNull byte[] $this$encodeHex) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeHex, (String)"<this>");
        return ArraysKt.joinToString$default((byte[])$this$encodeHex, (CharSequence)"", null, null, (int)0, null, (Function1)encodeHex.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, K> Map<K, List<T>> getDuplicates(@NotNull Collection<? extends T> $this$getDuplicates, @NotNull Function1<? super T, ? extends K> keySelector) {
        Map map;
        Intrinsics.checkNotNullParameter($this$getDuplicates, (String)"<this>");
        Intrinsics.checkNotNullParameter(keySelector, (String)"keySelector");
        if ($this$getDuplicates instanceof Set) {
            map = MapsKt.emptyMap();
        } else {
            void $this$filterTo$iv$iv;
            Object element$iv$iv;
            Map $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = $this$getDuplicates;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                element$iv$iv = iterator.next();
                Object key$iv$iv = keySelector.invoke(element$iv$iv);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$filter$iv = destination$iv$iv;
            boolean $i$f$filter = false;
            $this$groupByTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object it = element$iv$iv = (Map.Entry)iterator.next();
                boolean bl = false;
                if (!(((List)it.getValue()).size() > 1)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            map = destination$iv$iv;
        }
        return map;
    }

    @NotNull
    public static final <T> Set<T> getDuplicates(@NotNull Collection<? extends T> $this$getDuplicates) {
        Intrinsics.checkNotNullParameter($this$getDuplicates, (String)"<this>");
        return ExtensionsKt.getDuplicates($this$getDuplicates, getDuplicates.2.INSTANCE).keySet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<Integer, Integer>> collapseToRanges(@NotNull Collection<Integer> $this$collapseToRanges) {
        Pair it;
        Pair pair;
        Collection<Pair> collection;
        List list;
        Intrinsics.checkNotNullParameter($this$collapseToRanges, (String)"<this>");
        if ($this$collapseToRanges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List ranges = new ArrayList();
        SortedSet sortedValues = CollectionsKt.toSortedSet((Iterable)$this$collapseToRanges);
        Iterable $this$zipWithNext$iv = sortedValues;
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list = CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void b;
                void a;
                Object next$iv = iterator$iv.next();
                Integer n = (Integer)next$iv;
                Integer n2 = (Integer)current$iv;
                collection = result$iv;
                boolean bl = false;
                it = pair = TuplesKt.to((Object)a, (Object)b);
                boolean bl2 = false;
                void v1 = b;
                int n3 = a.intValue() + 1;
                collection.add((Pair)(v1 == null || v1.intValue() != n3 ? pair : null));
                current$iv = next$iv;
            }
            list = result$iv;
        }
        List rangeBreaks = CollectionsKt.filterNotNull((Iterable)list);
        Integer current = null;
        current = (Integer)sortedValues.first();
        Iterable $this$mapTo$iv = rangeBreaks;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Pair pair2 = (Pair)item$iv;
            collection = ranges;
            boolean bl = false;
            Integer last = (Integer)pair2.component1();
            Integer first = (Integer)pair2.component2();
            it = pair = TuplesKt.to(current, (Object)last);
            boolean bl3 = false;
            current = first;
            collection.add(pair);
        }
        ((Collection)ranges).add(TuplesKt.to(current, sortedValues.last()));
        return ranges;
    }

    @NotNull
    public static final String prettyPrintRanges(@NotNull Collection<Pair<Integer, Integer>> $this$prettyPrintRanges) {
        Intrinsics.checkNotNullParameter($this$prettyPrintRanges, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$prettyPrintRanges, null, null, null, (int)0, null, (Function1)prettyPrintRanges.1.INSTANCE, (int)31, null);
    }

    @NotNull
    public static final String format(double $this$format, int decimalPlaces) {
        String string = "%." + decimalPlaces + "f";
        Object[] objectArray = new Object[]{$this$format};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static /* synthetic */ String format$default(double d, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        return ExtensionsKt.format(d, n);
    }

    @NotNull
    public static final <E extends Enum<E>> EnumSet<E> plus(@NotNull EnumSet<E> $this$plus, @NotNull EnumSet<E> other) {
        EnumSet<E> enumSet;
        Intrinsics.checkNotNullParameter($this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        EnumSet<E> $this$plus_u24lambda_u245 = enumSet = EnumSet.copyOf($this$plus);
        boolean bl = false;
        $this$plus_u24lambda_u245.addAll(other);
        EnumSet<E> enumSet2 = enumSet;
        Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"apply(...)");
        return enumSet2;
    }

    @NotNull
    public static final File expandTilde(@NotNull File $this$expandTilde) {
        Intrinsics.checkNotNullParameter((Object)$this$expandTilde, (String)"<this>");
        String string = $this$expandTilde.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        File file = new File(ExtensionsKt.expandTilde(string)).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAbsoluteFile(...)");
        return file;
    }

    public static final boolean isSymbolicLink(@NotNull File $this$isSymbolicLink) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isSymbolicLink, (String)"<this>");
        Object object2 = $this$isSymbolicLink;
        try {
            File $this$isSymbolicLink_u24lambda_u247 = object2;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            BasicFileAttributes it = Files.readAttributes($this$isSymbolicLink_u24lambda_u247.toPath(), BasicFileAttributes.class, linkOptionArray);
            boolean bl2 = false;
            object = Result.constructor-impl((Object)(it.isSymbolicLink() || Os.INSTANCE.isWindows() && it.isOther() ? 1 : 0));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    @NotNull
    public static final File realFile(@NotNull File $this$realFile) {
        Intrinsics.checkNotNullParameter((Object)$this$realFile, (String)"<this>");
        File file = $this$realFile.toPath().toRealPath(new LinkOption[0]).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void safeDeleteRecursively(@NotNull File $this$safeDeleteRecursively, boolean force, @Nullable File baseDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$safeDeleteRecursively, (String)"<this>");
        if ($this$safeDeleteRecursively.isDirectory() && !ExtensionsKt.isSymbolicLink($this$safeDeleteRecursively)) {
            Closeable closeable = Files.newDirectoryStream($this$safeDeleteRecursively.toPath());
            Throwable throwable = null;
            try {
                DirectoryStream stream = (DirectoryStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)stream);
                Iterable $this$forEach$iv = stream;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path path = (Path)element$iv;
                    boolean bl2 = false;
                    File file = path.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    ExtensionsKt.safeDeleteRecursively$default(file, force, null, 2, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if (Intrinsics.areEqual((Object)baseDirectory, (Object)$this$safeDeleteRecursively)) {
            return;
        }
        if (!$this$safeDeleteRecursively.delete() && force && $this$safeDeleteRecursively.setWritable(true)) {
            $this$safeDeleteRecursively.delete();
        }
        if (baseDirectory != null) {
            for (File parent = $this$safeDeleteRecursively.getParentFile(); parent != null && !Intrinsics.areEqual((Object)parent, (Object)baseDirectory) && parent.delete(); parent = parent.getParentFile()) {
            }
        }
        if ($this$safeDeleteRecursively.exists()) {
            throw new IOException("Could not delete file '" + $this$safeDeleteRecursively.getAbsolutePath() + "'.");
        }
    }

    public static /* synthetic */ void safeDeleteRecursively$default(File file, boolean bl, File file2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            file2 = null;
        }
        ExtensionsKt.safeDeleteRecursively(file, bl, file2);
    }

    @NotNull
    public static final File safeMkdirs(@NotNull File $this$safeMkdirs) {
        Intrinsics.checkNotNullParameter((Object)$this$safeMkdirs, (String)"<this>");
        if ($this$safeMkdirs.isDirectory() || $this$safeMkdirs.mkdirs() || $this$safeMkdirs.isDirectory()) {
            return $this$safeMkdirs;
        }
        throw new IOException("Could not create directory '" + $this$safeMkdirs.getAbsolutePath() + "'.");
    }

    @Nullable
    public static final File searchUpwardsForSubdirectory(@NotNull File $this$searchUpwardsForSubdirectory, @NotNull String searchDirName) {
        File currentDir;
        Intrinsics.checkNotNullParameter((Object)$this$searchUpwardsForSubdirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)searchDirName, (String)"searchDirName");
        if (!$this$searchUpwardsForSubdirectory.isDirectory()) {
            return null;
        }
        for (currentDir = $this$searchUpwardsForSubdirectory.getAbsoluteFile(); currentDir != null && !FilesKt.resolve((File)currentDir, (String)searchDirName).isDirectory(); currentDir = currentDir.getParentFile()) {
        }
        return currentDir;
    }

    @NotNull
    public static final String getFormatSizeInMib(@NotNull File $this$formatSizeInMib) {
        Intrinsics.checkNotNullParameter((Object)$this$formatSizeInMib, (String)"<this>");
        return ExtensionsKt.format$default(ExtensionsKt.bytesToMib($this$formatSizeInMib.length()), 0, 1, null) + " MiB";
    }

    @NotNull
    public static final URI toSafeUri(@NotNull File $this$toSafeUri) {
        Intrinsics.checkNotNullParameter((Object)$this$toSafeUri, (String)"<this>");
        URI fileUri = $this$toSafeUri.toURI();
        return new URI("file", "", fileUri.getPath(), fileUri.getQuery(), fileUri.getFragment());
    }

    public static final long getKibibytes(int $this$kibibytes) {
        boolean $i$f$getKibibytes = false;
        return (long)$this$kibibytes * 1024L;
    }

    public static final long getMebibytes(int $this$mebibytes) {
        boolean $i$f$getMebibytes = false;
        int $this$kibibytes$iv = $this$mebibytes;
        boolean $i$f$getKibibytes = false;
        return (long)$this$kibibytes$iv * 1024L * 1024L;
    }

    public static final long getGibibytes(int $this$gibibytes) {
        boolean $i$f$getGibibytes = false;
        int $this$mebibytes$iv = $this$gibibytes;
        boolean $i$f$getMebibytes = false;
        int $this$kibibytes$iv$iv = $this$mebibytes$iv;
        boolean $i$f$getKibibytes = false;
        return (long)$this$kibibytes$iv$iv * 1024L * 1024L * 1024L;
    }

    @Nullable
    public static final <T> T nextOrNull(@NotNull Iterator<? extends T> $this$nextOrNull) {
        Intrinsics.checkNotNullParameter($this$nextOrNull, (String)"<this>");
        return $this$nextOrNull.hasNext() ? (T)$this$nextOrNull.next() : null;
    }

    @NotNull
    public static final Iterator<String> fieldNamesOrEmpty(@Nullable JsonNode $this$fieldNamesOrEmpty) {
        JsonNode jsonNode = $this$fieldNamesOrEmpty;
        Iterator iterator = jsonNode != null ? jsonNode.fieldNames() : null;
        if (iterator == null) {
            Iterator iterator2 = ClassUtil.emptyIterator();
            iterator = iterator2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"emptyIterator(...)");
        }
        return iterator;
    }

    @NotNull
    public static final Iterator<Map.Entry<String, JsonNode>> fieldsOrEmpty(@Nullable JsonNode $this$fieldsOrEmpty) {
        JsonNode jsonNode = $this$fieldsOrEmpty;
        Iterator iterator = jsonNode != null ? jsonNode.fields() : null;
        if (iterator == null) {
            Iterator iterator2 = ClassUtil.emptyIterator();
            iterator = iterator2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"emptyIterator(...)");
        }
        return iterator;
    }

    @NotNull
    public static final String textValueOrEmpty(@Nullable JsonNode $this$textValueOrEmpty) {
        JsonNode jsonNode = $this$textValueOrEmpty;
        String string = jsonNode != null ? jsonNode.textValue() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, W> Map<K, W> zip(@NotNull Map<K, ? extends V> $this$zip, @NotNull Map<K, ? extends V> other, @NotNull Function2<? super V, ? super V, ? extends W> operation) {
        Intrinsics.checkNotNullParameter($this$zip, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        boolean $i$f$zip = false;
        Iterable $this$associateWith$iv = SetsKt.plus($this$zip.keySet(), (Iterable)other.keySet());
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void key;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            Object t2 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Object object = operation.invoke($this$zip.get(key), other.get(key));
            map.put(t2, object);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, W> Map<K, W> zipWithDefault(@NotNull Map<K, ? extends V> $this$zipWithDefault, @NotNull Map<K, ? extends V> other, V v, @NotNull Function2<? super V, ? super V, ? extends W> operation) {
        Intrinsics.checkNotNullParameter($this$zipWithDefault, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        boolean $i$f$zipWithDefault = false;
        Iterable $this$associateWith$iv = SetsKt.plus($this$zipWithDefault.keySet(), (Iterable)other.keySet());
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            V v2;
            void key;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            Object t2 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            V v3 = $this$zipWithDefault.get(key);
            if (v3 == null) {
                v3 = v;
            }
            if ((v2 = other.get(key)) == null) {
                v2 = v;
            }
            Object object = operation.invoke(v3, v2);
            map.put(t2, object);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V extends Collection<? extends T>, T> Map<K, V> zipWithCollections(@NotNull Map<K, ? extends V> $this$zipWithCollections, @NotNull Map<K, ? extends V> other) {
        Intrinsics.checkNotNullParameter($this$zipWithCollections, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Map<K, V> $this$zip$iv = $this$zipWithCollections;
        boolean $i$f$zip = false;
        Iterable $this$associateWith$iv$iv = SetsKt.plus($this$zip$iv.keySet(), (Iterable)other.keySet());
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv$iv = $this$associateWith$iv$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Collection collection;
            void b;
            void key$iv;
            Object element$iv$iv$iv;
            Object t = element$iv$iv$iv = iterator.next();
            Object t2 = element$iv$iv$iv;
            Map map = result$iv$iv;
            boolean bl = false;
            Collection collection2 = (Collection)other.get(key$iv);
            Collection a = (Collection)$this$zip$iv.get(key$iv);
            boolean bl2 = false;
            if (a == null) {
                collection = b;
                if (collection == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
            } else if (b == null) {
                collection = a;
            } else {
                List list = CollectionsKt.plus((Collection)a, (Iterable)((Iterable)b));
                Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type V of org.ossreviewtoolkit.utils.common.ExtensionsKt.zipWithCollections$lambda$12");
                collection = list;
            }
            Collection collection3 = collection;
            map.put(t2, collection3);
        }
        return result$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="zipWithSets")
    @NotNull
    public static final <K, V extends Set<? extends T>, T> Map<K, V> zipWithSets(@NotNull Map<K, ? extends V> $this$zipWithCollections, @NotNull Map<K, ? extends V> other) {
        Intrinsics.checkNotNullParameter($this$zipWithCollections, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Map<K, V> $this$zip$iv = $this$zipWithCollections;
        boolean $i$f$zip = false;
        Iterable $this$associateWith$iv$iv = SetsKt.plus($this$zip$iv.keySet(), (Iterable)other.keySet());
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv$iv = $this$associateWith$iv$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Set set;
            void b;
            void key$iv;
            Object element$iv$iv$iv;
            Object t = element$iv$iv$iv = iterator.next();
            Object t2 = element$iv$iv$iv;
            Map map = result$iv$iv;
            boolean bl = false;
            Set set2 = (Set)other.get(key$iv);
            Set a = (Set)$this$zip$iv.get(key$iv);
            boolean bl2 = false;
            if (a == null) {
                set = b;
                if (set == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
            } else if (b == null) {
                set = a;
            } else {
                Set set3 = SetsKt.plus((Set)a, (Iterable)((Iterable)b));
                set = set3;
                Intrinsics.checkNotNull((Object)set3, (String)"null cannot be cast to non-null type V of org.ossreviewtoolkit.utils.common.ExtensionsKt.zipWithCollections$lambda$13");
            }
            Set set4 = set;
            map.put(t2, set4);
        }
        return result$iv$iv;
    }

    public static final double bytesToMib(@NotNull Number $this$bytesToMib) {
        Intrinsics.checkNotNullParameter((Object)$this$bytesToMib, (String)"<this>");
        int $this$mebibytes$iv = 1;
        boolean $i$f$getMebibytes = false;
        int $this$kibibytes$iv$iv = $this$mebibytes$iv;
        boolean $i$f$getKibibytes = false;
        return $this$bytesToMib.doubleValue() / (double)((long)$this$kibibytes$iv$iv * 1024L * 1024L);
    }

    @NotNull
    public static final String collapseWhitespace(@NotNull String $this$collapseWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$collapseWhitespace, (String)"<this>");
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)$this$collapseWhitespace)).toString();
        Regex regex = CONSECUTIVE_WHITESPACE_REGEX;
        String string = " ";
        return regex.replace(charSequence, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] decodeHex(@NotNull String $this$decodeHex) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$decodeHex, (String)"<this>");
        if (!($this$decodeHex.length() % 2 == 0)) {
            boolean $i$a$-require-ExtensionsKt$decodeHex$22 = false;
            String $i$a$-require-ExtensionsKt$decodeHex$22 = "The string must have an even number of characters.";
            throw new IllegalArgumentException($i$a$-require-ExtensionsKt$decodeHex$22.toString());
        }
        Iterable $this$map$iv = StringsKt.chunked((CharSequence)$this$decodeHex, (int)2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)Integer.parseInt((String)it, CharsKt.checkRadix((int)16)));
        }
        return CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
    }

    @NotNull
    public static final String encodeOr(@NotNull String $this$encodeOr, @NotNull String emptyValue) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$encodeOr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)emptyValue, (String)"emptyValue");
        if (!(((CharSequence)emptyValue).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CharSequence charSequence2 = $this$encodeOr;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = emptyValue;
        } else {
            charSequence = charSequence2;
        }
        return ExtensionsKt.fileSystemEncode((String)charSequence);
    }

    @NotNull
    public static final String encodeOrUnknown(@NotNull String $this$encodeOrUnknown) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeOrUnknown, (String)"<this>");
        return ExtensionsKt.encodeOr($this$encodeOrUnknown, "unknown");
    }

    @NotNull
    public static final String expandTilde(@NotNull String $this$expandTilde) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$expandTilde, (String)"<this>");
        if (Os.INSTANCE.getEnv().get("SHELL") != null) {
            CharSequence charSequence = $this$expandTilde;
            Regex regex = new Regex("^~");
            String string2 = System.getProperty("user.home");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            String string3 = Regex.Companion.escapeReplacement(string2);
            string = regex.replace(charSequence, string3);
        } else {
            string = $this$expandTilde;
        }
        return string;
    }

    @NotNull
    public static final String fileSystemEncode(@NotNull String $this$fileSystemEncode) {
        Intrinsics.checkNotNullParameter((Object)$this$fileSystemEncode, (String)"<this>");
        CharSequence charSequence = ExtensionsKt.percentEncode($this$fileSystemEncode);
        Regex regex = new Regex("(^\\.|\\.$)");
        String string = "%2E";
        return StringsKt.take((String)regex.replace(charSequence, string), (int)255);
    }

    public static final boolean isFalse(@Nullable String $this$isFalse) {
        String string = $this$isFalse;
        return string != null ? !Boolean.parseBoolean(string) : false;
    }

    public static final boolean isTrue(@Nullable String $this$isTrue) {
        String string = $this$isTrue;
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public static final boolean isValidUri(@NotNull String $this$isValidUri) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isValidUri, (String)"<this>");
        String string = $this$isValidUri;
        try {
            String $this$isValidUri_u24lambda_u2417 = string;
            boolean bl = false;
            object = Result.constructor-impl((Object)new URI($this$isValidUri_u24lambda_u2417));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return Result.isSuccess-impl((Object)object);
    }

    @NotNull
    public static final Regex getNON_LINUX_LINE_BREAKS() {
        return NON_LINUX_LINE_BREAKS;
    }

    @NotNull
    public static final String normalizeLineBreaks(@NotNull String $this$normalizeLineBreaks) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeLineBreaks, (String)"<this>");
        CharSequence charSequence = $this$normalizeLineBreaks;
        Regex regex = NON_LINUX_LINE_BREAKS;
        String string = "\n";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final String percentEncode(@NotNull String $this$percentEncode) {
        Intrinsics.checkNotNullParameter((Object)$this$percentEncode, (String)"<this>");
        String string = URLEncoder.encode($this$percentEncode, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null), (String)"*", (String)"%2A", (boolean)false, (int)4, null), (String)"%7E", (String)"~", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String replaceCredentialsInUri(@NotNull String $this$replaceCredentialsInUri, @Nullable String userInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceCredentialsInUri, (String)"<this>");
        Object object = ExtensionsKt.toUri($this$replaceCredentialsInUri, (Function1)new Function1<URI, String>(userInfo){
            final /* synthetic */ String $userInfo;
            {
                this.$userInfo = $userInfo;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull URI it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new URI(it.getScheme(), this.$userInfo, it.getHost(), it.getPort(), it.getPath(), it.getQuery(), it.getFragment()).toString();
            }
        });
        Object object2 = Result.isFailure-impl((Object)object) ? $this$replaceCredentialsInUri : object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrDefault(...)");
        return (String)object2;
    }

    public static /* synthetic */ String replaceCredentialsInUri$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return ExtensionsKt.replaceCredentialsInUri(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> splitOnWhitespace(@NotNull String $this$splitOnWhitespace) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$splitOnWhitespace, (String)"<this>");
        Sequence sequence = Regex.findAll$default((Regex)nonSpaceRegex, (CharSequence)$this$splitOnWhitespace, (int)0, (int)2, null);
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            MatchResult matchResult = (MatchResult)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        return (List)var2_2;
    }

    @NotNull
    public static final String titlecase(@NotNull String $this$titlecase) {
        Intrinsics.checkNotNullParameter((Object)$this$titlecase, (String)"<this>");
        String string = $this$titlecase.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return ExtensionsKt.uppercaseFirstChar(string);
    }

    @NotNull
    public static final Object toUri(@NotNull String $this$toUri) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toUri, (String)"<this>");
        String string = $this$toUri;
        try {
            String $this$toUri_u24lambda_u2419 = string;
            boolean bl = false;
            object = Result.constructor-impl((Object)new URI($this$toUri_u24lambda_u2419));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    @NotNull
    public static final <R> Object toUri(@NotNull String $this$toUri, @NotNull Function1<? super URI, ? extends R> transform) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toUri, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Object object2 = ExtensionsKt.toUri($this$toUri);
        if (Result.isSuccess-impl((Object)object2)) {
            Object object3;
            Object object4 = object2;
            try {
                object3 = object4;
                object3 = Result.constructor-impl((Object)transform.invoke(object3));
            }
            catch (Throwable throwable) {
                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object3;
        } else {
            object = Result.constructor-impl((Object)object2);
        }
        return object;
    }

    @NotNull
    public static final String unquote(@NotNull String $this$unquote, boolean trimWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$unquote, (String)"<this>");
        String $this$trim$iv = $this$unquote;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = trimWhitespace && CharsKt.isWhitespace((char)it) || it == '\'' || it == '\"';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    public static /* synthetic */ String unquote$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return ExtensionsKt.unquote(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String uppercaseFirstChar(@NotNull String $this$uppercaseFirstChar) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$uppercaseFirstChar, (String)"<this>");
        String string2 = $this$uppercaseFirstChar;
        if (((CharSequence)string2).length() > 0) {
            String string3;
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Character.isLowerCase((char)it)) {
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                string3 = CharsKt.titlecase((char)it, (Locale)locale);
            } else {
                string3 = String.valueOf((char)it);
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
            String string4 = string2;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        return string;
    }

    @Nullable
    public static final String withoutPrefix(@Nullable String $this$withoutPrefix, @NotNull String prefix, @NotNull Function0<String> missingPrefixValue) {
        String string;
        block3: {
            block2: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                Intrinsics.checkNotNullParameter(missingPrefixValue, (String)"missingPrefixValue");
                string = $this$withoutPrefix;
                if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)prefix)) == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it, (Object)$this$withoutPrefix) ? string2 : null;
                if (string != null) break block3;
            }
            string = (String)missingPrefixValue.invoke();
        }
        return string;
    }

    public static /* synthetic */ String withoutPrefix$default(String string, String string2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = withoutPrefix.1.INSTANCE;
        }
        return ExtensionsKt.withoutPrefix(string, string2, (Function0<String>)function0);
    }

    @Nullable
    public static final String withoutSuffix(@Nullable String $this$withoutSuffix, @NotNull String suffix, @NotNull Function0<String> missingSuffixValue) {
        String string;
        block3: {
            block2: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
                Intrinsics.checkNotNullParameter(missingSuffixValue, (String)"missingSuffixValue");
                string = $this$withoutSuffix;
                if (string == null || (string = StringsKt.removeSuffix((String)string, (CharSequence)suffix)) == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it, (Object)$this$withoutSuffix) ? string2 : null;
                if (string != null) break block3;
            }
            string = (String)missingSuffixValue.invoke();
        }
        return string;
    }

    public static /* synthetic */ String withoutSuffix$default(String string, String string2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = withoutSuffix.1.INSTANCE;
        }
        return ExtensionsKt.withoutSuffix(string, string2, (Function0<String>)function0);
    }

    @NotNull
    public static final String collectMessages(@NotNull Throwable $this$collectMessages) {
        Intrinsics.checkNotNullParameter((Object)$this$collectMessages, (String)"<this>");
        Object[] objectArray = new String[]{$this$collectMessages.getClass().getSimpleName() + ": " + $this$collectMessages.getMessage(), ExtensionsKt.collectMessages$formatCauseAndSuppressedMessages($this$collectMessages)};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<String>> getQueryParameters(@NotNull URI $this$getQueryParameters) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getQueryParameters, (String)"<this>");
        if ($this$getQueryParameters.getQuery() == null) {
            return MapsKt.emptyMap();
        }
        String string = $this$getQueryParameters.getQuery();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuery(...)");
        char[] cArray = new char[]{'&'};
        Iterable $this$groupBy$iv = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object object2;
            Object element$iv$iv = iterator.next();
            String it2 = (String)element$iv$iv;
            boolean $i$a$-groupBy-ExtensionsKt$getQueryParameters$32 = false;
            key$iv$iv = StringsKt.substringBefore$default((String)it2, (char)'=', null, (int)2, null);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            String $i$a$-groupBy-ExtensionsKt$getQueryParameters$32 = (String)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            char[] cArray2 = new char[]{','};
            object.add(StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)it, (char)'=', null, (int)2, null), (char[])cArray2, (boolean)false, (int)0, (int)6, null));
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map;
            boolean bl2 = false;
            List v = (List)entry.getValue();
            List list = CollectionsKt.flatten((Iterable)v);
            object.put(k, list);
        }
        return destination$iv$iv;
    }

    private static final String collectMessages$formatCauseAndSuppressedMessages(Throwable $this$collectMessages_u24formatCauseAndSuppressedMessages) {
        CharSequence charSequence;
        StringBuilder $this$collectMessages_u24formatCauseAndSuppressedMessages_u24lambda_u2427 = charSequence = new StringBuilder();
        boolean bl = false;
        Throwable throwable = $this$collectMessages_u24formatCauseAndSuppressedMessages.getCause();
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl2 = false;
            StringBuilder stringBuilder = $this$collectMessages_u24formatCauseAndSuppressedMessages_u24lambda_u2427.append("Caused by: " + it.getClass().getSimpleName() + ": " + it.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            String string = ExtensionsKt.collectMessages$formatCauseAndSuppressedMessages(it);
            if (string != null && (string = StringsKt.prependIndent$default((String)string, null, (int)1, null)) != null) {
                String string2;
                String p0 = string2 = string;
                boolean bl3 = false;
                $this$collectMessages_u24formatCauseAndSuppressedMessages_u24lambda_u2427.append(p0);
            }
        }
        Throwable[] throwableArray = $this$collectMessages_u24formatCauseAndSuppressedMessages.getSuppressed();
        Intrinsics.checkNotNullExpressionValue((Object)throwableArray, (String)"getSuppressed(...)");
        Object[] $this$forEach$iv = throwableArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Throwable it = (Throwable)element$iv;
            boolean bl4 = false;
            StringBuilder stringBuilder = $this$collectMessages_u24formatCauseAndSuppressedMessages_u24lambda_u2427.append("Suppressed: " + it.getClass().getSimpleName() + ": " + it.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNull((Object)it);
            String string3 = ExtensionsKt.collectMessages$formatCauseAndSuppressedMessages(it);
            if (string3 == null || (string3 = StringsKt.prependIndent$default((String)string3, null, (int)1, null)) == null) continue;
            String p0 = string = string3;
            boolean bl5 = false;
            $this$collectMessages_u24formatCauseAndSuppressedMessages_u24lambda_u2427.append(p0);
        }
        String string = charSequence.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CharSequence it = charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
        boolean bl6 = false;
        return !(((CharSequence)it).length() == 0) ? charSequence : null;
    }
}

