/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageCuration;
import org.ossreviewtoolkit.model.ResolvedPackageCurations;
import org.ossreviewtoolkit.model.RuleViolation;
import org.ossreviewtoolkit.model.ScanResult;
import org.ossreviewtoolkit.model.config.PackageConfiguration;
import org.ossreviewtoolkit.model.config.Resolutions;
import org.ossreviewtoolkit.model.utils.ResolutionProvider;
import org.ossreviewtoolkit.model.vulnerabilities.Vulnerability;
import org.ossreviewtoolkit.plugins.packageconfigurationproviders.api.PackageConfigurationProvider;
import org.ossreviewtoolkit.plugins.packagecurationproviders.api.PackageCurationProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JK\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2'\u0010\n\u001a#\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00050\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J4\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u0005J8\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00052\u0006\u0010#\u001a\u00020$\u00a8\u0006%"}, d2={"Lorg/ossreviewtoolkit/utils/config/ConfigurationResolver;", "", "<init>", "()V", "resolvePackageConfigurations", "", "Lorg/ossreviewtoolkit/model/config/PackageConfiguration;", "identifiers", "", "Lorg/ossreviewtoolkit/model/Identifier;", "scanResultProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "id", "Lorg/ossreviewtoolkit/model/ScanResult;", "packageConfigurationProvider", "Lorg/ossreviewtoolkit/plugins/packageconfigurationproviders/api/PackageConfigurationProvider;", "resolvePackageCurations", "Lorg/ossreviewtoolkit/model/ResolvedPackageCurations;", "packages", "", "Lorg/ossreviewtoolkit/model/Package;", "curationProviders", "Lkotlin/Pair;", "", "Lorg/ossreviewtoolkit/plugins/packagecurationproviders/api/PackageCurationProvider;", "resolveResolutions", "Lorg/ossreviewtoolkit/model/config/Resolutions;", "issues", "Lorg/ossreviewtoolkit/model/Issue;", "ruleViolations", "Lorg/ossreviewtoolkit/model/RuleViolation;", "vulnerabilities", "Lorg/ossreviewtoolkit/model/vulnerabilities/Vulnerability;", "resolutionProvider", "Lorg/ossreviewtoolkit/model/utils/ResolutionProvider;", "config-utils"})
@SourceDebugExtension(value={"SMAP\nConfigurationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationResolver.kt\norg/ossreviewtoolkit/utils/config/ConfigurationResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,108:1\n1368#2:109\n1454#2,2:110\n1368#2:112\n1454#2,5:113\n1456#2,3:118\n1863#2:121\n3193#2,4:126\n1755#2,3:130\n3197#2,6:133\n1864#2:141\n1368#2:146\n1454#2,5:147\n1368#2:152\n1454#2,5:153\n1368#2:158\n1454#2,5:159\n95#3:122\n135#3,3:123\n38#4:139\n38#4:140\n126#5:142\n153#5,3:143\n*S KotlinDebug\n*F\n+ 1 ConfigurationResolver.kt\norg/ossreviewtoolkit/utils/config/ConfigurationResolver\n*L\n50#1:109\n50#1:110,2\n51#1:112\n51#1:113,5\n50#1:118,3\n66#1:121\n73#1:126,4\n74#1:130,3\n73#1:133,6\n66#1:141\n103#1:146\n103#1:147,5\n104#1:152\n104#1:153,5\n105#1:158\n105#1:159,5\n67#1:122\n67#1:123,3\n78#1:139\n86#1:140\n89#1:142\n89#1:143,3\n*E\n"})
public final class ConfigurationResolver {
    @NotNull
    public static final ConfigurationResolver INSTANCE = new ConfigurationResolver();

    private ConfigurationResolver() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PackageConfiguration> resolvePackageConfigurations(@NotNull Set<Identifier> identifiers, @NotNull Function1<? super Identifier, ? extends List<ScanResult>> scanResultProvider, @NotNull PackageConfigurationProvider packageConfigurationProvider) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
        Intrinsics.checkNotNullParameter(scanResultProvider, (String)"scanResultProvider");
        Intrinsics.checkNotNullParameter((Object)packageConfigurationProvider, (String)"packageConfigurationProvider");
        Iterable $this$flatMap$iv = identifiers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            Identifier id = (Identifier)element$iv$iv;
            boolean bl = false;
            Iterable $this$flatMap$iv2 = (Iterable)scanResultProvider.invoke((Object)id);
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                ScanResult scanResult = (ScanResult)element$iv$iv2;
                boolean bl2 = false;
                Iterable list$iv$iv = packageConfigurationProvider.getPackageConfigurations(id, scanResult.getProvenance());
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResolvedPackageCurations> resolvePackageCurations(@NotNull Collection<Package> packages, @NotNull List<? extends Pair<String, ? extends PackageCurationProvider>> curationProviders) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        Intrinsics.checkNotNullParameter(curationProviders, (String)"curationProviders");
        Map packageCurations = new LinkedHashMap();
        Iterable $this$forEach$iv = curationProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurationResolver $this$logger$iv;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String id = (String)pair.component1();
            PackageCurationProvider curationProvider = (PackageCurationProvider)pair.component2();
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl2 = false;
            Set result$iv$iv = curationProvider.getCurationsFor(packages);
            TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            Set curations = (Set)timedValue.component1();
            long duration = timedValue.component2-UwyO8pc();
            Iterable $this$partition$iv = curations;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                boolean bl3;
                block7: {
                    PackageCuration curation = (PackageCuration)element$iv2;
                    boolean bl4 = false;
                    Iterable $this$any$iv = packages;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv) {
                            Package pkg = (Package)element$iv3;
                            boolean bl5 = false;
                            if (!curation.isApplicable(pkg.getId())) continue;
                            bl3 = true;
                            break block7;
                        }
                        bl3 = false;
                    }
                }
                boolean bl6 = bl3 ? first$iv.add(element$iv2) : second$iv.add(element$iv2);
            }
            Pair pair2 = new Pair(first$iv, second$iv);
            List applicableCurations = (List)pair2.component1();
            List nonApplicableCurations = (List)pair2.component2();
            if (!((Collection)nonApplicableCurations).isEmpty()) {
                $this$logger$iv = INSTANCE;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(ConfigurationResolver.class).warn(() -> ConfigurationResolver.resolvePackageCurations$lambda$7$lambda$5(id, nonApplicableCurations));
            }
            packageCurations.put(id, applicableCurations);
            $this$logger$iv = INSTANCE;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(ConfigurationResolver.class).info(() -> ConfigurationResolver.resolvePackageCurations$lambda$7$lambda$6(curations, id, duration));
        }
        Map $this$map$iv = packageCurations;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String providerId = (String)entry.getKey();
            List curations = (List)entry.getValue();
            collection.add(new ResolvedPackageCurations(new ResolvedPackageCurations.Provider(providerId), curations));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Resolutions resolveResolutions(@NotNull List<Issue> issues, @NotNull List<RuleViolation> ruleViolations, @NotNull List<Vulnerability> vulnerabilities, @NotNull ResolutionProvider resolutionProvider) {
        Iterable list$iv$iv;
        Issue it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Intrinsics.checkNotNullParameter(ruleViolations, (String)"ruleViolations");
        Intrinsics.checkNotNullParameter(vulnerabilities, (String)"vulnerabilities");
        Intrinsics.checkNotNullParameter((Object)resolutionProvider, (String)"resolutionProvider");
        Iterable $this$flatMap$iv = issues;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Issue)element$iv$iv;
            boolean bl = false;
            list$iv$iv = resolutionProvider.getResolutionsFor(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = ruleViolations;
        List list = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (RuleViolation)element$iv$iv;
            boolean bl = false;
            list$iv$iv = resolutionProvider.getResolutionsFor((RuleViolation)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = vulnerabilities;
        List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Vulnerability)element$iv$iv;
            boolean bl = false;
            list$iv$iv = resolutionProvider.getResolutionsFor((Vulnerability)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        List list4 = CollectionsKt.distinct((Iterable)list3);
        List list5 = list2;
        List list6 = list;
        return new Resolutions(list6, list5, list4);
    }

    private static final Object resolvePackageCurations$lambda$7$lambda$5(String $id, List $nonApplicableCurations) {
        return "The provider '" + $id + "' returned the following non-applicable curations: " + CollectionsKt.joinToString$default((Iterable)$nonApplicableCurations, null, null, null, (int)0, null, null, (int)63, null) + ".";
    }

    private static final Object resolvePackageCurations$lambda$7$lambda$6(Set $curations, String $id, long $duration) {
        return "Getting " + $curations.size() + " package curation(s) from provider '" + $id + "' took " + Duration.toString-impl((long)$duration) + ".";
    }
}

