/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.ort.storage;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.ort.OkHttpClientHelperKt;
import org.ossreviewtoolkit.utils.ort.storage.FileStorage;
import org.ossreviewtoolkit.utils.ort.storage.HttpFileStorage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/ossreviewtoolkit/utils/ort/storage/HttpFileStorage;", "Lorg/ossreviewtoolkit/utils/ort/storage/FileStorage;", "url", "", "query", "headers", "", "cacheMaxAgeInSeconds", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;I)V", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient", "()Lokhttp3/OkHttpClient;", "httpClient$delegate", "Lkotlin/Lazy;", "getQuery", "()Ljava/lang/String;", "getUrl", "exists", "", "path", "read", "Ljava/io/InputStream;", "urlForPath", "write", "", "inputStream", "ort-utils"})
@SourceDebugExtension(value={"SMAP\nHttpFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpFileStorage.kt\norg/ossreviewtoolkit/utils/ort/storage/HttpFileStorage\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,140:1\n38#2:141\n38#2:142\n*S KotlinDebug\n*F\n+ 1 HttpFileStorage.kt\norg/ossreviewtoolkit/utils/ort/storage/HttpFileStorage\n*L\n102#1:141\n126#1:142\n*E\n"})
public final class HttpFileStorage
implements FileStorage {
    @NotNull
    private final String url;
    @NotNull
    private final String query;
    @NotNull
    private final Map<String, String> headers;
    private final int cacheMaxAgeInSeconds;
    @NotNull
    private final Lazy httpClient$delegate;

    public HttpFileStorage(@NotNull String url, @NotNull String query, @NotNull Map<String, String> headers, int cacheMaxAgeInSeconds) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.url = url;
        this.query = query;
        this.headers = headers;
        this.cacheMaxAgeInSeconds = cacheMaxAgeInSeconds;
        this.httpClient$delegate = LazyKt.lazy((Function0)httpClient.2.INSTANCE);
    }

    public /* synthetic */ HttpFileStorage(String string, String string2, Map map, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(string, string2, map, n);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getQuery() {
        return this.query;
    }

    private final OkHttpClient getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Request request = new Request.Builder().headers(Headers.Companion.of(this.headers)).cacheControl(new CacheControl.Builder().maxAge(this.cacheMaxAgeInSeconds, TimeUnit.SECONDS).build()).head().url(this.urlForPath(path)).build();
        return OkHttpClientHelperKt.execute(this.getHttpClient(), request).isSuccessful();
    }

    @Override
    @NotNull
    public InputStream read(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Request request = new Request.Builder().headers(Headers.Companion.of(this.headers)).cacheControl(new CacheControl.Builder().maxAge(this.cacheMaxAgeInSeconds, TimeUnit.SECONDS).build()).get().url(this.urlForPath(path)).build();
        HttpFileStorage $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(HttpFileStorage.class).debug((Function0)new Function0<Object>(request){
            final /* synthetic */ Request $request;
            {
                this.$request = $request;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Reading file from storage: " + this.$request.url();
            }
        });
        Response response = OkHttpClientHelperKt.execute(this.getHttpClient(), request);
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                ResponseBody body = responseBody;
                boolean bl = false;
                return body.byteStream();
            }
            response.close();
            throw new IOException("The response body must not be null.");
        }
        response.close();
        throw new IOException("Could not read from '" + request.url() + "': " + response.code() + " - " + response.message());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull String path, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Request request = new Request.Builder().headers(Headers.Companion.of(this.headers)).put(RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])ByteStreamsKt.readBytes((InputStream)it), null, (int)0, (int)0, (int)7, null)).url(this.urlForPath(path)).build();
            HttpFileStorage $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(HttpFileStorage.class).debug((Function0)new Function0<Object>(request){
                final /* synthetic */ Request $request;
                {
                    this.$request = $request;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Writing file to storage: " + this.$request.url();
                }
            });
            Closeable closeable2 = (Closeable)OkHttpClientHelperKt.execute(this.getHttpClient(), request);
            Throwable throwable2 = null;
            try {
                Response response = (Response)closeable2;
                boolean bl2 = false;
                if (!response.isSuccessful()) {
                    throw new IOException("Could not store file at '" + request.url() + "': " + response.code() + " - " + response.message());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            return;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String urlForPath(String path) {
        return this.url + "/" + path + this.query;
    }
}

