/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.ort.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.ort.storage.FileStorage;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BG\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0014H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/ossreviewtoolkit/utils/ort/storage/S3FileStorage;", "Lorg/ossreviewtoolkit/utils/ort/storage/FileStorage;", "accessKeyId", "", "awsRegion", "bucketName", "compression", "", "customEndpoint", "secretAccessKey", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "s3Client", "Lsoftware/amazon/awssdk/services/s3/S3Client;", "getS3Client", "()Lsoftware/amazon/awssdk/services/s3/S3Client;", "s3Client$delegate", "Lkotlin/Lazy;", "exists", "path", "read", "Ljava/io/InputStream;", "write", "", "inputStream", "ort-utils"})
@SourceDebugExtension(value={"SMAP\nS3FileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 S3FileStorage.kt\norg/ossreviewtoolkit/utils/ort/storage/S3FileStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,140:1\n1#2:141\n38#3:142\n38#3:143\n*S KotlinDebug\n*F\n+ 1 S3FileStorage.kt\norg/ossreviewtoolkit/utils/ort/storage/S3FileStorage\n*L\n97#1:142\n136#1:143\n*E\n"})
public final class S3FileStorage
implements FileStorage {
    @Nullable
    private final String accessKeyId;
    @Nullable
    private final String awsRegion;
    @NotNull
    private final String bucketName;
    private final boolean compression;
    @Nullable
    private final String customEndpoint;
    @Nullable
    private final String secretAccessKey;
    @NotNull
    private final Lazy s3Client$delegate;

    public S3FileStorage(@Nullable String accessKeyId, @Nullable String awsRegion, @NotNull String bucketName, boolean compression, @Nullable String customEndpoint, @Nullable String secretAccessKey) {
        Intrinsics.checkNotNullParameter((Object)bucketName, (String)"bucketName");
        this.accessKeyId = accessKeyId;
        this.awsRegion = awsRegion;
        this.bucketName = bucketName;
        this.compression = compression;
        this.customEndpoint = customEndpoint;
        this.secretAccessKey = secretAccessKey;
        this.s3Client$delegate = LazyKt.lazy((Function0)((Function0)new Function0<S3Client>(this){
            final /* synthetic */ S3FileStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final S3Client invoke() {
                S3Client s3Client2;
                StaticCredentialsProvider provider;
                StaticCredentialsProvider staticCredentialsProvider = provider = S3FileStorage.access$getAccessKeyId$p(this.this$0) != null && S3FileStorage.access$getSecretAccessKey$p(this.this$0) != null ? StaticCredentialsProvider.create((AwsCredentials)((AwsCredentials)AwsBasicCredentials.create((String)S3FileStorage.access$getAccessKeyId$p(this.this$0), (String)S3FileStorage.access$getSecretAccessKey$p(this.this$0)))) : null;
                if (S3FileStorage.access$getAwsRegion$p(this.this$0) != null && provider != null) {
                    S3ClientBuilder s3ClientBuilder = S3Client.builder();
                    S3FileStorage s3FileStorage = this.this$0;
                    S3ClientBuilder $this$invoke_u24lambda_u240 = s3ClientBuilder;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.region(Region.of((String)S3FileStorage.access$getAwsRegion$p(s3FileStorage)));
                    $this$invoke_u24lambda_u240.credentialsProvider((AwsCredentialsProvider)provider);
                    $this$invoke_u24lambda_u240.endpointOverride(S3FileStorage.access$getCustomEndpoint$p(s3FileStorage) != null ? URI.create(S3FileStorage.access$getCustomEndpoint$p(s3FileStorage)) : null);
                    s3Client2 = (S3Client)s3ClientBuilder.build();
                } else {
                    s3Client2 = S3FileStorage.access$getAwsRegion$p(this.this$0) != null ? (S3Client)((S3ClientBuilder)S3Client.builder().region(Region.of((String)S3FileStorage.access$getAwsRegion$p(this.this$0)))).build() : S3Client.create();
                }
                return s3Client2;
            }
        }));
    }

    public /* synthetic */ S3FileStorage(String string, String string2, String string3, boolean bl, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            string5 = null;
        }
        this(string, string2, string3, bl, string4, string5);
    }

    private final S3Client getS3Client() {
        Lazy lazy = this.s3Client$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (S3Client)object;
    }

    @Override
    public boolean exists(@NotNull String path) {
        Object object;
        block3: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            HeadObjectRequest.Builder $this$exists_u24lambda_u240 = object = HeadObjectRequest.builder();
            boolean bl = false;
            $this$exists_u24lambda_u240.key(path);
            $this$exists_u24lambda_u240.bucket(this.bucketName);
            HeadObjectRequest request = (HeadObjectRequest)object.build();
            object = this;
            try {
                S3FileStorage $this$exists_u24lambda_u241 = (S3FileStorage)object;
                boolean bl2 = false;
                object2 = Result.constructor-impl((Object)$this$exists_u24lambda_u241.getS3Client().headObject(request));
            }
            catch (Throwable bl2) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block3;
            Object exception = object2 = throwable;
            boolean bl3 = false;
            if (!(exception instanceof NoSuchKeyException)) {
                S3FileStorage $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(S3FileStorage.class).warn((Function0)new Function0<Object>(path, (Throwable)exception){
                    final /* synthetic */ String $path;
                    final /* synthetic */ Throwable $exception;
                    {
                        this.$path = $path;
                        this.$exception = $exception;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to retrieve status for S3 key " + this.$path + ". Error: " + this.$exception.getMessage();
                    }
                });
            }
        }
        return Result.isSuccess-impl((Object)object);
    }

    @Override
    @NotNull
    public InputStream read(@NotNull String path) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GetObjectRequest.Builder $this$read_u24lambda_u243 = object2 = GetObjectRequest.builder();
        boolean bl = false;
        $this$read_u24lambda_u243.key(path);
        $this$read_u24lambda_u243.bucket(this.bucketName);
        GetObjectRequest request = (GetObjectRequest)object2.build();
        object2 = this;
        try {
            S3FileStorage $this$read_u24lambda_u244 = (S3FileStorage)object2;
            boolean bl2 = false;
            ResponseBytes response = $this$read_u24lambda_u244.getS3Client().getObjectAsBytes(request);
            ByteArrayInputStream stream = new ByteArrayInputStream(response.asByteArray());
            object = Result.constructor-impl((Object)($this$read_u24lambda_u244.compression ? (InputStream)new XZCompressorInputStream((InputStream)stream) : (InputStream)stream));
        }
        catch (Throwable bl2) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object exception = object = throwable;
            boolean bl3 = false;
            if (exception instanceof NoSuchKeyException) {
                throw new NoSuchFileException(new File(path), null, null, 6, null);
            }
        }
        ResultKt.throwOnFailure((Object)object2);
        return (InputStream)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull String path, @NotNull InputStream inputStream) {
        block11: {
            Object object;
            PutObjectRequest.Builder builder;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            PutObjectRequest.Builder $this$write_u24lambda_u246 = builder = PutObjectRequest.builder();
            boolean $i$a$-apply-S3FileStorage$write$request$22 = false;
            $this$write_u24lambda_u246.key(path);
            $this$write_u24lambda_u246.bucket(this.bucketName);
            PutObjectRequest request = (PutObjectRequest)builder.build();
            Object object2 = inputStream;
            Throwable $i$a$-apply-S3FileStorage$write$request$22 = null;
            try {
                RequestBody requestBody;
                InputStream it = (InputStream)object2;
                boolean bl = false;
                if (this.compression) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    new XZCompressorOutputStream((OutputStream)stream).write(ByteStreamsKt.readBytes((InputStream)it));
                    requestBody = RequestBody.fromBytes((byte[])stream.toByteArray());
                } else {
                    requestBody = RequestBody.fromBytes((byte[])ByteStreamsKt.readBytes((InputStream)it));
                }
                it = requestBody;
            }
            catch (Throwable it) {
                $i$a$-apply-S3FileStorage$write$request$22 = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)$i$a$-apply-S3FileStorage$write$request$22);
            }
            InputStream body = it;
            object2 = this;
            try {
                S3FileStorage $this$write_u24lambda_u248 = (S3FileStorage)object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)$this$write_u24lambda_u248.getS3Client().putObject(request, (RequestBody)body));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block11;
            Object exception = object = throwable;
            boolean bl = false;
            if (exception instanceof S3Exception) {
                S3FileStorage $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(S3FileStorage.class).warn((Function0)new Function0<Object>(path, this){
                    final /* synthetic */ String $path;
                    final /* synthetic */ S3FileStorage this$0;
                    {
                        this.$path = $path;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Can not write '" + this.$path + "' to S3 bucket '" + S3FileStorage.access$getBucketName$p(this.this$0) + "'.";
                    }
                });
            }
        }
    }

    public static final /* synthetic */ String access$getBucketName$p(S3FileStorage $this) {
        return $this.bucketName;
    }

    public static final /* synthetic */ String access$getAccessKeyId$p(S3FileStorage $this) {
        return $this.accessKeyId;
    }

    public static final /* synthetic */ String access$getSecretAccessKey$p(S3FileStorage $this) {
        return $this.secretAccessKey;
    }

    public static final /* synthetic */ String access$getAwsRegion$p(S3FileStorage $this) {
        return $this.awsRegion;
    }

    public static final /* synthetic */ String access$getCustomEndpoint$p(S3FileStorage $this) {
        return $this.customEndpoint;
    }
}

