/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.ort.storage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.utils.ort.storage.LocalFileStorage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/ossreviewtoolkit/utils/ort/storage/XZCompressedLocalFileStorage;", "Lorg/ossreviewtoolkit/utils/ort/storage/LocalFileStorage;", "directory", "Ljava/io/File;", "(Ljava/io/File;)V", "read", "Ljava/io/InputStream;", "path", "", "safeOutputStream", "Lorg/apache/commons/compress/compressors/xz/XZCompressorOutputStream;", "transformPath", "ort-utils"})
public final class XZCompressedLocalFileStorage
extends LocalFileStorage {
    public XZCompressedLocalFileStorage(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        super(directory);
    }

    @Override
    @NotNull
    public String transformPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path + ".xz";
    }

    @Override
    @NotNull
    public InputStream read(@NotNull String path) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            inputStream = (InputStream)new XZCompressorInputStream(super.read(this.transformPath(path)));
        }
        catch (FileNotFoundException compressedFileNotFoundException) {
            InputStream inputStream2;
            try {
                inputStream2 = super.read(path);
            }
            catch (FileNotFoundException uncompressedFileNotFoundException) {
                Throwable throwable = uncompressedFileNotFoundException.initCause(compressedFileNotFoundException);
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
                throw throwable;
            }
            inputStream = inputStream2;
        }
        return inputStream;
    }

    @NotNull
    protected XZCompressorOutputStream safeOutputStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new XZCompressorOutputStream(super.safeOutputStream(this.transformPath(path)));
    }
}

