/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.ort.storage;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.CacheControl;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.utils.ort.OkHttpClientHelper;
import org.ossreviewtoolkit.utils.ort.OkHttpClientHelperKt;
import org.ossreviewtoolkit.utils.ort.storage.FileStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lorg/ossreviewtoolkit/utils/ort/storage/HttpFileStorage;", "Lorg/ossreviewtoolkit/utils/ort/storage/FileStorage;", "url", "", "query", "headers", "", "cacheMaxAgeInSeconds", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;I)V", "getUrl", "()Ljava/lang/String;", "getQuery", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient", "()Lokhttp3/OkHttpClient;", "httpClient$delegate", "Lkotlin/Lazy;", "requestBuilder", "Lokhttp3/Request$Builder;", "exists", "", "path", "read", "Ljava/io/InputStream;", "write", "", "inputStream", "urlForPath", "delete", "ort-utils"})
@SourceDebugExtension(value={"SMAP\nHttpFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpFileStorage.kt\norg/ossreviewtoolkit/utils/ort/storage/HttpFileStorage\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,152:1\n38#2:153\n38#2:154\n38#2:155\n*S KotlinDebug\n*F\n+ 1 HttpFileStorage.kt\norg/ossreviewtoolkit/utils/ort/storage/HttpFileStorage\n*L\n103#1:153\n126#1:154\n146#1:155\n*E\n"})
public final class HttpFileStorage
implements FileStorage {
    @NotNull
    private final String url;
    @NotNull
    private final String query;
    @NotNull
    private final Map<String, String> headers;
    private final int cacheMaxAgeInSeconds;
    @NotNull
    private final Lazy httpClient$delegate;

    public HttpFileStorage(@NotNull String url, @NotNull String query, @NotNull Map<String, String> headers, int cacheMaxAgeInSeconds) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.url = url;
        this.query = query;
        this.headers = headers;
        this.cacheMaxAgeInSeconds = cacheMaxAgeInSeconds;
        this.httpClient$delegate = LazyKt.lazy(HttpFileStorage::httpClient_delegate$lambda$1);
    }

    public /* synthetic */ HttpFileStorage(String string, String string2, Map map, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(string, string2, map, n);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getQuery() {
        return this.query;
    }

    private final OkHttpClient getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    private final Request.Builder requestBuilder() {
        return new Request.Builder().headers(Headers.Companion.of(this.headers)).cacheControl(new CacheControl.Builder().maxAge(this.cacheMaxAgeInSeconds, TimeUnit.SECONDS).build());
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Request request = this.requestBuilder().head().url(this.urlForPath(path)).build();
        return OkHttpClientHelperKt.execute(this.getHttpClient(), request).isSuccessful();
    }

    @Override
    @NotNull
    public InputStream read(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Request request = this.requestBuilder().get().url(this.urlForPath(path)).build();
        HttpFileStorage $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(HttpFileStorage.class).debug(() -> HttpFileStorage.read$lambda$2(request));
        Response response = OkHttpClientHelperKt.execute(this.getHttpClient(), request);
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                ResponseBody body = responseBody;
                boolean bl = false;
                return body.byteStream();
            }
            response.close();
            throw new IOException("The response body must not be null.");
        }
        response.close();
        throw new IOException("Could not read from " + request.url() + ": " + response.code() + " - " + response.message());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull String path, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Request request = this.requestBuilder().put(RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])ByteStreamsKt.readBytes((InputStream)it), null, (int)0, (int)0, (int)7, null)).url(this.urlForPath(path)).build();
            HttpFileStorage $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(HttpFileStorage.class).debug(() -> HttpFileStorage.write$lambda$6$lambda$4(request));
            Closeable closeable2 = (Closeable)OkHttpClientHelperKt.execute(this.getHttpClient(), request);
            Throwable throwable2 = null;
            try {
                Response response = (Response)closeable2;
                boolean bl2 = false;
                if (!response.isSuccessful()) {
                    throw new IOException("Could not store file at " + request.url() + ": " + response.code() + " - " + response.message());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            return;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String urlForPath(String path) {
        return this.url + "/" + path + this.query;
    }

    @Override
    public boolean delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Request request = Request.Builder.delete$default((Request.Builder)this.requestBuilder(), null, (int)1, null).url(this.urlForPath(path)).build();
        HttpFileStorage $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(HttpFileStorage.class).debug(() -> HttpFileStorage.delete$lambda$7(request));
        Response response = OkHttpClientHelperKt.execute(this.getHttpClient(), request);
        return response.isSuccessful();
    }

    private static final Unit httpClient_delegate$lambda$1$lambda$0(OkHttpClient.Builder $this$buildClient) {
        Intrinsics.checkNotNullParameter((Object)$this$buildClient, (String)"$this$buildClient");
        ConnectionPool connectionPool = new ConnectionPool(5, 60L, TimeUnit.SECONDS);
        $this$buildClient.connectionPool(connectionPool);
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        $this$buildClient.connectTimeout(duration);
        return Unit.INSTANCE;
    }

    private static final OkHttpClient httpClient_delegate$lambda$1() {
        return OkHttpClientHelper.INSTANCE.buildClient((Function1<? super OkHttpClient.Builder, Unit>)((Function1)HttpFileStorage::httpClient_delegate$lambda$1$lambda$0));
    }

    private static final Object read$lambda$2(Request $request) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        return "Reading file from storage: " + $request.url();
    }

    private static final Object write$lambda$6$lambda$4(Request $request) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        return "Writing file to storage: " + $request.url();
    }

    private static final Object delete$lambda$7(Request $request) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        return "Deleting file from storage: " + $request.url();
    }
}

