/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.ort.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.ort.storage.FileStorage;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BI\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/ossreviewtoolkit/utils/ort/storage/S3FileStorage;", "Lorg/ossreviewtoolkit/utils/ort/storage/FileStorage;", "accessKeyId", "", "awsRegion", "bucketName", "compression", "", "customEndpoint", "secretAccessKey", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "s3Client", "Lsoftware/amazon/awssdk/services/s3/S3Client;", "getS3Client", "()Lsoftware/amazon/awssdk/services/s3/S3Client;", "s3Client$delegate", "Lkotlin/Lazy;", "exists", "path", "read", "Ljava/io/InputStream;", "write", "", "inputStream", "delete", "ort-utils"})
@SourceDebugExtension(value={"SMAP\nS3FileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 S3FileStorage.kt\norg/ossreviewtoolkit/utils/ort/storage/S3FileStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,151:1\n1#2:152\n38#3:153\n38#3:154\n*S KotlinDebug\n*F\n+ 1 S3FileStorage.kt\norg/ossreviewtoolkit/utils/ort/storage/S3FileStorage\n*L\n98#1:153\n137#1:154\n*E\n"})
public final class S3FileStorage
implements FileStorage {
    @Nullable
    private final String accessKeyId;
    @Nullable
    private final String awsRegion;
    @NotNull
    private final String bucketName;
    private final boolean compression;
    @Nullable
    private final String customEndpoint;
    @Nullable
    private final String secretAccessKey;
    @NotNull
    private final Lazy s3Client$delegate;

    public S3FileStorage(@Nullable String accessKeyId, @Nullable String awsRegion, @NotNull String bucketName, boolean compression, @Nullable String customEndpoint, @Nullable String secretAccessKey) {
        Intrinsics.checkNotNullParameter((Object)bucketName, (String)"bucketName");
        this.accessKeyId = accessKeyId;
        this.awsRegion = awsRegion;
        this.bucketName = bucketName;
        this.compression = compression;
        this.customEndpoint = customEndpoint;
        this.secretAccessKey = secretAccessKey;
        this.s3Client$delegate = LazyKt.lazy(() -> S3FileStorage.s3Client_delegate$lambda$0(this));
    }

    public /* synthetic */ S3FileStorage(String string, String string2, String string3, boolean bl, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            string5 = null;
        }
        this(string, string2, string3, bl, string4, string5);
    }

    private final S3Client getS3Client() {
        Lazy lazy = this.s3Client$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (S3Client)object;
    }

    @Override
    public boolean exists(@NotNull String path) {
        Object object;
        block3: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().key(path).bucket(this.bucketName).build();
            object = this;
            try {
                S3FileStorage $this$exists_u24lambda_u241 = object;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)$this$exists_u24lambda_u241.getS3Client().headObject(request));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block3;
            Object exception = object2 = throwable;
            boolean bl = false;
            if (!(exception instanceof NoSuchKeyException)) {
                S3FileStorage $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(S3FileStorage.class).warn(() -> S3FileStorage.exists$lambda$3$lambda$2(path, (Throwable)exception));
            }
        }
        return Result.isSuccess-impl((Object)object);
    }

    @Override
    @NotNull
    public InputStream read(@NotNull String path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().key(path).bucket(this.bucketName).build();
        Object object2 = this;
        try {
            S3FileStorage $this$read_u24lambda_u244 = object2;
            boolean bl = false;
            ResponseBytes response = $this$read_u24lambda_u244.getS3Client().getObjectAsBytes(request);
            ByteArrayInputStream stream = new ByteArrayInputStream(response.asByteArray());
            object = Result.constructor-impl((Object)($this$read_u24lambda_u244.compression ? (InputStream)new XZCompressorInputStream((InputStream)stream) : (InputStream)stream));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object exception = object = throwable;
            boolean bl = false;
            if (exception instanceof NoSuchKeyException) {
                throw new NoSuchFileException(new File(path), null, null, 6, null);
            }
        }
        ResultKt.throwOnFailure((Object)object2);
        return (InputStream)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull String path, @NotNull InputStream inputStream) {
        block11: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().key(path).bucket(this.bucketName).build();
            Object object = inputStream;
            Object object2 = null;
            try {
                RequestBody requestBody;
                InputStream it = (InputStream)object;
                boolean bl = false;
                if (this.compression) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    new XZCompressorOutputStream((OutputStream)stream).write(ByteStreamsKt.readBytes((InputStream)it));
                    requestBody = RequestBody.fromBytes((byte[])stream.toByteArray());
                } else {
                    requestBody = RequestBody.fromBytes((byte[])ByteStreamsKt.readBytes((InputStream)it));
                }
                it = requestBody;
            }
            catch (Throwable it) {
                object2 = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            InputStream body = it;
            object = this;
            try {
                S3FileStorage $this$write_u24lambda_u247 = (S3FileStorage)object;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)$this$write_u24lambda_u247.getS3Client().putObject(request, (RequestBody)body));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block11;
            Object exception = object2 = throwable;
            boolean bl = false;
            if (exception instanceof S3Exception) {
                S3FileStorage $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(S3FileStorage.class).warn(() -> S3FileStorage.write$lambda$9$lambda$8(path, this));
            }
        }
    }

    @Override
    public boolean delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DeleteObjectRequest request = (DeleteObjectRequest)DeleteObjectRequest.builder().key(path).bucket(this.bucketName).build();
        DeleteObjectResponse response = this.getS3Client().deleteObject(request);
        return response.sdkHttpResponse().isSuccessful();
    }

    private static final S3Client s3Client_delegate$lambda$0(S3FileStorage this$0) {
        StaticCredentialsProvider provider;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        StaticCredentialsProvider staticCredentialsProvider = provider = this$0.accessKeyId != null && this$0.secretAccessKey != null ? StaticCredentialsProvider.create((AwsCredentials)((AwsCredentials)AwsBasicCredentials.create((String)this$0.accessKeyId, (String)this$0.secretAccessKey))) : null;
        return this$0.awsRegion != null && provider != null ? (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)this$0.awsRegion))).credentialsProvider((AwsCredentialsProvider)provider)).endpointOverride(this$0.customEndpoint != null ? URI.create(this$0.customEndpoint) : null)).build() : (this$0.awsRegion != null ? (S3Client)((S3ClientBuilder)S3Client.builder().region(Region.of((String)this$0.awsRegion))).build() : S3Client.create());
    }

    private static final Object exists$lambda$3$lambda$2(String $path, Throwable $exception) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
        return "Unable to retrieve status for S3 key " + $path + ". Error: " + $exception.getMessage();
    }

    private static final Object write$lambda$9$lambda$8(String $path, S3FileStorage this$0) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Can not write '" + $path + "' to S3 bucket '" + this$0.bucketName + "'.";
    }
}

