/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.ort;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.StringSortedSetConverter;
import org.ossreviewtoolkit.utils.ort.CopyrightStatementsProcessorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a8\u0006\u000e"}, d2={"Lorg/ossreviewtoolkit/utils/ort/CopyrightStatementsProcessor;", "", "<init>", "()V", "determineParts", "Lorg/ossreviewtoolkit/utils/ort/CopyrightStatementsProcessor$Parts;", "copyrightStatement", "", "process", "Lorg/ossreviewtoolkit/utils/ort/CopyrightStatementsProcessor$Result;", "copyrightStatements", "", "Parts", "Result", "ort-utils"})
@SourceDebugExtension(value={"SMAP\nCopyrightStatementsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyrightStatementsProcessor.kt\norg/ossreviewtoolkit/utils/ort/CopyrightStatementsProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,316:1\n1863#2,2:317\n1863#2,2:319\n1557#2:321\n1628#2,3:322\n2341#2,14:325\n1863#2,2:345\n434#3:339\n507#3,5:340\n*S KotlinDebug\n*F\n+ 1 CopyrightStatementsProcessor.kt\norg/ossreviewtoolkit/utils/ort/CopyrightStatementsProcessor\n*L\n291#1:317,2\n303#1:319,2\n222#1:321\n222#1:322,3\n224#1:325,14\n273#1:345,2\n264#1:339\n264#1:340,5\n*E\n"})
public final class CopyrightStatementsProcessor {
    @NotNull
    public static final CopyrightStatementsProcessor INSTANCE = new CopyrightStatementsProcessor();

    private CopyrightStatementsProcessor() {
    }

    @Nullable
    public final Parts determineParts(@NotNull String copyrightStatement) {
        Intrinsics.checkNotNullParameter((Object)copyrightStatement, (String)"copyrightStatement");
        Pair<String, String> prefixStripResult = CopyrightStatementsProcessor.determineParts$stripKnownCopyrightPrefix(copyrightStatement);
        if (((CharSequence)prefixStripResult.getSecond()).length() == 0) {
            return null;
        }
        Pair<String, Set<Integer>> yearsStripResult = CopyrightStatementsProcessor.determineParts$stripYears((String)prefixStripResult.getFirst());
        char[] cArray = CopyrightStatementsProcessorKt.access$getINVALID_OWNER_START_CHARS$p();
        return new Parts((String)prefixStripResult.getSecond(), (Set)yearsStripResult.getSecond(), ExtensionsKt.collapseWhitespace((String)StringsKt.trimStart((String)((String)yearsStripResult.getFirst()), (char[])Arrays.copyOf(cArray, cArray.length))), CollectionsKt.listOf((Object)copyrightStatement));
    }

    @NotNull
    public final Result process(@NotNull Collection<String> copyrightStatements) {
        Intrinsics.checkNotNullParameter(copyrightStatements, (String)"copyrightStatements");
        Set unprocessedStatements = new LinkedHashSet();
        List processableStatements = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)copyrightStatements);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String statement = (String)element$iv;
            boolean bl = false;
            Parts parts = INSTANCE.determineParts(statement);
            if (parts != null) {
                ((Collection)processableStatements).add(parts);
                continue;
            }
            ((Collection)unprocessedStatements).add(statement);
        }
        List<Parts> mergedParts = CopyrightStatementsProcessor.process$groupByPrefixAndOwner(CollectionsKt.sorted((Iterable)processableStatements));
        Map processedStatements = new LinkedHashMap();
        Iterable $this$forEach$iv2 = mergedParts;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Parts it = (Parts)element$iv;
            boolean bl = false;
            if (!(((CharSequence)it.getOwner()).length() > 0)) continue;
            String statement = it.toString();
            processedStatements.put(statement, CollectionsKt.toSet((Iterable)it.getOriginalStatements()));
        }
        return new Result(processedStatements, unprocessedStatements);
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<String, String> determineParts$stripKnownCopyrightPrefix(String copyrightStatement) {
        Object v0;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CopyrightStatementsProcessorKt.access$getKNOWN_PREFIX_REGEX$p();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void regex;
            Regex regex2 = (Regex)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = copyrightStatement;
            String string = "";
            collection.add(regex.replace(charSequence, string));
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                String it = (String)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.length();
                do {
                    Object e$iv = iterator$iv.next();
                    String it2 = (String)e$iv;
                    $i$a$-minByOrNull-CopyrightStatementsProcessor$determineParts$stripKnownCopyrightPrefix$copyrightStatementWithoutPrefix$2 = false;
                    int v$iv = it2.length();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        String string = v0;
        if (string == null) {
            return new Pair((Object)copyrightStatement, (Object)"");
        }
        String copyrightStatementWithoutPrefix = string;
        return new Pair((Object)copyrightStatementWithoutPrefix, (Object)StringsKt.removeSuffix((String)copyrightStatement, (CharSequence)copyrightStatementWithoutPrefix));
    }

    private static final Pair<String, Set<Integer>> determineParts$stripYears(String copyrightStatement) {
        Pair it = CopyrightStatementsProcessorKt.access$replaceYears(copyrightStatement);
        boolean bl = false;
        return Pair.copy$default((Pair)it, (Object)StringsKt.replace$default((String)((String)it.getFirst()), (String)"<ORT_YEAR_PLACEHOLDER_TRO>", (String)"", (boolean)false, (int)4, null), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String process$toNormalizedOwnerKey(String $this$process_u24toNormalizedOwnerKey) {
        void $this$filterTo$iv$iv;
        String $this$filter$iv = $this$process_u24toNormalizedOwnerKey;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(!ArraysKt.contains((char[])CopyrightStatementsProcessorKt.access$getINVALID_OWNER_KEY_CHARS$p(), (char)it))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return string2;
    }

    private static final Parts process$groupByPrefixAndOwner$lambda$6$lambda$4(Parts existing, Parts other) {
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Parts(existing.getPrefix(), SetsKt.plus(existing.getYears(), (Iterable)other.getYears()), existing.getOwner(), CollectionsKt.plus((Collection)existing.getOriginalStatements(), (Iterable)other.getOriginalStatements()));
    }

    private static final Parts process$groupByPrefixAndOwner$lambda$6$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        return (Parts)$tmp0.invoke(p0, p1);
    }

    private static final List<Parts> process$groupByPrefixAndOwner(Collection<Parts> $this$process_u24groupByPrefixAndOwner) {
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$process_u24groupByPrefixAndOwner;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Parts part = (Parts)element$iv;
            boolean bl = false;
            String key = part.getPrefix() + ":" + CopyrightStatementsProcessor.process$toNormalizedOwnerKey(part.getOwner());
            map.merge(key, part, (arg_0, arg_1) -> CopyrightStatementsProcessor.process$groupByPrefixAndOwner$lambda$6$lambda$5(CopyrightStatementsProcessor::process$groupByPrefixAndOwner$lambda$6$lambda$4, arg_0, arg_1));
        }
        return CollectionsKt.toList((Iterable)map.values());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/ossreviewtoolkit/utils/ort/CopyrightStatementsProcessor$Parts;", "", "prefix", "", "years", "", "", "owner", "originalStatements", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;Ljava/util/List;)V", "getPrefix", "()Ljava/lang/String;", "getYears", "()Ljava/util/Set;", "getOwner", "getOriginalStatements", "()Ljava/util/List;", "compareTo", "other", "toString", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "Companion", "ort-utils"})
    public static final class Parts
    implements Comparable<Parts> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String prefix;
        @NotNull
        private final Set<Integer> years;
        @NotNull
        private final String owner;
        @NotNull
        private final List<String> originalStatements;
        @NotNull
        private static final Comparator<Parts> COMPARATOR;

        public Parts(@NotNull String prefix, @NotNull Set<Integer> years, @NotNull String owner, @NotNull List<String> originalStatements) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter(years, (String)"years");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter(originalStatements, (String)"originalStatements");
            this.prefix = prefix;
            this.years = years;
            this.owner = owner;
            this.originalStatements = originalStatements;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final Set<Integer> getYears() {
            return this.years;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        @NotNull
        public final List<String> getOriginalStatements() {
            return this.originalStatements;
        }

        @Override
        public int compareTo(@NotNull Parts other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return COMPARATOR.compare(this, other);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u240.append(this.prefix);
            if (!((Collection)this.years).isEmpty()) {
                $this$toString_u24lambda_u240.append(" ");
                $this$toString_u24lambda_u240.append(ExtensionsKt.prettyPrintRanges((Collection)ExtensionsKt.collapseToRanges((Collection)this.years)));
            }
            if (((CharSequence)this.owner).length() > 0) {
                $this$toString_u24lambda_u240.append(" ");
                $this$toString_u24lambda_u240.append(this.owner);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final String component1() {
            return this.prefix;
        }

        @NotNull
        public final Set<Integer> component2() {
            return this.years;
        }

        @NotNull
        public final String component3() {
            return this.owner;
        }

        @NotNull
        public final List<String> component4() {
            return this.originalStatements;
        }

        @NotNull
        public final Parts copy(@NotNull String prefix, @NotNull Set<Integer> years, @NotNull String owner, @NotNull List<String> originalStatements) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter(years, (String)"years");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter(originalStatements, (String)"originalStatements");
            return new Parts(prefix, years, owner, originalStatements);
        }

        public static /* synthetic */ Parts copy$default(Parts parts, String string, Set set, String string2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = parts.prefix;
            }
            if ((n & 2) != 0) {
                set = parts.years;
            }
            if ((n & 4) != 0) {
                string2 = parts.owner;
            }
            if ((n & 8) != 0) {
                list = parts.originalStatements;
            }
            return parts.copy(string, set, string2, list);
        }

        public int hashCode() {
            int result = this.prefix.hashCode();
            result = result * 31 + ((Object)this.years).hashCode();
            result = result * 31 + this.owner.hashCode();
            result = result * 31 + ((Object)this.originalStatements).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parts)) {
                return false;
            }
            Parts parts = (Parts)other;
            if (!Intrinsics.areEqual((Object)this.prefix, (Object)parts.prefix)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.years, parts.years)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.owner, (Object)parts.owner)) {
                return false;
            }
            return Intrinsics.areEqual(this.originalStatements, parts.originalStatements);
        }

        private static final Comparable COMPARATOR$lambda$1(Parts it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Comparable)((Object)it.owner);
        }

        private static final Comparable COMPARATOR$lambda$2(Parts it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Comparable)((Object)ExtensionsKt.prettyPrintRanges((Collection)ExtensionsKt.collapseToRanges((Collection)it.years)));
        }

        private static final Comparable COMPARATOR$lambda$3(Parts it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Comparable)((Object)it.prefix);
        }

        static {
            Function1[] function1Array = new Function1[]{Parts::COMPARATOR$lambda$1, Parts::COMPARATOR$lambda$2, Parts::COMPARATOR$lambda$3};
            COMPARATOR = ComparisonsKt.compareBy((Function1[])function1Array);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/ossreviewtoolkit/utils/ort/CopyrightStatementsProcessor$Parts$Companion;", "", "<init>", "()V", "COMPARATOR", "Ljava/util/Comparator;", "Lorg/ossreviewtoolkit/utils/ort/CopyrightStatementsProcessor$Parts;", "Lkotlin/Comparator;", "ort-utils"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u001a\b\u0001\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u0012\u000e\b\u0001\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005H\u00c6\u0003J5\u0010\u0013\u001a\u00020\u00002\u001a\b\u0003\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u00032\u000e\b\u0003\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001R(\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00058GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/ossreviewtoolkit/utils/ort/CopyrightStatementsProcessor$Result;", "", "processedStatements", "", "", "", "unprocessedStatements", "<init>", "(Ljava/util/Map;Ljava/util/Set;)V", "getProcessedStatements", "()Ljava/util/Map;", "getUnprocessedStatements", "()Ljava/util/Set;", "allStatements", "getAllStatements", "allStatements$delegate", "Lkotlin/Lazy;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ort-utils"})
    public static final class Result {
        @JsonPropertyOrder(alphabetic=true)
        @NotNull
        private final Map<String, Set<String>> processedStatements;
        @NotNull
        private final Set<String> unprocessedStatements;
        @NotNull
        private final Lazy allStatements$delegate;

        public Result(@JsonSerialize(contentConverter=StringSortedSetConverter.class) @NotNull Map<String, ? extends Set<String>> processedStatements, @JsonSerialize(converter=StringSortedSetConverter.class) @NotNull Set<String> unprocessedStatements) {
            Intrinsics.checkNotNullParameter(processedStatements, (String)"processedStatements");
            Intrinsics.checkNotNullParameter(unprocessedStatements, (String)"unprocessedStatements");
            this.processedStatements = processedStatements;
            this.unprocessedStatements = unprocessedStatements;
            this.allStatements$delegate = LazyKt.lazy(() -> Result.allStatements_delegate$lambda$0(this));
        }

        @NotNull
        public final Map<String, Set<String>> getProcessedStatements() {
            return this.processedStatements;
        }

        @NotNull
        public final Set<String> getUnprocessedStatements() {
            return this.unprocessedStatements;
        }

        @JsonIgnore
        @NotNull
        public final Set<String> getAllStatements() {
            Lazy lazy = this.allStatements$delegate;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final Map<String, Set<String>> component1() {
            return this.processedStatements;
        }

        @NotNull
        public final Set<String> component2() {
            return this.unprocessedStatements;
        }

        @NotNull
        public final Result copy(@JsonSerialize(contentConverter=StringSortedSetConverter.class) @NotNull Map<String, ? extends Set<String>> processedStatements, @JsonSerialize(converter=StringSortedSetConverter.class) @NotNull Set<String> unprocessedStatements) {
            Intrinsics.checkNotNullParameter(processedStatements, (String)"processedStatements");
            Intrinsics.checkNotNullParameter(unprocessedStatements, (String)"unprocessedStatements");
            return new Result(processedStatements, unprocessedStatements);
        }

        public static /* synthetic */ Result copy$default(Result result, Map map, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                map = result.processedStatements;
            }
            if ((n & 2) != 0) {
                set = result.unprocessedStatements;
            }
            return result.copy(map, set);
        }

        @NotNull
        public String toString() {
            return "Result(processedStatements=" + this.processedStatements + ", unprocessedStatements=" + this.unprocessedStatements + ")";
        }

        public int hashCode() {
            int result = ((Object)this.processedStatements).hashCode();
            result = result * 31 + ((Object)this.unprocessedStatements).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual(this.processedStatements, result.processedStatements)) {
                return false;
            }
            return Intrinsics.areEqual(this.unprocessedStatements, result.unprocessedStatements);
        }

        private static final Set allStatements_delegate$lambda$0(Result this$0) {
            return SetsKt.plus(this$0.unprocessedStatements, (Iterable)this$0.processedStatements.keySet());
        }
    }
}

