/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.ort;

import eu.hansolo.jdktools.Architecture;
import eu.hansolo.jdktools.ArchiveType;
import eu.hansolo.jdktools.Latest;
import eu.hansolo.jdktools.LibCType;
import eu.hansolo.jdktools.Match;
import eu.hansolo.jdktools.OperatingSystem;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.util.Helper;
import eu.hansolo.jdktools.versioning.SemverParsingResult;
import io.foojay.api.discoclient.DiscoClient;
import io.foojay.api.discoclient.pkg.Pkg;
import io.foojay.api.discoclient.pkg.Scope;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import okhttp3.OkHttpClient;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.utils.common.ArchiveUtilsKt;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.Os;
import org.ossreviewtoolkit.utils.ort.Environment;
import org.ossreviewtoolkit.utils.ort.EnvironmentKt;
import org.ossreviewtoolkit.utils.ort.OkHttpClientHelperKt;
import org.semver4j.Semver;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\n\u001a\u00020\u000b*\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/ossreviewtoolkit/utils/ort/JavaBootstrapper;", "", "<init>", "()V", "discoClient", "Lio/foojay/api/discoclient/DiscoClient;", "getDiscoClient", "()Lio/foojay/api/discoclient/DiscoClient;", "discoClient$delegate", "Lkotlin/Lazy;", "singleContainedDirectoryOrThis", "Ljava/io/File;", "isRunningOnJdk", "", "version", "", "installJdk", "Lkotlin/Result;", "distributionName", "installJdk-gIAlu-s", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "ort-utils"})
@SourceDebugExtension(value={"SMAP\nJavaBootstrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaBootstrapper.kt\norg/ossreviewtoolkit/utils/ort/JavaBootstrapper\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,146:1\n38#2:147\n38#2:150\n38#2:151\n38#2:164\n38#2:176\n38#2:177\n1053#3:148\n1#4:149\n79#5,5:152\n113#5,7:157\n18#5,4:165\n50#5,7:169\n*S KotlinDebug\n*F\n+ 1 JavaBootstrapper.kt\norg/ossreviewtoolkit/utils/ort/JavaBootstrapper\n*L\n79#1:147\n117#1:150\n125#1:151\n133#1:164\n137#1:176\n140#1:177\n108#1:148\n127#1:152,5\n127#1:157,7\n135#1:165,4\n135#1:169,7\n*E\n"})
public final class JavaBootstrapper {
    @NotNull
    public static final JavaBootstrapper INSTANCE = new JavaBootstrapper();
    @NotNull
    private static final Lazy discoClient$delegate = LazyKt.lazy(JavaBootstrapper::discoClient_delegate$lambda$0);

    private JavaBootstrapper() {
    }

    private final DiscoClient getDiscoClient() {
        Lazy lazy = discoClient$delegate;
        return (DiscoClient)lazy.getValue();
    }

    private final File singleContainedDirectoryOrThis(File $this$singleContainedDirectoryOrThis) {
        File file = (File)SequencesKt.singleOrNull((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)$this$singleContainedDirectoryOrThis, null, (int)1, null).maxDepth(1)), arg_0 -> JavaBootstrapper.singleContainedDirectoryOrThis$lambda$1($this$singleContainedDirectoryOrThis, arg_0)));
        if (file == null) {
            file = $this$singleContainedDirectoryOrThis;
        }
        return file;
    }

    public final boolean isRunningOnJdk(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Semver requestedVersion = Semver.coerce((String)version);
        Semver runningVersion = Semver.coerce((String)Environment.Companion.getJAVA_VERSION());
        if (!Intrinsics.areEqual((Object)requestedVersion, (Object)runningVersion)) {
            return false;
        }
        String string = System.getProperty("java.home");
        if (string == null) {
            return false;
        }
        String javaHome = string;
        File javac = FilesKt.resolve((File)FilesKt.resolve((File)new File(javaHome), (String)"bin"), (String)"javac");
        return Os.INSTANCE.resolveExecutable(javac) != null;
    }

    @NotNull
    public final Object installJdk-gIAlu-s(@NotNull String distributionName, @NotNull String version) {
        Object v3;
        Object $this$sortedBy$iv;
        block10: {
            Intrinsics.checkNotNullParameter((Object)distributionName, (String)"distributionName");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            SemverParsingResult versionResult = eu.hansolo.jdktools.versioning.Semver.fromText((String)version);
            if (versionResult.getError1() != null) {
                Error error = versionResult.getError1();
                Intrinsics.checkNotNullExpressionValue((Object)error, (String)"getError1(...)");
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)error));
            }
            eu.hansolo.jdktools.versioning.Semver semVer = versionResult.getSemver1();
            JavaBootstrapper $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(JavaBootstrapper.class).info(() -> JavaBootstrapper.installJdk_gIAlu_s$lambda$2(distributionName, semVer));
            OperatingSystem operatingSystem = Helper.getOperatingSystem();
            Architecture architecture = Helper.getArchitecture();
            OperatingSystem operatingSystem2 = operatingSystem;
            LibCType libcType = switch (operatingSystem2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[operatingSystem2.ordinal()]) {
                case 1 -> LibCType.GLIBC;
                case 2, 3 -> LibCType.MUSL;
                default -> LibCType.NONE;
            };
            List pkgs = this.getDiscoClient().getPkgs(null, semVer.getVersionNumber(), Latest.PER_VERSION, operatingSystem, libcType, architecture, architecture.getBitness(), operatingSystem == OperatingSystem.WINDOWS ? ArchiveType.ZIP : ArchiveType.TAR_GZ, PackageType.JDK, Boolean.valueOf(false), Boolean.valueOf(true), CollectionsKt.listOf((Object)semVer.getReleaseStatus()), TermOfSupport.NONE, CollectionsKt.listOf((Object)Scope.PUBLIC), Match.ANY);
            Intrinsics.checkNotNull((Object)pkgs);
            $this$sortedBy$iv = pkgs;
            boolean $i$f$sortedBy22 = false;
            Iterable $i$f$sortedBy22 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pkg it = (Pkg)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getId());
                    it = (Pkg)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
                }
            });
            for (Object t : $i$f$sortedBy22) {
                Pkg it = (Pkg)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDistributionName(), (Object)distributionName)) continue;
                v3 = t;
                break block10;
            }
            v3 = null;
        }
        Pkg pkg = v3;
        if (pkg == null) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("No package found for JDK '" + distributionName + "' in version '" + version + "'.")));
        }
        Pkg pkg2 = pkg;
        File file = FilesKt.resolve((File)EnvironmentKt.getOrtToolsDirectory(), (String)"jdks");
        String string = pkg2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        Object $this$installJdk_gIAlu_s_u24lambda_u246 = $this$sortedBy$iv = FilesKt.resolve((File)file, (String)string);
        boolean bl = false;
        if (((File)$this$installJdk_gIAlu_s_u24lambda_u246).isDirectory()) {
            Object $this$logger$iv = $this$installJdk_gIAlu_s_u24lambda_u246;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(File.class).info(() -> JavaBootstrapper.installJdk_gIAlu_s$lambda$6$lambda$5((File)$this$installJdk_gIAlu_s_u24lambda_u246));
            return Result.constructor-impl((Object)INSTANCE.singleContainedDirectoryOrThis((File)$this$installJdk_gIAlu_s_u24lambda_u246));
        }
        ExtensionsKt.safeMkdirs((File)$this$installJdk_gIAlu_s_u24lambda_u246);
        Object installDir = $this$sortedBy$iv;
        String url = this.getDiscoClient().getPkgDirectDownloadUri(pkg2.getId());
        JavaBootstrapper $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(JavaBootstrapper.class).info(() -> JavaBootstrapper.installJdk_gIAlu_s$lambda$7(url));
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl2 = false;
        OkHttpClient okHttpClient2 = OkHttpClientHelperKt.getOkHttpClient();
        Intrinsics.checkNotNull((Object)url);
        Object object = OkHttpClientHelperKt.downloadFile(okHttpClient2, url, (File)installDir);
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl3 = false;
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
        }
        File result$iv$iv = (File)object;
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        File archive = (File)timedValue.component1();
        long downloadDuration = timedValue.component2-UwyO8pc();
        JavaBootstrapper $this$logger$iv2 = this;
        boolean $i$f$getLogger2 = false;
        LoggingFactoryKt.cachedLoggerOf(JavaBootstrapper.class).info(() -> JavaBootstrapper.installJdk_gIAlu_s$lambda$10(downloadDuration));
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv2 = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl4 = false;
        ArchiveUtilsKt.unpack$default((File)archive, (File)installDir, null, null, (int)6, null);
        long unpackDuration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv2);
        JavaBootstrapper $this$logger$iv3 = this;
        boolean $i$f$getLogger3 = false;
        LoggingFactoryKt.cachedLoggerOf(JavaBootstrapper.class).info(() -> JavaBootstrapper.installJdk_gIAlu_s$lambda$12(unpackDuration));
        if (!archive.delete()) {
            $this$logger$iv3 = this;
            $i$f$getLogger3 = false;
            LoggingFactoryKt.cachedLoggerOf(JavaBootstrapper.class).warn(() -> JavaBootstrapper.installJdk_gIAlu_s$lambda$13(archive));
        }
        return Result.constructor-impl((Object)this.singleContainedDirectoryOrThis((File)installDir));
    }

    private static final DiscoClient discoClient_delegate$lambda$0() {
        return new DiscoClient(Environment.Companion.getORT_USER_AGENT());
    }

    private static final boolean singleContainedDirectoryOrThis$lambda$1(File $this_singleContainedDirectoryOrThis, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$this_singleContainedDirectoryOrThis) && it.isDirectory();
    }

    private static final Object installJdk_gIAlu_s$lambda$2(String $distributionName, eu.hansolo.jdktools.versioning.Semver $semVer) {
        return "Setting up JDK '" + $distributionName + "' in version '" + $semVer + "'...";
    }

    private static final Object installJdk_gIAlu_s$lambda$6$lambda$5(File $this_apply) {
        return "Not downloading the JDK again as the directory '" + $this_apply + "' already exists.";
    }

    private static final Object installJdk_gIAlu_s$lambda$7(String $url) {
        return "Downloading the JDK package from " + $url + "...";
    }

    private static final Object installJdk_gIAlu_s$lambda$10(long $downloadDuration) {
        return "Downloading the JDK took " + Duration.toString-impl((long)$downloadDuration) + ".";
    }

    private static final Object installJdk_gIAlu_s$lambda$12(long $unpackDuration) {
        return "Unpacking the JDK took " + Duration.toString-impl((long)$unpackDuration) + ".";
    }

    private static final Object installJdk_gIAlu_s$lambda$13(File $archive) {
        return "Unable to delete the JDK archive from '" + $archive + "'.";
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OperatingSystem.values().length];
            try {
                nArray[OperatingSystem.LINUX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.LINUX_MUSL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.ALPINE_LINUX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

