/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.ort.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.ort.storage.FileStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\tH\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/ossreviewtoolkit/utils/ort/storage/LocalFileStorage;", "Lorg/ossreviewtoolkit/utils/ort/storage/FileStorage;", "directory", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getDirectory", "()Ljava/io/File;", "transformPath", "", "path", "exists", "", "read", "Ljava/io/InputStream;", "safeOutputStream", "Ljava/io/OutputStream;", "write", "", "inputStream", "delete", "ort-utils"})
@SourceDebugExtension(value={"SMAP\nLocalFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalFileStorage.kt\norg/ossreviewtoolkit/utils/ort/storage/LocalFileStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public class LocalFileStorage
implements FileStorage {
    @NotNull
    private final File directory;

    public LocalFileStorage(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directory = directory;
    }

    @NotNull
    public final File getDirectory() {
        return this.directory;
    }

    @NotNull
    public String transformPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path;
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FilesKt.resolve((File)this.directory, (String)this.transformPath(path)).exists();
    }

    @Override
    @NotNull
    public synchronized InputStream read(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = FilesKt.resolve((File)this.directory, (String)this.transformPath(path));
        File file2 = file.getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getCanonicalFile(...)");
        File file3 = this.directory.getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getCanonicalFile(...)");
        if (!FilesKt.startsWith((File)file2, (File)file3)) {
            boolean bl = false;
            String string = "Path '" + path + "' is not in directory '" + FilesKt.getInvariantSeparatorsPath((File)this.directory) + "'.";
            throw new IllegalArgumentException(string.toString());
        }
        return new FileInputStream(file);
    }

    @NotNull
    protected OutputStream safeOutputStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = FilesKt.resolve((File)this.directory, (String)this.transformPath(path));
        File file2 = file.getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getCanonicalFile(...)");
        File file3 = this.directory.getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getCanonicalFile(...)");
        if (!FilesKt.startsWith((File)file2, (File)file3)) {
            boolean bl = false;
            String string = "Path '" + path + "' is not in directory '" + FilesKt.getInvariantSeparatorsPath((File)this.directory) + "'.";
            throw new IllegalArgumentException(string.toString());
        }
        File file4 = file.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getParentFile(...)");
        ExtensionsKt.safeMkdirs((File)file4);
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(@NotNull String path, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Closeable closeable = this.safeOutputStream(path);
        Throwable throwable = null;
        try {
            long l;
            OutputStream outputStream = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = inputStream;
            Throwable throwable2 = null;
            try {
                InputStream it = (InputStream)closeable2;
                boolean bl2 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)outputStream, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public synchronized boolean delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FilesKt.resolve((File)this.directory, (String)this.transformPath(path)).delete();
    }
}

