/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.ort.storage;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.utils.ort.storage.LocalFileStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0014\u00a8\u0006\r"}, d2={"Lorg/ossreviewtoolkit/utils/ort/storage/XZCompressedLocalFileStorage;", "Lorg/ossreviewtoolkit/utils/ort/storage/LocalFileStorage;", "directory", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "transformPath", "", "path", "read", "Lorg/apache/commons/compress/compressors/xz/XZCompressorInputStream;", "safeOutputStream", "Lorg/apache/commons/compress/compressors/xz/XZCompressorOutputStream;", "ort-utils"})
public final class XZCompressedLocalFileStorage
extends LocalFileStorage {
    public XZCompressedLocalFileStorage(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        super(directory);
    }

    @Override
    @NotNull
    public String transformPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path + ".xz";
    }

    @NotNull
    public XZCompressorInputStream read(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new XZCompressorInputStream(super.read(path));
    }

    @NotNull
    protected XZCompressorOutputStream safeOutputStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new XZCompressorOutputStream(super.safeOutputStream(path));
    }
}

