/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.scripting;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.CompiledScript;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.EvaluationResult;
import kotlin.script.experimental.api.ResultValue;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.ScriptEvaluationConfiguration;
import kotlin.script.experimental.host.ScriptHostUtilKt;
import kotlin.script.experimental.jvmhost.BasicJvmScriptingHost;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.CoroutineScope;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.utils.ort.UtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/ossreviewtoolkit/utils/scripting/ScriptRunner;", "", "<init>", "()V", "scriptingHost", "Lkotlin/script/experimental/jvmhost/BasicJvmScriptingHost;", "compConfig", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "getCompConfig", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "evalConfig", "Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "getEvalConfig", "()Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "checkSyntax", "", "script", "", "runScript", "Lkotlin/script/experimental/api/ResultValue;", "logReports", "", "reports", "", "Lkotlin/script/experimental/api/ScriptDiagnostic;", "scripting-utils"})
@SourceDebugExtension(value={"SMAP\nScriptRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptRunner.kt\norg/ossreviewtoolkit/utils/scripting/ScriptRunner\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n79#2,5:97\n113#2,7:102\n38#3:109\n38#3:111\n38#3:112\n38#3:113\n38#3:114\n38#3:115\n1863#4:110\n1864#4:116\n*S KotlinDebug\n*F\n+ 1 ScriptRunner.kt\norg/ossreviewtoolkit/utils/scripting/ScriptRunner\n*L\n53#1:97,5\n53#1:102,7\n57#1:109\n88#1:111\n89#1:112\n90#1:113\n91#1:114\n92#1:115\n79#1:110\n79#1:116\n*E\n"})
public abstract class ScriptRunner {
    @NotNull
    private final BasicJvmScriptingHost scriptingHost = new BasicJvmScriptingHost(null, null, null, 7, null);

    @NotNull
    protected abstract ScriptCompilationConfiguration getCompConfig();

    @NotNull
    protected abstract ScriptEvaluationConfiguration getEvalConfig();

    public final boolean checkSyntax(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        ResultWithDiagnostics result$iv$iv = (ResultWithDiagnostics)UtilsKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ResultWithDiagnostics<? extends CompiledScript>>, Object>(this, script, null){
            int label;
            final /* synthetic */ ScriptRunner this$0;
            final /* synthetic */ String $script;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ScriptRunner.access$getScriptingHost$p(this.this$0).getCompiler().invoke(ScriptHostUtilKt.toScriptSource$default((String)this.$script, null, (int)1, null), this.this$0.getCompConfig(), (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ResultWithDiagnostics<? extends CompiledScript>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        ResultWithDiagnostics result = (ResultWithDiagnostics)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        ScriptRunner $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(ScriptRunner.class).info(() -> ScriptRunner.checkSyntax$lambda$1(duration));
        this.logReports(result.getReports());
        return result instanceof ResultWithDiagnostics.Success;
    }

    @NotNull
    public final ResultValue runScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        ResultWithDiagnostics result = this.scriptingHost.eval(ScriptHostUtilKt.toScriptSource$default((String)script, null, (int)1, null), this.getCompConfig(), this.getEvalConfig());
        this.logReports(result.getReports());
        ResultValue value = ((EvaluationResult)ErrorHandlingKt.valueOrThrow((ResultWithDiagnostics)result)).getReturnValue();
        if (value instanceof ResultValue.Error) {
            throw ((ResultValue.Error)value).getError();
        }
        return value;
    }

    private final void logReports(List<ScriptDiagnostic> reports) {
        Iterable $this$forEach$iv = reports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptDiagnostic report = (ScriptDiagnostic)element$iv;
            boolean bl = false;
            String renderedReport = report.render(false, true, false, false);
            switch (WhenMappings.$EnumSwitchMapping$0[report.getSeverity().ordinal()]) {
                case 1: {
                    ScriptRunner $this$logger$iv = this;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(ScriptRunner.class).debug((CharSequence)renderedReport, report.getException());
                    break;
                }
                case 2: {
                    ScriptRunner $this$logger$iv = this;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(ScriptRunner.class).info((CharSequence)renderedReport, report.getException());
                    break;
                }
                case 3: {
                    ScriptRunner $this$logger$iv = this;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(ScriptRunner.class).warn((CharSequence)renderedReport, report.getException());
                    break;
                }
                case 4: {
                    ScriptRunner $this$logger$iv = this;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(ScriptRunner.class).error((CharSequence)renderedReport, report.getException());
                    break;
                }
                case 5: {
                    ScriptRunner $this$logger$iv = this;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(ScriptRunner.class).fatal((CharSequence)renderedReport, report.getException());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private static final Object checkSyntax$lambda$1(long $duration) {
        return "Compiling the script took " + Duration.toString-impl((long)$duration) + ".";
    }

    public static final /* synthetic */ BasicJvmScriptingHost access$getScriptingHost$p(ScriptRunner $this) {
        return $this.scriptingHost;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptDiagnostic.Severity.values().length];
            try {
                nArray[ScriptDiagnostic.Severity.DEBUG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.INFO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.FATAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

