/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.utils.spdx.SpdxCompoundExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxConstants;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxLicense;
import org.ossreviewtoolkit.utils.spdx.SpdxLicenseException;
import org.ossreviewtoolkit.utils.spdx.SpdxLicenseIdExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxLicenseWithExceptionExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxOperator;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0014\u0010\n\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u001a\n\u0010\f\u001a\u00020\r*\u00020\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0014\u0010\u000f\u001a\u00020\u0007*\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u001a\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u00a8\u0006\u0015"}, d2={"and", "Lorg/ossreviewtoolkit/utils/spdx/SpdxCompoundExpression;", "Lorg/ossreviewtoolkit/utils/spdx/SpdxLicense;", "other", "Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression;", "isSpdxExpression", "", "", "strictness", "Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression$Strictness;", "isSpdxExpressionOrNotPresent", "or", "toExpression", "Lorg/ossreviewtoolkit/utils/spdx/SpdxLicenseIdExpression;", "toSpdx", "toSpdxId", "allowPlusSuffix", "with", "Lorg/ossreviewtoolkit/utils/spdx/SpdxLicenseWithExceptionExpression;", "exception", "Lorg/ossreviewtoolkit/utils/spdx/SpdxLicenseException;", "spdx-utils"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\norg/ossreviewtoolkit/utils/spdx/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,122:1\n1#2:123\n1174#3,2:124\n107#4:126\n79#4,22:127\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\norg/ossreviewtoolkit/utils/spdx/ExtensionsKt\n*L\n100#1:124,2\n118#1:126\n118#1:127,22\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final SpdxCompoundExpression and(@NotNull SpdxLicense $this$and, @NotNull SpdxLicense other) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$and), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
        return ExtensionsKt.and($this$and, ExtensionsKt.toExpression(other));
    }

    @NotNull
    public static final SpdxCompoundExpression and(@NotNull SpdxLicense $this$and, @NotNull SpdxExpression other) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$and), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new SpdxCompoundExpression(ExtensionsKt.toExpression($this$and), SpdxOperator.AND, other);
    }

    @NotNull
    public static final SpdxCompoundExpression or(@NotNull SpdxLicense $this$or, @NotNull SpdxLicense other) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$or), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
        return ExtensionsKt.or($this$or, ExtensionsKt.toExpression(other));
    }

    @NotNull
    public static final SpdxCompoundExpression or(@NotNull SpdxLicense $this$or, @NotNull SpdxExpression other) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$or), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new SpdxCompoundExpression(ExtensionsKt.toExpression($this$or), SpdxOperator.OR, other);
    }

    @NotNull
    public static final SpdxLicenseWithExceptionExpression with(@NotNull SpdxLicense $this$with, @NotNull SpdxLicenseException exception) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$with), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
        return new SpdxLicenseWithExceptionExpression(ExtensionsKt.toExpression($this$with), exception.getId());
    }

    @NotNull
    public static final SpdxLicenseIdExpression toExpression(@NotNull SpdxLicense $this$toExpression) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toExpression), (String)"<this>");
        String expressionId = $this$toExpression.getId();
        if ($this$toExpression.getDeprecated()) {
            expressionId = StringsKt.removeSuffix((String)$this$toExpression.getId(), (CharSequence)"+");
            bl = !Intrinsics.areEqual((Object)$this$toExpression.getId(), (Object)expressionId);
        } else {
            bl = StringsKt.endsWith$default((String)$this$toExpression.getId(), (String)"-or-later", (boolean)false, (int)2, null);
        }
        boolean orLaterVersion = bl;
        return new SpdxLicenseIdExpression(expressionId, orLaterVersion);
    }

    public static final boolean isSpdxExpression(@NotNull String $this$isSpdxExpression, @NotNull SpdxExpression.Strictness strictness) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isSpdxExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        String string = $this$isSpdxExpression;
        try {
            String $this$isSpdxExpression_u24lambda_u240 = string;
            boolean bl = false;
            object = Result.constructor-impl((Object)SpdxExpression.Companion.parse($this$isSpdxExpression_u24lambda_u240, strictness));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return Result.isSuccess-impl((Object)object);
    }

    public static /* synthetic */ boolean isSpdxExpression$default(String string, SpdxExpression.Strictness strictness, int n, Object object) {
        if ((n & 1) != 0) {
            strictness = SpdxExpression.Strictness.ALLOW_DEPRECATED;
        }
        return ExtensionsKt.isSpdxExpression(string, strictness);
    }

    public static final boolean isSpdxExpressionOrNotPresent(@NotNull String $this$isSpdxExpressionOrNotPresent, @NotNull SpdxExpression.Strictness strictness) {
        Intrinsics.checkNotNullParameter((Object)$this$isSpdxExpressionOrNotPresent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        return SpdxConstants.INSTANCE.isNotPresent($this$isSpdxExpressionOrNotPresent) || ExtensionsKt.isSpdxExpression($this$isSpdxExpressionOrNotPresent, strictness);
    }

    public static /* synthetic */ boolean isSpdxExpressionOrNotPresent$default(String string, SpdxExpression.Strictness strictness, int n, Object object) {
        if ((n & 1) != 0) {
            strictness = SpdxExpression.Strictness.ALLOW_DEPRECATED;
        }
        return ExtensionsKt.isSpdxExpressionOrNotPresent(string, strictness);
    }

    @NotNull
    public static final SpdxExpression toSpdx(@NotNull String $this$toSpdx, @NotNull SpdxExpression.Strictness strictness) {
        Intrinsics.checkNotNullParameter((Object)$this$toSpdx, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        return SpdxExpression.Companion.parse($this$toSpdx, strictness);
    }

    public static /* synthetic */ SpdxExpression toSpdx$default(String string, SpdxExpression.Strictness strictness, int n, Object object) {
        if ((n & 1) != 0) {
            strictness = SpdxExpression.Strictness.ALLOW_ANY;
        }
        return ExtensionsKt.toSpdx(string, strictness);
    }

    @NotNull
    public static final String toSpdxId(@NotNull String $this$toSpdxId, boolean allowPlusSuffix) {
        String trimmed;
        String string;
        String converted;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toSpdxId, (String)"<this>");
        boolean hasPlusSuffix = StringsKt.endsWith$default((CharSequence)$this$toSpdxId, (char)'+', (boolean)false, (int)2, null);
        Object[] objectArray = new Character[]{Character.valueOf('-'), Character.valueOf('.')};
        Set specialValid = SetsKt.setOf((Object[])objectArray);
        Object[] objectArray2 = new Character[]{Character.valueOf(':'), Character.valueOf('_')};
        Set specialInvalid = SetsKt.setOf((Object[])objectArray2);
        StringBuilder $this$toSpdxId_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Character lastChar = null;
        CharSequence $this$forEach$iv = $this$toSpdxId;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            Character c;
            char it;
            char element$iv;
            char c2 = element$iv = $this$forEach$iv.charAt(i);
            boolean bl2 = false;
            if (Character.isLetterOrDigit(c2) || specialValid.contains(Character.valueOf(c2))) {
                v0 = Character.valueOf(c2);
            } else if (specialInvalid.contains(Character.valueOf(c2))) {
                var16_18 = Character.valueOf('-');
                it = var16_18.charValue();
                boolean bl3 = false;
                v0 = !CollectionsKt.contains((Iterable)specialValid, (Object)lastChar) ? var16_18 : null;
            } else {
                var16_18 = Character.valueOf('.');
                it = var16_18.charValue();
                boolean bl4 = false;
                v0 = c = !CollectionsKt.contains((Iterable)specialValid, (Object)lastChar) ? var16_18 : null;
            }
            if (c == null) continue;
            it = c.charValue();
            boolean bl5 = false;
            $this$toSpdxId_u24lambda_u245.append(it);
            lastChar = Character.valueOf(it);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String $this$trim$iv = converted = string2;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl6 = false;
            boolean match$iv$iv = specialValid.contains(Character.valueOf(it));
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String it = string = (trimmed = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        boolean bl7 = false;
        Object object = !(hasPlusSuffix && allowPlusSuffix) ? string : null;
        if (object == null) {
            object = trimmed + "+";
        }
        return object;
    }

    public static /* synthetic */ String toSpdxId$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ExtensionsKt.toSpdxId(string, bl);
    }
}

