/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.spdx.ExtensionsKt;
import org.ossreviewtoolkit.utils.spdx.InvalidLicenseChoiceException;
import org.ossreviewtoolkit.utils.spdx.InvalidSubExpressionException;
import org.ossreviewtoolkit.utils.spdx.SpdxCompoundExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxOperator;
import org.ossreviewtoolkit.utils.spdx.SpdxSingleLicenseExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0001H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u0018\u0010 \u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002J\b\u0010!\u001a\u00020\u0001H\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010H\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006("}, d2={"Lorg/ossreviewtoolkit/utils/spdx/SpdxCompoundExpression;", "Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression;", "left", "operator", "Lorg/ossreviewtoolkit/utils/spdx/SpdxOperator;", "right", "(Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression;Lorg/ossreviewtoolkit/utils/spdx/SpdxOperator;Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression;)V", "getLeft", "()Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression;", "getOperator", "()Lorg/ossreviewtoolkit/utils/spdx/SpdxOperator;", "getRight", "applyChoice", "choice", "subExpression", "decompose", "", "Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;", "disjunctiveNormalForm", "equals", "", "other", "", "hashCode", "", "isSubExpression", "licenses", "", "", "normalize", "mapDeprecated", "offersChoice", "replaceSubexpressionWithChoice", "sorted", "toString", "validChoicesForDnf", "validate", "", "strictness", "Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression$Strictness;", "spdx-utils"})
@SourceDebugExtension(value={"SMAP\nSpdxExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpdxExpression.kt\norg/ossreviewtoolkit/utils/spdx/SpdxCompoundExpression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,676:1\n2661#2,7:677\n2661#2,7:684\n223#2,2:691\n766#2:693\n857#2,2:694\n2661#2,7:696\n1549#2:703\n1620#2,3:704\n1549#2:707\n1620#2,3:708\n1726#2,3:711\n1045#2:715\n1#3:714\n*S KotlinDebug\n*F\n+ 1 SpdxExpression.kt\norg/ossreviewtoolkit/utils/spdx/SpdxCompoundExpression\n*L\n300#1:677,7\n315#1:684,7\n360#1:691,2\n361#1:693\n361#1:694,2\n367#1:696,7\n383#1:703\n383#1:704,3\n384#1:707\n384#1:708,3\n386#1:711,3\n297#1:715\n*E\n"})
public final class SpdxCompoundExpression
extends SpdxExpression {
    @NotNull
    private final SpdxExpression left;
    @NotNull
    private final SpdxOperator operator;
    @NotNull
    private final SpdxExpression right;

    public SpdxCompoundExpression(@NotNull SpdxExpression left, @NotNull SpdxOperator operator, @NotNull SpdxExpression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        super(null);
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @NotNull
    public final SpdxExpression getLeft() {
        return this.left;
    }

    @NotNull
    public final SpdxOperator getOperator() {
        return this.operator;
    }

    @NotNull
    public final SpdxExpression getRight() {
        return this.right;
    }

    @Override
    @NotNull
    public Set<SpdxSingleLicenseExpression> decompose() {
        return SetsKt.plus(this.left.decompose(), (Iterable)this.right.decompose());
    }

    @Override
    @NotNull
    public List<String> licenses() {
        return CollectionsKt.plus((Collection)this.left.licenses(), (Iterable)this.right.licenses());
    }

    @Override
    @NotNull
    public SpdxExpression disjunctiveNormalForm() {
        SpdxExpression leftDnf = this.left.disjunctiveNormalForm();
        SpdxExpression rightDnf = this.right.disjunctiveNormalForm();
        return switch (WhenMappings.$EnumSwitchMapping$0[this.operator.ordinal()]) {
            case 1 -> new SpdxCompoundExpression(leftDnf, SpdxOperator.OR, rightDnf);
            case 2 -> leftDnf instanceof SpdxCompoundExpression && ((SpdxCompoundExpression)leftDnf).operator == SpdxOperator.OR && rightDnf instanceof SpdxCompoundExpression && ((SpdxCompoundExpression)rightDnf).operator == SpdxOperator.OR ? ((SpdxCompoundExpression)leftDnf).left.and(((SpdxCompoundExpression)rightDnf).left).or(((SpdxCompoundExpression)leftDnf).left.and(((SpdxCompoundExpression)rightDnf).right)).or(((SpdxCompoundExpression)leftDnf).right.and(((SpdxCompoundExpression)rightDnf).left).or(((SpdxCompoundExpression)leftDnf).right.and(((SpdxCompoundExpression)rightDnf).right))) : (leftDnf instanceof SpdxCompoundExpression && ((SpdxCompoundExpression)leftDnf).operator == SpdxOperator.OR ? ((SpdxCompoundExpression)leftDnf).left.and(rightDnf).or(((SpdxCompoundExpression)leftDnf).right.and(rightDnf)) : (rightDnf instanceof SpdxCompoundExpression && ((SpdxCompoundExpression)rightDnf).operator == SpdxOperator.OR ? leftDnf.and(((SpdxCompoundExpression)rightDnf).left).or(leftDnf.and(((SpdxCompoundExpression)rightDnf).right)) : new SpdxCompoundExpression(leftDnf, this.operator, rightDnf)));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public SpdxCompoundExpression normalize(boolean mapDeprecated) {
        return new SpdxCompoundExpression(this.left.normalize(mapDeprecated), this.operator, this.right.normalize(mapDeprecated));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SpdxExpression sorted() {
        void $this$reduce$iv;
        Iterable iterable = SpdxCompoundExpression.sorted$getSortedChildrenWithSameOperator(this, this);
        Function2 operation$iv = (Function2)(switch (WhenMappings.$EnumSwitchMapping$0[this.operator.ordinal()]) {
            case 2 -> (KFunction)sorted.1.INSTANCE;
            case 1 -> (KFunction)sorted.2.INSTANCE;
            default -> throw new NoWhenBranchMatchedException();
        });
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            accumulator$iv = operation$iv.invoke(accumulator$iv, iterator$iv.next());
        }
        return (SpdxExpression)accumulator$iv;
    }

    @Override
    public void validate(@NotNull SpdxExpression.Strictness strictness) {
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        this.left.validate(strictness);
        this.right.validate(strictness);
    }

    @Override
    @NotNull
    protected Set<SpdxExpression> validChoicesForDnf() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.operator.ordinal()]) {
            case 2 -> {
                Iterable $this$reduce$iv = this.decompose();
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    SpdxExpression var5_7 = (SpdxExpression)iterator$iv.next();
                    SpdxExpression p0 = (SpdxExpression)accumulator$iv;
                    boolean $i$a$-reduce-SpdxCompoundExpression$validChoicesForDnf$1 = false;
                    accumulator$iv = p0.and((SpdxExpression)p1);
                }
                yield SetsKt.setOf(accumulator$iv);
            }
            case 1 -> {
                Set<SpdxExpression> validChoicesLeft = this.left instanceof SpdxCompoundExpression ? ((SpdxCompoundExpression)this.left).validChoicesForDnf() : this.left.validChoices();
                Set<SpdxExpression> validChoicesRight = this.right instanceof SpdxCompoundExpression ? ((SpdxCompoundExpression)this.right).validChoicesForDnf() : this.right.validChoices();
                yield SetsKt.plus(validChoicesLeft, (Iterable)validChoicesRight);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean offersChoice() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.operator.ordinal()]) {
            case 1 -> true;
            case 2 -> {
                if (this.left.offersChoice() || this.right.offersChoice()) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public SpdxExpression applyChoice(@NotNull SpdxExpression choice, @NotNull SpdxExpression subExpression) {
        Intrinsics.checkNotNullParameter((Object)choice, (String)"choice");
        Intrinsics.checkNotNullParameter((Object)subExpression, (String)"subExpression");
        if (!subExpression.validChoices().containsAll((Collection)choice.validChoices())) {
            throw new InvalidLicenseChoiceException(choice + " is not a valid choice for " + subExpression + ". Valid choices are: " + this.validChoices() + ".");
        }
        if (!this.isSubExpression(subExpression)) {
            throw new InvalidSubExpressionException(subExpression + " is not not a valid subExpression of " + this);
        }
        return this.replaceSubexpressionWithChoice(subExpression, choice);
    }

    /*
     * WARNING - void declaration
     */
    private final SpdxExpression replaceSubexpressionWithChoice(SpdxExpression subExpression, SpdxExpression choice) {
        SpdxExpression spdxExpression;
        String expressionString = this.toString();
        String subExpressionString = subExpression.toString();
        String choiceString = choice.toString();
        if (StringsKt.contains$default((CharSequence)expressionString, (CharSequence)subExpressionString, (boolean)false, (int)2, null)) {
            spdxExpression = ExtensionsKt.toSpdx$default(StringsKt.replace$default((String)expressionString, (String)subExpressionString, (String)choiceString, (boolean)false, (int)4, null), null, 1, null);
        } else {
            void $this$filterTo$iv$iv;
            Object element$iv2;
            block7: {
                Iterable $this$first$iv = subExpression.validChoices();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    SpdxExpression it = (SpdxExpression)element$iv2;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)choice))) continue;
                    break block7;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            SpdxExpression dismissedLicense = (SpdxExpression)element$iv2;
            Iterable $this$filter$iv = this.validChoices();
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SpdxExpression it = (SpdxExpression)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)dismissedLicense))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List unchosenLicenses = (List)destination$iv$iv;
            if (!(!((Collection)unchosenLicenses).isEmpty())) {
                boolean $i$a$-require-SpdxCompoundExpression$replaceSubexpressionWithChoice$22 = false;
                String $i$a$-require-SpdxCompoundExpression$replaceSubexpressionWithChoice$22 = "No licenses left after applying choice " + choice + " to " + subExpression + ".";
                throw new IllegalArgumentException($i$a$-require-SpdxCompoundExpression$replaceSubexpressionWithChoice$22.toString());
            }
            Iterable $this$reduce$iv = unchosenLicenses;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                SpdxExpression $i$f$filterTo2 = (SpdxExpression)iterator$iv.next();
                SpdxExpression p0 = (SpdxExpression)accumulator$iv;
                boolean bl = false;
                accumulator$iv = p0.or((SpdxExpression)p1);
            }
            spdxExpression = (SpdxExpression)accumulator$iv;
        }
        return spdxExpression;
    }

    @Override
    public boolean isSubExpression(@Nullable SpdxExpression subExpression) {
        if (subExpression == null) {
            return false;
        }
        String expressionString = this.toString();
        String subExpressionString = subExpression.toString();
        return this.validChoices().containsAll((Collection)subExpression.validChoices()) || StringsKt.contains$default((CharSequence)expressionString, (CharSequence)subExpressionString, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Set it;
        Collection collection;
        void $this$mapTo$iv$iv;
        if (!(other instanceof SpdxExpression)) {
            return false;
        }
        Iterable $this$map$iv = this.validChoices();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            SpdxExpression spdxExpression = (SpdxExpression)item$iv$iv;
            collection = collection2;
            boolean bl = false;
            collection.add(it2.decompose());
        }
        List validChoices = (List)collection2;
        Iterable $this$map$iv2 = ((SpdxExpression)other).validChoices();
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : iterable2) {
            void it3;
            SpdxExpression bl = (SpdxExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it3.decompose());
        }
        List otherValidChoices = (List)destination$iv$iv;
        if (validChoices.size() != otherValidChoices.size()) return false;
        Iterable $this$all$iv = validChoices;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (Set)element$iv;
            boolean bl = false;
        } while (otherValidChoices.contains(it));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        Iterable iterable = this.decompose();
        int n = 0;
        for (Object t : iterable) {
            void it;
            SpdxSingleLicenseExpression spdxSingleLicenseExpression = (SpdxSingleLicenseExpression)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.hashCode();
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.left instanceof SpdxCompoundExpression && this.operator != ((SpdxCompoundExpression)this.left).operator) {
            $this$toString_u24lambda_u249.append("(" + this.left + ")");
        } else {
            $this$toString_u24lambda_u249.append(String.valueOf(this.left));
        }
        $this$toString_u24lambda_u249.append(" " + this.operator + " ");
        if (this.right instanceof SpdxCompoundExpression && this.operator != ((SpdxCompoundExpression)this.right).operator) {
            $this$toString_u24lambda_u249.append("(" + this.right + ")");
        } else {
            $this$toString_u24lambda_u249.append(String.valueOf(this.right));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final void sorted$getSortedChildrenWithSameOperator$addChildren(SpdxCompoundExpression this$0, List<SpdxExpression> children, SpdxExpression child) {
        if (child instanceof SpdxCompoundExpression && ((SpdxCompoundExpression)child).operator == this$0.operator) {
            CollectionsKt.addAll((Collection)children, (Iterable)SpdxCompoundExpression.sorted$getSortedChildrenWithSameOperator(this$0, (SpdxCompoundExpression)child));
        } else {
            ((Collection)children).add(child.sorted());
        }
    }

    private static final List<SpdxExpression> sorted$getSortedChildrenWithSameOperator(SpdxCompoundExpression this$0, SpdxCompoundExpression expression) {
        List children = new ArrayList();
        SpdxCompoundExpression.sorted$getSortedChildrenWithSameOperator$addChildren(this$0, children, expression.left);
        SpdxCompoundExpression.sorted$getSortedChildrenWithSameOperator$addChildren(this$0, children, expression.right);
        Iterable $this$sortedBy$iv = children;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SpdxExpression it = (SpdxExpression)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.toString());
                it = (SpdxExpression)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.toString())));
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpdxOperator.values().length];
            try {
                nArray[SpdxOperator.OR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpdxOperator.AND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

