/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.spdx.ExtensionsKt;
import org.ossreviewtoolkit.utils.spdx.SpdxDeclaredLicenseMapping;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxLicense;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR'\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\n8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/SpdxDeclaredLicenseMapping;", "", "()V", "mapping", "Ljava/util/SortedMap;", "", "Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression;", "getMapping", "()Ljava/util/SortedMap;", "rawMapping", "", "getRawMapping$spdx_utils", "()Ljava/util/Map;", "rawMapping$delegate", "Lkotlin/Lazy;", "map", "license", "spdx-utils"})
public final class SpdxDeclaredLicenseMapping {
    @NotNull
    public static final SpdxDeclaredLicenseMapping INSTANCE = new SpdxDeclaredLicenseMapping();
    @NotNull
    private static final Lazy rawMapping$delegate = LazyKt.lazy((Function0)rawMapping.2.INSTANCE);
    @NotNull
    private static final SortedMap<String, SpdxExpression> mapping = MapsKt.toSortedMap(INSTANCE.getRawMapping$spdx_utils(), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));

    private SpdxDeclaredLicenseMapping() {
    }

    @NotNull
    public final Map<String, SpdxExpression> getRawMapping$spdx_utils() {
        Lazy lazy = rawMapping$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final SortedMap<String, SpdxExpression> getMapping() {
        return mapping;
    }

    @Nullable
    public final SpdxExpression map(@NotNull String license) {
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        SpdxExpression spdxExpression = (SpdxExpression)mapping.get(license);
        if (spdxExpression == null) {
            SpdxLicense spdxLicense2 = SpdxLicense.Companion.forId(license);
            spdxExpression = spdxLicense2 != null ? ExtensionsKt.toExpression(spdxLicense2) : null;
        }
        return spdxExpression;
    }
}

