/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx;

import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.spdx.SpdxConstants;
import org.ossreviewtoolkit.utils.spdx.SpdxException;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxLicense;
import org.ossreviewtoolkit.utils.spdx.SpdxSimpleExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxSimpleLicenseMapping;
import org.ossreviewtoolkit.utils.spdx.SpdxSingleLicenseExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/SpdxLicenseIdExpression;", "Lorg/ossreviewtoolkit/utils/spdx/SpdxSimpleExpression;", "id", "", "orLaterVersion", "", "(Ljava/lang/String;Z)V", "getId", "()Ljava/lang/String;", "getOrLaterVersion", "()Z", "spdxLicense", "Lorg/ossreviewtoolkit/utils/spdx/SpdxLicense;", "getSpdxLicense", "()Lorg/ossreviewtoolkit/utils/spdx/SpdxLicense;", "spdxLicense$delegate", "Lkotlin/Lazy;", "decompose", "", "equals", "other", "", "exception", "getLicenseUrl", "hashCode", "", "licenses", "", "normalize", "Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;", "mapDeprecated", "simpleLicense", "toString", "validate", "", "strictness", "Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression$Strictness;", "spdx-utils"})
public final class SpdxLicenseIdExpression
extends SpdxSimpleExpression {
    @NotNull
    private final String id;
    private final boolean orLaterVersion;
    @NotNull
    private final Lazy spdxLicense$delegate;

    public SpdxLicenseIdExpression(@NotNull String id, boolean orLaterVersion) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(null);
        this.id = id;
        this.orLaterVersion = orLaterVersion;
        this.spdxLicense$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SpdxLicense>(this){
            final /* synthetic */ SpdxLicenseIdExpression this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SpdxLicense invoke() {
                return SpdxLicense.Companion.forId(this.this$0.getId());
            }
        }));
    }

    public /* synthetic */ SpdxLicenseIdExpression(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final boolean getOrLaterVersion() {
        return this.orLaterVersion;
    }

    private final SpdxLicense getSpdxLicense() {
        Lazy lazy = this.spdxLicense$delegate;
        return (SpdxLicense)((Object)lazy.getValue());
    }

    @NotNull
    public Set<SpdxLicenseIdExpression> decompose() {
        return SetsKt.setOf((Object)this);
    }

    @Override
    @NotNull
    public List<String> licenses() {
        return CollectionsKt.listOf((Object)this.toString());
    }

    @Override
    @NotNull
    public String simpleLicense() {
        return this.toString();
    }

    @Override
    @Nullable
    public String exception() {
        return null;
    }

    @Override
    @NotNull
    public SpdxSingleLicenseExpression normalize(boolean mapDeprecated) {
        SpdxSingleLicenseExpression spdxSingleLicenseExpression = SpdxSimpleLicenseMapping.INSTANCE.map(this.toString(), mapDeprecated);
        if (spdxSingleLicenseExpression == null) {
            spdxSingleLicenseExpression = this;
        }
        return spdxSingleLicenseExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate(@NotNull SpdxExpression.Strictness strictness) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        if (SpdxConstants.INSTANCE.isNotPresent(this.id)) return;
        switch (WhenMappings.$EnumSwitchMapping$0[strictness.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                if (this.getSpdxLicense() != null) {
                    return;
                }
                bl = false;
                break;
            }
            case 3: 
            case 4: {
                SpdxLicense spdxLicense2 = this.getSpdxLicense();
                if (spdxLicense2 != null) {
                    if (!spdxLicense2.getDeprecated()) {
                        return;
                    }
                    bl = false;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (bl) {
            return;
        }
        boolean bl2 = false;
        boolean isValid = bl2;
        if (isValid) return;
        throw new SpdxException("'" + this + "' is not a valid SPDX license id.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (object instanceof SpdxLicenseIdExpression) {
            if (!Intrinsics.areEqual((Object)this.id, (Object)((SpdxLicenseIdExpression)other).id)) return false;
            if (this.orLaterVersion != ((SpdxLicenseIdExpression)other).orLaterVersion) return false;
            return true;
        }
        if (!(object instanceof SpdxExpression)) return false;
        Set<SpdxSingleLicenseExpression> decomposed = ((SpdxExpression)other).decompose();
        if (decomposed.size() != 1) return false;
        SpdxSingleLicenseExpression it = (SpdxSingleLicenseExpression)CollectionsKt.first((Iterable)decomposed);
        boolean bl = false;
        if (!(it instanceof SpdxLicenseIdExpression)) return false;
        if (!Intrinsics.areEqual((Object)((SpdxLicenseIdExpression)it).id, (Object)this.id)) return false;
        if (((SpdxLicenseIdExpression)it).orLaterVersion != this.orLaterVersion) return false;
        return true;
    }

    public int hashCode() {
        return this.id.hashCode() + 31 * Boolean.hashCode(this.orLaterVersion);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u241.append(this.id);
        if (this.orLaterVersion && !StringsKt.endsWith$default((String)this.id, (String)"-or-later", (boolean)false, (int)2, null)) {
            $this$toString_u24lambda_u241.append("+");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @Nullable
    public String getLicenseUrl() {
        return SpdxExpression.isValid$default(this, null, 1, null) ? "https://spdx.org/licenses/" + this.id : null;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpdxExpression.Strictness.values().length];
            try {
                nArray[SpdxExpression.Strictness.ALLOW_ANY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpdxExpression.Strictness.ALLOW_DEPRECATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpdxExpression.Strictness.ALLOW_CURRENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpdxExpression.Strictness.ALLOW_LICENSEREF_EXCEPTIONS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

