/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.utils.spdx;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.spdx.SpdxException;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxSimpleExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxSingleLicenseExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lorg/ossreviewtoolkit/utils/spdx/SpdxLicenseReferenceExpression;", "Lorg/ossreviewtoolkit/utils/spdx/SpdxSimpleExpression;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "decompose", "", "equals", "", "other", "", "exception", "getLicenseUrl", "hashCode", "", "licenses", "", "normalize", "mapDeprecated", "simpleLicense", "toString", "validate", "", "strictness", "Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression$Strictness;", "spdx-utils"})
@SourceDebugExtension(value={"SMAP\nSpdxExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpdxExpression.kt\norg/ossreviewtoolkit/utils/spdx/SpdxLicenseReferenceExpression\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,676:1\n1#2:677\n*E\n"})
public final class SpdxLicenseReferenceExpression
extends SpdxSimpleExpression {
    @NotNull
    private final String id;

    public SpdxLicenseReferenceExpression(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(null);
        this.id = id;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public Set<SpdxLicenseReferenceExpression> decompose() {
        return SetsKt.setOf((Object)this);
    }

    @Override
    @NotNull
    public List<String> licenses() {
        return CollectionsKt.listOf((Object)this.id);
    }

    @Override
    @NotNull
    public String simpleLicense() {
        return this.id;
    }

    @Override
    @Nullable
    public String exception() {
        return null;
    }

    @Override
    @NotNull
    public SpdxLicenseReferenceExpression normalize(boolean mapDeprecated) {
        return this;
    }

    @Override
    public void validate(@NotNull SpdxExpression.Strictness strictness) {
        boolean isDocumentRefToLicenseRef;
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        boolean isLicenseRef = StringsKt.startsWith$default((String)this.id, (String)"LicenseRef-", (boolean)false, (int)2, null);
        boolean bl = isDocumentRefToLicenseRef = StringsKt.startsWith$default((String)this.id, (String)"DocumentRef-", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)this.id, (CharSequence)":LicenseRef-", (boolean)false, (int)2, null);
        if (!isLicenseRef && !isDocumentRefToLicenseRef) {
            throw new SpdxException("'" + this.id + "' is not an SPDX license reference.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (!(object instanceof SpdxLicenseReferenceExpression)) {
            if (!(object instanceof SpdxExpression)) return false;
            Set<SpdxSingleLicenseExpression> decomposed = ((SpdxExpression)other).decompose();
            if (decomposed.size() != 1) return false;
            SpdxSingleLicenseExpression it = (SpdxSingleLicenseExpression)CollectionsKt.first((Iterable)decomposed);
            boolean bl = false;
            if (!(it instanceof SpdxLicenseReferenceExpression)) return false;
            if (!Intrinsics.areEqual((Object)((SpdxLicenseReferenceExpression)it).id, (Object)this.id)) return false;
            return true;
        }
        boolean bl = Intrinsics.areEqual((Object)this.id, (Object)((SpdxLicenseReferenceExpression)other).id);
        return bl;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public String toString() {
        return this.id;
    }

    @Override
    @Nullable
    public String getLicenseUrl() {
        return null;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final SpdxLicenseReferenceExpression copy(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new SpdxLicenseReferenceExpression(id);
    }

    public static /* synthetic */ SpdxLicenseReferenceExpression copy$default(SpdxLicenseReferenceExpression spdxLicenseReferenceExpression, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = spdxLicenseReferenceExpression.id;
        }
        return spdxLicenseReferenceExpression.copy(string);
    }
}

